/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.GCMParameterSpec;
import com.teradata.tdgss.jgssp2td2.ASN1Msg;
import com.teradata.tdgss.jgssp2td2.ASN1TokenHdr;
import com.teradata.tdgss.jgssp2td2.Td2MinorStatus;
import com.teradata.tdgss.jgssp2td2.Td2Token;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public final class Td2Crypto {
    private static final int ASN1OVERHEADBYTES = 48;
    private final TdgssLogger logger;
    private SecretKey secretKey;
    private byte[] key;
    private byte[] hSecretKey;
    private String encAlg;
    private String mode;
    private String padding;
    private String micAlg;
    private int peerCapabilities;
    private MessageDigest wrapDigest;
    private MessageDigest unwrapDigest;
    private MessageDigest getMicDigest;
    private MessageDigest verifyMicDigest;
    private Mac verifyMAC;
    private Mac getMAC;
    private Mac hMAC;
    private final int GCM_TAG_LENGTH = 16;

    public Td2Crypto(SecretKey secretKey, byte[] byArray, AlgQop algQop, int n, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.secretKey = secretKey;
        this.key = byArray;
        this.hSecretKey = null;
        this.encAlg = algQop.getConfidentialityAlgorithm();
        this.mode = algQop.getMode();
        this.padding = algQop.getPadding();
        this.micAlg = algQop.getIntegrityAlgorithm();
        this.peerCapabilities = n;
        try {
            if ((n & 0x10) == 16) {
                this.getMAC = Mac.getInstance("HMAC" + this.micAlg.replaceFirst("-", ""));
                this.verifyMAC = Mac.getInstance("HMAC" + this.micAlg.replaceFirst("-", ""));
                this.hMAC = Mac.getInstance("HMAC" + this.micAlg.replaceFirst("-", ""));
            } else {
                this.wrapDigest = MessageDigest.getInstance(this.micAlg);
                this.unwrapDigest = MessageDigest.getInstance(this.micAlg);
                this.getMicDigest = MessageDigest.getInstance(this.micAlg);
                this.verifyMicDigest = MessageDigest.getInstance(this.micAlg);
            }
        }
        catch (Exception exception) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL, exception);
        }
    }

    public void computeKeyHash() throws GSSException {
        if ((this.peerCapabilities & 1) == 1) {
            if ((this.peerCapabilities & 0x10) == 16) {
                return;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.micAlg);
                messageDigest.update(this.key, 0, this.key.length);
                this.hSecretKey = messageDigest.digest();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("The Secret Key hash is ************************", this.hSecretKey));
                }
            }
            catch (Exception exception) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL, exception);
            }
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        boolean bl = false;
        byte[] byArray2 = new byte[]{};
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token Header is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.wrapDigest == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Wrap digest argument is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((td2Token.getFlags() & 4) == 4) {
            bl = true;
        }
        if (this.hSecretKey == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Hash of the secret key is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        int n3 = n2 + this.hSecretKey.length;
        td2Token.setMsgLength(n3 + 16);
        byte[] byArray3 = new byte[n3 + 16];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        System.arraycopy(this.hSecretKey, 0, byArray3, n2, this.hSecretKey.length);
        if (!bl) {
            byte[] byArray4 = td2Token.GetTokenBytes();
            System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
            this.wrapDigest.update(byArray3);
            byte[] byArray5 = this.wrapDigest.digest();
            System.arraycopy(byArray5, 0, byArray3, n2, byArray5.length);
            byArray2 = byArray3;
        } else {
            byte[] byArray6;
            int n4;
            String string = this.encAlg + "/" + this.mode + "/" + this.padding;
            int n5 = byArray3.length;
            byte[] byArray7 = td2Token.GetTokenBytes();
            try {
                Cipher cipher = Cipher.getInstance(string);
                if (this.padding.equalsIgnoreCase("NoPadding")) {
                    int n6 = cipher.getBlockSize();
                    n5 = byArray3.length / n6 * n6;
                }
                if (this.mode.equalsIgnoreCase("ECB")) {
                    cipher.init(1, this.secretKey);
                } else {
                    byArray7 = td2Token.GetTokenBytes();
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                    cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                }
                n4 = cipher.getOutputSize(n5);
                td2Token.setMsgLength(n4);
                byArray7 = td2Token.GetTokenBytes();
                System.arraycopy(byArray7, 0, byArray3, n3, byArray7.length);
                this.wrapDigest.update(byArray3);
                byte[] byArray8 = this.wrapDigest.digest();
                System.arraycopy(byArray8, 0, byArray3, n2, byArray8.length);
                if (!this.mode.equalsIgnoreCase("ECB")) {
                    byArray7 = td2Token.GetTokenBytes();
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                    cipher.init(1, (Key)this.secretKey, ivParameterSpec);
                }
                byArray6 = cipher.doFinal(byArray3, 0, n5);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
            }
            catch (Exception exception) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
            }
            byArray2 = new byte[n4 + 16];
            System.arraycopy(byArray6, 0, byArray2, 0, byArray6.length);
            System.arraycopy(byArray7, 0, byArray2, byArray6.length, byArray7.length);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    public byte[] newWrap(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        byte[] byArray2;
        Object object;
        int n3;
        boolean bl = false;
        byte[] byArray3 = new byte[]{};
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering newWrap!");
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token Header is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.hMAC == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Wrap digest argument is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((td2Token.getFlags() & 4) == 4) {
            bl = true;
        }
        byte[] byArray4 = new byte[n2 + 16];
        System.arraycopy(byArray, n, byArray4, 0, n2);
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        if (!bl) {
            n3 = n2 + this.getMAC.getMacLength() + 16;
            td2Token.setMsgLength(n3);
            byArray7 = td2Token.GetTokenBytes();
            System.arraycopy(td2Token.GetTokenBytes(), 0, byArray4, n2, byArray7.length);
            byArray6 = this.computeHMAC(byArray4, n, n2);
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        } else {
            int n4;
            Cipher cipher;
            String string = this.mode.equalsIgnoreCase("GCM") ? this.encAlg + "/" + this.mode + "/" + "NoPadding" : (this.mode.equalsIgnoreCase("AEADGCM") || this.mode.equalsIgnoreCase("GCM96") ? this.encAlg + "/GCM/NoPadding" : (this.mode.equalsIgnoreCase("CTR") ? this.encAlg + "/" + this.mode + "/" + "NoPadding" : this.encAlg + "/" + this.mode + "/" + this.padding));
            n3 = byArray4.length;
            try {
                cipher = Cipher.getInstance(string);
            }
            catch (Exception exception) {
                this.logger.debug("Encryption algorithm is not available");
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
            }
            if ((this.mode.equalsIgnoreCase("GCM") || this.mode.equalsIgnoreCase("AEADGCM")) && AlgParcel.isGCMsupported() || this.mode.equalsIgnoreCase("GCM96") && AlgParcel.isGCM96supported()) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec;
                    cipher.init(1, this.secretKey);
                    n4 = cipher.getOutputSize(n3);
                    td2Token.setMsgLength(n4 + this.hMAC.getMacLength() + 16);
                    byArray7 = td2Token.GetTokenBytes();
                    if (this.mode.equalsIgnoreCase("GCM96")) {
                        byte[] byArray8 = new byte[12];
                        System.arraycopy(byArray7, 4, byArray4, n2, byArray7.length - 4);
                        System.arraycopy(byArray7, 4, byArray8, 0, byArray7.length - 4);
                        algorithmParameterSpec = GCMParameterSpec.getInstance(128, byArray8);
                    } else {
                        System.arraycopy(byArray7, 0, byArray4, n2, byArray7.length);
                        algorithmParameterSpec = GCMParameterSpec.getInstance(128, byArray7);
                    }
                    cipher = Cipher.getInstance(string);
                    cipher.init(1, (Key)this.secretKey, algorithmParameterSpec);
                    byte[] byArray9 = cipher.doFinal(byArray4, 0, n3);
                    byArray3 = new byte[byArray9.length - 16];
                    byArray5 = new byte[16];
                    System.arraycopy(byArray9, byArray9.length - 16, byArray5, 0, 16);
                    System.arraycopy(byArray9, 0, byArray3, 0, byArray3.length);
                }
                catch (Exception exception) {
                    this.logger.debug("encrption wrap failed");
                    throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
                }
            }
            try {
                cipher.init(1, this.secretKey);
                n4 = cipher.getOutputSize(n3);
                td2Token.setMsgLength(n4 + this.hMAC.getMacLength() + 16);
                byArray7 = td2Token.GetTokenBytes();
                object = new IvParameterSpec(byArray7);
                cipher = Cipher.getInstance(string);
                cipher.init(1, (Key)this.secretKey, (AlgorithmParameterSpec)object);
                System.arraycopy(byArray7, 0, byArray4, n2, byArray7.length);
                byArray2 = cipher.doFinal(byArray4, 0, n3);
                byArray3 = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            }
            catch (Exception exception) {
                this.logger.debug("encrption wrap failed");
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
            }
            if (!this.mode.equalsIgnoreCase("AEADGCM") && !this.mode.equalsIgnoreCase("GCM96")) {
                byArray6 = this.computeHMAC(byArray3, 0, byArray3.length);
            }
        }
        ASN1TokenHdr aSN1TokenHdr = new ASN1TokenHdr();
        byte by = td2Token.getFlags();
        aSN1TokenHdr.setFlag(by);
        aSN1TokenHdr.setMsgLength(td2Token.getMsgLength());
        byArray2 = new byte[]{td2Token.getMsgType()};
        aSN1TokenHdr.setMsgType(byArray2);
        object = Td2Util.inttobytearray(td2Token.getQOP());
        aSN1TokenHdr.setfQOP((byte[])object);
        aSN1TokenHdr.setSeqNum(td2Token.getSeqNumber());
        byte by2 = td2Token.getVersion();
        byte[] byArray10 = new byte[]{by2};
        aSN1TokenHdr.setVersion(byArray10);
        ASN1Msg aSN1Msg = new ASN1Msg();
        aSN1Msg.setAsn1TokenHdr(aSN1TokenHdr);
        if (byArray5 != null) {
            aSN1Msg.setAuthTag(byArray5);
        }
        aSN1Msg.setInputMsg(byArray3);
        if (!this.mode.equalsIgnoreCase("AEADGCM") && !this.mode.equalsIgnoreCase("GCM96")) {
            aSN1Msg.setComputedMac(byArray6);
        }
        DER dER = aSN1Msg.getDERObject();
        return dER.getEncodedValue();
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        boolean bl = false;
        byte[] byArray2 = new byte[]{};
        int n3 = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input argument is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token Header is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.unwrapDigest == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unwrap digest is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((td2Token.getFlags() & 4) == 4) {
            bl = true;
        }
        n3 = this.unwrapDigest.getDigestLength();
        if (td2Token.getVersion() != 3 || td2Token.getMsgType() != 7) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        if (!bl) {
            byte[] byArray3 = (byte[])byArray.clone();
            byte[] byArray4 = new byte[n3];
            int n4 = n2 - n3 - 16;
            System.arraycopy(this.hSecretKey, 0, byArray3, n4, this.hSecretKey.length);
            System.arraycopy(byArray, n + n4, byArray4, 0, n3);
            if (!this.verifyHash(byArray3, byArray4, this.unwrapDigest)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
            byArray2 = new byte[n4];
            System.arraycopy(byArray3, 0, byArray2, 0, n4);
        } else {
            byte[] byArray5;
            byte[] byArray6 = new byte[n2 - 16];
            byte[] byArray7 = new byte[16];
            String string = this.encAlg + "/" + this.mode + "/" + this.padding;
            System.arraycopy(byArray, n, byArray6, 0, n2 - 16);
            System.arraycopy(byArray, n + n2 - 16, byArray7, 0, 16);
            try {
                Cipher cipher = Cipher.getInstance(string);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                cipher.init(2, (Key)this.secretKey, ivParameterSpec);
                byArray5 = cipher.doFinal(byArray6, 0, byArray6.length);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
            }
            catch (Exception exception) {
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
            }
            for (int i = 0; i < 16; ++i) {
                byte by = byArray5[byArray5.length - 16 + i];
                if (by == byArray7[i]) continue;
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL);
            }
            byte[] byArray8 = (byte[])byArray5.clone();
            byte[] byArray9 = new byte[n3];
            int n5 = byArray5.length - n3 - 16;
            System.arraycopy(this.hSecretKey, 0, byArray8, n5, n3);
            System.arraycopy(byArray5, n5, byArray9, 0, n3);
            if (!this.verifyHash(byArray8, byArray9, this.unwrapDigest)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
            byArray2 = new byte[n5];
            System.arraycopy(byArray8, 0, byArray2, 0, n5);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    public byte[] newUnWrap(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl, Td2Token td2Token, byte[] byArray3) throws GSSException {
        AlgorithmParameterSpec algorithmParameterSpec;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input argument is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token Header is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        byArray4 = td2Token.GetTokenBytes();
        byte[] byArray7 = null;
        if (!bl) {
            byArray6 = new byte[n2 + byArray4.length];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            System.arraycopy(byArray4, 0, byArray6, n2, byArray4.length);
            if (byArray2 == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("mac is null");
                }
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
            }
            if (!this.verifyMac(byArray6, byArray2)) {
                this.logger.debug("MAC verification failed");
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
            byArray5 = new byte[n2];
            System.arraycopy(byArray, n, byArray5, 0, n2);
            return byArray5;
        }
        if (!this.mode.equalsIgnoreCase("AEADGCM") && !this.mode.equalsIgnoreCase("GCM96")) {
            if (byArray2 == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("mac is null");
                }
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
            }
            if (!this.verifyMac(byArray, byArray2)) {
                this.logger.debug("MAC verification failed");
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
        }
        String string = this.mode.equalsIgnoreCase("GCM") ? this.encAlg + "/" + this.mode + "/" + "NoPadding" : (this.mode.equalsIgnoreCase("AEADGCM") || this.mode.equalsIgnoreCase("GCM96") ? this.encAlg + "/GCM/NoPadding" : (this.mode.equalsIgnoreCase("CTR") ? this.encAlg + "/" + this.mode + "/" + "NoPadding" : this.encAlg + "/" + this.mode + "/" + this.padding));
        if ((this.mode.equalsIgnoreCase("GCM") || this.mode.equalsIgnoreCase("AEADGCM")) && AlgParcel.isGCMsupported() || this.mode.equalsIgnoreCase("GCM96") && AlgParcel.isGCM96supported()) {
            if (byArray3 == null) {
                this.logger.debug("authtag is null");
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
            }
            byArray6 = new byte[n2 + byArray3.length];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            System.arraycopy(byArray3, n, byArray6, n2, byArray3.length);
            try {
                Cipher cipher = Cipher.getInstance(string);
                if (this.mode.equalsIgnoreCase("GCM96")) {
                    byte[] byArray8 = new byte[12];
                    System.arraycopy(byArray4, 4, byArray8, 0, byArray4.length - 4);
                    algorithmParameterSpec = GCMParameterSpec.getInstance(128, byArray8);
                } else {
                    algorithmParameterSpec = GCMParameterSpec.getInstance(128, byArray4);
                }
                cipher.init(2, (Key)this.secretKey, algorithmParameterSpec);
                byArray7 = cipher.doFinal(byArray6, 0, byArray6.length);
            }
            catch (Exception exception) {
                this.logger.debug("Encryption failed");
                throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
            }
        }
        algorithmParameterSpec = new IvParameterSpec(byArray4);
        try {
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(2, (Key)this.secretKey, algorithmParameterSpec);
            byArray7 = cipher.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.logger.debug("Encryption failed");
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
        }
        int n3 = byArray7.length - 16;
        byArray5 = new byte[n3];
        System.arraycopy(byArray7, 0, byArray5, 0, n3);
        return byArray5;
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        byte[] byArray2 = new byte[]{};
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token Header is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_INPUT);
        }
        if (this.getMicDigest == null && this.getMAC == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Get MIC/MAC digest is null");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_BAD_CONTEXT_STATE);
        }
        if ((this.peerCapabilities & 0x10) == 16) {
            byte[] byArray3 = new byte[n2 + 16];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            td2Token.setMsgLength(this.getMAC.getMacLength() + 16);
            byte[] byArray4 = td2Token.GetTokenBytes();
            System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
            byte[] byArray5 = this.computeHMAC(byArray3, n, byArray3.length);
            byArray2 = new byte[byArray5.length + 16];
            System.arraycopy(byArray5, 0, byArray2, 0, byArray5.length);
            System.arraycopy(byArray4, 0, byArray2, byArray5.length, 16);
        } else {
            int n3 = this.getMicDigest.getDigestLength();
            int n4 = n2 + this.hSecretKey.length;
            td2Token.setMsgLength(n3);
            byte[] byArray6 = new byte[n4 + 16];
            System.arraycopy(byArray, n, byArray6, 0, n2);
            System.arraycopy(this.hSecretKey, 0, byArray6, n2, this.hSecretKey.length);
            byte[] byArray7 = td2Token.GetTokenBytes();
            System.arraycopy(byArray7, 0, byArray6, n4, byArray7.length);
            this.getMicDigest.update(byArray6);
            byte[] byArray8 = this.getMicDigest.digest();
            byArray2 = new byte[n3 + 16];
            System.arraycopy(byArray8, 0, byArray2, 0, byArray8.length);
            System.arraycopy(byArray7, 0, byArray2, byArray8.length, 16);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    private byte[] computeHMAC(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2;
        try {
            this.getMAC.init(this.secretKey);
            this.getMAC.update(byArray);
            byArray2 = this.getMAC.doFinal();
        }
        catch (Exception exception) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_MIC_FAIL, exception);
        }
        return byArray2;
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp, Td2Token td2Token) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input length is larger than buffer size ");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        if (td2Token.getVersion() != 3 || td2Token.getMsgType() != 8) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        if ((this.peerCapabilities & 0x10) == 16) {
            int n5 = this.verifyMAC.getMacLength();
            int n6 = n4 + 16;
            byte[] byArray3 = new byte[n5];
            byte[] byArray4 = new byte[n6];
            byte[] byArray5 = td2Token.GetTokenBytes();
            System.arraycopy(byArray2, n3, byArray4, 0, n4);
            System.arraycopy(byArray5, 0, byArray4, n4, 16);
            System.arraycopy(byArray, n, byArray3, 0, n5);
            if (!this.verifyMac(byArray4, byArray3)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
        } else {
            int n7 = this.verifyMicDigest.getDigestLength();
            int n8 = n4 + n7 + 16;
            byte[] byArray6 = new byte[n7];
            byte[] byArray7 = new byte[n8];
            byte[] byArray8 = td2Token.GetTokenBytes();
            System.arraycopy(byArray, n, byArray6, 0, n7);
            System.arraycopy(byArray2, n3, byArray7, 0, n4);
            System.arraycopy(this.hSecretKey, 0, byArray7, n4, this.hSecretKey.length);
            System.arraycopy(byArray8, 0, byArray7, n8 - 16, 16);
            if (!this.verifyHash(byArray7, byArray6, this.verifyMicDigest)) {
                throw new TdgssException(6, Td2MinorStatus.TD2_ERR_INVALID_DIGEST);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
    }

    private boolean verifyMac(byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            this.verifyMAC.init(this.secretKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
        }
        this.verifyMAC.update(byArray);
        byte[] byArray3 = this.verifyMAC.doFinal();
        if (byArray3.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2, boolean bl2) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        int n3 = 0;
        int n4 = 48;
        int n5 = 0;
        if (n2 < 16) {
            return 0;
        }
        if (bl) {
            int n6 = this.getMaxInputLength(n2 - 16);
            n3 = n6 > 16 ? n6 : 0;
            if (n3 > 16) {
                n3 -= 16;
            }
        } else {
            n3 = n2 - 16;
        }
        n5 = (this.peerCapabilities & 0x10) == 16 ? this.hMAC.getMacLength() : this.wrapDigest.getDigestLength();
        if (n3 > n5) {
            n3 -= n5;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        if (bl2) {
            return n3 + n4;
        }
        return n3;
    }

    private int getMaxInputLength(int n) throws GSSException {
        String string = this.encAlg + "/" + this.mode + "/" + this.padding;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            Cipher cipher = Cipher.getInstance(string);
            if (this.mode.equalsIgnoreCase("ECB")) {
                cipher.init(1, this.secretKey);
            } else {
                byte[] byArray = new byte[cipher.getBlockSize()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = 0;
                }
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                cipher.init(1, (Key)this.secretKey, ivParameterSpec);
            }
            n3 = cipher.getBlockSize();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_INVALID_KEYSIZE, invalidKeyException);
        }
        catch (Exception exception) {
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_ENCRYPTION_FAIL, exception);
        }
        n2 = 0;
        n4 = n;
        if (this.mode.equalsIgnoreCase("CBC")) {
            if (n4 < n3) {
                n2 = 0;
            } else {
                n5 = n4 % n3;
                n2 = this.padding.equalsIgnoreCase("NoPadding") ? n4 - n5 : (this.padding.equalsIgnoreCase("PKCS5Padding") ? n4 - (n3 + n5) : 0);
            }
        } else if (this.mode.equalsIgnoreCase("CFB") || this.mode.equalsIgnoreCase("OFB")) {
            n5 = n4 >= n3 ? n4 % n3 : 0;
            n2 = this.padding.equalsIgnoreCase("NoPadding") ? n4 : (this.padding.equalsIgnoreCase("PKCS5Padding") ? (n4 >= n3 ? n4 - (n5 + 1) : 0) : 0);
        } else {
            n2 = 0;
        }
        return n2;
    }

    private boolean verifyHash(byte[] byArray, byte[] byArray2, MessageDigest messageDigest) {
        messageDigest.update(byArray);
        byte[] byArray3 = messageDigest.digest();
        if (byArray3.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

