/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Factory;
import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERBIGInteger;
import com.teradata.tdgss.asn1.der.DERClass;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERInteger;
import com.teradata.tdgss.asn1.der.DERLength;
import com.teradata.tdgss.asn1.der.DERObjectIdentifier;
import com.teradata.tdgss.asn1.der.DEROctetString;
import com.teradata.tdgss.asn1.der.DERSequence;
import com.teradata.tdgss.asn1.der.DERTag;
import com.teradata.tdgss.asn1.der.DERUTF8String;
import com.teradata.tdgss.asn1.der.ListArray;
import java.math.BigInteger;
import org.ietf.jgss.Oid;

public class DER {
    private final boolean primitive = false;
    private final boolean constructed = true;
    private DERTag tag;
    private DERLength length;
    private DERASN1Type value;
    private int explicitlyEncodedBufferLength = 0;
    private int explicitlyEncodedBufferSize = 0;

    public DER(int n, long l) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(l);
    }

    public DER(int n, BigInteger bigInteger) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(bigInteger);
    }

    public DER(int n, byte[] byArray) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(byArray);
    }

    public DER(int n, byte by) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(new byte[]{by});
    }

    public DER(int n, String string) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(string);
    }

    public DER(int n, Oid oid) {
        this.tag = this.getDERTag(n, this.primitive);
        this.value = DERASN1Factory.createASN1Type(oid);
    }

    public DER(int n, ListArray listArray) {
        this.tag = this.getDERTag(n, this.constructed);
        this.value = DERASN1Factory.createASN1Type(listArray);
    }

    public DER(byte[] byArray) {
        this(byArray, 0);
    }

    public DER(byte[] byArray, boolean bl) {
        this(byArray, 0, bl);
    }

    public DER(byte[] byArray, int n) {
        this(byArray, n, true);
    }

    public DER(byte[] byArray, int n, boolean bl) {
        this.parse(byArray, n, bl);
    }

    private void parse(byte[] byArray, int n, boolean bl) {
        this.tag = new DERTag(byArray, n);
        this.length = new DERLength(byArray, n += this.tag.getTagOctets().length);
        byte[] byArray2 = new byte[this.length.getLength()];
        System.arraycopy(byArray, n += this.length.getLengthOctets().length, byArray2, 0, this.length.getLength());
        this.value = DERASN1Factory.createASN1Type(this.tag, byArray2, 0, byArray2.length, bl);
        if (!bl) {
            this.changeType();
            this.explicitlyEncodedBufferLength = this.length.getLength();
            this.explicitlyEncodedBufferSize = this.tag.size() + this.length.size() + this.explicitlyEncodedBufferLength;
        }
    }

    public boolean isConstructed() {
        return this.tag.isConstructed();
    }

    public int getTagNumber() {
        return this.tag.getTag();
    }

    public boolean add(DER dER) {
        if (this.value instanceof DERSequence) {
            ((DERSequence)this.value).add(dER);
            return true;
        }
        throw new DERException("Invalid operation");
    }

    public long getValueAsInt() {
        return new DERInteger(this.value.getOctets()).getValue();
    }

    public String getValueAsUTF8String() {
        return new DERUTF8String(this.value.getOctets()).getValue();
    }

    public Oid getValueAsOid() {
        return new DERObjectIdentifier(this.value.getOctets()).getValue();
    }

    public byte[] getValueAsOctetString() {
        return new DEROctetString(this.value.getOctets()).getValue();
    }

    public byte getValueAsByte() {
        byte[] byArray = new DEROctetString(this.value.getOctets()).getValue();
        return byArray[0];
    }

    public ListArray getValueAsSequence() {
        return ((DERSequence)this.value).getValue();
    }

    public DER[] getChildren() {
        ListArray listArray = this.getValueAsSequence();
        DER[] dERArray = new DER[listArray.size()];
        for (int i = 0; i < listArray.size(); ++i) {
            dERArray[i] = (DER)listArray.get(i);
        }
        return dERArray;
    }

    public DER getChildrenWithTag(int n) {
        if (this.isConstructed()) {
            return ((DERSequence)this.value).getElementWithTag(n);
        }
        throw new DERException("Invalid operation");
    }

    public byte[] getEncodedValue() {
        return this.getEncodedValue(true);
    }

    public byte[] getEncodedValue(boolean bl) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray2 = this.value.getOctets(bl);
        this.length = byArray2 != null ? new DERLength(byArray2.length) : new DERLength(0);
        byte[] byArray3 = this.concat(this.tag.getTagOctets(bl), this.length.getLengthOctets());
        byArray = this.concat(byArray3, byArray2 != null ? byArray2 : new byte[]{});
        if (!bl) {
            this.explicitlyEncodedBufferLength = byArray2 != null ? byArray2.length : 0;
            this.explicitlyEncodedBufferSize = byArray.length;
        }
        return byArray;
    }

    private final byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n += byArray.length, byArray2.length);
        return byArray3;
    }

    private DERTag getDERTag(int n, boolean bl) {
        DERClass dERClass = DERClass.PRIVATE;
        return new DERTag(dERClass, bl, n);
    }

    public int size() {
        return this.size(true);
    }

    public int size(boolean bl) {
        if (!bl) {
            if (this.explicitlyEncodedBufferSize == 0) {
                this.explicitlyEncodedBufferSize = this.getEncodedValue(bl).length;
            }
            return this.explicitlyEncodedBufferSize;
        }
        this.length = new DERLength(this.value.getOctets(true).length);
        return this.tag.size() + this.length.size() + this.value.getOctets(true).length;
    }

    public BigInteger getValueAsBigInt() {
        return new DERBIGInteger(this.value.getOctets()).getValue();
    }

    private void changeType() {
        if (this.value.isConstructed()) {
            this.tag.setConstructed();
        } else {
            this.tag.setPrimitive();
        }
    }
}

