/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.FormatChecker;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.ColumnDisplaySizes;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemDecimal;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class ColumnProperties {
    public static final int TDTYPE_NOT_AVAILABLE = -1;
    private int precision;
    private int scale;
    private String columnName;
    private String actualColumnName;
    private String columnFormat;
    private int columnType;
    private int m_nColumnBaseJDBCType;
    private String columnTypeName;
    private String columnClassName;
    private String schemaName;
    private String tableName;
    private boolean autoIncrement;
    private boolean currency;
    private boolean signed;
    private boolean searchable;
    private boolean readOnly;
    private boolean writable;
    private boolean definitelyWritable;
    private boolean keyColumn;
    private boolean unique;
    private int nullable;
    private String columnLabel;
    private int tdType;
    private int maxDataLengthInBytes;
    private int columnDisplaySize;
    private byte columnExtInfo;
    private int m_nArrayDimension;
    private int[] m_anArrayMaxCardinalities;
    private ArrayList m_attributeProperties = new ArrayList();
    private int m_nMetadataItemNumber;
    private boolean m_bCaseSensitive;
    private String m_sCatalogName = "";

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setIsSigned(boolean bl) {
        this.signed = bl;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public boolean isKeyColumn() {
        return this.keyColumn;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public void setColumnDisplaySize(int n) {
        this.columnDisplaySize = n;
    }

    public byte getColumnExtInfo() {
        return this.columnExtInfo;
    }

    public void determineCaseSensitiveFromColumnExtInfo() {
        this.m_bCaseSensitive = (this.columnExtInfo & 1) == 1;
    }

    public boolean caseSensitive() {
        return this.m_bCaseSensitive;
    }

    public String getCatalogName() {
        return this.m_sCatalogName;
    }

    public String getColumnFormat() {
        return this.columnFormat;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public void setColumnLabel(String string) {
        this.columnLabel = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getActualColumnName() {
        return this.actualColumnName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public int getColumnBaseJDBCType() {
        return this.m_nColumnBaseJDBCType;
    }

    public void setColumnType(int n, int n2) {
        this.m_nColumnBaseJDBCType = this.columnType = n;
        this.columnTypeName = JDBC4Constants.getJavaSQLTypeName(this.columnType);
        this.columnClassName = n2 == -1 ? JDBC4Constants.getJavaClassNameForSqlType(n) : JDBC4Constants.getJavaClassNameForTdType(n2);
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public String getColumnClassName(Map map) {
        Class clazz = (Class)map.get(this.columnTypeName);
        return clazz != null ? clazz.getName() : this.columnClassName;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTdType() {
        return this.tdType;
    }

    public void setTdType(int n) {
        this.tdType = n;
    }

    public int getMaxDataLengthInBytes() {
        return this.maxDataLengthInBytes;
    }

    public void initWithPrepInfoItem(PrepInfoItem prepInfoItem, GenericTeradataConnection genericTeradataConnection, StatementController statementController) throws SQLException {
        if (prepInfoItem != null) {
            this.columnFormat = prepInfoItem.getColumnFormat();
            this.columnName = prepInfoItem.getColumnName();
            this.columnLabel = prepInfoItem.getColumnTitle();
            this.m_nColumnBaseJDBCType = this.columnType = this.determineJavaSQLType(prepInfoItem.getDataType());
            this.columnTypeName = JDBC4Constants.getJavaSQLTypeName(this.columnType);
            this.columnClassName = JDBC4Constants.getJavaClassNameForTdType(prepInfoItem.getDataType());
            this.nullable = JDBC4Constants.getNullable(prepInfoItem.getDataType());
            this.tdType = prepInfoItem.getDataType();
            this.maxDataLengthInBytes = prepInfoItem.getDataLen();
            this.columnDisplaySize = JDBC4Constants.getDisplaySize(prepInfoItem.getDataType());
            if (this.columnDisplaySize == 0 && JDBC4Constants.isCharType(prepInfoItem.getDataType())) {
                this.columnDisplaySize = ColumnDisplaySizes.getCharDisplaySize(prepInfoItem.getDataLen(), genericTeradataConnection, prepInfoItem.getColumnServerCharSet());
            }
            if (this.columnDisplaySize == 0) {
                this.columnDisplaySize = prepInfoItem.getDataLen();
            }
            if (prepInfoItem instanceof PrepInfoItemDecimal) {
                this.precision = ((PrepInfoItemDecimal)prepInfoItem).getPrecision();
                this.scale = ((PrepInfoItemDecimal)prepInfoItem).getScale();
            } else {
                this.precision = this.columnType == -6 ? 3 : (this.columnType == 5 ? 5 : (this.columnType == 4 ? 10 : 0));
            }
            this.columnExtInfo = prepInfoItem.getColumnExtInfo();
            this.determineCaseSensitiveFromColumnExtInfo();
            long l = prepInfoItem instanceof PrepInfoItemDecimal ? (long)(this.precision <= 2 ? 1 : (this.precision <= 4 ? 2 : (this.precision <= 9 ? 4 : (this.precision <= 18 ? 8 : 16)))) : prepInfoItem.getLongDataLen();
            this.m_sCatalogName = statementController == null || statementController.getStatement().getSQLRequestEscapeFunction("REQUEST_SCOPE_CATALOG_JSON") == null ? "" : "{" + Utility.formatNameAndValueAsJSON("parcel", "PrepInfo") + "," + Utility.formatNameAndValueAsJSON("dataType", prepInfoItem.getDataType()) + "," + Utility.formatNameAndValueAsJSON("maxDataLengthInBytes", l) + "," + Utility.formatNameAndValueAsJSON("rawColumnName", prepInfoItem.getColumnName()) + "," + Utility.formatNameAndValueAsJSON("columnFormat", prepInfoItem.getColumnFormat()) + "," + Utility.formatNameAndValueAsJSON("columnTitle", prepInfoItem.getColumnTitle()) + "," + Utility.formatNameAndValueAsJSON("columnExtInfo", prepInfoItem.getColumnExtInfo()) + "," + Utility.formatNameAndValueAsJSON("columnServerCharset", prepInfoItem.getColumnServerCharSet()) + "," + Utility.formatNameAndValueAsJSON("caseSensitive", this.m_bCaseSensitive) + "," + Utility.formatNameAndValueAsJSON("columnName", this.columnName) + "," + Utility.formatNameAndValueAsJSON("columnLabel", this.columnLabel) + "," + Utility.formatNameAndValueAsJSON("columnType", this.columnType) + "," + Utility.formatNameAndValueAsJSON("columnBaseJDBCType", this.m_nColumnBaseJDBCType) + "," + Utility.formatNameAndValueAsJSON("columnTypeName", this.columnTypeName) + "," + Utility.formatNameAndValueAsJSON("columnClassName", this.columnClassName) + "," + Utility.formatNameAndValueAsJSON("nullable", this.nullable) + "," + Utility.formatNameAndValueAsJSON("columnDisplaySize", this.columnDisplaySize) + "," + Utility.formatNameAndValueAsJSON("precision", this.precision) + "," + Utility.formatNameAndValueAsJSON("scale", this.scale) + "}";
        }
    }

    public void initWithMetadataItem(FullContentMetadataItem fullContentMetadataItem, StatementController statementController) {
        byte by;
        boolean bl = (statementController.getSession().getURLParameters().getAccurateColumnNames() || statementController.getStatement().getSQLRequestEscapeFunction("REQUEST_SCOPE_COLUMN_NAME_ON") != null) && statementController.getStatement().getSQLRequestEscapeFunction("REQUEST_SCOPE_COLUMN_NAME_OFF") == null;
        boolean bl2 = statementController.getSession().getURLParameters().getMayBeNull() || statementController.getStatement().getSQLRequestEscapeFunction("REQUEST_SCOPE_MAYBENULL_ON") != null;
        this.m_nMetadataItemNumber = fullContentMetadataItem.getReceiveMetadataItemNumber();
        this.columnFormat = fullContentMetadataItem.getFormat();
        this.columnName = bl ? fullContentMetadataItem.getColumnOrParameterName() : fullContentMetadataItem.getLegacyPrepInfoColumnName();
        this.actualColumnName = fullContentMetadataItem.getColumnOrParameterName();
        this.columnLabel = bl ? fullContentMetadataItem.getLegacyPrepInfoColumnName() : fullContentMetadataItem.getTitle();
        this.m_nColumnBaseJDBCType = this.columnType = fullContentMetadataItem.getCustomerVisibleColumnType();
        this.columnTypeName = fullContentMetadataItem.getCustomerVisibleColumnTypeName();
        this.columnClassName = JDBC4Constants.getJavaClassNameForTdType(fullContentMetadataItem.getDataType());
        if (fullContentMetadataItem.getUdtIndicator() == 2) {
            this.columnType = 2001;
        }
        this.tdType = fullContentMetadataItem.getDataType();
        this.maxDataLengthInBytes = (int)fullContentMetadataItem.getMaxDataLengthInBytes();
        this.tableName = fullContentMetadataItem.getProcedureOrTableName();
        this.schemaName = fullContentMetadataItem.getDatabaseName();
        this.autoIncrement = fullContentMetadataItem.isIdentityColumn() == 89;
        this.signed = fullContentMetadataItem.isSigned() == 89;
        this.searchable = fullContentMetadataItem.isSearchable() == 89;
        this.writable = fullContentMetadataItem.isWritable() == 89;
        this.definitelyWritable = fullContentMetadataItem.isDefinitelyWritable() == 89;
        this.keyColumn = fullContentMetadataItem.isKeyColumn() == 89;
        this.unique = fullContentMetadataItem.isUnique() == 89;
        this.precision = ColumnProperties.determinePrecision(fullContentMetadataItem);
        this.scale = fullContentMetadataItem.getNumberOfFractionalDigits();
        this.columnExtInfo = fullContentMetadataItem.getColumnExtInfo();
        this.determineCaseSensitiveFromColumnExtInfo();
        this.m_nArrayDimension = fullContentMetadataItem.getNumberOfArrayDimensions();
        this.m_anArrayMaxCardinalities = fullContentMetadataItem.getArrayMaxCardinalities();
        this.columnDisplaySize = this.m_nColumnBaseJDBCType == 2 && !fullContentMetadataItem.isFloatingNumber() ? this.precision + 2 : JDBC4Constants.getDisplaySize(fullContentMetadataItem.getDataType());
        Integer n = JDBC4Constants.getCategory(fullContentMetadataItem.getDataType());
        if (n == JDBC4Constants.CTG_TIME_TS || n == JDBC4Constants.CTG_INTERVAL) {
            this.columnDisplaySize += fullContentMetadataItem.getNumberOfFractionalDigits() > 0 ? fullContentMetadataItem.getNumberOfFractionalDigits() + 1 : 0;
        }
        if (n == JDBC4Constants.CTG_INTERVAL) {
            this.columnDisplaySize += fullContentMetadataItem.getNumberOfIntervalDigits();
        }
        if (this.columnDisplaySize == 0 && JDBC4Constants.isCharType(fullContentMetadataItem.getDataType())) {
            this.columnDisplaySize = (int)fullContentMetadataItem.getMaxNumberOfCharacters();
        }
        if (this.columnDisplaySize == 0 && this.columnType != 2002) {
            this.columnDisplaySize = (int)fullContentMetadataItem.getMaxDataLengthInBytes();
        }
        byte by2 = by = bl2 ? fullContentMetadataItem.getMayBeNull() : fullContentMetadataItem.isNullable();
        this.nullable = by == 89 ? 1 : (by == 78 ? 0 : 2);
        String string = fullContentMetadataItem.getCatalogName();
        if ("TD_LOCAL".equals(string) && !statementController.getSession().getURLParameters().getLocalCatalog()) {
            string = "";
        }
        this.m_sCatalogName = statementController.getStatement().getSQLRequestEscapeFunction("REQUEST_SCOPE_CATALOG_JSON") == null ? string : "{" + Utility.formatNameAndValueAsJSON("parcel", "StatementInfo") + "," + Utility.formatNameAndValueAsJSON("dataType", fullContentMetadataItem.getDataType()) + "," + Utility.formatNameAndValueAsJSON("maxDataLengthInBytes", fullContentMetadataItem.getMaxDataLengthInBytes()) + "," + Utility.formatNameAndValueAsJSON("rawColumnName", fullContentMetadataItem.getColumnOrParameterName()) + "," + Utility.formatNameAndValueAsJSON("columnFormat", fullContentMetadataItem.getFormat()) + "," + Utility.formatNameAndValueAsJSON("columnTitle", fullContentMetadataItem.getTitle()) + "," + Utility.formatNameAndValueAsJSON("columnExtInfo", fullContentMetadataItem.getColumnExtInfo()) + "," + Utility.formatNameAndValueAsJSON("columnServerCharset", fullContentMetadataItem.getCharsetCode()) + "," + Utility.formatNameAndValueAsJSON("caseSensitive", this.m_bCaseSensitive) + "," + Utility.formatNameAndValueAsJSON("columnName", this.columnName) + "," + Utility.formatNameAndValueAsJSON("columnLabel", this.columnLabel) + "," + Utility.formatNameAndValueAsJSON("columnType", this.columnType) + "," + Utility.formatNameAndValueAsJSON("columnBaseJDBCType", this.m_nColumnBaseJDBCType) + "," + Utility.formatNameAndValueAsJSON("columnTypeName", this.columnTypeName) + "," + Utility.formatNameAndValueAsJSON("columnClassName", this.columnClassName) + "," + Utility.formatNameAndValueAsJSON("nullable", this.nullable) + "," + Utility.formatNameAndValueAsJSON("columnDisplaySize", this.columnDisplaySize) + "," + Utility.formatNameAndValueAsJSON("precision", this.precision) + "," + Utility.formatNameAndValueAsJSON("scale", this.scale) + "," + Utility.formatNameAndValueAsJSON("totalNumberOfDigits", fullContentMetadataItem.getTotalNumberOfDigits()) + "," + Utility.formatNameAndValueAsJSON("numberOfIntervalDigits", fullContentMetadataItem.getNumberOfIntervalDigits()) + "," + Utility.formatNameAndValueAsJSON("numberOfFractionalDigits", fullContentMetadataItem.getNumberOfFractionalDigits()) + "," + Utility.formatNameAndValueAsJSON("columnPositionInTable", fullContentMetadataItem.getColumnPositionInTable()) + "," + Utility.formatNameAndValueAsJSON("asClauseName", fullContentMetadataItem.getAsClauseName()) + "," + Utility.formatNameAndValueAsJSON("defaultValue", fullContentMetadataItem.getDefaultValue()) + "," + Utility.formatNameAndValueAsJSON("isIdentityColumn", "" + (char)fullContentMetadataItem.isIdentityColumn()) + "," + Utility.formatNameAndValueAsJSON("isDefinitelyWritable", "" + (char)fullContentMetadataItem.isDefinitelyWritable()) + "," + Utility.formatNameAndValueAsJSON("isNullable", "" + (char)fullContentMetadataItem.isNullable()) + "," + Utility.formatNameAndValueAsJSON("mayBeNull", "" + (char)fullContentMetadataItem.getMayBeNull()) + "," + Utility.formatNameAndValueAsJSON("isSearchable", "" + (char)fullContentMetadataItem.isSearchable()) + "," + Utility.formatNameAndValueAsJSON("isWritable", "" + (char)fullContentMetadataItem.isWritable()) + "," + Utility.formatNameAndValueAsJSON("UDTIndicator", fullContentMetadataItem.getUdtIndicator()) + "," + Utility.formatNameAndValueAsJSON("UDTTypeName", fullContentMetadataItem.getUdtTypeName()) + "," + Utility.formatNameAndValueAsJSON("dataTypeMiscInfo", fullContentMetadataItem.getDataTypeMiscInfo()) + "," + Utility.formatNameAndValueAsJSON("maxNumberOfCharacters", fullContentMetadataItem.getMaxNumberOfCharacters()) + "," + Utility.formatNameAndValueAsJSON("isCaseSensitive", "" + (char)fullContentMetadataItem.isCaseSensitive()) + "," + Utility.formatNameAndValueAsJSON("isSigned", "" + (char)fullContentMetadataItem.isSigned()) + "," + Utility.formatNameAndValueAsJSON("isKeyColumn", "" + (char)fullContentMetadataItem.isKeyColumn()) + "," + Utility.formatNameAndValueAsJSON("isUnique", "" + (char)fullContentMetadataItem.isUnique()) + "," + Utility.formatNameAndValueAsJSON("isExpression", "" + (char)fullContentMetadataItem.isExpression()) + "," + Utility.formatNameAndValueAsJSON("isSortable", "" + (char)fullContentMetadataItem.isSortable()) + "," + Utility.formatNameAndValueAsJSON("isTemporal", fullContentMetadataItem.isTemporal()) + "," + Utility.formatNameAndValueAsJSON("serverDataType", fullContentMetadataItem.getServerDataType()) + "," + Utility.formatNameAndValueAsJSON("tableName", this.tableName) + "," + Utility.formatNameAndValueAsJSON("schemaName", this.schemaName) + "," + Utility.formatNameAndValueAsJSON("autoIncrement", this.autoIncrement) + "," + Utility.formatNameAndValueAsJSON("signed", this.signed) + "," + Utility.formatNameAndValueAsJSON("searchable", this.searchable) + "," + Utility.formatNameAndValueAsJSON("writable", this.writable) + "," + Utility.formatNameAndValueAsJSON("definitelyWritable", this.definitelyWritable) + "," + Utility.formatNameAndValueAsJSON("keyColumn", this.keyColumn) + "," + Utility.formatNameAndValueAsJSON("unique", this.unique) + "," + Utility.formatNameAndValueAsJSON("arrayDimensions", this.m_nArrayDimension) + "," + Utility.formatNameAndValueAsJSON("catalogName", string) + "}";
    }

    public static int determinePrecision(FullContentMetadataItem fullContentMetadataItem) {
        short s = fullContentMetadataItem.getDataType();
        if (s == 0) {
            return 0;
        }
        int n = fullContentMetadataItem.getTotalNumberOfDigits();
        if (n == 0) {
            if (JDBC4Constants.isCharType(s)) {
                n = (int)fullContentMetadataItem.getMaxNumberOfCharacters();
            } else if (JDBC4Constants.isBinaryType(s)) {
                n = (int)fullContentMetadataItem.getMaxDataLengthInBytes();
            } else if (JDBC4Constants.isIntervalType(s)) {
                n = JDBC4Constants.getDisplaySize(s) + fullContentMetadataItem.getNumberOfIntervalDigits() + fullContentMetadataItem.getNumberOfFractionalDigits() + (fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : 1);
            } else if (JDBC4Constants.getCategory(s) == JDBC4Constants.CTG_TIME_TS) {
                n = JDBC4Constants.getDisplaySize(s) + fullContentMetadataItem.getNumberOfFractionalDigits() + (fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : 1);
            } else if (JDBC4Constants.getJavaSQLType(s) == 91) {
                n = JDBC4Constants.getDisplaySize(s);
            }
        }
        return n;
    }

    private int determineJavaSQLType(int n) {
        if (this.getColumnFormat() != null && JDBC4Constants.getTDBasicType(n) == 452) {
            switch (FormatChecker.getFormatType(this.getColumnFormat())) {
                case 2: {
                    n = 760;
                    break;
                }
                case 3: {
                    n = 764;
                    break;
                }
                case 4: {
                    n = 748;
                    break;
                }
            }
        }
        return JDBC4Constants.getJavaSQLType(n);
    }

    public ColumnProperties addAttributeProperties(FullContentMetadataItem fullContentMetadataItem, StatementController statementController) {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.initWithMetadataItem(fullContentMetadataItem, statementController);
        this.m_attributeProperties.add(columnProperties);
        return columnProperties;
    }

    public ColumnProperties[] getAttributePropertiesArray() {
        return this.m_attributeProperties.toArray(new ColumnProperties[0]);
    }

    public boolean isStruct() {
        return this.columnType == 2002;
    }

    public int getArrayDimensions() {
        return this.m_nArrayDimension;
    }

    public int[] getArrayMaxCardinalities() {
        return this.m_anArrayMaxCardinalities;
    }

    public boolean isArray() {
        return this.columnType == 2003;
    }

    public int getMetadataItemNumber() {
        return this.m_nMetadataItemNumber;
    }
}

