/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.console;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.console.ConsoleStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class ConsoleConnection
extends GenericTeradataConnection
implements Connection,
ResultSetHelper {
    private boolean autoCommit = true;
    private boolean promptMode = false;

    public ConsoleConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
    }

    protected boolean getPromptMode() {
        return this.promptMode;
    }

    protected void setPromptMode(boolean bl) {
        this.promptMode = bl;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            genericLogoffController.run();
            this.io.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        return this.constructStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return 8;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void rollback() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.autoCommit = bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean hasResponseNullIndicatorBits() {
        return false;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getClientInfo(String)");
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    protected Statement constructStatement() throws SQLException {
        return new ConsoleStatement(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.abortIfClosed();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), Collections.EMPTY_MAP, sQLException);
        }
        SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ726", "setClientInfo(Properties)");
        throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), Collections.EMPTY_MAP, sQLException);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.abortIfClosed();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), Collections.EMPTY_MAP, sQLException);
        }
        SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ726", "setClientInfo(String,String)");
        throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), Collections.EMPTY_MAP, sQLException);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

