/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpServer
extends Thread {
    private Log m_log;
    private String m_sExpectedPrefix;
    private int m_nBrowserTabTimeoutInMs;
    private ServerSocket m_ss;
    private SQLException m_ex;
    private Map<String, String> m_mapRequestParams = new LinkedHashMap<String, String>();

    public HttpServer(Log log, int[] nArray, String string, int n, int n2) throws SQLException {
        this.m_log = log;
        this.m_sExpectedPrefix = string;
        this.m_nBrowserTabTimeoutInMs = n2;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n3;
        while (this.m_ss == null) {
            block4: {
                try {
                    this.m_ss = new ServerSocket(n5);
                    this.m_ss.setSoTimeout(n);
                }
                catch (Exception exception) {
                    if (n5 == n4) {
                        throw Utility.logEx(log, "HttpServer", Utility.wrapEx(exception, ErrorFactory.makeDriverJDBCException("TJ1545")));
                    }
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("HttpServer could not bind to port " + n5 + " due to " + exception);
                }
            }
            ++n5;
        }
        this.setDaemon(true);
        this.start();
    }

    public int getLocalPort() {
        return this.m_ss.getLocalPort();
    }

    public Map<String, String> waitForRequestParams(Log log) throws SQLException {
        long l = System.currentTimeMillis();
        Utility.waitForThreadDeath(this);
        if (log.isTimingEnabled()) {
            log.timing("Waiting for HttpServer thread took " + (System.currentTimeMillis() - l) + " ms");
        }
        if (this.m_ex != null) {
            throw this.m_ex;
        }
        return this.m_mapRequestParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("HttpServer listening on port " + this.m_ss.getLocalPort());
        }
        try {
            socket = this.m_ss.accept();
        }
        catch (IOException iOException) {
            this.m_ex = Utility.logEx(this.m_log, "HttpServer", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1546")));
            return;
        }
        try {
            this.m_ss.close();
        }
        catch (IOException iOException) {
            this.m_log.error("HttpServer close " + iOException);
        }
        try {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("HttpServer accepted connection from " + socket.getRemoteSocketAddress());
            }
            try {
                Object object;
                boolean bl;
                Object object2;
                String string;
                boolean bl2;
                String[] stringArray;
                int n;
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = 0;
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                    if ((n2 = n2 << 8 | n) != 0xD0A0D0A) continue;
                }
                String string2 = byteArrayOutputStream.toString("ASCII");
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug("HttpServer received HTTP request headers: " + string2);
                }
                String string3 = (stringArray = string2.split("\r\n")).length > 0 ? stringArray[0] : "";
                String[] stringArray2 = string3.split(" ");
                boolean bl3 = bl2 = stringArray2.length >= 3 && stringArray2[0].equals("GET") && stringArray2[1].startsWith(this.m_sExpectedPrefix) && stringArray2[2].startsWith("HTTP/");
                if (bl2) {
                    string = stringArray2[1].substring(this.m_sExpectedPrefix.length());
                    object2 = string.split("&");
                    for (bl = false; bl < ((String[])object2).length; bl += 1) {
                        object = object2[bl].split("=", 2);
                        this.m_mapRequestParams.put(object[0], ((String[])object).length == 2 ? object[1] : null);
                    }
                }
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug("HttpServer bValidRequest=" + bl2 + " m_mapRequestParams=" + this.m_mapRequestParams);
                }
                string = Utility.decodeURLParameter(this.m_mapRequestParams.getOrDefault("error", ""));
                object2 = Utility.decodeURLParameter(this.m_mapRequestParams.getOrDefault("error_description", ""));
                boolean bl4 = bl = string.length() > 0 || ((String)object2).length() > 0;
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug("HttpServer bError=" + bl + " sError=" + string + " sErrorDesc=" + (String)object2);
                }
                object = "HTTP/1.1 " + (bl2 ? "200 OK" : "404 Not Found") + "\r\n" + "Content-Type: text/html; charset=utf-8\r\n" + "Cache-Control: no-cache\r\n" + "Pragma: no-cache\r\n" + "Connection: close\r\n" + "\r\n" + (bl2 ? "<!DOCTYPE HTML>\r\n<html>\r\n<head>\r\n<title>" + ErrorMessage.messages.getString("OIDC-RESPONSE-TITLE") + "</title>\r\n" + "</head>\r\n" + "<body style=\"background-color: DimGray;\"" + (this.m_nBrowserTabTimeoutInMs < 0 ? "" : " onload=\"setTimeout(window.close," + this.m_nBrowserTabTimeoutInMs + ");\"") + ">\r\n" + "<p style=\"" + "border-radius: 10pt;" + "padding: 22pt;" + "background: DarkOrange;" + "color: white;" + "text-align: center;" + "font-family: sans-serif;" + "font-weight: bolder;" + "font-size: 24pt;" + "\">" + ErrorMessage.messages.getString(bl ? "OIDC-RESPONSE-ERROR" : "OIDC-RESPONSE-BODY") + "</p>\r\n" + "</body>\r\n" + "</html>\r\n" : "");
                outputStream.write(((String)object).getBytes("UTF-8"));
                if (bl) {
                    throw new IOException("HttpServer received " + (string.length() > 0 ? string : "unspecified") + " error " + (String)(((String)object2).length() > 0 ? object2 : "with no description"));
                }
            }
            catch (IOException iOException) {
                this.m_ex = Utility.logEx(this.m_log, "HttpServer", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1547")));
                try {
                    socket.shutdownInput();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                socket.shutdownInput();
            }
            catch (IOException iOException) {}
            try {
                socket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

