/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.HttpServer;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class BrowserAuth {
    private static final String PLACEHOLDER = "PLACEHOLDER";
    private static final Object sm_mutexActiveBrowser = new Object();

    public static void validateBrowserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1539");
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1540");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBrowserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, TokenCache.CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doBrowserAuth bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            Map<String, String> map;
            Object object;
            boolean bl2;
            String string6;
            Object object2;
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            String string7 = uRLParameters.getBrowser();
            if (string7 == null || string7.length() == 0) {
                object2 = System.getProperty("os.name");
                String string8 = string6 = object2 != null ? ((String)object2).toUpperCase() : "";
                if (string6.indexOf("WIN") >= 0) {
                    string7 = "cmd /c start \"title\" \"PLACEHOLDER\"";
                } else if (string6.indexOf("MAC") >= 0) {
                    string7 = "open PLACEHOLDER";
                } else {
                    throw ErrorFactory.makeDriverJDBCException("TJ1541", (String)object2);
                }
            }
            object2 = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
            string6 = ((Utility.HttpResponse)object2).sBody;
            String string9 = Utility.getStringFromJSON("authorization_endpoint", string6, "TJ1544", string3);
            String string10 = Utility.getStringFromJSON("token_endpoint", string6, "TJ1544", string3);
            String string11 = Utility.base64Encode(true, Utility.getRandomBytes(32));
            String string12 = Utility.base64Encode(true, Utility.hashBytes(log, "SHA-256", Encoder.encodeStringAsciiReplace(genericTeradataConnection, string11)));
            String string13 = "/openid-callback";
            int n = uRLParameters.getBrowserTimeout() * 1000;
            int n2 = uRLParameters.getBrowserTabTimeout() * 1000;
            if (log.isTimingEnabled()) {
                log.timing("Starting HttpServer with Browser Authentication timeout " + n + " ms and browser tab timeout " + n2 + " ms");
            }
            HttpServer httpServer = new HttpServer(log, uRLParameters.getOIDCRedirectPortRange(), string13 + "?", n, n2);
            String string14 = "http://127.0.0.1:" + httpServer.getLocalPort() + string13;
            genericTeradataConnection.m_extraClientAttributes.sOIDCRedirectPort = (uRLParameters.getOIDCRedirectPortRange()[0] == 0 ? "E" : "") + httpServer.getLocalPort();
            boolean bl3 = string != null && string.length() > 0;
            boolean bl4 = bl2 = bl3 && uRLParameters.getOIDCPrompt() != null;
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string6);
                log.debug("sAuthURL=" + string9);
                log.debug("sTokenURL=" + string10);
                log.debug("sCodeVerifier=" + string11);
                log.debug("sCodeChallenge=" + string12);
                log.debug("sRedirectURL=" + string14);
                log.debug("sUserName=" + string + " bUseLoginHint=" + bl3);
                log.debug("getOIDCPrompt=" + uRLParameters.getOIDCPrompt() + " bUsePrompt=" + bl2);
                log.debug("(before PLACEHOLDER swap) sBrowser=" + string7);
            }
            string7 = string7.replaceAll(PLACEHOLDER, string9 + "?response_type=code" + "&client_id=" + Utility.safeForURL(string4) + "&redirect_uri=" + Utility.safeForURL(string14) + "&code_challenge=" + Utility.safeForURL(string12) + "&code_challenge_method=S256" + "&scope=" + Utility.safeForURL(string5) + "&state=" + Utility.base64Encode(true, Utility.getRandomBytes(16)) + (bl3 ? "&login_hint=" + Utility.safeForURL(string) : "") + (bl2 ? "&prompt=" + Utility.safeForURL(uRLParameters.getOIDCPrompt()) : ""));
            Object object3 = sm_mutexActiveBrowser;
            synchronized (object3) {
                block22: {
                    if (log.isTimingEnabled()) {
                        log.timing("Launching browser " + string7);
                    }
                    try {
                        object = Runtime.getRuntime().exec(string7);
                    }
                    catch (IOException iOException) {
                        throw Utility.logEx(log, "Runtime exec", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1551", string7)));
                    }
                    try {
                        ((Process)object).getInputStream().close();
                        ((Process)object).getOutputStream().close();
                        ((Process)object).getErrorStream().close();
                    }
                    catch (IOException iOException) {
                        if (!log.isDebugEnabled()) break block22;
                        log.debug("Ignoring Process stream close exception: " + iOException);
                    }
                }
                map = httpServer.waitForRequestParams(log);
            }
            object3 = map.get("code");
            if (object3 == null || ((String)object3).length() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ1548");
            }
            object = "grant_type=authorization_code&client_id=" + Utility.safeForURL(string4) + "&code=" + Utility.safeForURL((String)object3) + "&redirect_uri=" + Utility.safeForURL(string14) + "&code_verifier=" + Utility.safeForURL(string11);
            if (log.isDebugEnabled()) {
                log.debug("sClientID=" + string4);
                log.debug("sCode=" + (String)object3);
                log.debug("sRedirectURL=" + string14);
                log.debug("sCodeVerifier=" + string11);
                log.debug("sFormData=" + (String)object);
            }
            byte[] byArray = Encoder.encodeStringUTF8((String)object);
            string6 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string10, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
            TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string10, string6, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doBrowserAuth bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }
}

