/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.client;

import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClientClob
implements Clob {
    private boolean m_bFreed = false;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private List<char[]> m_bufferList = new ArrayList<char[]>();
    private final Object lock = new Object();
    private long m_nTotalSize = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.m_bFreed) {
                return;
            }
            this.m_bFreed = true;
            this.m_bufferList.clear();
            this.m_nTotalSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            return this.m_nTotalSize;
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, this.m_nTotalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 1L || l2 < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.getCharacterStream");
            }
            if (l + l2 > this.m_nTotalSize + 1L) {
                throw ErrorFactory.makeDriverJDBCException("TJ219", "Clob.getCharacterStream");
            }
            if (l - 1L + l2 > this.m_nTotalSize) {
                l2 = this.m_nTotalSize - (l - 1L);
            }
            return new ClobReader(l - 1L, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l, int n) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 1L || n < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.getSubString");
            }
            if (n == 0 || l > this.m_nTotalSize) {
                return "";
            }
            if ((long)n + l > this.m_nTotalSize + 1L) {
                n = (int)this.m_nTotalSize - (int)l + 1;
            }
            char[] cArray = new char[n];
            long l2 = l - 1L;
            long l3 = 0L;
            while (l3 < (long)n) {
                int n2 = (int)l2 / 0x100000;
                int n3 = (int)l2 % 0x100000;
                char[] cArray2 = this.m_bufferList.get(n2);
                int n4 = Math.min(n - (int)l3, 0x100000 - n3);
                System.arraycopy(cArray2, n3, cArray, (int)l3, n4);
                l3 += (long)n4;
                l2 += (long)n4;
            }
            return new String(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (string == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ516", "ClientClob.position");
            }
            if (l < 1L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "position");
            }
            if (l + (long)string.length() > this.m_nTotalSize + 1L) {
                return -1L;
            }
            long l2 = this.m_nTotalSize - (long)string.length() + 1L;
            for (long i = l; i <= l2; ++i) {
                if (!this.matchesPattern(i - 1L, string.toCharArray())) continue;
                return i;
            }
            return -1L;
        }
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob == null ? null : clob.getSubString(1L, (int)clob.length()), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l <= 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setAsciiStream");
            }
            return new ClobOutputStream(l - 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            return new ClobInputStream(0L, this.m_nTotalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l <= 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setCharacterStream");
            }
            return new ClobWriter(l - 1L);
        }
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string == null ? 0 : string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            int n3;
            int n4;
            this.verifyFreedStatus();
            if (string == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ516", "Clob.setString");
            }
            if (l < 1L || n2 < 0 || n < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setString");
            }
            if (n2 == 0 || n >= string.length()) {
                return 0;
            }
            if (n + n2 > string.length()) {
                n2 = string.length() - n;
            }
            long l2 = l - 1L;
            long l3 = Math.max(this.m_nTotalSize, l2 + (long)n2);
            int n5 = 0;
            this.ensureCapacity(l3);
            while (this.m_nTotalSize < l2) {
                n4 = (int)(this.m_nTotalSize / 0x100000L);
                n3 = (int)(this.m_nTotalSize % 0x100000L);
                cArray = this.m_bufferList.get(n4);
                cArray[n3] = 32;
                ++this.m_nTotalSize;
            }
            while (n5 < n2) {
                n4 = (int)(l2 / 0x100000L);
                n3 = (int)(l2 % 0x100000L);
                cArray = this.m_bufferList.get(n4);
                int n6 = Math.min(n2 - n5, 0x100000 - n3);
                string.getChars(n + n5, n + n5 + n6, cArray, n3);
                n5 += n6;
                l2 += (long)n6;
            }
            this.m_nTotalSize = l3;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.truncate");
            }
            if (l >= this.m_nTotalSize) {
                return;
            }
            long l2 = (l + 0x100000L - 1L) / 0x100000L;
            while ((long)this.m_bufferList.size() > l2) {
                this.m_bufferList.remove(this.m_bufferList.size() - 1);
            }
            if (this.m_bufferList.size() > 0) {
                int n = this.m_bufferList.size() - 1;
                char[] cArray = this.m_bufferList.get(n);
                int n2 = (int)(l % 0x100000L);
                if (n2 == 0) {
                    n2 = 0x100000;
                }
                Arrays.fill(cArray, n2, cArray.length, '\u0000');
            }
            this.m_nTotalSize = l;
        }
    }

    private boolean matchesPattern(long l, char[] cArray) throws SQLException {
        long l2 = l;
        for (int i = 0; i < cArray.length; ++i) {
            int n = (int)l2 / 0x100000;
            int n2 = (int)l2 % 0x100000;
            char[] cArray2 = this.m_bufferList.get(n);
            if (cArray2[n2] != cArray[i]) {
                return false;
            }
            ++l2;
        }
        return true;
    }

    private void ensureCapacity(long l) {
        while (l > (long)(this.m_bufferList.size() * 0x100000)) {
            this.m_bufferList.add(new char[0x100000]);
        }
    }

    private void verifyFreedStatus() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
    }

    private void verifyParameters(String string, boolean bl, Object object, int n, int n2, int n3) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (bl) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", string);
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (object == null) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ516", string);
            throw new NullPointerException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (n < 0 || n2 < 0) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ218", string);
            throw new IndexOutOfBoundsException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (n2 > n3 - n) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ219", string);
            throw new IndexOutOfBoundsException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }

    public class ClobOutputStream
    extends OutputStream {
        private long m_nStreamPosition;
        private boolean m_bClosed = false;

        public ClobOutputStream(long l) throws SQLException {
            this.m_nStreamPosition = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) throws IOException {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "ClientClob@ClobOutputStream.write");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                ClientClob.this.ensureCapacity(this.m_nStreamPosition + 1L);
                int n2 = (int)this.m_nStreamPosition / 0x100000;
                int n3 = (int)this.m_nStreamPosition % 0x100000;
                char[] cArray = (char[])ClientClob.this.m_bufferList.get(n2);
                cArray[n3] = (char)(n & 0xFF);
                ++this.m_nStreamPosition;
                if (this.m_nStreamPosition > ClientClob.this.m_nTotalSize) {
                    ClientClob.this.m_nTotalSize = this.m_nStreamPosition;
                }
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray == null ? 0 : byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                int n3;
                ClientClob.this.verifyParameters("ClientClob@ClobOutputStream.write", this.m_bClosed, byArray, n, n2, byArray == null ? 0 : byArray.length);
                ClientClob.this.ensureCapacity(this.m_nStreamPosition + (long)n2);
                while (ClientClob.this.m_nTotalSize < this.m_nStreamPosition) {
                    n3 = (int)(ClientClob.this.m_nTotalSize / 0x100000L);
                    int n4 = (int)(ClientClob.this.m_nTotalSize % 0x100000L);
                    char[] cArray = (char[])ClientClob.this.m_bufferList.get(n3);
                    cArray[n4] = 32;
                    ClientClob.this.m_nTotalSize++;
                }
                n3 = 0;
                long l = this.m_nStreamPosition;
                while (n3 < n2) {
                    int n5 = (int)this.m_nStreamPosition / 0x100000;
                    int n6 = (int)(this.m_nStreamPosition % 0x100000L);
                    char[] cArray = (char[])ClientClob.this.m_bufferList.get(n5);
                    int n7 = Math.min(n2 - n3, 0x100000 - n6);
                    for (int i = 0; i < n7; ++i) {
                        cArray[n6 + i] = (char)(byArray[n + n3 + i] & 0xFF);
                    }
                    n3 += n7;
                    this.m_nStreamPosition += (long)n7;
                }
                if ((long)n3 + l > ClientClob.this.m_nTotalSize) {
                    ClientClob.this.m_nTotalSize = (long)n3 + l;
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }
    }

    public class ClobInputStream
    extends InputStream {
        private long m_nPos;
        private final long m_nEndPosition;
        private boolean m_bClosed = false;

        public ClobInputStream(long l, long l2) {
            this.m_nPos = l;
            this.m_nEndPosition = l + l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "ClientClob@ClobInputStream.read");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                int n = (int)this.m_nPos / 0x100000;
                int n2 = (int)this.m_nPos % 0x100000;
                char[] cArray = (char[])ClientClob.this.m_bufferList.get(n);
                int n3 = cArray[n2] & 0xFF;
                ++this.m_nPos;
                return n3;
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray == null ? 0 : byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                ClientClob.this.verifyParameters("ClientClob@ClobInputStream.read", this.m_bClosed, byArray, n, n2, byArray == null ? 0 : byArray.length);
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                n2 = (int)Math.min((long)n2, this.m_nEndPosition - this.m_nPos);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = (int)this.m_nPos / 0x100000;
                    int n5 = (int)this.m_nPos % 0x100000;
                    char[] cArray = (char[])ClientClob.this.m_bufferList.get(n4);
                    int n6 = Math.min(n2 - n3, 0x100000 - n5);
                    for (int i = 0; i < n6; ++i) {
                        byArray[n + n3 + i] = (byte)(cArray[n5 + i] & 0xFF);
                    }
                    n3 += n6;
                    this.m_nPos += (long)n6;
                }
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = ClientClob.this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }
    }

    public class ClobWriter
    extends Writer {
        private long m_nStreamPosition;
        private boolean m_bClosed = false;

        public ClobWriter(long l) throws SQLException {
            this.m_nStreamPosition = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "ClientClob@ClobWriter.write");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                ClientClob.this.ensureCapacity(this.m_nStreamPosition + 1L);
                int n2 = (int)this.m_nStreamPosition / 0x100000;
                int n3 = (int)this.m_nStreamPosition % 0x100000;
                char[] cArray = (char[])ClientClob.this.m_bufferList.get(n2);
                cArray[n3] = (char)n;
                ++this.m_nStreamPosition;
                if (this.m_nStreamPosition > ClientClob.this.m_nTotalSize) {
                    ClientClob.this.m_nTotalSize = this.m_nStreamPosition;
                }
            }
        }

        @Override
        public void write(char[] cArray) throws IOException {
            this.write(cArray, 0, cArray == null ? 0 : cArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                int n3;
                ClientClob.this.verifyParameters("ClientClob@ClobWriter.write", this.m_bClosed, cArray, n, n2, cArray == null ? 0 : cArray.length);
                ClientClob.this.ensureCapacity(this.m_nStreamPosition + (long)n2);
                while (ClientClob.this.m_nTotalSize < this.m_nStreamPosition) {
                    n3 = (int)(ClientClob.this.m_nTotalSize / 0x100000L);
                    int n4 = (int)(ClientClob.this.m_nTotalSize % 0x100000L);
                    char[] cArray2 = (char[])ClientClob.this.m_bufferList.get(n3);
                    cArray2[n4] = 32;
                    ClientClob.this.m_nTotalSize++;
                }
                n3 = 0;
                long l = this.m_nStreamPosition;
                while (n3 < n2) {
                    int n5 = (int)this.m_nStreamPosition / 0x100000;
                    int n6 = (int)(this.m_nStreamPosition % 0x100000L);
                    char[] cArray3 = (char[])ClientClob.this.m_bufferList.get(n5);
                    int n7 = Math.min(n2 - n3, 0x100000 - n6);
                    System.arraycopy(cArray, n + n3, cArray3, n6, n7);
                    n3 += n7;
                    this.m_nStreamPosition += (long)n7;
                }
                if ((long)n3 + l > ClientClob.this.m_nTotalSize) {
                    ClientClob.this.m_nTotalSize = (long)n3 + l;
                }
            }
        }

        @Override
        public void write(String string) throws IOException {
            this.write(string == null ? null : string.toCharArray());
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            this.write(string == null ? null : string.toCharArray(), n, n2);
        }

        @Override
        public void flush() throws IOException {
        }
    }

    public class ClobReader
    extends Reader {
        private long m_nPos;
        private final long m_nEndPosition;
        private boolean m_bClosed = false;

        public ClobReader(long l, long l2) {
            this.m_nPos = l;
            this.m_nEndPosition = l + l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "ClientClob@ClobReader.read");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                int n = (int)this.m_nPos / 0x100000;
                int n2 = (int)this.m_nPos % 0x100000;
                char[] cArray = (char[])ClientClob.this.m_bufferList.get(n);
                char c = cArray[n2];
                ++this.m_nPos;
                return c;
            }
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray == null ? 0 : cArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                ClientClob.this.verifyParameters("ClientClob@ClobReader.read", this.m_bClosed, cArray, n, n2, cArray == null ? 0 : cArray.length);
                if (n2 > cArray.length - n) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ219", "ClientClob@ClobReader.read");
                    throw new IndexOutOfBoundsException(sQLException.getErrorCode() + ": " + sQLException);
                }
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                n2 = (int)Math.min((long)n2, this.m_nEndPosition - this.m_nPos);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = (int)this.m_nPos / 0x100000;
                    int n5 = (int)this.m_nPos % 0x100000;
                    char[] cArray2 = (char[])ClientClob.this.m_bufferList.get(n4);
                    int n6 = Math.min(n2 - n3, 0x100000 - n5);
                    System.arraycopy(cArray2, n5, cArray, n + n3, n6);
                    n3 += n6;
                    this.m_nPos += (long)n6;
                }
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }
    }
}

