/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jtdgss.TdgssDeferredLogger;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLocationLogger;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMechProp;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssParseXml;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TdgssConfigApi {
    private static final TdgssDeferredLogger deferredLogger = new TdgssDeferredLogger();
    public static final int LEGACY_QOP_VALUES = 5;
    public static final int SUPPORTED_QOP_VALUES = 7;
    private static final String CONFIDENTIALITY_ALGORITHM = "ConfidentialityAlgorithm";
    private static final String KEY_LENGTH = "KeyLength";
    private static final String MODE = "Mode";
    private static final String PADDING = "Padding";
    private static final String INTEGRITY_ALGORITHM = "IntegrityAlgorithm";
    private static final String KEY_EXCHANGE_ALGORITHM = "KeyExchangeAlgorithm";
    private static final String KEY_LENGTH_P = "KeyLengthP";
    private Node Mechanisms = null;
    private final Document doc;
    private final TdgssLogger logger;
    private static final TdgssConfigApi instance = new TdgssConfigApi(deferredLogger);

    private TdgssConfigApi() {
        this(deferredLogger);
    }

    private TdgssConfigApi(TdgssLogger tdgssLogger) {
        this.logger = new TdgssLocationLogger(tdgssLogger);
        String string = "com/teradata/tdgss/jtdgss/TdgssLibraryConfigFile.xml";
        String string2 = "TdgssUserConfigFile.xml";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            this.logger.error("WARNING ! System Class Loader is not available!!");
            throw new NullPointerException();
        }
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        while (classLoader != null) {
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream2 == null) {
                inputStream2 = classLoader.getResourceAsStream(string2);
            }
            if (inputStream2 != null && inputStream != null) break;
            classLoader = classLoader.getParent();
        }
        Document document = null;
        try {
            TdgssParseXml tdgssParseXml = new TdgssParseXml(inputStream, inputStream2, tdgssLogger);
            document = tdgssParseXml.parse();
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
        }
        this.doc = document;
    }

    private TdgssConfigApi(Document document, TdgssLogger tdgssLogger) {
        this.doc = document;
        this.logger = new TdgssLocationLogger(tdgssLogger);
        if (document == null) {
            this.logger.error("Parsing the TDGSS configuration failed. See earlier logs.");
        }
    }

    public static TdgssConfigApi getInstance() {
        return instance;
    }

    public static TdgssConfigApi newInstance(TdgssLogger tdgssLogger) {
        deferredLogger.report(tdgssLogger);
        return new TdgssConfigApi(TdgssConfigApi.instance.doc, tdgssLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node GetNode(Node node, String string) {
        Document document = this.doc;
        synchronized (document) {
            if (node == null) {
                return this.Mechanisms;
            }
            if (node.getNodeType() == 1 && node.getNodeName() != null && node.getNodeName().equalsIgnoreCase(string)) {
                this.Mechanisms = node;
            }
            if (this.Mechanisms == null && node.hasChildNodes()) {
                this.GetNode(node.getFirstChild(), string);
            }
            Node node2 = node.getNextSibling();
            if (this.Mechanisms == null && node2 != null) {
                this.GetNode(node2, string);
            }
            return this.Mechanisms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node FindNode(Node node, String string) {
        Document document = this.doc;
        synchronized (document) {
            this.Mechanisms = null;
            return this.GetNode(node, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] GetMechanisms() {
        Document document = this.doc;
        synchronized (document) {
            String[] stringArray = new String[20];
            int n = 0;
            String string = "";
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            Node node2 = node.getFirstChild();
            Node node3 = null;
            while (node2 != null) {
                if (node2.getNodeType() == 1) {
                    Object object;
                    int n2;
                    boolean bl = false;
                    if (node2.getNodeName().equalsIgnoreCase("Mechanism") && node2.hasAttributes() && node2.getAttributes().getLength() > 0) {
                        for (n2 = 0; n2 < node2.getAttributes().getLength(); ++n2) {
                            if (node2.getAttributes().item(n2) == null || !node2.getAttributes().item(n2).getNodeName().equalsIgnoreCase("Name") || !node2.getAttributes().item(n2).getNodeValue().equalsIgnoreCase("NTLM")) continue;
                            bl = true;
                        }
                    }
                    if (bl) {
                        node2 = node2.getNextSibling();
                        continue;
                    }
                    node3 = node2;
                    for (n2 = 0; n2 < node3.getChildNodes().getLength(); ++n2) {
                        if (node3.getChildNodes().item(n2).getNodeType() != 1 || !node3.getChildNodes().item(n2).getNodeName().equalsIgnoreCase("MechanismProperties")) continue;
                        object = node3.getChildNodes().item(n2).getAttributes();
                        if (!node3.getChildNodes().item(n2).hasAttributes()) continue;
                        for (int i = 0; i < object.getLength(); ++i) {
                            if (object.item(i) == null || !object.item(i).getNodeName().equalsIgnoreCase("MechanismEnabled") || !object.item(i).getNodeValue().equalsIgnoreCase("yes")) continue;
                            bl = true;
                        }
                    }
                    string = "com.teradata.tdgss.j";
                    if (bl && node2.hasAttributes() && node2.getAttributes().getLength() > 0) {
                        for (n2 = 0; n2 < node2.getAttributes().getLength(); ++n2) {
                            if (node2.getAttributes().item(n2) == null) continue;
                            if (node2.getAttributes().item(n2).getNodeName().equalsIgnoreCase("LibraryName")) {
                                if (!node2.getAttributes().item(n2).getNodeValue().equalsIgnoreCase("gssp2sspi")) {
                                    string = string + node2.getAttributes().item(n2).getNodeValue().toLowerCase() + ".";
                                    continue;
                                }
                                string = string + "gssp2gss.";
                                continue;
                            }
                            if (!node2.getAttributes().item(n2).getNodeName().equalsIgnoreCase("Prefix")) continue;
                            object = node2.getAttributes().item(n2).getNodeValue().toUpperCase();
                            if (((String)(object = ((String)object).substring(0, 1) + ((String)object).substring(1).toLowerCase())).equalsIgnoreCase("ldapv3")) {
                                object = "Ldap";
                            }
                            string = string + (String)object + "Mechanism";
                        }
                    }
                    if (bl) {
                        stringArray[n] = string;
                        ++n;
                    }
                }
                node2 = node2.getNextSibling();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] GetQopForMech(String string) {
        Document document = this.doc;
        synchronized (document) {
            int[] nArray = new int[10];
            int n = 0;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n2;
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Node node2 = null;
                if (nodeList.item(i).hasAttributes()) {
                    for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                        if (namedNodeMap.item(n2) == null || !namedNodeMap.item(n2).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(n2).getNodeValue().equalsIgnoreCase(string)) continue;
                        node2 = nodeList.item(i);
                        break;
                    }
                }
                if (node2 == null) continue;
                for (n2 = 0; n2 < node2.getChildNodes().getLength(); ++n2) {
                    if (node2.getChildNodes().item(n2).getNodeType() != 1 || !node2.getChildNodes().item(n2).getNodeName().equalsIgnoreCase("MechQop")) continue;
                    namedNodeMap = node2.getChildNodes().item(n2).getAttributes();
                    if (!node2.getChildNodes().item(n2).hasAttributes()) continue;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase("Value")) continue;
                        nArray[n] = new Integer(namedNodeMap.item(j).getNodeValue());
                        ++n;
                    }
                }
            }
            nArray[n] = -1;
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] GetInforForQOP(String string, int n) {
        Document document = this.doc;
        synchronized (document) {
            int n2;
            Object object;
            String[] stringArray = new String[5];
            String string2 = null;
            int n3 = 0;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                object = nodeList.item(i).getAttributes();
                Node node2 = null;
                boolean bl = false;
                if (nodeList.item(i).hasAttributes()) {
                    for (n2 = 0; n2 < object.getLength(); ++n2) {
                        if (object.item(n2) == null || !object.item(n2).getNodeName().equalsIgnoreCase("ObjectId") || !object.item(n2).getNodeValue().equalsIgnoreCase(string)) continue;
                        node2 = nodeList.item(i);
                        break;
                    }
                }
                if (node2 == null) continue;
                for (n2 = 0; n2 < node2.getChildNodes().getLength(); ++n2) {
                    Node node3;
                    if (node2.getChildNodes().item(n2).getNodeType() != 1 || !node2.getChildNodes().item(n2).getNodeName().equalsIgnoreCase("MechQop")) continue;
                    object = node2.getChildNodes().item(n2).getAttributes();
                    if (node2.getChildNodes().item(n2).hasAttributes()) {
                        for (int j = 0; j < object.getLength(); ++j) {
                            if (object.item(j) == null || new Integer(object.item(j).getNodeValue()) != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl || !(node3 = node2.getChildNodes().item(n2)).hasChildNodes() || node3.getFirstChild().getNodeType() != 3 || node3.getFirstChild().getNodeValue() == null || node3.getFirstChild().getNodeValue().trim().length() <= 0) continue;
                    string2 = node3.getFirstChild().getNodeValue();
                    break;
                }
                if (bl) break;
            }
            if (string2 == null) {
                return stringArray;
            }
            Node node4 = this.FindNode(this.doc.getFirstChild(), "GlobalQOPs");
            object = node4.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                if (object.item(i).getNodeType() != 1) continue;
                if (n3 > 1) break;
                NamedNodeMap namedNodeMap = object.item(i).getAttributes();
                if (object.item(i).hasAttributes()) {
                    for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                        if (namedNodeMap.item(n2) == null || !namedNodeMap.item(n2).getNodeName().equalsIgnoreCase("Value") || !namedNodeMap.item(n2).getNodeValue().trim().equalsIgnoreCase(string2.trim())) continue;
                        ++n3;
                        break;
                    }
                }
                if (n3 <= 0) continue;
                for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                    if (namedNodeMap.item(n2) == null) continue;
                    if (namedNodeMap.item(n2).getNodeName().equalsIgnoreCase(CONFIDENTIALITY_ALGORITHM)) {
                        stringArray[0] = namedNodeMap.item(n2).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(n2).getNodeName().equalsIgnoreCase(KEY_LENGTH)) {
                        stringArray[1] = namedNodeMap.item(n2).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(n2).getNodeName().equalsIgnoreCase(MODE)) {
                        stringArray[2] = namedNodeMap.item(n2).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(n2).getNodeName().equalsIgnoreCase(PADDING)) {
                        stringArray[3] = namedNodeMap.item(n2).getNodeValue();
                        continue;
                    }
                    if (!namedNodeMap.item(n2).getNodeName().equalsIgnoreCase(INTEGRITY_ALGORITHM)) continue;
                    stringArray[4] = namedNodeMap.item(n2).getNodeValue();
                }
                break;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetPropertyForMech(String string, String string2) {
        Document document = this.doc;
        synchronized (document) {
            String string3 = null;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n;
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Node node2 = null;
                if (nodeList.item(i).hasAttributes()) {
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (namedNodeMap.item(n) == null || !namedNodeMap.item(n).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(n).getNodeValue().equalsIgnoreCase(string)) continue;
                        node2 = nodeList.item(i);
                        break;
                    }
                }
                if (node2 == null) continue;
                for (n = 0; n < node2.getChildNodes().getLength(); ++n) {
                    if (node2.getChildNodes().item(n).getNodeType() != 1 || !node2.getChildNodes().item(n).getNodeName().equalsIgnoreCase("MechanismProperties")) continue;
                    namedNodeMap = node2.getChildNodes().item(n).getAttributes();
                    if (!node2.getChildNodes().item(n).hasAttributes()) continue;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase(string2)) continue;
                        return namedNodeMap.item(j).getNodeValue();
                    }
                }
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TdgssMechProp[] InquirePropertiesForMech(String string) {
        Document document = this.doc;
        synchronized (document) {
            TdgssMechProp[] tdgssMechPropArray = new TdgssMechProp[100];
            String string2 = null;
            String string3 = null;
            int n = 0;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n2;
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Node node2 = null;
                if (nodeList.item(i).hasAttributes()) {
                    for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                        if (namedNodeMap.item(n2) == null || !namedNodeMap.item(n2).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(n2).getNodeValue().equalsIgnoreCase(string)) continue;
                        node2 = nodeList.item(i);
                        break;
                    }
                }
                if (node2 == null) continue;
                for (n2 = 0; n2 < node2.getChildNodes().getLength(); ++n2) {
                    if (node2.getChildNodes().item(n2).getNodeType() != 1 || !node2.getChildNodes().item(n2).getNodeName().equalsIgnoreCase("MechanismProperties")) continue;
                    namedNodeMap = node2.getChildNodes().item(n2).getAttributes();
                    if (!node2.getChildNodes().item(n2).hasAttributes()) continue;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (namedNodeMap.item(j) != null) {
                            Integer n3;
                            string2 = namedNodeMap.item(j).getNodeName();
                            int n4 = 2;
                            try {
                                n3 = new Integer(namedNodeMap.item(j).getNodeValue());
                                n4 = 1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                n4 = 2;
                            }
                            if (namedNodeMap.item(j).getNodeValue().equalsIgnoreCase("yes") || namedNodeMap.item(j).getNodeValue().equalsIgnoreCase("no")) {
                                n4 = 3;
                            }
                            string3 = namedNodeMap.item(j).getNodeValue();
                            Integer n5 = new Integer(n4);
                            Node node3 = this.FindNode(this.doc.getFirstChild(), "LegalValues");
                            Node node4 = this.FindNode(node3, "MechanismProperties");
                            NamedNodeMap namedNodeMap2 = node4.getAttributes();
                            n3 = new Integer("-1");
                            if (node4.hasAttributes()) {
                                for (int k = 0; k < namedNodeMap2.getLength(); ++k) {
                                    if (!namedNodeMap2.item(k).getNodeName().equalsIgnoreCase(namedNodeMap.item(j).getNodeName())) continue;
                                    n3 = new Integer(namedNodeMap2.item(k).getNodeValue());
                                }
                            }
                            if (string2 != null && n3 != -1 && string3 != null && string2.length() > 0 && string3.length() > 0) {
                                tdgssMechPropArray[n] = new TdgssMechProp(string2, n3, n5, string3);
                                ++n;
                            }
                        }
                        string3 = null;
                        string2 = null;
                    }
                }
            }
            TdgssMechProp[] tdgssMechPropArray2 = new TdgssMechProp[n];
            for (int i = 0; i < n; ++i) {
                tdgssMechPropArray2[i] = tdgssMechPropArray[i];
            }
            return tdgssMechPropArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] GetInforForMech(Oid oid) {
        Document document = this.doc;
        synchronized (document) {
            String[] stringArray = new String[2];
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            block3: for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                if (!nodeList.item(i).hasAttributes()) continue;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(j).getNodeValue().equalsIgnoreCase(oid.toString())) continue;
                    for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                        if (namedNodeMap.item(k) == null || !namedNodeMap.item(k).getNodeName().equalsIgnoreCase("Name")) continue;
                        stringArray[0] = namedNodeMap.item(k).getNodeValue();
                    }
                    stringArray[1] = namedNodeMap.item(j).getNodeValue();
                    continue block3;
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer GetPropertyForLegal(String string, String string2) {
        Document document = this.doc;
        synchronized (document) {
            String string3 = null;
            Node node = this.FindNode(this.doc.getFirstChild(), "LegalValues");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1 || !nodeList.item(i).getNodeName().equalsIgnoreCase(string)) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                string3 = null;
                if (nodeList.item(i).hasAttributes()) {
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase(string2)) continue;
                        string3 = namedNodeMap.item(j).getNodeValue();
                        break;
                    }
                }
                if (string3 != null) break;
            }
            if (string3 != null) {
                return new Integer(string3);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] GetInforForOID(String string) throws GSSException {
        Document document = this.doc;
        synchronized (document) {
            Object object;
            String[] stringArray = new String[7];
            String string2 = null;
            int n = 0;
            Node node = this.doc.getFirstChild();
            if (node == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doc.getFirstChild is null");
                }
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_BIN_FILE_NAME_BAD);
            }
            Node node2 = this.FindNode(node, "Mechanisms");
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n2;
                if (nodeList.item(i).getNodeType() != 1) continue;
                object = nodeList.item(i).getAttributes();
                string2 = null;
                Node node3 = null;
                if (nodeList.item(i).hasAttributes()) {
                    for (n2 = 0; n2 < object.getLength(); ++n2) {
                        if (object.item(n2) == null || !object.item(n2).getNodeName().equalsIgnoreCase("ObjectId") || !object.item(n2).getNodeValue().equalsIgnoreCase(string)) continue;
                        node3 = nodeList.item(i);
                        break;
                    }
                }
                if (node3 == null) continue;
                for (n2 = 0; n2 < node3.getChildNodes().getLength(); ++n2) {
                    Node node4;
                    if (node3.getChildNodes().item(n2).getNodeType() != 1 || !node3.getChildNodes().item(n2).getNodeName().equalsIgnoreCase("MechQop") || !(node4 = node3.getChildNodes().item(n2)).hasChildNodes() || node4.getFirstChild().getNodeType() != 3 || node4.getFirstChild().getNodeValue() == null || node4.getFirstChild().getNodeValue().trim().length() <= 0) continue;
                    string2 = node4.getFirstChild().getNodeValue();
                    break;
                }
                if (string2 != null) break;
            }
            if (string2 == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("MechQOP is null");
                }
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CFG_BIN_FILE_NAME_BAD);
            }
            Node node5 = this.FindNode(this.doc.getFirstChild(), "GlobalQOPs");
            object = node5.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                n = 0;
                if (object.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = object.item(i).getAttributes();
                if (object.item(i).hasAttributes()) {
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase("Value") || !namedNodeMap.item(j).getNodeValue().trim().equalsIgnoreCase(string2.trim())) continue;
                        ++n;
                        break;
                    }
                }
                if (n <= 0) continue;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    if (namedNodeMap.item(j) == null) continue;
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(CONFIDENTIALITY_ALGORITHM)) {
                        stringArray[0] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(KEY_LENGTH)) {
                        stringArray[1] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(MODE)) {
                        stringArray[2] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(PADDING)) {
                        stringArray[3] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(INTEGRITY_ALGORITHM)) {
                        stringArray[4] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (namedNodeMap.item(j).getNodeName().equalsIgnoreCase(KEY_EXCHANGE_ALGORITHM)) {
                        stringArray[5] = namedNodeMap.item(j).getNodeValue();
                        continue;
                    }
                    if (!namedNodeMap.item(j).getNodeName().equalsIgnoreCase(KEY_LENGTH_P)) continue;
                    stringArray[6] = namedNodeMap.item(j).getNodeValue();
                }
                break;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String GetMechanism(String string) {
        Document document = this.doc;
        synchronized (document) {
            String string2 = null;
            boolean bl = false;
            String string3 = null;
            String string4 = null;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Object var11_11 = null;
                if (!nodeList.item(i).hasAttributes()) continue;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    int n;
                    if (namedNodeMap.item(j) == null || !namedNodeMap.item(j).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(j).getNodeValue().equalsIgnoreCase(string)) continue;
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (namedNodeMap.item(n) == null || !namedNodeMap.item(n).getNodeName().equalsIgnoreCase("LibraryName") || !(string3 = namedNodeMap.item(n).getNodeValue()).equalsIgnoreCase("gssp2sspi")) continue;
                        string3 = "gssp2gss";
                    }
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (namedNodeMap.item(n) == null || !namedNodeMap.item(n).getNodeName().equalsIgnoreCase("prefix")) continue;
                        string4 = namedNodeMap.item(n).getNodeValue().toUpperCase();
                        if ((string4 = string4.substring(0, 1) + string4.substring(1).toLowerCase()).equalsIgnoreCase("ldapv3")) {
                            string4 = "Ldap";
                        }
                        if (!string4.equalsIgnoreCase("gssp2gss")) continue;
                        string4 = "Gss";
                    }
                    string2 = "com.teradata.tdgss.j" + string3 + "." + string4 + "Mechanism";
                    return string2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEnabledNegMech(Oid oid) throws GSSException {
        Document document = this.doc;
        synchronized (document) {
            String[] stringArray = null;
            Node node = this.FindNode(this.doc.getFirstChild(), "Mechanisms");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                int n;
                if (nodeList.item(i).getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Node node2 = null;
                if (namedNodeMap != null) {
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (namedNodeMap.item(n) == null || !namedNodeMap.item(n).getNodeName().equalsIgnoreCase("ObjectId") || !namedNodeMap.item(n).getNodeValue().equalsIgnoreCase(oid.toString())) continue;
                        node2 = nodeList.item(i);
                        break;
                    }
                }
                if (node2 == null) continue;
                n = 0;
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                String string = null;
                String string2 = null;
                for (int j = 0; j < node2.getChildNodes().getLength(); ++j) {
                    object = node2.getChildNodes().item(j);
                    if (object.getNodeType() != 1 || !object.getNodeName().equalsIgnoreCase("NegotiatedMechanism")) continue;
                    namedNodeMap = object.getAttributes();
                    if (namedNodeMap != null) {
                        for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                            if (namedNodeMap.item(k) != null && namedNodeMap.item(k).getNodeName().equalsIgnoreCase("ObjectId")) {
                                string = namedNodeMap.item(k).getNodeValue();
                            }
                            if (!namedNodeMap.item(k).getNodeName().equalsIgnoreCase("Enable") || !namedNodeMap.item(k).getNodeValue().equalsIgnoreCase("yes")) continue;
                            string2 = namedNodeMap.item(k).getNodeValue();
                        }
                    }
                    if (string == null || string2 == null) continue;
                    hashtable.put(string, string2);
                }
                stringArray = new String[hashtable.size()];
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    stringArray[n++] = this.GetMechanism((String)object);
                }
            }
            return stringArray;
        }
    }
}

