/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2jwt.JwtTokenHdr;

public class JwtClientInfoToken {
    private JwtTokenHdr tokenHeader;
    private byte[] cipherSuite = null;
    private byte[] abyJwtToken = null;
    private boolean bCIBypass = false;

    public JwtTokenHdr getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(JwtTokenHdr jwtTokenHdr) {
        this.tokenHeader = jwtTokenHdr;
    }

    public byte[] getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(byte[] byArray) {
        this.cipherSuite = byArray;
    }

    public byte[] getJwtToken() {
        return this.abyJwtToken;
    }

    public void setJwtToken(byte[] byArray) {
        this.abyJwtToken = byArray;
    }

    public void setCIBypass(boolean bl) {
        this.bCIBypass = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DER getDERObject() {
        ListArray listArray = new ListArray(DER.class);
        DER dER = new DER(0, listArray);
        if (this.tokenHeader == null) {
            throw new IllegalArgumentException("Argument tokenheader is null");
        }
        DER dER2 = this.tokenHeader.getDERObject();
        dER.add(dER2);
        if (!this.bCIBypass) {
            if (null == this.cipherSuite) throw new IllegalArgumentException("Argument CipherSuite is null");
            dER2 = new DER(1, this.cipherSuite);
            dER.add(dER2);
            return dER;
        } else {
            if (null == this.abyJwtToken) throw new IllegalArgumentException("Argument jwtToken is null");
            dER2 = new DER(2, this.abyJwtToken);
            dER.add(dER2);
        }
        return dER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseDERObject(DER dER) {
        if (0 != dER.getTagNumber()) {
            throw new IllegalArgumentException("client Info token not  found");
        }
        DER dER2 = dER.getChildrenWithTag(0);
        if (dER2 == null) {
            throw new IllegalArgumentException("client info Token header found");
        }
        this.tokenHeader = new JwtTokenHdr();
        this.tokenHeader.parseDERObject(dER2);
        if (!this.bCIBypass) {
            DER dER3 = dER.getChildrenWithTag(1);
            if (dER3 == null) throw new IllegalArgumentException("Cipher suite not found");
            this.cipherSuite = dER3.getValueAsOctetString();
            return;
        } else {
            DER dER4 = dER.getChildrenWithTag(2);
            if (dER4 == null) throw new IllegalArgumentException("JWT Token not found");
            this.abyJwtToken = dER4.getValueAsOctetString();
        }
    }
}

