/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class PasswordFlow {
    public static void validatePasswordFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        if (string == null || string.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1580", uRLParameters.getLogMech());
        }
        if (string2 == null || string2.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1581", uRLParameters.getLogMech());
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "LOGDATA", uRLParameters.getLogMech());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPasswordFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, TokenCache.CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doPasswordFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            Utility.HttpResponse httpResponse = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
            String string6 = httpResponse.sBody;
            String string7 = Utility.getStringFromJSON("token_endpoint", string6, "TJ1544", string3);
            String string8 = "grant_type=password&client_id=" + Utility.safeForURL(string4) + "&scope=" + Utility.safeForURL(string5) + "&username=" + Utility.safeForURL(string) + "&password=" + Utility.safeForURL(string2);
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string6);
                log.debug("sTokenURL=" + string7);
                log.debug("sFormData=" + string8);
            }
            byte[] byArray = Encoder.encodeStringUTF8(string8);
            string6 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string7, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
            TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string7, string6, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doPasswordFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }
}

