/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OIDCMetadataCache {
    private Utility.HttpResponse m_resp;
    private long m_nCreateTimeSecs;
    private static Map<String, OIDCMetadataCache> sm_cache = Collections.synchronizedMap(new LinkedHashMap());

    private OIDCMetadataCache(Utility.HttpResponse httpResponse) {
        this.m_resp = httpResponse;
        this.m_nCreateTimeSecs = System.currentTimeMillis() / 1000L;
    }

    private boolean isValid(GenericTeradataConnection genericTeradataConnection) {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        long l = uRLParameters.getOIDCMetadataCache();
        long l2 = this.m_nCreateTimeSecs + l;
        long l3 = System.currentTimeMillis() / 1000L;
        return l3 < l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Utility.HttpResponse getResponse(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter OIDCMetadataCache.getResponse sIdProURL=" + string);
        }
        try {
            Object object;
            boolean bl;
            OIDCMetadataCache oIDCMetadataCache = sm_cache.get(string);
            boolean bl2 = oIDCMetadataCache == null;
            boolean bl3 = bl = oIDCMetadataCache != null && oIDCMetadataCache.isValid(genericTeradataConnection);
            if (bl2 || !bl) {
                object = genericTeradataConnection.getURLParameters();
                Utility.HttpResponse httpResponse = Utility.doHttpRequest((URLParameters)object, log, "GET", string, null, null, true, new int[]{200});
                oIDCMetadataCache = new OIDCMetadataCache(httpResponse);
                sm_cache.put(string, oIDCMetadataCache);
            }
            if (log.isInfoEnabled()) {
                log.info("OIDC metadata cache " + (bl2 ? "miss" : (bl ? "hit" : "refresh")) + " for " + string);
            }
            genericTeradataConnection.m_extraClientAttributes.sIdpProxyUsed = oIDCMetadataCache.m_resp.sProxyUsed;
            genericTeradataConnection.m_extraClientAttributes.sIdpProtocol = oIDCMetadataCache.m_resp.sProtocol;
            genericTeradataConnection.m_extraClientAttributes.sIdpCipher = oIDCMetadataCache.m_resp.sCipher;
            genericTeradataConnection.m_extraClientAttributes.sIdpCertStatus = oIDCMetadataCache.m_resp.sCertStatus;
            object = oIDCMetadataCache.m_resp;
            return object;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave OIDCMetadataCache.getResponse sIdProURL=" + string);
            }
        }
    }
}

