'=============================================================================================================
' Copyright 2007-2014 Teradata. All rights reserved.
' TERADATA CONFIDENTIAL AND TRADE SECRET
'     
'     uninstall_TTU.vbs - version 14.10
'     Copyright 2007-2014 Teradata. All rights reserved.
'     TERADATA CONFIDENTIAL AND TRADE SECRET
'     Usage: 
'     cscript uninstall_TTU.vbs [ALL TERAGSS TDICU CLIv2 TDODBC PIOM BTEQ FASTLD MLOAD  
'                               FASTEXP TPUMP TDOLEDB SQLPP NPAXSMOD MQAXSMOD       
'                               OLEDBAXSMOD JMSAXSMOD SQLA TSET VECOMP TIWIZ TSWIZ  
'                               PMON TQSADMIN TQSSERVER TQSCLIENT TWA TMGR TDADMIN  
'                               TDWM TSAW TPTSTREAM TPTBASE TPTINFRA TPTAPI TPTLOADOP
'                               TPTEXPORTOP TPTUPDATEOP TPTSTREAMOP TPTICU TPTOSL   
'                               TPTDATACONOP TPTDDLOP TPTINSERTOP TPTODBCOP         
'                               TPTOSCMDOP TPTSELECTOP ARC MONITOROBJ TDWALLET  
'                               TDNETDP] [/PRIORTOVERSION:xx.xx.xx.xx][/FORCE:TRUE]
'                               [SUITE:ALL]
'     1)Any or all of the products specified above can be passed as arguments
'     to the script.
'     2)The /SUITE option should be used to remove all suites having version less 
'     than the PRIORTOVERSION. PRIORTOVERSION value should to be equal to or greater than
'     15.00.00.00 and the script should be run from media to remove suite packages.
'     3)The /FORCE option should be used to remove all traces of the product by 
'     force. Specify /FORCE:TRUE if needed, otherwise the default is /FORCE:FALSE.
'     4)The /PRIORTOVERSION option should be used to remove all versions of the 
'     product less than the specified version. Specify /PRIORTOVERSION:xx.xx.xx.xx 
'     if needed, otherwise the default is /PRIORTOVERSION:14.10.00.00.
'     5)When both /PRIORTOVERSION and /FORCE options are specified then all versions 
'     of the specified products less than the PRIORTOVERSION are removed. 
'     6)When the product name is specified as 'ALL' all the Suites and products supported  
'     by the script are uninstalled. When /PRIORTOVERSION and /FORCE options are not 
'     specified with 'ALL', the default values for these options are used. 
'     Examples:
'     cscript uninstall_TTU.vbs TDODBC
'     cscript uninstall_TTU.vbs TDODBC CLIv2 /PRIORTOVERSION:14.10.00.00
'     cscript uninstall_TTU.vbs TDODBC CLIv2 TDICU TERAGSS /FORCE:TRUE
'     cscript uninstall_TTU.vbs CLIv2 TDICU /FORCE:TRUE /PRIORTOVERSION:14.10.00.00
'     cscript uninstall_TTU.vbs ALL
'     cscript uninstall_TTU.vbs ALL /PRIORTOVERSION:14.10.00.00 /FORCE:TRUE
'     cscript uninstall_TTU.vbs /SUITE:ALL /PRIORTOVERSION:15.00.00.00
'     cscript uninstall_TTU.vbs TDODBC TDWALLET /SUITE:ALL /PRIORTOVERSION:15.00.00.00
'     cscript uninstall_TTU.vbs /SUITE:ALL /PRIORTOVERSION:15.00.00.00 /FORCE:TRUE
'
' Description : 
' uninstall_TTU.vbs script is used to uninstall previous versions of a TTU product.
' This script can be executed from a command prompt by passing the product name as arguments.
' The script handles uninstallation of previous versions for the following TTU products
' TERAGSS                   TSET                TPTLOADOP
' TDICU                     VECOMP              TPTEXPORTOP
' TDODBC                    TIWIZ               TPTUPDATEOP
' CLIv2                     TSWIZ               TPTSTREAMOP
' PIOM                      PMON                TPTICU
' BTEQ                      TQSADMIN            TPTOSL
' FASTLD                    TQSSERVER           TPTDATACONOP
' MLOAD                     TQSCLIENT           TPTDDLOP
' FASTEXP                   TWA                 TPTINSERTOP
' TPUMP                     TMGR                TPTODBCOP
' TDOLEDB                   TDADMIN             TPTOSCMDOP
' SQLPP                     TDWM                TPTSELECTOP
' NPAXSMOD                  TSAW                ARC
' MQAXSMOD                  TPTBASE             MONITOROBJ
' OLEDBAXSMOD               TPTSTREAM           TDWALLET
' JMSAXSMOD                 TPTINFRA            TDNETDP
' SQLA                      TPTAPI              TDGEOSPATIAL
' ALL
'
' This script searches the registry for the 32-bit and 64-bit variants of the product 
' and uninstalls if the installed version is less than the version of the product that is 
' being installed. The product name and product version is picked up from the Property Manager.
' This script does not require any arguments to be passed. The script creates temporary files
' in User's %TEMP% folder. The script execution is logged into a file called 
' %TEMP\uninstall_script.log. The information logged in the file can be used for
' troubleshooting errors in the script. 
' This script uses 
'	IDriver.exe to uninstall Installscript MSI packages installed on the machine.
'	Msiexec.exe to uninstall Basic MSI packages installed on the machine.
' 
'
' Note : 
'	1) This script assumes IDriver.exe file exists under the following folders 
'				on 32-bit machines:
'			C:\Program Files\Common Files\InstallShield\Driver\7\Intel 32\ & 
'			C:\Program Files\Common Files\InstallShield\Driver\9\Intel 32\ 
'	
'				on 64-bit machines:
'			C:\Program Files (x86)\Common Files\InstallShield\Driver\7\Intel 32\ & 
'			C:\Program Files (x86)\Common Files\InstallShield\Driver\9\Intel 32\ 
'
'
' Revision History:
' 13.00.00.00	2008Feb01	pk185011	DR117520	TDICU		: Uninstallation of previous version 
' 13.00.00.00	2008Feb01	pk185011	DR117517	CLIv2		: Uninstallation of previous version 
' 13.00.00.00	2008Feb01	pk185011	DR117527	TDODBC		: Uninstallation of previous version 
' 13.00.00.00	2008Feb01	pk185011	DR117516	PIOM		: Uninstallation of previous version 
' 13.00.00.00	2008Feb01	pk185011	DR116126	BTEQ		: Uninstallation of previous version 
' 13.00.00.00	2008Feb12	pk185011	DR117519	FASTLD		: Uninstallation of previous version 
' 13.00.00.00	2008Feb12	pk185011	DR117525	MLOAD		: Uninstallation of previous version 
' 13.00.00.00	2008Feb12	pk185011	DR117518	FASTEXP		: Uninstallation of previous version 
' 13.00.00.00	2008Feb12	pk185011	DR117528	TPUMP		: Uninstallation of previous version 
' 13.00.00.00	2008Mar15	pk185011	DRxxxxxx	TERAGSS		: Uninstallation of previous version 
' 13.00.00.00	2008Mar15	pk185011	DRxxxxxx	TDOLEDB		: Uninstallation of previous version 
' 13.00.00.00	2008Mar16	pk185011	DRxxxxxx	SQLPP		: Uninstallation of previous version 
' 13.00.00.00	2008Mar16	pk185011	DRxxxxxx	NPAXSMOD	: Uninstallation of previous version 
' 13.00.00.00	2008Mar16	pk185011	DRxxxxxx	MQAXSMOD	: Uninstallation of previous version 
' 13.00.00.00	2008Mar16	pk185011	DRxxxxxx	OLEDBAXSMOD	: Uninstallation of previous version 
' 13.00.00.00	2008Mar16	pk185011	DRxxxxxx	JMSAXSMOD	: Uninstallation of previous version 
' 13.00.00.00	2008Jun19	pk185011	DR123218	TDOLEDB		: Enhanced the script to uninstall
'                                                               : corrupted installations or left over
'                                                               : files and registry entries.  
' 13.00.00.00	2008Jul23	pk185011	DR123999	ALL Products: Uninstallation of the previous versions
'										DR124001				: was not working for silent installation
'										DR124002				: of Basic MSI packages even though the
'																: uninstall_prev_ver custom action was
'																: sequenced in the Execute Sequence.
'																: Hence the script was enhanced to execute
'																: it from command prompt and uninstall
'																: the previous versions of TTU products
'																: that are passed to the script as arguments.
' 13.00.00.00	2008Aug29	pk185011	DR123999	ALL Products: Uninstallation of 64-bit TTU products
'																: was not happening because the 64-bit
'																: registry was not accessed. Modified
'																: the script to handle reading both the
'																: 32-bit & 64-bit sections of the registry.
'																: Added support for SQLA uninstall.
' 13.00.00.01	2008Oct15	pk185011	DR125893	TDOLEDB		: Added code to remove terasso.dll from
' 																: system folders during uninstallation.
' 13.00.00.01	2009Mar12	pk185011	DR125893	TDOLEDB		: Backing out the changes for DR125893 as the
' 																: changes are done in the TDOLEDB product to handle the scenario.
' 13.00.00.01   2009Apr01   pk185011    DR129226    CLNINST     : Fixing issues in the script identified during
'                                                               : testing through SMS at EBay.
' 13.10.00.01   2010Jun21   pk185011    DR140746    BTEQ        : Added ProductName & ProductVersion in the
'                                                               : title of the error message displayed for
'                                                               : Windows Installer & WSH version incompatibility.
'                                                               : Getting the installer version from Windows 
'                                                               : Installer object instead of the .ism property.
'                                                               : Getting the Windows Script Host version from
'                                                               : WScript instead of running the cscript command.
' 13.10.00.01   2011Oct22   pk185011    DR144065    DBM/DBQAT   : Added support for uninstallation of DBM/DBQAT 
'                                                               : products(TSET, VECOMP, TIWIZ, TSWIZ, PMON, TQSADMIN,
'                                                               : TQSSERVER, TQSCLIENT, TWA, TMGR, TDADMIN, TDWM, TWA.
'                                                               : Fixed an issue with /FORCE:TRUE option reported on 
'                                                               : 64-bit machines.
' 14.00.00.01   2011July29  pk185011    DR151872    ALL         : Added support for uninstallation of TTU packages 
'                                       CLNTINS-1138            : lesser than the provided versions, thereby extending 
'                                       CLNTINS-1371            : the uninstall_TTU script to uninstall any version of 
'                                                               : of the supported TTU packages. Added enhancement to
'                                                               : run the script using SYSTEM account which is used during
'                                                               : deployment through SMS. Introduced /PRIORTOVERSION option.
'                                                               : /FORCE option also uses the /PRIORTOVERSION value.
' 14.10.00.00   2012-06-18 pk185011     CLNTINS-3473    TPT     : Added support for TPT packages to the uninstall script.
' 14.10.00.01   2012-06-20 pk185011     CLNTINS-3474    ALL     : Changed the default PRIORTOVERSION to current release based
'                                                               : on the requirement listed in the Jira.
' 14.10.00.02   2012-08-14 pk185011     CLNTINS-3520    ALL     : Added the 14.10 productcodes for all the packages supported                                                               : on the requirement listed in the Jira.
'                                                               : so that the /FORCE option can also cleanup leftover 14.10 packages.
' 14.10.00.03   2012-09-10 pk185011     CLNTINS-3667    ARC     : Added support for ARC uninstallation to the uninstall script. 
' 14.10.00.04   2012-09-13 pk185011     CLNTINS-3682    SCRIPT  : Added code to extract windows version information in numeric 
'                                                               : for comparison. This eliminates the locale specific decimal symbol
'                                                               : during comparisons.
' 14.10.00.05   2012-09-25 pk185011     CLNTINS-3693    MONITOROBJ : Add support for Monitor Object to uninstall script.
' 14.10.00.06   2012-10-10 pk185011     CLNTINS-3692    TDWALLET: Add support for TDWALLET to uninstall script.
' 14.10.00.07   2012-10-29 pk185011     CLNTINS-3691    TDNETDP : Add support for TDNETDP to uninstall script.
' 14.10.00.08   2012-11-01 pk185011     CLNTINS-3732    ALL     : Add ALL option to the uninstall script to support 
'                                                               : uninstallation of all products supported by the script.
' 14.10.00.09   2013-01-08 pk185011     CLNTINS-3826    ALL     : Change the logging options for Basic MSI package uninstallation
'                                                               : to reduce the time taken to complete uninstallation.
' 14.10.00.10   2013-05-01 sg255032     CLNTINS-3852    SUITES  : Adding uninstallation support of suite packages. 
' 14.10.00.11   2013-07-18 sg255032     CLNTINS-4161    LOGFILE : Adding code to write special characters to log file.
' 15.00.00.00   2014-04-02 sg255032     CLNTINS-4495    TDGEOSPATIAL : support uninstallation of the TDGeoSpatial product.
' 15.00.00.00   2014-12-02 sg255032     CLNTINS-4561    All     : Update the uninstall_TTU.vbs script for the TTU 15.00 release
' 15.00.00.01	2014-04-22 np255013		CLNTINS-4613	TERAGSS	: Update uninstall_TTU.vbs to remove TeraGSS entries from registry
' 15.00.00.01   2014-04-23 sg255032     CLNTINS-4689    ARC     : The product code of 15.00.00.00 ARC 64-bit package is empty.
' 17.00.00.00	2020-05-08 vj250009		CLNTINS-12623   Windows: Update copyright text as per the guidelines from Teradata Legal.
'==============================================================================================================================
Dim objWshNetwork
Dim objWshShell
Dim objFile

Dim ComputerName
Dim CurrentUserName
Dim UserDomain
Dim CompleteUserName

Dim position
Dim output
Dim winroot
Dim logfldr
Dim program_files_dir
Dim program_files_x86_dir
Dim allusers_dir
Dim users_dir
Dim fldr_name

Dim product_name
Dim product_code
Dim product_ver
Dim Wow6432Node
Dim Hex_Version
Dim Disp_Name
Dim alpha_product_ver
Dim saved_product_ver
Dim saved_product_code
Dim alpha_char
Dim short_version
Dim short_ver_first_part
Dim windows_version
Dim tdgssver_switched
Dim uninstall_cmd

Dim txtfile
Dim txtfile1
Dim txtfile2
Dim lf
Dim outputfile
Dim outputfile1
Dim outputfile2
Dim ScriptLog
Dim ISSFileName
Dim LogFileName
Dim InstallPath
Dim TIMESTAMP
Dim Package_64bit
Dim strcomputer
Dim objCtx
Dim objLocator
Dim objServices
Dim objStdRegProv
Dim Inparams
Dim Outparams
Dim Proc_Arch
Dim RegValue
Dim Product_GUID
Dim Reqd_WSHVersion
Dim WSHVersion
Dim Reqd_MSIVersion
Dim MSIVersion
Dim installer
Dim GUID_searched_in_registry
Dim priorto_version
Dim install_pkg_type
Dim CompanyName
Dim def_cur_ver
Dim suite_option
Dim suite_ptr

Dim TTUProds(55)
Dim TTUProducts(55)
Dim Basic_MSI_ver_13_0(55)
Dim Basic_MSI_ver_13_10(55)

'The Array subscript is set based on the max number of product codes stored. Right now SQLA has 13 product codes. 
'Increase this array subscript to an appropriate number when more product codes are added.
Class Product_Ver_Code_Info
    Public Ver_Count
    Public ProductCode(18)
    Public ProductVersion(18)
End Class

Dim TeraGSS_Prod_Codes
Dim TDICU_Prod_Codes
Dim CLIv2_Prod_Codes
Dim TDODBC_Prod_Codes
Dim PIOM_Prod_Codes
Dim BTEQ_Prod_Codes
Dim FASTLD_Prod_Codes
Dim MLOAD_Prod_Codes
Dim FASTEXP_Prod_Codes
Dim TPUMP_Prod_Codes
Dim TDOLEDB_Prod_Codes
Dim SQLPP_Prod_Codes
Dim NPAXSMOD_Prod_Codes
Dim MQAXSMOD_Prod_Codes
Dim OLEDBAXSMOD_Prod_Codes
Dim JMSAXSMOD_Prod_Codes
Dim SQLA_Prod_Codes
Dim TSET_Prod_Codes
Dim VECOMP_Prod_Codes
Dim TIWIZ_Prod_Codes
Dim TSWIZ_Prod_Codes
Dim PMON_Prod_Codes
Dim TQSADMIN_Prod_Codes
Dim TQSSERVER_Prod_Codes
Dim TQSCLIENT_Prod_Codes
Dim TWA_Prod_Codes
Dim TMGR_Prod_Codes
Dim TDADMIN_Prod_Codes
Dim TDWM_Prod_Codes
Dim TSAW_Prod_Codes
Dim TPTBASE_Prod_Codes
Dim TPTSTREAM_Prod_Codes
Dim TPTINFRA_Prod_Codes
Dim TPTAPI_Prod_Codes
Dim TPTLOADOP_Prod_Codes
Dim TPTEXPORTOP_Prod_Codes
Dim TPTUPDATEOP_Prod_Codes
Dim TPTSTREAMOP_Prod_Codes
Dim TPTICU_Prod_Codes
Dim TPTOSL_Prod_Codes
Dim ARC_Prod_Codes
Dim MONITOROBJ_Prod_Codes
Dim TDWALLET_Prod_Codes
Dim TDNETDP_Prod_Codes
Dim TDGEOSPATIAL_Prod_Codes


Dim TeraGSS_64_Prod_Codes
Dim TDICU_64_Prod_Codes
Dim CLIv2_64_Prod_Codes
Dim TDODBC_64_Prod_Codes
Dim PIOM_64_Prod_Codes
Dim NPAXSMOD_64_Prod_Codes
Dim JMSAXSMOD_64_Prod_Codes
Dim SQLPP_64_Prod_Codes
Dim TPTBASE_64_Prod_Codes
Dim TPTSTREAM_64_Prod_Codes
Dim TPTAPI_64_Prod_Codes
Dim TPTLOADOP_64_Prod_Codes
Dim TPTEXPORTOP_64_Prod_Codes
Dim TPTUPDATEOP_64_Prod_Codes
Dim TPTSTREAMOP_64_Prod_Codes
Dim TPTICU_64_Prod_Codes
Dim TPTOSL_64_Prod_Codes
Dim ARC_64_Prod_Codes
Dim TDWALLET_64_Prod_Codes
Dim TDGEOSPATIAL_64_Prod_Codes


'The Array subscript is set based on the max number of product codes stored.
'Increase this array subscript to an appropriate number when more product codes are added.
Class Suite_Product_Ver_Code_Info
    Public Ver_Count
    Public ProductCode(18)
    Public ProductVersion(18)
End Class

Dim Suite_TeraGSS_Prod_Codes
Dim Suite_TDICU_Prod_Codes
Dim Suite_CLIv2_Prod_Codes
Dim Suite_TDODBC_Prod_Codes
Dim Suite_PIOM_Prod_Codes
Dim Suite_BTEQ_Prod_Codes
Dim Suite_FASTLD_Prod_Codes
Dim Suite_MLOAD_Prod_Codes
Dim Suite_FASTEXP_Prod_Codes
Dim Suite_TPUMP_Prod_Codes
Dim Suite_SQLPP_Prod_Codes
Dim Suite_NPAXSMOD_Prod_Codes
Dim Suite_MQAXSMOD_Prod_Codes
Dim Suite_OLEDBAXSMOD_Prod_Codes
Dim Suite_JMSAXSMOD_Prod_Codes
Dim Suite_SQLA_Prod_Codes
Dim Suite_TSET_Prod_Codes
Dim Suite_VECOMP_Prod_Codes
Dim Suite_TIWIZ_Prod_Codes
Dim Suite_TSWIZ_Prod_Codes
Dim Suite_PMON_Prod_Codes
Dim Suite_TQSADMIN_Prod_Codes
Dim Suite_TQSSERVER_Prod_Codes
Dim Suite_TQSCLIENT_Prod_Codes
Dim Suite_TWA_Prod_Codes
Dim Suite_TDADMIN_Prod_Codes
Dim Suite_TPTBASE_Prod_Codes
Dim Suite_TPTSTREAM_Prod_Codes
Dim Suite_ARC_Prod_Codes
Dim Suite_MONITOROBJ_Prod_Codes
Dim Suite_TDWALLET_Prod_Codes
Dim Suite_TDNETDP_Prod_Codes
Dim Suite_TDGEOSPATIAL_Prod_Codes

Dim Suite_TeraGSS_64_Prod_Codes
Dim Suite_TDICU_64_Prod_Codes
Dim Suite_CLIv2_64_Prod_Codes
Dim Suite_TDODBC_64_Prod_Codes
Dim Suite_PIOM_64_Prod_Codes
Dim Suite_NPAXSMOD_64_Prod_Codes
Dim Suite_JMSAXSMOD_64_Prod_Codes
Dim Suite_SQLPP_64_Prod_Codes
Dim Suite_TPTBASE_64_Prod_Codes
Dim Suite_TPTSTREAM_64_Prod_Codes
Dim Suite_ARC_64_Prod_Codes
Dim Suite_TDWALLET_64_Prod_Codes
Dim Suite_TDGEOSPATIAL_64_Prod_Codes


TTUProds(0) = "TERAGSS"
TTUProds(1) = "TDICU"
TTUProds(2) = "CLIv2"
TTUProds(3) = "TDODBC"
TTUProds(4) = "PIOM"
TTUProds(5) = "BTEQ"
TTUProds(6) = "FASTLD"
TTUProds(7) = "MLOAD"
TTUProds(8) = "FASTEXP"
TTUProds(9) = "TPUMP"
TTUProds(10) = "TDOLEDB"
TTUProds(11) = "SQLPP"
TTUProds(12) = "NPAXSMOD"
TTUProds(13) = "MQAXSMOD"
TTUProds(14) = "OLEDBAXSMOD"
TTUProds(15) = "JMSAXSMOD"
TTUProds(16) = "SQLA"
TTUProds(17) = "TSET"
TTUProds(18) = "VECOMP"
TTUProds(19) = "TIWIZ"
TTUProds(20) = "TSWIZ"
TTUProds(21) = "PMON"
TTUProds(22) = "TQSADMIN"
TTUProds(23) = "TQSSERVER"
TTUProds(24) = "TQSCLIENT"
TTUProds(25) = "TWA"
TTUProds(26) = "TMGR"
TTUProds(27) = "TDADMIN"
TTUProds(28) = "TDWM"
TTUProds(29) = "TSAW"
TTUProds(30) = "TPTBASE"
TTUProds(31) = "TPTSTREAM"
TTUProds(32) = "TPTINFRA"
TTUProds(33) = "TPTAPI"
TTUProds(34) = "TPTLOADOP"
TTUProds(35) = "TPTEXPORTOP"
TTUProds(36) = "TPTUPDATEOP"
TTUProds(37) = "TPTSTREAMOP"
TTUProds(38) = "TPTICU"
TTUProds(39) = "TPTOSL"
TTUProds(40) = "TPTDATACONOP"
TTUProds(41) = "TPTDDLOP"
TTUProds(42) = "TPTINSERTOP"
TTUProds(43) = "TPTODBCOP"
TTUProds(44) = "TPTOSCMDOP"
TTUProds(45) = "TPTSELECTOP"
TTUProds(46) = "ARC"
TTUProds(47) = "MONITOROBJ"
TTUProds(48) = "TDWALLET"
TTUProds(49) = "TDNETDP"
TTUProds(50) = "TDGEOSPATIAL"
TTUProds(51) = Empty

TTUProducts(0) = "Teradata GSS"
TTUProducts(1) = "Shared ICU Libraries for Teradata"
TTUProducts(2) = "Teradata CLIv2"
TTUProducts(3) = "ODBC Driver for Teradata"
TTUProducts(4) = "Teradata Data Connector"
TTUProducts(5) = "Teradata BTEQ"
TTUProducts(6) = "Teradata FastLoad"
TTUProducts(7) = "Teradata MultiLoad"
TTUProducts(8) = "Teradata FastExport"
TTUProducts(9) = "Teradata TPump"
TTUProducts(10) = "OLE DB Provider for Teradata"
TTUProducts(11) = "Teradata C PP2"
TTUProducts(12) = "Teradata Named Pipes Access Module"
TTUProducts(13) = "WebSphere Access Module for Teradata"
TTUProducts(14) = "Teradata OLE DB Access Module"
TTUProducts(15) = "Teradata Access Module For JMS"
TTUProducts(16) = "Teradata SQL Assistant"
TTUProducts(17) = "Teradata System Emulation Tool"
TTUProducts(18) = "Teradata Visual Explain"
TTUProducts(19) = "Teradata Index Wizard"
TTUProducts(20) = "Teradata Statistics Wizard"
TTUProducts(21) = "Teradata Performance Monitor"
TTUProducts(22) = "Teradata Query Scheduler Administrator"
TTUProducts(23) = "Teradata Query Scheduler Server"
TTUProducts(24) = "Teradata Query Scheduler Client"
TTUProducts(25) = "Teradata Workload Analyzer"
TTUProducts(26) = "Teradata Manager"
TTUProducts(27) = "Teradata Administrator"
TTUProducts(28) = "Teradata Dynamic Workload Manager"
TTUProducts(29) = "Teradata SQL Assistant/Web Edition"
TTUProducts(30) = "Teradata Parallel Transporter Base"
TTUProducts(31) = "Teradata Parallel Transporter Stream"
TTUProducts(32) = "Teradata Parallel Transporter Infrastructure"
TTUProducts(33) = "Teradata Parallel Transporter API"
TTUProducts(34) = "Teradata Parallel Transporter Load Operator"
TTUProducts(35) = "Teradata Parallel Transporter Export Operator"
TTUProducts(36) = "Teradata Parallel Transporter Update Operator"
TTUProducts(37) = "Teradata Parallel Transporter Stream Operator"
TTUProducts(38) = "Teradata Parallel Transporter ICU Library"
TTUProducts(39) = "Teradata Parallel Transporter Operator Support Library"
TTUProducts(40) = "Teradata Parallel Transporter Data Connector Operator"
TTUProducts(41) = "Teradata Parallel Transporter DDL Operator"
TTUProducts(42) = "Teradata Parallel Transporter SQL Inserter Operator"
TTUProducts(43) = "Teradata Parallel Transporter ODBC Operator"
TTUProducts(44) = "Teradata Parallel Transporter OS Command Operator"
TTUProducts(45) = "Teradata Parallel Transporter SQL Selector Operator"
TTUProducts(46) = "Teradata ARC"
TTUProducts(47) = "Teradata Performance Monitor Object"
TTUProducts(48) = "Teradata Wallet"
TTUProducts(49) = ".NET Data Provider for Teradata"
TTUProducts(50) = "Teradata GeoSpatial Tool"
TTUProducts(51) = Empty

const ForReading=1, ForWriting=2
Const HKEY_CLASSES_ROOT = &H80000000
Const HKEY_LOCAL_MACHINE = &H80000002
Const HKCR = &H80000000
Const HKLM = &H80000002


strComputer = "."

GUID_searched_in_registry=False

'The following class objects are created and populated with the product code and product version information for all releases.
'For new releases when the product code changes the product code with the version needs to be added under the appropriate 
'product_ver_code object initialization section. When adding new information increase the Ver_Count member by 1 and add 
'new product code & product version at the end of the existing information by incrementing the index by 1.


set TERAGSS_Prod_Codes = New Product_Ver_Code_Info
TERAGSS_Prod_Codes.Ver_Count = 1
TERAGSS_Prod_Codes.ProductVersion(0) = "12.00.00.00"                            'UpgradeCode used instead of ProductCode
TERAGSS_Prod_Codes.ProductCode(0) = "{51F73750-FA01-4A8E-AA73-4480F1853CCE}"    'because UpgradeCode is same for all pre-13.0 versions

set TDICU_Prod_Codes = New Product_Ver_Code_Info
TDICU_Prod_Codes.Ver_Count = 6
TDICU_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 1.1, 1.1.1, 1.1.2, 12.0
TDICU_Prod_Codes.ProductCode(0) = "{8AFBC2EB-BB17-43C8-8AE0-5B7961A4A217}"
TDICU_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
TDICU_Prod_Codes.ProductCode(1) = "{7AACD0B1-74BB-4DF1-869C-15767BB8C573}"
TDICU_Prod_Codes.ProductVersion(2) = "13.10.00.00"      'Version 13.10
TDICU_Prod_Codes.ProductCode(2) = "{13A449C3-D9FF-4930-9F76-23E396F3D938}"
TDICU_Prod_Codes.ProductVersion(3) = "14.00.00.00"      'Version 14.00
TDICU_Prod_Codes.ProductCode(3) = "{0CDBDB7E-B45C-48C2-BEF1-3F602ED1051A}"
TDICU_Prod_Codes.ProductVersion(4) = "14.10.00.00"      'Version 14.10
TDICU_Prod_Codes.ProductCode(4) = "{FBBB82E9-A7DF-40A2-B3EB-123AAC731410}"
TDICU_Prod_Codes.ProductVersion(5) = "15.00.00.00"      'Version 15.00
TDICU_Prod_Codes.ProductCode(5) = "{FBBB82E9-A7DF-40A2-B3EB-123AAC731500}"

set CLIv2_Prod_Codes = New Product_Ver_Code_Info
CLIv2_Prod_Codes.Ver_Count = 7
CLIv2_Prod_Codes.ProductVersion(0) = "04.08.00.00"      'Version 4.7.1, 4.8.0
CLIv2_Prod_Codes.ProductCode(0) = "{4F4356EC-102B-4341-B492-8CF7CACDEC0C}"
CLIv2_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 4.8.2, 12.0
CLIv2_Prod_Codes.ProductCode(1) = "{0517CC15-921A-4FC1-BDB6-7B1FA42B02A6}"
CLIv2_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
CLIv2_Prod_Codes.ProductCode(2) = "{0DF8B969-B0F6-4675-848A-ABED5CD2418D}"
CLIv2_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
CLIv2_Prod_Codes.ProductCode(3) = "{83105558-B3BD-402B-B2AF-B8E8859C7861}"
CLIv2_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
CLIv2_Prod_Codes.ProductCode(4) = "{6BDA2A1F-07EB-497E-BB19-15F8D31E8C48}"
CLIv2_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
CLIv2_Prod_Codes.ProductCode(5) = "{76707046-0BAA-48FA-91A7-AB9876A31410}"
CLIv2_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
CLIv2_Prod_Codes.ProductCode(6) = "{76707046-0BAA-48FA-91A7-AB9876A31500}"

set TDODBC_Prod_Codes = New Product_Ver_Code_Info
TDODBC_Prod_Codes.Ver_Count = 10
TDODBC_Prod_Codes.ProductVersion(0) = "03.06.00.00"      'Version 3.3, 3.4, 3.5, 3.6
TDODBC_Prod_Codes.ProductCode(0) = "{EA7AF756-C648-11D6-800A-00B0D0ACA37F}"
TDODBC_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TDODBC_Prod_Codes.ProductCode(1) = "{48ABA7D9-A1FC-47DA-A0CC-F0E4CD9D4BC1}"
TDODBC_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TDODBC_Prod_Codes.ProductCode(2) = "{BA8904B8-B5B1-47FE-A243-EFABA06EBC56}"
TDODBC_Prod_Codes.ProductVersion(3) = "13.00.00.07"      'Version 13.0.0.7
TDODBC_Prod_Codes.ProductCode(3) = "{9DB45B07-E5A1-49A0-A31A-E4971010C2CF}"
TDODBC_Prod_Codes.ProductVersion(4) = "13.00.00.08"      'Version 13.0.0.8
TDODBC_Prod_Codes.ProductCode(4) = "{2F6BCE39-827B-4132-877F-2D333678FF17}"
TDODBC_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
TDODBC_Prod_Codes.ProductCode(5) = "{C325CC7A-501B-482C-B741-41D8F34C51BA}"
TDODBC_Prod_Codes.ProductVersion(6) = "13.10.00.03"      'Version 13.10.0.3
TDODBC_Prod_Codes.ProductCode(6) = "{9DB45B07-E5A1-49A0-A31A-E4971010C2CF}"
TDODBC_Prod_Codes.ProductVersion(7) = "14.00.00.03"      'Version 14.00
TDODBC_Prod_Codes.ProductCode(7) = "{1551F9D6-1B14-4AE1-BABA-70A4319C236A}"
TDODBC_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
TDODBC_Prod_Codes.ProductCode(8) = "{DF7D8033-5CE9-46DC-B5C4-DA16B77D1410}"
TDODBC_Prod_Codes.ProductVersion(9) = "15.00.00.00"      'Version 15.00
TDODBC_Prod_Codes.ProductCode(9) = "{DF7D8033-5CE9-46DC-B5C4-DA16B77D1500}"

set PIOM_Prod_Codes = New Product_Ver_Code_Info
PIOM_Prod_Codes.Ver_Count = 7
PIOM_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 2.1, 2.2, 2.3, 2.4, 12.0
PIOM_Prod_Codes.ProductCode(0) = "{69FE15A5-550A-406D-83A9-DD23F960BEBF}"
PIOM_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
PIOM_Prod_Codes.ProductCode(1) = "{574C9B79-3BBB-4050-94DC-7E3DD780F658}"
PIOM_Prod_Codes.ProductVersion(2) = "13.00.00.08"      'Version 13.0.0.8
PIOM_Prod_Codes.ProductCode(2) = "{8EAE1945-29A2-495A-A4B4-962C30FF9935}"
PIOM_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
PIOM_Prod_Codes.ProductCode(3) = "{D980764C-D417-4E92-B9EA-D3E0F559D9A9}"
PIOM_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
PIOM_Prod_Codes.ProductCode(4) = "{702EFE95-A12A-44CC-A889-58BF6B0D5641}"
PIOM_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
PIOM_Prod_Codes.ProductCode(5) = "{99CFA68C-06AF-4889-9295-57DE39771410}"
PIOM_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
PIOM_Prod_Codes.ProductCode(6) = "{99CFA68C-06AF-4889-9295-57DE39771500}"

set BTEQ_Prod_Codes = New Product_Ver_Code_Info
BTEQ_Prod_Codes.Ver_Count = 7
BTEQ_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 8.2.1, 8.2.2, 8.2.3, 8.2.4, 12.0
BTEQ_Prod_Codes.ProductCode(0) = "{C0AF45A8-DFB7-4AF4-A9EF-8184B5E4B1B6}"
BTEQ_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
BTEQ_Prod_Codes.ProductCode(1) = "{2D139851-6D32-4EAF-AD74-BE144BA92C08}"
BTEQ_Prod_Codes.ProductVersion(2) = "13.00.00.10"      'Version 13.0.0.10
BTEQ_Prod_Codes.ProductCode(2) = "{3288EC08-1ECB-4D6E-A837-74BF52D745A0}"
BTEQ_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
BTEQ_Prod_Codes.ProductCode(3) = "{6A0F8B0F-8FD5-46EF-8A94-F00C4EBDC9D2}"
BTEQ_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
BTEQ_Prod_Codes.ProductCode(4) = "{CD4749EF-AEAB-4B1F-A003-5BD609C9A42D}"
BTEQ_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
BTEQ_Prod_Codes.ProductCode(5) = "{ADDB19E3-8283-45EC-BB8D-419DBABC1410}"
BTEQ_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
BTEQ_Prod_Codes.ProductCode(6) = "{ADDB19E3-8283-45EC-BB8D-419DBABC1500}"

set FASTLD_Prod_Codes = New Product_Ver_Code_Info
FASTLD_Prod_Codes.Ver_Count = 7
FASTLD_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 7.5.2, 7.6.1, 7.7, 7.8, 12.0
FASTLD_Prod_Codes.ProductCode(0) = "{DB76EB4F-A3B5-49BF-AEAA-4D51D61E9E5C}"
FASTLD_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
FASTLD_Prod_Codes.ProductCode(1) = "{261A496B-F827-4E2C-B5AA-BF2F3E7036E3}"
FASTLD_Prod_Codes.ProductVersion(2) = "13.00.00.09"      'Version 13.0.0.9
FASTLD_Prod_Codes.ProductCode(2) = "{29E450DA-D731-4C89-9CB4-9A80B7190C25}"
FASTLD_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
FASTLD_Prod_Codes.ProductCode(3) = "{347A4386-53FB-4E17-8173-EB80C1BA722A}"
FASTLD_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
FASTLD_Prod_Codes.ProductCode(4) = "{20D78B1F-C782-44DA-8E9B-A2714DA50E6E}"
FASTLD_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
FASTLD_Prod_Codes.ProductCode(5) = "{6E80C54D-58FC-4BFC-B842-B2AF86041410}"
FASTLD_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
FASTLD_Prod_Codes.ProductCode(6) = "{6E80C54D-58FC-4BFC-B842-B2AF86041500}"

set MLOAD_Prod_Codes = New Product_Ver_Code_Info
MLOAD_Prod_Codes.Ver_Count = 7
MLOAD_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 7.6.3, 7.7.1, 7.8, 7.9, 12.0
MLOAD_Prod_Codes.ProductCode(0) = "{5F2C2C07-3313-42D9-8059-CA08AB596909}"
MLOAD_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
MLOAD_Prod_Codes.ProductCode(1) = "{7A5B87DF-F00D-4857-A3E5-0C4392E92C27}"
MLOAD_Prod_Codes.ProductVersion(2) = "13.00.00.08"      'Version 13.0.0.8
MLOAD_Prod_Codes.ProductCode(2) = "{81954520-AAFE-41AC-BCA9-FAEBF79797EB}"
MLOAD_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
MLOAD_Prod_Codes.ProductCode(3) = "{8D7D49C7-E03A-4F55-AF3D-FAAB0CD599CE}"
MLOAD_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
MLOAD_Prod_Codes.ProductCode(4) = "{C0E901B7-0D10-4DA4-B66F-B95EB62A6ABD}"
MLOAD_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
MLOAD_Prod_Codes.ProductCode(5) = "{6AF6694D-8432-46D8-A0C4-A45213681410}"
MLOAD_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
MLOAD_Prod_Codes.ProductCode(6) = "{6AF6694D-8432-46D8-A0C4-A45213681500}"

set FASTEXP_Prod_Codes = New Product_Ver_Code_Info
FASTEXP_Prod_Codes.Ver_Count = 7
FASTEXP_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 7.6, 7.7, 7.8, 7.9, 12.0
FASTEXP_Prod_Codes.ProductCode(0) = "{D10B629F-9CD7-447C-8CD6-28A8FA24C71C}"
FASTEXP_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
FASTEXP_Prod_Codes.ProductCode(1) = "{620D1022-7339-435C-A775-F03A08C926CE}"
FASTEXP_Prod_Codes.ProductVersion(2) = "13.00.00.11"      'Version 13.0.0.11
FASTEXP_Prod_Codes.ProductCode(2) = "{ABA40005-0CD6-4C78-8CC5-F0D75B5CC859}"
FASTEXP_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
FASTEXP_Prod_Codes.ProductCode(3) = "{93F07369-73BD-4553-8473-83D4FC7F2868}"
FASTEXP_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
FASTEXP_Prod_Codes.ProductCode(4) = "{27BED3C1-671A-451A-BBB4-BB5FDEE00FEE}"
FASTEXP_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
FASTEXP_Prod_Codes.ProductCode(5) = "{6F3498D2-AC81-41DE-A850-60A6A4FB1410}"
FASTEXP_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
FASTEXP_Prod_Codes.ProductCode(6) = "{6F3498D2-AC81-41DE-A850-60A6A4FB1500}"

set TPUMP_Prod_Codes = New Product_Ver_Code_Info
TPUMP_Prod_Codes.Ver_Count = 7
TPUMP_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version  1.8, 2.0, 2.0.1, 2.1, 2,2, 12.0
TPUMP_Prod_Codes.ProductCode(0) = "{873241FB-8FC9-4B94-905D-ECB30980F74E}"
TPUMP_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version  13.0
TPUMP_Prod_Codes.ProductCode(1) = "{5CAA2CE3-07D4-4B07-BC39-D1D4593E3203}"
TPUMP_Prod_Codes.ProductVersion(2) = "13.00.00.08"      'Version  13.0.0.8
TPUMP_Prod_Codes.ProductCode(2) = "{ED9186AF-924E-4AA8-8E73-09B5BB8C69C0}"
TPUMP_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version  13.10
TPUMP_Prod_Codes.ProductCode(3) = "{F9FBE144-7EEC-43D6-A1A6-1B811C985122}"
TPUMP_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version  14.00
TPUMP_Prod_Codes.ProductCode(4) = "{514EB380-EEF0-44FD-8E35-CE948399633F}"
TPUMP_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version  14.10
TPUMP_Prod_Codes.ProductCode(5) = "{E2149622-860A-4E49-8238-5FE60F321410}"
TPUMP_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version  15.00
TPUMP_Prod_Codes.ProductCode(6) = "{E2149622-860A-4E49-8238-5FE60F321500}"

set TDOLEDB_Prod_Codes = New Product_Ver_Code_Info
TDOLEDB_Prod_Codes.Ver_Count = 6
TDOLEDB_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 1.4, 1.5, 12.0
TDOLEDB_Prod_Codes.ProductCode(0) = "{62F77146-0D5D-4DD3-9273-292EBE6DDA37}"
TDOLEDB_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
TDOLEDB_Prod_Codes.ProductCode(1) = "{AD8722C3-3D02-467F-A519-C023AE2D1D8C}"
TDOLEDB_Prod_Codes.ProductVersion(2) = "13.00.00.02"      'Version 13.0.0.2
TDOLEDB_Prod_Codes.ProductCode(2) = "{DB3211F3-2DF8-403B-BC98-1D4F310A84C2}"
TDOLEDB_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
TDOLEDB_Prod_Codes.ProductCode(3) = "{4E2BA721-C85E-416A-B2E5-76B79F0FFC7C}"
TDOLEDB_Prod_Codes.ProductVersion(4) = "13.10.00.02"      'Version 13.10.0.2
TDOLEDB_Prod_Codes.ProductCode(4) = "{32D86D45-9056-441C-AD72-3C7D86CB5E38}"
TDOLEDB_Prod_Codes.ProductVersion(5) = "14.00.00.00"      'Version 14.00
TDOLEDB_Prod_Codes.ProductCode(5) = "{2EF6A32F-BC72-4720-B8AC-DC44B8C2E364}"

set SQLPP_Prod_Codes = New Product_Ver_Code_Info
SQLPP_Prod_Codes.Ver_Count = 8
SQLPP_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 8.0, 9.1, 9.2, 12.0
SQLPP_Prod_Codes.ProductCode(0) = "{7288F593-AF9E-4A78-BB7D-B39779925406}"
SQLPP_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
SQLPP_Prod_Codes.ProductCode(1) = "{2E55714F-3E83-49C5-A372-EC999B7DC733}"
SQLPP_Prod_Codes.ProductVersion(2) = "13.00.00.07"      'Version 13.0.0.7
SQLPP_Prod_Codes.ProductCode(2) = "{E68B60A3-1AD7-4E8F-8FD0-E45562EFE3F6}"
SQLPP_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
SQLPP_Prod_Codes.ProductCode(3) = "{91EFFF4D-3981-49F3-957C-E13985546F2C}"
SQLPP_Prod_Codes.ProductVersion(4) = "13.10.00.05"      'Version 13.10.0.5
SQLPP_Prod_Codes.ProductCode(4) = "{45AED6BC-03B0-4C48-8572-B3B6ECE2B117}"
SQLPP_Prod_Codes.ProductVersion(5) = "14.00.00.00"      'Version 14.00
SQLPP_Prod_Codes.ProductCode(5) = "{D2D162F9-8D39-42A6-956C-2BED2181E58E}"
SQLPP_Prod_Codes.ProductVersion(6) = "14.10.00.00"      'Version 14.10
SQLPP_Prod_Codes.ProductCode(6) = "{D2D162F9-8D39-42A6-956C-2BED21811410}"
SQLPP_Prod_Codes.ProductVersion(7) = "15.00.00.00"      'Version 15.00
SQLPP_Prod_Codes.ProductCode(7) = "{D2D162F9-8D39-42A6-956C-2BED21811500}"

set NPAXSMOD_Prod_Codes = New Product_Ver_Code_Info
NPAXSMOD_Prod_Codes.Ver_Count = 7
NPAXSMOD_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 1.3, 1.3.1, 1.4, 1.5, 12.0
NPAXSMOD_Prod_Codes.ProductCode(0) = "{CFE8A4E5-8E8E-4B17-A8E9-1DBC7B05E691}"
NPAXSMOD_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
NPAXSMOD_Prod_Codes.ProductCode(1) = "{FF146B0B-14D9-4557-8373-AC9B89C4B642}"
NPAXSMOD_Prod_Codes.ProductVersion(2) = "13.00.00.05"      'Version 13.0.0.5
NPAXSMOD_Prod_Codes.ProductCode(2) = "{02214C26-18F6-40DD-9D44-BDB7F2DD5303}"
NPAXSMOD_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
NPAXSMOD_Prod_Codes.ProductCode(3) = "{7050AED0-8310-4885-9EA7-F2CB8FDDA9D9}"
NPAXSMOD_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
NPAXSMOD_Prod_Codes.ProductCode(4) = "{3FE375C4-76E1-459D-8C16-6580CA58BF06}"
NPAXSMOD_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
NPAXSMOD_Prod_Codes.ProductCode(5) = "{1BABD132-9AE4-4964-851D-906278C81410}"
NPAXSMOD_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
NPAXSMOD_Prod_Codes.ProductCode(6) = "{1BABD132-9AE4-4964-851D-906278C81500}"

set MQAXSMOD_Prod_Codes = New Product_Ver_Code_Info
MQAXSMOD_Prod_Codes.Ver_Count = 8
MQAXSMOD_Prod_Codes.ProductVersion(0) = "01.05.00.00"      'Version 1.3, 1.5
MQAXSMOD_Prod_Codes.ProductCode(0) = "{2CC34ED3-B570-47FC-AB6B-A455FD9D5F33}"
MQAXSMOD_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
MQAXSMOD_Prod_Codes.ProductCode(1) = "{97C65880-5B22-4165-946B-928AA7AFE1FD}"
MQAXSMOD_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
MQAXSMOD_Prod_Codes.ProductCode(2) = "{552F8B45-A513-4576-BBF5-17BDE2C17DC8}"
MQAXSMOD_Prod_Codes.ProductVersion(3) = "13.00.00.06"      'Version 13.0.0.6
MQAXSMOD_Prod_Codes.ProductCode(3) = "{31766B34-A7C6-490A-9C08-8E78D7659612}"
MQAXSMOD_Prod_Codes.ProductVersion(4) = "13.10.00.06"      'Version 13.10
MQAXSMOD_Prod_Codes.ProductCode(4) = "{0FF96368-A984-40CD-911D-D21407943A58}"
MQAXSMOD_Prod_Codes.ProductVersion(5) = "14.00.00.00"      'Version 14.00
MQAXSMOD_Prod_Codes.ProductCode(5) = "{94FB5E91-7B3F-492E-9AC8-DF57E5B6D0A2}"
MQAXSMOD_Prod_Codes.ProductVersion(6) = "14.10.00.00"      'Version 14.10
MQAXSMOD_Prod_Codes.ProductCode(6) = "{9760FAAE-F5B7-4460-B01C-2CDF04A91410}"
MQAXSMOD_Prod_Codes.ProductVersion(7) = "15.00.00.00"      'Version 15.00
MQAXSMOD_Prod_Codes.ProductCode(7) = "{9760FAAE-F5B7-4460-B01C-2CDF04A91500}"

set OLEDBAXSMOD_Prod_Codes = New Product_Ver_Code_Info
OLEDBAXSMOD_Prod_Codes.Ver_Count = 10
OLEDBAXSMOD_Prod_Codes.ProductVersion(0) = "02.02.01.00"      'Version 2,2, 2.2.1 
OLEDBAXSMOD_Prod_Codes.ProductCode(0) = "{1BC47FD7-E288-4B63-9F7E-FD803AC06341}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(1) = "02.03.00.00"      'Version 2.3
OLEDBAXSMOD_Prod_Codes.ProductCode(1) = "{45474B11-9E08-478D-8A11-EBEA87788C9C}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
OLEDBAXSMOD_Prod_Codes.ProductCode(2) = "{73797DDB-5F24-458E-9AE9-2F1C762D4610}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
OLEDBAXSMOD_Prod_Codes.ProductCode(3) = "{FF4926B9-EDCB-496D-9C9C-0768ABB86847}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(4) = "13.00.00.10"      'Version 13.0.0.10
OLEDBAXSMOD_Prod_Codes.ProductCode(4) = "{D773BBCC-9460-4608-BDD3-B3EF6226EF58}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
OLEDBAXSMOD_Prod_Codes.ProductCode(5) = "{8322BFFA-C413-4DCC-97B4-27FAB5073A51}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(6) = "14.00.00.00"      'Version 14.00
OLEDBAXSMOD_Prod_Codes.ProductCode(6) = "{32F51C03-07D1-434C-9C40-9765169ED6F2}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(7) = "14.00.00.03"      'Version 14.00.0.3
OLEDBAXSMOD_Prod_Codes.ProductCode(7) = "{2EF6A32F-BC72-4720-B8AC-DC44B8C2E364}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
OLEDBAXSMOD_Prod_Codes.ProductCode(8) = "{32F51C03-07D1-434C-9C40-9765169E1410}"
OLEDBAXSMOD_Prod_Codes.ProductVersion(9) = "15.00.00.00"      'Version 15.00
OLEDBAXSMOD_Prod_Codes.ProductCode(9) = "{32F51C03-07D1-434C-9C40-9765169E1500}"

set JMSAXSMOD_Prod_Codes = New Product_Ver_Code_Info
JMSAXSMOD_Prod_Codes.Ver_Count = 6
JMSAXSMOD_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 12.0
JMSAXSMOD_Prod_Codes.ProductCode(0) = "{B3F8B75D-9E1C-4927-BAAA-A57601FBD133}"
JMSAXSMOD_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
JMSAXSMOD_Prod_Codes.ProductCode(1) = "{0FF3195D-DE93-4F98-A212-E6D56B8296A7}"
JMSAXSMOD_Prod_Codes.ProductVersion(2) = "13.10.00.00"      'Version 13.10
JMSAXSMOD_Prod_Codes.ProductCode(2) = "{6D5D1AE9-C953-443A-B17E-25369BCB5A8E}"
JMSAXSMOD_Prod_Codes.ProductVersion(3) = "14.00.00.00"      'Version 14.00
JMSAXSMOD_Prod_Codes.ProductCode(3) = "{6666E95D-C4F3-49D1-97A2-81D4B07DC837}"
JMSAXSMOD_Prod_Codes.ProductVersion(4) = "14.10.00.00"      'Version 14.10
JMSAXSMOD_Prod_Codes.ProductCode(4) = "{DC8E925F-F660-4820-8FD5-3895BA0D1410}"
JMSAXSMOD_Prod_Codes.ProductVersion(5) = "15.00.00.00"      'Version 15.00
JMSAXSMOD_Prod_Codes.ProductCode(5) = "{DC8E925F-F660-4820-8FD5-3895BA0D1500}"

set SQLA_Prod_Codes = New Product_Ver_Code_Info
SQLA_Prod_Codes.Ver_Count = 15
SQLA_Prod_Codes.ProductVersion(0) = "06.01.00.00"      'Version 6.1
SQLA_Prod_Codes.ProductCode(0) = "{12BAB8DD-A3D8-4D4F-9202-38D0F752143D}"
SQLA_Prod_Codes.ProductVersion(1) = "06.02.00.00"      'Version 6.2
SQLA_Prod_Codes.ProductCode(1) = "{F98C0534-5F2A-4E9D-A39B-F3B97C7F5369}"
SQLA_Prod_Codes.ProductVersion(2) = "07.01.00.00"      'Version 7.1
SQLA_Prod_Codes.ProductCode(2) = "{E3627386-5DC1-4B00-AB34-A20AF746C3F0}"
SQLA_Prod_Codes.ProductVersion(3) = "07.02.00.00"      'Version 7.2
SQLA_Prod_Codes.ProductCode(3) = "{548DAA80-3DC5-42F4-B6BA-E1BCB2548179}"
SQLA_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
SQLA_Prod_Codes.ProductCode(4) = "{6255A607-8881-4B02-9859-B4F3C798F7F9}"
SQLA_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
SQLA_Prod_Codes.ProductCode(5) = "{989D565C-E2D3-47F1-A83E-7C7229859FCF}"
SQLA_Prod_Codes.ProductVersion(6) = "13.00.00.08"      'Version 13.0.0.8
SQLA_Prod_Codes.ProductCode(6) = "{6F62EEB9-66A3-4401-B1C9-FA4B0E08ECC6}"
SQLA_Prod_Codes.ProductVersion(7) = "13.00.00.13"      'Version 13.0.0.13
SQLA_Prod_Codes.ProductCode(7) = "{75A9046D-2F68-4ACD-A282-7C700E7A5E7E}"
SQLA_Prod_Codes.ProductVersion(8) = "13.10.00.00"      'Version 13.10
SQLA_Prod_Codes.ProductCode(8) = "{09676DA4-24D4-42FA-B148-6A831BDB644E}"
SQLA_Prod_Codes.ProductVersion(9) = "13.11.00.00"      'Version 13.11
SQLA_Prod_Codes.ProductCode(9) = "{2841D59F-ACCC-4F04-A7E1-83DE59D59FAB}"
SQLA_Prod_Codes.ProductVersion(10) = "14.00.00.00"      'Version 14.00
SQLA_Prod_Codes.ProductCode(10) = "{4FF2173E-D7C9-41B4-AF3A-0E3799E591D9}"
SQLA_Prod_Codes.ProductVersion(11) = "14.01.00.00"      'Version 14.01
SQLA_Prod_Codes.ProductCode(11) = "{5A717A30-8F97-4B96-900F-3799CEDD743D}"
SQLA_Prod_Codes.ProductVersion(12) = "14.10.00.00"      'Version 14.10
SQLA_Prod_Codes.ProductCode(12) = "{F51CC502-7C9D-4F99-9E4F-D70D520B1410}"
SQLA_Prod_Codes.ProductVersion(13) = "14.10.00.04"      'Version 14.10.00.04
SQLA_Prod_Codes.ProductCode(13) = "{6649A22F-A5BE-46EB-AE46-CFC535AB1410}"
SQLA_Prod_Codes.ProductVersion(14) = "15.00.00.00"      'Version 15.00
SQLA_Prod_Codes.ProductCode(14) = "{6649A22F-A5BE-46EB-AE46-CFC535AB1500}"

set TSET_Prod_Codes = New Product_Ver_Code_Info
TSET_Prod_Codes.Ver_Count = 12
TSET_Prod_Codes.ProductVersion(0) = "02.01.00.00"      'Version 2.1
TSET_Prod_Codes.ProductCode(0) = "{84C0C511-98ED-4BA8-99C6-1A6A1757E01A}"
TSET_Prod_Codes.ProductVersion(1) = "02.02.00.00"      'Version 2.2
TSET_Prod_Codes.ProductCode(1) = "{7556EA99-8947-4A1E-91D4-E9A675454DB0}"
TSET_Prod_Codes.ProductVersion(2) = "02.03.00.00"      'Version 2.3
TSET_Prod_Codes.ProductCode(2) = "{EB6D3DEB-13DC-4CE5-A502-48920D396A01}"
TSET_Prod_Codes.ProductVersion(3) = "02.04.00.00"      'Version 2.4
TSET_Prod_Codes.ProductCode(3) = "{A7B7F0EB-BCFA-4D3F-810B-476D0C1D5E42}"
TSET_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
TSET_Prod_Codes.ProductCode(4) = "{53AB5270-67EE-404B-844D-AFE85125DAE6}"
TSET_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
TSET_Prod_Codes.ProductCode(5) = "{5A49567E-4ABB-439F-B457-BAEB4B671639}"
TSET_Prod_Codes.ProductVersion(6) = "13.00.00.06"      'Version 13.0.0.6
TSET_Prod_Codes.ProductCode(6) = "{8155541A-0A28-46CB-808E-AF5231BADCB1}"
TSET_Prod_Codes.ProductVersion(7) = "13.10.00.00"      'Version 13.10
TSET_Prod_Codes.ProductCode(7) = "{362CA339-24D8-499B-A444-442F9835F51B}"
TSET_Prod_Codes.ProductVersion(8) = "13.10.00.05"      'Version 13.10.0.5
TSET_Prod_Codes.ProductCode(8) = "{403F5D16-B064-499F-8A85-D7BA887E5A9F}"
TSET_Prod_Codes.ProductVersion(9) = "14.00.00.00"      'Version 14.00
TSET_Prod_Codes.ProductCode(9) = "{AEEE91F8-0952-4D99-A352-F46A40705615}"
TSET_Prod_Codes.ProductVersion(10) = "14.10.00.00"      'Version 14.10
TSET_Prod_Codes.ProductCode(10) = "{0FCC3DD4-B0F7-4AE1-B777-705D7A621410}"
TSET_Prod_Codes.ProductVersion(11) = "15.00.00.00"      'Version 15.00
TSET_Prod_Codes.ProductCode(11) = "{0FCC3DD4-B0F7-4AE1-B777-705D7A621500}"

set VECOMP_Prod_Codes = New Product_Ver_Code_Info
VECOMP_Prod_Codes.Ver_Count = 12
VECOMP_Prod_Codes.ProductVersion(0) = "03.01.00.00"      'Version 3.1
VECOMP_Prod_Codes.ProductCode(0) = "{3CBA1A4F-5337-4666-99AA-211798D1AFBC}"
VECOMP_Prod_Codes.ProductVersion(1) = "03.02.00.00"      'Version 3.2
VECOMP_Prod_Codes.ProductCode(1) = "{50A728AD-65FC-4318-84BB-68C9533727F6}"
VECOMP_Prod_Codes.ProductVersion(2) = "03.03.00.00"      'Version 3.3
VECOMP_Prod_Codes.ProductCode(2) = "{9F830439-CFE6-4435-A642-1E3E69D5BA35}"
VECOMP_Prod_Codes.ProductVersion(3) = "03.04.00.00"      'Version 3.4
VECOMP_Prod_Codes.ProductCode(3) = "{83888B7E-7D3E-4B7B-AC43-B910DBDC6C0F}"
VECOMP_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
VECOMP_Prod_Codes.ProductCode(4) = "{F1A133E9-B426-44C1-8A0D-9D7125466232}"
VECOMP_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
VECOMP_Prod_Codes.ProductCode(5) = "{847BB1F8-CA8F-4003-AEBD-E564AB7B1105}"
VECOMP_Prod_Codes.ProductVersion(6) = "13.00.00.07"      'Version 13.0.0.7
VECOMP_Prod_Codes.ProductCode(6) = "{9CF58761-B9C2-4825-B8D5-69BF8BF1F4D8}"
VECOMP_Prod_Codes.ProductVersion(7) = "13.10.00.00"      'Version 13.10
VECOMP_Prod_Codes.ProductCode(7) = "{2282678B-149B-4F9D-890A-07BBBAC0BE83}"
VECOMP_Prod_Codes.ProductVersion(8) = "13.10.00.05"      'Version 13.10.0.5
VECOMP_Prod_Codes.ProductCode(8) = "{65CA66DF-2F1F-4C3F-9EF3-8001262822CA}"
VECOMP_Prod_Codes.ProductVersion(9) = "14.00.00.00"      'Version 14.00
VECOMP_Prod_Codes.ProductCode(9) = "{1C0490F6-6925-4A5C-880C-80D4F53ADED7}"
VECOMP_Prod_Codes.ProductVersion(10) = "14.10.00.00"      'Version 14.10
VECOMP_Prod_Codes.ProductCode(10) = "{007D0AF6-0E6D-4695-B90F-EE0A27B41410}"
VECOMP_Prod_Codes.ProductVersion(11) = "15.00.00.00"      'Version 15.00
VECOMP_Prod_Codes.ProductCode(11) = "{007D0AF6-0E6D-4695-B90F-EE0A27B41500}"

set TIWIZ_Prod_Codes = New Product_Ver_Code_Info
TIWIZ_Prod_Codes.Ver_Count = 10
TIWIZ_Prod_Codes.ProductVersion(0) = "01.03.00.00"      'Version 1.3
TIWIZ_Prod_Codes.ProductCode(0) = "{C099F369-CD27-41A5-8AEF-70E5CD7A70BC}"
TIWIZ_Prod_Codes.ProductVersion(1) = "01.04.00.00"      'Version 1.4
TIWIZ_Prod_Codes.ProductCode(1) = "{39EF6C78-8B75-4D10-BA90-120F1BF4904D}"
TIWIZ_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TIWIZ_Prod_Codes.ProductCode(2) = "{1660F270-4E4C-4A14-BCA3-0C8664D19B51}"
TIWIZ_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TIWIZ_Prod_Codes.ProductCode(3) = "{82892461-3510-4E4D-8729-618339959B01}"
TIWIZ_Prod_Codes.ProductVersion(4) = "13.00.00.04"      'Version 13.0.0.4
TIWIZ_Prod_Codes.ProductCode(4) = "{A7E698D4-1700-435A-ADFF-0A241B721A73}"
TIWIZ_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
TIWIZ_Prod_Codes.ProductCode(5) = "{73F1BDB7-11E1-11D5-9DC6-00C04F2FC33B}"
TIWIZ_Prod_Codes.ProductVersion(6) = "13.10.00.04"      'Version 13.10.0.4
TIWIZ_Prod_Codes.ProductCode(6) = "{8EAE1945-29A2-495A-A4B4-962C30FF9935}"
TIWIZ_Prod_Codes.ProductVersion(7) = "14.00.00.00"      'Version 14.00
TIWIZ_Prod_Codes.ProductCode(7) = "{FA28CE0C-DD1B-4165-864C-8C49DF86A46F}"
TIWIZ_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
TIWIZ_Prod_Codes.ProductCode(8) = "{D1BD2BD7-6115-4318-9CFB-1E0CD22A1410}"
TIWIZ_Prod_Codes.ProductVersion(9) = "15.00.00.00"      'Version 15.00
TIWIZ_Prod_Codes.ProductCode(9) = "{D1BD2BD7-6115-4318-9CFB-1E0CD22A1500}"

set TSWIZ_Prod_Codes = New Product_Ver_Code_Info
TSWIZ_Prod_Codes.Ver_Count = 9
TSWIZ_Prod_Codes.ProductVersion(0) = "01.03.00.00"      'Version 1.3
TSWIZ_Prod_Codes.ProductCode(0) = "{848BA2AA-DC69-46B8-960B-2DE55705E3C7}"
TSWIZ_Prod_Codes.ProductVersion(1) = "01.04.00.00"      'Version 1.4
TSWIZ_Prod_Codes.ProductCode(1) = "{6C06EC61-FAD1-485C-ADD0-2F66DEE81976}"
TSWIZ_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TSWIZ_Prod_Codes.ProductCode(2) = "{49E20C29-DB4C-4354-B281-4544197F2902}"
TSWIZ_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TSWIZ_Prod_Codes.ProductCode(3) = "{1915835A-6324-4521-BE82-7A0B1783E207}"
TSWIZ_Prod_Codes.ProductVersion(4) = "13.00.00.00"      'Version 13.0.0.5
TSWIZ_Prod_Codes.ProductCode(4) = "{ED8DD671-B3A6-4C6A-B500-CB7182150A31}"
TSWIZ_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
TSWIZ_Prod_Codes.ProductCode(5) = "{C150929F-C8C3-426B-B9DD-364C1FAB4716}"
TSWIZ_Prod_Codes.ProductVersion(6) = "13.10.00.03"      'Version 13.10.0.3
TSWIZ_Prod_Codes.ProductCode(6) = "{EE583E08-1FC2-4AF9-8A5B-66ABFCD44B61}"
TSWIZ_Prod_Codes.ProductVersion(7) = "14.00.00.00"      'Version 14.00
TSWIZ_Prod_Codes.ProductCode(7) = "{BE59C5A4-D2C2-4EE5-9A12-14C8CDADD64E}"
TSWIZ_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
TSWIZ_Prod_Codes.ProductCode(8) = "{E2BFCFC0-D224-4171-AE28-F5E001241410}"

set PMON_Prod_Codes = New Product_Ver_Code_Info
PMON_Prod_Codes.Ver_Count = 9
PMON_Prod_Codes.ProductVersion(0) = "07.00.00.00"      'Version 7.0
PMON_Prod_Codes.ProductCode(0) = "{A8D1E601-5426-45BB-AF9A-171BA084B4BA}"
PMON_Prod_Codes.ProductVersion(1) = "07.01.00.00"      'Version 7.1
PMON_Prod_Codes.ProductCode(1) = "{ECDF04B5-20C7-40F4-9CD1-9C11AAD80A40}"
PMON_Prod_Codes.ProductVersion(2) = "07.02.00.00"      'Version 7.2
PMON_Prod_Codes.ProductCode(2) = "{30ECF1B7-873A-43C3-BFD8-4E787035EC79}"
PMON_Prod_Codes.ProductVersion(3) = "12.00.00.00"      'Version 12.0
PMON_Prod_Codes.ProductCode(3) = "{4CA5E49B-D0FF-456A-A730-28F8876334EE}"
PMON_Prod_Codes.ProductVersion(4) = "13.00.00.00"      'Version 13.0
PMON_Prod_Codes.ProductCode(4) = "{0AAF1405-F9C1-4A15-BF69-F064263D57E4}"
PMON_Prod_Codes.ProductVersion(5) = "13.00.00.03"      'Version 13.0.0.3
PMON_Prod_Codes.ProductCode(5) = "{51AA97F6-5145-484A-94D8-4DB8F77C376D}"
PMON_Prod_Codes.ProductVersion(6) = "14.00.00.00"      'Version 14.00
PMON_Prod_Codes.ProductCode(6) = "{9AF82AC8-0FC3-4C6F-ADBF-4771C9D77484}"
PMON_Prod_Codes.ProductVersion(7) = "14.10.00.00"      'Version 14.10
PMON_Prod_Codes.ProductCode(7) = "{9AF82AC8-0FC3-4C6F-ADBF-4771C9D71410}"
PMON_Prod_Codes.ProductVersion(8) = "15.00.00.00"      'Version 15.00
PMON_Prod_Codes.ProductCode(8) = "{95F2ACF6-6AC8-46F3-BC40-E237DB751500}"

set TQSADMIN_Prod_Codes = New Product_Ver_Code_Info
TQSADMIN_Prod_Codes.Ver_Count = 11
TQSADMIN_Prod_Codes.ProductVersion(0) = "05.00.00.00"      'Version 5.0
TQSADMIN_Prod_Codes.ProductCode(0) = "{E7D7CD27-E90E-11D5-9D41-00D0B758EBA5}"
TQSADMIN_Prod_Codes.ProductVersion(1) = "06.00.00.00"      'Version 6.0
TQSADMIN_Prod_Codes.ProductCode(1) = "{8849AD7A-B537-4DCF-918F-7C89FED0891F}"
TQSADMIN_Prod_Codes.ProductVersion(2) = "06.01.00.00"      'Version 6.1
TQSADMIN_Prod_Codes.ProductCode(2) = "{EC8B5F3E-2C31-4022-8B7F-62902446A7FD}"
TQSADMIN_Prod_Codes.ProductVersion(3) = "06.02.00.00"      'Version 6.2
TQSADMIN_Prod_Codes.ProductCode(3) = "{7BB6769D-99C7-4D22-A0E2-9EC62EF478F1}"
TQSADMIN_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
TQSADMIN_Prod_Codes.ProductCode(4) = "{B130B26D-2839-4A80-981F-2F4A56F6BCDB}"
TQSADMIN_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
TQSADMIN_Prod_Codes.ProductCode(5) = "{906FEAE0-4CB3-48E7-9B1E-3C3B6049FDDD}"
TQSADMIN_Prod_Codes.ProductVersion(6) = "13.10.00.00"      'Version 13.10
TQSADMIN_Prod_Codes.ProductCode(6) = "{7C989A3C-B60F-4B37-AA9A-DC75A77AE73F}"
TQSADMIN_Prod_Codes.ProductVersion(7) = "13.10.00.03"      'Version 13.10.0.3
TQSADMIN_Prod_Codes.ProductCode(7) = "{69DD2F55-3AD7-41F1-8233-59C3660BEC76}"
TQSADMIN_Prod_Codes.ProductVersion(8) = "14.00.00.00"      'Version 14.00
TQSADMIN_Prod_Codes.ProductCode(8) = "{BC39EEC1-7447-45E2-8F6F-92907D738BD5}"
TQSADMIN_Prod_Codes.ProductVersion(9) = "14.10.00.00"      'Version 14.10
TQSADMIN_Prod_Codes.ProductCode(9) = "{BC39EEC1-7447-45E2-8F6F-92907D731410}"
TQSADMIN_Prod_Codes.ProductVersion(10) = "15.00.00.00"      'Version 15.00
TQSADMIN_Prod_Codes.ProductCode(10) = "{BC39EEC1-7447-45E2-8F6F-92907D731500}"

set TQSSERVER_Prod_Codes = New Product_Ver_Code_Info
TQSSERVER_Prod_Codes.Ver_Count = 11
TQSSERVER_Prod_Codes.ProductVersion(0) = "05.00.00.00"      'Version 5.0
TQSSERVER_Prod_Codes.ProductCode(0) = "{B9B9FC34-51B3-4C2E-874B-82F8BA50B3BF}"
TQSSERVER_Prod_Codes.ProductVersion(1) = "06.00.00.00"      'Version 6.0
TQSSERVER_Prod_Codes.ProductCode(1) = "{80549DA0-7BD6-4E48-BD2E-211634E50551}"
TQSSERVER_Prod_Codes.ProductVersion(2) = "06.01.00.00"      'Version 6.1
TQSSERVER_Prod_Codes.ProductCode(2) = "{0C368613-5799-441B-B390-16A6881C08AB}"
TQSSERVER_Prod_Codes.ProductVersion(3) = "06.02.00.00"      'Version 6.2
TQSSERVER_Prod_Codes.ProductCode(3) = "{0BFE919A-042A-4434-9986-690B7A38B68C}"
TQSSERVER_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
TQSSERVER_Prod_Codes.ProductCode(4) = "{BE7AA283-19F6-425B-8ED1-D4079BF78E64}"
TQSSERVER_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
TQSSERVER_Prod_Codes.ProductCode(5) = "{B1A602AD-48FA-4EE8-BAA1-47D8DDCC6110}"
TQSSERVER_Prod_Codes.ProductVersion(6) = "13.10.00.00"      'Version 13.10
TQSSERVER_Prod_Codes.ProductCode(6) = "{96759D93-26F8-4AF5-B021-C80BDA2739AA}"
TQSSERVER_Prod_Codes.ProductVersion(7) = "13.10.00.03"      'Version 13.10.0.3
TQSSERVER_Prod_Codes.ProductCode(7) = "{29B253C0-4774-4916-A294-7BBFA36DA7A7}"
TQSSERVER_Prod_Codes.ProductVersion(8) = "14.00.00.00"      'Version 14.00
TQSSERVER_Prod_Codes.ProductCode(8) = "{29B253C0-4774-4916-A294-7BBFA36DA7A7}"
TQSSERVER_Prod_Codes.ProductVersion(9) = "14.10.00.00"      'Version 14.10
TQSSERVER_Prod_Codes.ProductCode(9) = "{29B253C0-4774-4916-A294-7BBFA36D1410}"
TQSSERVER_Prod_Codes.ProductVersion(10) = "15.00.00.00"      'Version 15.00
TQSSERVER_Prod_Codes.ProductCode(10) = "{29B253C0-4774-4916-A294-7BBFA36D1500}"

set TQSCLIENT_Prod_Codes = New Product_Ver_Code_Info
TQSCLIENT_Prod_Codes.Ver_Count = 11
TQSCLIENT_Prod_Codes.ProductVersion(0) = "05.00.00.00"      'Version 5.0
TQSCLIENT_Prod_Codes.ProductCode(0) = "{60F1B600-E252-45FE-B258-C266B4D86C52}"
TQSCLIENT_Prod_Codes.ProductVersion(1) = "06.00.00.00"      'Version 6.0
TQSCLIENT_Prod_Codes.ProductCode(1) = "{378EA444-BDF6-4BF7-9C9B-F77ABE992E70}"
TQSCLIENT_Prod_Codes.ProductVersion(2) = "06.01.00.00"      'Version 6.1
TQSCLIENT_Prod_Codes.ProductCode(2) = "{06205FF7-E353-4108-9714-91C805366366}"
TQSCLIENT_Prod_Codes.ProductVersion(3) = "06.02.00.00"      'Version 6.2
TQSCLIENT_Prod_Codes.ProductCode(3) = "{CA25379D-AE23-4AAB-BAF4-8A69656822FD}"
TQSCLIENT_Prod_Codes.ProductVersion(4) = "12.00.00.00"      'Version 12.0
TQSCLIENT_Prod_Codes.ProductCode(4) = "{B119364C-A5C6-4213-B9E8-F32FD90BEAD7}"
TQSCLIENT_Prod_Codes.ProductVersion(5) = "13.00.00.00"      'Version 13.0
TQSCLIENT_Prod_Codes.ProductCode(5) = "{05629C05-29BC-43A7-B22B-E17B65019B66}"
TQSCLIENT_Prod_Codes.ProductVersion(6) = "13.10.00.00"      'Version 13.10
TQSCLIENT_Prod_Codes.ProductCode(6) = "{9006016E-84F3-4698-BB8E-C97384E61075}"
TQSCLIENT_Prod_Codes.ProductVersion(7) = "13.10.00.03"      'Version 13.10.0.3
TQSCLIENT_Prod_Codes.ProductCode(7) = "{2830762F-C8E5-492A-8D17-57EE23A6BAD7}"
TQSCLIENT_Prod_Codes.ProductVersion(8) = "14.00.00.00"      'Version 14.00
TQSCLIENT_Prod_Codes.ProductCode(8) = "{E00558EE-EE85-4993-BC85-5A885A168F0F}"
TQSCLIENT_Prod_Codes.ProductVersion(9) = "14.10.00.00"      'Version 14.10
TQSCLIENT_Prod_Codes.ProductCode(9) = "{E00558EE-EE85-4993-BC85-5A885A161410}"
TQSCLIENT_Prod_Codes.ProductVersion(10) = "15.00.00.00"      'Version 15.00
TQSCLIENT_Prod_Codes.ProductCode(10) = "{E00558EE-EE85-4993-BC85-5A885A161500}"

set TWA_Prod_Codes = New Product_Ver_Code_Info
TWA_Prod_Codes.Ver_Count = 10
TWA_Prod_Codes.ProductVersion(0) = "01.00.00.00"      'Version 1.0
TWA_Prod_Codes.ProductCode(0) = "{415A65F6-5D92-47A2-AFE4-4050C59732FB}"
TWA_Prod_Codes.ProductVersion(1) = "01.01.00.00"      'Version 1.1
TWA_Prod_Codes.ProductCode(1) = "{E65E7660-CD17-432E-9A6B-B7DCEBC232C9}"
TWA_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TWA_Prod_Codes.ProductCode(2) = "{5EB50458-4EFF-4EBF-B9C7-C306B6501833}"
TWA_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TWA_Prod_Codes.ProductCode(3) = "{BC0E7108-A233-408B-90E1-C9BFCED41162}"
TWA_Prod_Codes.ProductVersion(4) = "13.00.00.04"      'Version 13.0.0.4
TWA_Prod_Codes.ProductCode(4) = "{503606E5-FA5F-4ACA-BFE4-9A351A8CF1EC}"
TWA_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
TWA_Prod_Codes.ProductCode(5) = "{FDB91C93-9C60-472B-81B2-18F4D279A43C}"
TWA_Prod_Codes.ProductVersion(6) = "13.10.00.04"      'Version 13.10.0.4
TWA_Prod_Codes.ProductCode(6) = "{E46D843D-B2D2-40D3-BC71-3BF14B4FB7C0}"
TWA_Prod_Codes.ProductVersion(7) = "14.00.00.00"      'Version 14.00
TWA_Prod_Codes.ProductCode(7) = "{F76A72C5-8940-4E84-A6EC-185BAFD6097E}"
TWA_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
TWA_Prod_Codes.ProductCode(8) = "{95CC5FC2-D4B4-43BA-A39A-CCADC36D1410}"
TWA_Prod_Codes.ProductVersion(9) = "15.00.00.00"      'Version 15.00
TWA_Prod_Codes.ProductCode(9) = "{95CC5FC2-D4B4-43BA-A39A-CCADC36D1500}"

set TMGR_Prod_Codes = New Product_Ver_Code_Info
TMGR_Prod_Codes.Ver_Count = 6
TMGR_Prod_Codes.ProductVersion(0) = "07.00.00.00"      'Version 7.0
TMGR_Prod_Codes.ProductCode(0) = "{FD537BD9-9516-4FC7-BFD7-1A81C9503B88}"
TMGR_Prod_Codes.ProductVersion(1) = "07.01.00.00"      'Version 7.1
TMGR_Prod_Codes.ProductCode(1) = "{4659B503-3F1D-4630-AAB0-A6E9F5377008}"
TMGR_Prod_Codes.ProductVersion(2) = "07.02.00.00"      'Version 7.2
TMGR_Prod_Codes.ProductCode(2) = "{E23B63EB-3100-40BF-9593-F2EBF61C7624}"
TMGR_Prod_Codes.ProductVersion(3) = "12.00.00.00"      'Version 12.0
TMGR_Prod_Codes.ProductCode(3) = "{89B4078C-085C-4C05-B2F5-DE34BB1B2981}"
TMGR_Prod_Codes.ProductVersion(4) = "13.00.00.00"      'Version 13.0
TMGR_Prod_Codes.ProductCode(4) = "{34322408-B4AE-44DD-BBAD-3895A88D9198}"
TMGR_Prod_Codes.ProductVersion(5) = "13.00.00.10"      'Version 13.0.0.10
TMGR_Prod_Codes.ProductCode(5) = "{2E380135-A509-4FB3-B2BF-07C3CE5F900F}"

set TDADMIN_Prod_Codes = New Product_Ver_Code_Info
TDADMIN_Prod_Codes.Ver_Count = 10
TDADMIN_Prod_Codes.ProductVersion(0) = "07.01.00.00"      'Version 7.1
TDADMIN_Prod_Codes.ProductCode(0) = "{CD6EC92C-D28A-4BA0-BCAE-4F905472CFBF}"
TDADMIN_Prod_Codes.ProductVersion(1) = "07.02.00.00"      'Version 7.2
TDADMIN_Prod_Codes.ProductCode(1) = "{3E7AD53D-76FC-477A-920F-A40728B0774B}"
TDADMIN_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TDADMIN_Prod_Codes.ProductCode(2) = "{9027F2E8-9F71-40F0-8737-C37A36C3EF5E}"
TDADMIN_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TDADMIN_Prod_Codes.ProductCode(3) = "{3A7CCC8B-F674-4577-9128-2A5B1AA53584}"
TDADMIN_Prod_Codes.ProductVersion(4) = "13.00.00.04"      'Version 13.0.0.4
TDADMIN_Prod_Codes.ProductCode(4) = "{BD7F9A84-B5E3-44A5-A5C3-3A086DC055F6}"
TDADMIN_Prod_Codes.ProductVersion(5) = "13.10.00.00"      'Version 13.10
TDADMIN_Prod_Codes.ProductCode(5) = "{4FF4BB0F-6694-400E-92D6-E2AFD0413198}"
TDADMIN_Prod_Codes.ProductVersion(6) = "13.10.00.03"      'Version 13.10.0.3
TDADMIN_Prod_Codes.ProductCode(6) = "{30788AF0-9E40-4200-9759-9390BC851A07}"
TDADMIN_Prod_Codes.ProductVersion(7) = "14.00.00.00"      'Version 14.00
TDADMIN_Prod_Codes.ProductCode(7) = "{5095C363-B331-4529-8750-315E74966C06}"
TDADMIN_Prod_Codes.ProductVersion(8) = "14.10.00.00"      'Version 14.10
TDADMIN_Prod_Codes.ProductCode(8) = "{908CD71C-F004-472C-9638-D47927F11410}"
TDADMIN_Prod_Codes.ProductVersion(9) = "15.00.00.00"      'Version 15.00
TDADMIN_Prod_Codes.ProductCode(9) = "{908CD71C-F004-472C-9638-D47927F11500}"

set TDWM_Prod_Codes = New Product_Ver_Code_Info
TDWM_Prod_Codes.Ver_Count = 5
TDWM_Prod_Codes.ProductVersion(0) = "06.01.00.00"      'Version 6.1
TDWM_Prod_Codes.ProductCode(0) = "{74B3CEFA-B19B-493A-B4C4-093A82BDA32D}"
TDWM_Prod_Codes.ProductVersion(1) = "06.02.00.00"      'Version 6.2
TDWM_Prod_Codes.ProductCode(1) = "{E9AFE8D8-399E-4BEF-B8FD-506F35278A09}"
TDWM_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TDWM_Prod_Codes.ProductCode(2) = "{70EE223B-BDC9-4BC2-8B2B-D212D800694E}"
TDWM_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TDWM_Prod_Codes.ProductCode(3) = "{E9573FBB-208E-4B70-9788-EB28291A05F1}"
TDWM_Prod_Codes.ProductVersion(4) = "13.00.00.07"      'Version 13.0.0.7
TDWM_Prod_Codes.ProductCode(4) = "{58515FFC-00E8-4F62-B9E2-6EDF87C8ED9F}"

set TSAW_Prod_Codes = New Product_Ver_Code_Info
TSAW_Prod_Codes.Ver_Count = 5
TSAW_Prod_Codes.ProductVersion(0) = "02.00.00.00"      'Version 2.0
TSAW_Prod_Codes.ProductCode(0) = "{57129151-EAED-4388-BD4F-AEE1D88F724A}"
TSAW_Prod_Codes.ProductVersion(1) = "02.01.00.00"      'Version 2.1
TSAW_Prod_Codes.ProductCode(1) = "{9B52B378-5D87-4264-85CA-7EBC5145C09C}"
TSAW_Prod_Codes.ProductVersion(2) = "02.02.00.00"      'Version 2.2
TSAW_Prod_Codes.ProductCode(2) = "{D22B83FD-41DF-4976-A379-1C211D469672}"
TSAW_Prod_Codes.ProductVersion(3) = "12.00.00.00"      'Version 12.0
TSAW_Prod_Codes.ProductCode(3) = "{7F53139F-D39A-4F12-852A-2E13A2C34435}"
TSAW_Prod_Codes.ProductVersion(4) = "13.00.00.00"      'Version 13.0
TSAW_Prod_Codes.ProductCode(4) = "{C61DF117-DBDF-4CCD-B4E3-D8F863DE57BD}"

set TPTBASE_Prod_Codes = New Product_Ver_Code_Info
TPTBASE_Prod_Codes.Ver_Count = 3
TPTBASE_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.0
TPTBASE_Prod_Codes.ProductCode(0) = "{9B5284B7-6E72-40CA-A00A-80797DEC6ADB}"
TPTBASE_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TPTBASE_Prod_Codes.ProductCode(1) = "{EAE2826E-F71E-4AB1-9D55-71ACAAD01410}"
TPTBASE_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TPTBASE_Prod_Codes.ProductCode(2) = "{709BD56F-9451-4AC4-B14F-304D9D8C1500}"

set TPTSTREAM_Prod_Codes = New Product_Ver_Code_Info
TPTSTREAM_Prod_Codes.Ver_Count = 3
TPTSTREAM_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.0
TPTSTREAM_Prod_Codes.ProductCode(0) = "{80A81922-B022-4BDE-B679-B045EE1AA43F}"
TPTSTREAM_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TPTSTREAM_Prod_Codes.ProductCode(1) = "{FD2A2864-57E1-4DF8-B756-4C124DBB1410}"
TPTSTREAM_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TPTSTREAM_Prod_Codes.ProductCode(2) = "{843D7BBA-C4FD-490C-913B-03C7AFD81500}"

set TPTINFRA_Prod_Codes = New Product_Ver_Code_Info
TPTINFRA_Prod_Codes.Ver_Count = 4
TPTINFRA_Prod_Codes.ProductVersion(0) = "13.00.00.00"      'Version 13.0
TPTINFRA_Prod_Codes.ProductCode(0) = "{D05F4A13-8EC6-4A6A-81BD-0EDB0B99391A}"
TPTINFRA_Prod_Codes.ProductVersion(1) = "13.00.00.12"      'Version 13.0.0.12
TPTINFRA_Prod_Codes.ProductCode(1) = "{6CD213A9-5116-4D01-B8AB-3692F29CEAA6}"
TPTINFRA_Prod_Codes.ProductVersion(2) = "13.10.00.00"      'Version 13.10
TPTINFRA_Prod_Codes.ProductCode(2) = "{E7B9A412-7247-48AF-9B2E-737E50965115}"
TPTINFRA_Prod_Codes.ProductVersion(3) = "13.10.00.02"      'Version 13.10.0.2
TPTINFRA_Prod_Codes.ProductCode(3) = "{77B1CB70-9008-4446-803C-0B09AAB7D338}"

set TPTAPI_Prod_Codes = New Product_Ver_Code_Info
TPTAPI_Prod_Codes.Ver_Count = 8
TPTAPI_Prod_Codes.ProductVersion(0) = "08.01.00.00"      'Version 8.1
TPTAPI_Prod_Codes.ProductCode(0) = "{43CAB512-600D-45BF-A024-D6C6FC4256AD}"
TPTAPI_Prod_Codes.ProductVersion(1) = "08.02.00.00"      'Version 8.2
TPTAPI_Prod_Codes.ProductCode(1) = "{CC0D3BFD-F6B0-4916-A4D8-244FB7D853FB}"
TPTAPI_Prod_Codes.ProductVersion(2) = "12.00.00.00"      'Version 12.0
TPTAPI_Prod_Codes.ProductCode(2) = "{7576EF06-70FB-410A-952B-FBC20ACD1977}"
TPTAPI_Prod_Codes.ProductVersion(3) = "13.00.00.00"      'Version 13.0
TPTAPI_Prod_Codes.ProductCode(3) = "{7AAC7752-2AED-45F3-9B76-91AB6746FC41}"
TPTAPI_Prod_Codes.ProductVersion(4) = "13.00.00.02"      'Version 13.0.0.2
TPTAPI_Prod_Codes.ProductCode(4) = "{130747D0-0547-4D6D-B6AA-E8CFE2E641CA}"
TPTAPI_Prod_Codes.ProductVersion(5) = "13.00.00.09"      'Version 13.0.0.09
TPTAPI_Prod_Codes.ProductCode(5) = "{33D3FB6F-2FB7-4D69-A671-9BEDF69E6585}"
TPTAPI_Prod_Codes.ProductVersion(6) = "13.10.00.00"      'Version 13.10
TPTAPI_Prod_Codes.ProductCode(6) = "{7AAC7752-2AED-45F3-9B76-91AB6746FC41}"
TPTAPI_Prod_Codes.ProductVersion(7) = "13.10.00.02"      'Version 13.10.0.2
TPTAPI_Prod_Codes.ProductCode(7) = "{EA170654-.0.7-4745-8E58-2B8ED1ED153F}"

set TPTLOADOP_Prod_Codes = New Product_Ver_Code_Info
TPTLOADOP_Prod_Codes.Ver_Count = 6
TPTLOADOP_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTLOADOP_Prod_Codes.ProductCode(0) = "{3E149025-D5E0-49AC-8BB2-E545AC3D3A20}"
TPTLOADOP_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTLOADOP_Prod_Codes.ProductCode(1) = "{19D4A30D-8B9B-4DB3-A3AC-E037F5DA6A83}"
TPTLOADOP_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTLOADOP_Prod_Codes.ProductCode(2) = "{93A78C72-983D-422B-8989-06839D5062DA}"
TPTLOADOP_Prod_Codes.ProductVersion(3) = "13.00.00.09"      'Version 13.0.0.09
TPTLOADOP_Prod_Codes.ProductCode(3) = "{D4B987BF-66B5-4E17-8BD7-439F8FF1D2D5}"
TPTLOADOP_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTLOADOP_Prod_Codes.ProductCode(4) = "{521F7359-CF71-4E2E-9583-9595FDFD5DFE}"
TPTLOADOP_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTLOADOP_Prod_Codes.ProductCode(5) = "{BB9B94ED-A4E7-4D87-B693-CA265D4A8685}"

set TPTEXPORTOP_Prod_Codes = New Product_Ver_Code_Info
TPTEXPORTOP_Prod_Codes.Ver_Count = 6
TPTEXPORTOP_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTEXPORTOP_Prod_Codes.ProductCode(0) = "{12BC7B91-2EE0-4F8C-BBB8-D1FF7E6238FD}"
TPTEXPORTOP_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTEXPORTOP_Prod_Codes.ProductCode(1) = "{9D0B3E03-A5D7-4C2E-9610-1463D1B1E9C8}"
TPTEXPORTOP_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTEXPORTOP_Prod_Codes.ProductCode(2) = "{27035F95-A5F6-49AC-88BD-530C2E0E34AD}"
TPTEXPORTOP_Prod_Codes.ProductVersion(3) = "13.00.00.07"      'Version 13.0.0.07
TPTEXPORTOP_Prod_Codes.ProductCode(3) = "{A9E44D08-A8A3-4DBD-BBDF-9514921EF130}"
TPTEXPORTOP_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTEXPORTOP_Prod_Codes.ProductCode(4) = "{FEE4EEDE-F438-4553-9626-3154D7992452}"
TPTEXPORTOP_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTEXPORTOP_Prod_Codes.ProductCode(5) = "{052539AA-A183-4370-B6A5-17B4FDD2CAFB}"

set TPTUPDATEOP_Prod_Codes = New Product_Ver_Code_Info
TPTUPDATEOP_Prod_Codes.Ver_Count = 6
TPTUPDATEOP_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTUPDATEOP_Prod_Codes.ProductCode(0) = "{8C2AE120-C93A-4F76-98B7-B997C272285C}"
TPTUPDATEOP_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTUPDATEOP_Prod_Codes.ProductCode(1) = "{35356EC8-5ED5-4AB5-AF99-D4242666AC58}"
TPTUPDATEOP_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTUPDATEOP_Prod_Codes.ProductCode(2) = "{6CBC76C8-7B90-4A89-8472-E7E3A8A7731A}"
TPTUPDATEOP_Prod_Codes.ProductVersion(3) = "13.00.00.08"      'Version 13.0.0.08
TPTUPDATEOP_Prod_Codes.ProductCode(3) = "{FB9CE011-D1E5-4100-B186-3CDB5B293DD0}"
TPTUPDATEOP_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTUPDATEOP_Prod_Codes.ProductCode(4) = "{B23954B1-F1B0-4553-8E92-02F6807B402D}"
TPTUPDATEOP_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTUPDATEOP_Prod_Codes.ProductCode(5) = "{89E8C6E9-164E-4FAB-8819-0DFE7A63B55F}"

set TPTSTREAMOP_Prod_Codes = New Product_Ver_Code_Info
TPTSTREAMOP_Prod_Codes.Ver_Count = 6
TPTSTREAMOP_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTSTREAMOP_Prod_Codes.ProductCode(0) = "{6011A31B-9B22-48CF-8171-884E36C12802}"
TPTSTREAMOP_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTSTREAMOP_Prod_Codes.ProductCode(1) = "{35E44CAE-8252-468B-A2F8-8096FC4C1606}"
TPTSTREAMOP_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTSTREAMOP_Prod_Codes.ProductCode(2) = "{36AB0011-DCC1-43BE-A0F6-F4DCC93C5183}"
TPTSTREAMOP_Prod_Codes.ProductVersion(3) = "13.00.00.11"      'Version 13.0.0.11
TPTSTREAMOP_Prod_Codes.ProductCode(3) = "{E324674E-4B5A-4EBC-A5C6-68BBB85A52BD}"
TPTSTREAMOP_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTSTREAMOP_Prod_Codes.ProductCode(4) = "{8CBC7CFE-EFE4-4C20-9470-0A6BCC42189E}"
TPTSTREAMOP_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTSTREAMOP_Prod_Codes.ProductCode(5) = "{3FA0CEAC-F036-41D0-A88A-3AF4AF6A9FC4}"

set TPTICU_Prod_Codes = New Product_Ver_Code_Info
TPTICU_Prod_Codes.Ver_Count = 1
TPTICU_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 12.0
TPTICU_Prod_Codes.ProductCode(0) = "{EC9EB94B-25A9-4CED-835E-C005B028407A}"

set TPTOSL_Prod_Codes = New Product_Ver_Code_Info
TPTOSL_Prod_Codes.Ver_Count = 2
TPTOSL_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTOSL_Prod_Codes.ProductCode(0) = "{AB8915D1-454C-4B47-8E87-F70AAFE98AAC}"
TPTOSL_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTOSL_Prod_Codes.ProductCode(1) = "{52BE79E8-6706-4A06-93C1-7C2831A7F74E}"

set ARC_Prod_Codes = New Product_Ver_Code_Info
ARC_Prod_Codes.Ver_Count = 16
ARC_Prod_Codes.ProductVersion(0) = "08.00.00.00"      'Version 8.0-12.0
ARC_Prod_Codes.ProductCode(0) = "{60627AF4-D06A-4CD0-9A48-8011C5FE6644}"
ARC_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
ARC_Prod_Codes.ProductCode(1) = "{69847286-D75D-433B-B0FE-88978B11FCD0}"
ARC_Prod_Codes.ProductVersion(2) = "13.00.00.02"      'Version 13.0.0.2
ARC_Prod_Codes.ProductCode(2) = "{8D106069-D480-47B6-A9BE-DE8793F8E05F}"
ARC_Prod_Codes.ProductVersion(3) = "13.00.00.03"      'Version 13.0.0.3
ARC_Prod_Codes.ProductCode(3) = "{C8FB1BA0-19F9-4D76-A6E6-FD7FF3BCF6A2}"
ARC_Prod_Codes.ProductVersion(4) = "13.00.00.04"      'Version 13.0.0.4
ARC_Prod_Codes.ProductCode(4) = "{5168088A-E152-4D40-9124-7812169E242A}"
ARC_Prod_Codes.ProductVersion(5) = "13.00.00.05"      'Version 13.0.0.5
ARC_Prod_Codes.ProductCode(5) = "{739361B4-065F-4FA4-BAD8-D8B31A55D3B4}"
ARC_Prod_Codes.ProductVersion(6) = "13.00.00.06"      'Version 13.0.0.6
ARC_Prod_Codes.ProductCode(6) = "{1A833C8D-A22A-4B87-A0EB-40CB724DF5A3}"
ARC_Prod_Codes.ProductVersion(7) = "13.00.00.07"      'Version 13.0.0.7
ARC_Prod_Codes.ProductCode(7) = "{31C2EEDC-5E19-4B83-AC8C-68C17954E6F6}"
ARC_Prod_Codes.ProductVersion(8) = "13.00.00.08"      'Version 13.0.0.8
ARC_Prod_Codes.ProductCode(8) = "{8F500EF8-E064-4FD4-A86D-EEF3548C48DA}"
ARC_Prod_Codes.ProductVersion(9) = "13.00.00.09"      'Version 13.0.0.9
ARC_Prod_Codes.ProductCode(9) = "{31051A28-D741-4490-8995-B2C7914CD41E}"
ARC_Prod_Codes.ProductVersion(10) = "13.00.00.10"      'Version 13.0.0.10
ARC_Prod_Codes.ProductCode(10) = "{C5462235-EFBA-4919-9999-F88988BC846B}"
ARC_Prod_Codes.ProductVersion(11) = "13.00.00.11"      'Version 13.0.0.11
ARC_Prod_Codes.ProductCode(11) = "{6F99489E-A1F8-48E3-BD5E-9D74DF368E60}"
ARC_Prod_Codes.ProductVersion(12) = "13.10.00.00"      'Version 13.10
ARC_Prod_Codes.ProductCode(12) = "{F6D39677-0E8D-4688-8C6E-74BB4644074C}"
ARC_Prod_Codes.ProductVersion(13) = "14.00.00.00"      'Version 14.00
ARC_Prod_Codes.ProductCode(13) = "{516DB730-82DF-4481-9DDB-C7B947E600D0}"
ARC_Prod_Codes.ProductVersion(14) = "14.10.00.00"      'Version 14.10
ARC_Prod_Codes.ProductCode(14) = "{03383B7B-9C53-42C2-BAD5-56FDA9661410}"
ARC_Prod_Codes.ProductVersion(15) = "15.00.00.00"      'Version 15.00
ARC_Prod_Codes.ProductCode(15) = "{03383B7B-9C53-42C2-BAD5-56FDA9661500}"

set MONITOROBJ_Prod_Codes = New Product_Ver_Code_Info
MONITOROBJ_Prod_Codes.Ver_Count = 3
MONITOROBJ_Prod_Codes.ProductVersion(0) = "13.10.00.00"      'Version 13.10-13.10.0.1
MONITOROBJ_Prod_Codes.ProductCode(0) = "{A170761C-A844-4E0D-900F-6A432255A1B1}"
MONITOROBJ_Prod_Codes.ProductVersion(1) = "13.10.00.02"      'Version 13.10.0.2
MONITOROBJ_Prod_Codes.ProductCode(1) = "{9B63C7D8-41D6-41B3-B6AE-4289484277D1}"
MONITOROBJ_Prod_Codes.ProductVersion(2) = "14.00.00.01"      'Version 14.00.0.1
MONITOROBJ_Prod_Codes.ProductCode(2) = "{9AF82AC8-0FC3-4C6F-ADBF-4771C9D77484}"

'TDWALLET
set TDWALLET_Prod_Codes = New Product_Ver_Code_Info
TDWALLET_Prod_Codes.Ver_Count = 3
TDWALLET_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.00
TDWALLET_Prod_Codes.ProductCode(0) = "{EF16B04A-C9E5-4AE1-B5C9-6DA558E5CB36}"
TDWALLET_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TDWALLET_Prod_Codes.ProductCode(1) = "{3CF8F483-AB79-48A3-AD8E-3EF5DC671410}"
TDWALLET_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TDWALLET_Prod_Codes.ProductCode(2) = "{3CF8F483-AB79-48A3-AD8E-3EF5DC671500}"

'For TDNETDP the upgrade codes are used because the product code is changed for each package created. 
'The upgrade code is same for all packages in a release.
set TDNETDP_Prod_Codes = New Product_Ver_Code_Info
TDNETDP_Prod_Codes.Ver_Count = 4
TDNETDP_Prod_Codes.ProductVersion(0) = "13.10.00.00"      'Version 01.00 - 13.10
TDNETDP_Prod_Codes.ProductCode(0) = "{79D89732-11F0-4F30-860C-CB7017B41060}"
TDNETDP_Prod_Codes.ProductVersion(1) = "13.11.00.00"      'Version 13.11
TDNETDP_Prod_Codes.ProductCode(1) = "{99721740-3FD7-4075-9012-30D1290B4641}"
TDNETDP_Prod_Codes.ProductVersion(2) = "14.00.00.00"      'Version 14.00-14.10
TDNETDP_Prod_Codes.ProductCode(2) = "{55542F49-5AD1-4A6F-817A-740C99721D95}"
TDNETDP_Prod_Codes.ProductVersion(3) = "14.11.00.00"      'Version 14.11
TDNETDP_Prod_Codes.ProductCode(3) = "{CE5A6FDC-21F0-4A9A-A965-E01C6E7CFE75}"

'TDGEOSPATIAL
set TDGEOSPATIAL_Prod_Codes = New Product_Ver_Code_Info
TDGEOSPATIAL_Prod_Codes.Ver_Count = 1
TDGEOSPATIAL_Prod_Codes.ProductVersion(0) = "15.00.00.00"      'Version 15.00
TDGEOSPATIAL_Prod_Codes.ProductCode(0) = "{AAB73B17-53F5-41A0-90C8-E85A5BB61500}"


'------------------------------
'Product code information for the 64-bit products.

set TERAGSS_64_Prod_Codes = New Product_Ver_Code_Info
TERAGSS_64_Prod_Codes.Ver_Count = 1
TERAGSS_64_Prod_Codes.ProductVersion(0) = "12.00.00.00"                            'UpgradeCode used instead of ProductCode
TERAGSS_64_Prod_Codes.ProductCode(0) = "{51F73750-FA01-4A8E-AA73-4480F1853CCE}"    'because UpgradeCode is same for all pre-13.0 versions

set TDICU_64_Prod_Codes = New Product_Ver_Code_Info
TDICU_64_Prod_Codes.Ver_Count = 6
TDICU_64_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 1.1.1, 1.1.2, 12.0
TDICU_64_Prod_Codes.ProductCode(0) = "{5AE1AFE6-AA91-43EA-88C5-F1F48852B87A}"
TDICU_64_Prod_Codes.ProductVersion(1) = "13.00.00.00"      'Version 13.0
TDICU_64_Prod_Codes.ProductCode(1) = "{FE6858CC-F495-4ABB-9607-04F61DDFAAA9}"
TDICU_64_Prod_Codes.ProductVersion(2) = "13.10.00.00"      'Version 13.10
TDICU_64_Prod_Codes.ProductCode(2) = "{8B40C7D0-B353-42F4-B603-A75D1A25A5E3}"
TDICU_64_Prod_Codes.ProductVersion(3) = "14.00.00.00"      'Version 14.00
TDICU_64_Prod_Codes.ProductCode(3) = "{C27A1002-9BA2-417C-9859-C195F014B9DA}"
TDICU_64_Prod_Codes.ProductVersion(4) = "14.10.00.00"      'Version 14.10
TDICU_64_Prod_Codes.ProductCode(4) = "{7FF1884F-2FFA-4FAC-B19B-9F2871B81410}"
TDICU_64_Prod_Codes.ProductVersion(5) = "15.00.00.00"      'Version 15.00
TDICU_64_Prod_Codes.ProductCode(5) = "{7FF1884F-2FFA-4FAC-B19B-9F2871B81500}"

set CLIv2_64_Prod_Codes = New Product_Ver_Code_Info
CLIv2_64_Prod_Codes.Ver_Count = 7
CLIv2_64_Prod_Codes.ProductVersion(0) = "04.08.01.00"      'Version 4.8.1
CLIv2_64_Prod_Codes.ProductCode(0) = "{64BC52B5-B9CA-4BC1-961D-0480B4AE9E06}"
CLIv2_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 4.8.2, 12.0
CLIv2_64_Prod_Codes.ProductCode(1) = "{89571A0B-B1A9-4DAC-A2EB-7BD53B4C381F}"
CLIv2_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
CLIv2_64_Prod_Codes.ProductCode(2) = "{D23530E5-B0D1-48E4-884B-2E542A809CB8}"
CLIv2_64_Prod_Codes.ProductVersion(3) = "13.10.00.00"      'Version 13.10
CLIv2_64_Prod_Codes.ProductCode(3) = "{847B761D-096B-4F40-9D24-461C80BD06D8}"
CLIv2_64_Prod_Codes.ProductVersion(4) = "14.00.00.00"      'Version 14.00
CLIv2_64_Prod_Codes.ProductCode(4) = "{AE1A6A62-0E43-4068-96F8-877A975EB711}"
CLIv2_64_Prod_Codes.ProductVersion(5) = "14.10.00.00"      'Version 14.10
CLIv2_64_Prod_Codes.ProductCode(5) = "{DD02328E-58D5-4753-91B5-99BA7BEC1410}"
CLIv2_64_Prod_Codes.ProductVersion(6) = "15.00.00.00"      'Version 15.00
CLIv2_64_Prod_Codes.ProductCode(6) = "{DD02328E-58D5-4753-91B5-99BA7BEC1500}"

set TDODBC_64_Prod_Codes = New Product_Ver_Code_Info
TDODBC_64_Prod_Codes.Ver_Count = 9
TDODBC_64_Prod_Codes.ProductVersion(0) = "03.06.00.00"      'Version 3.6
TDODBC_64_Prod_Codes.ProductCode(0) = "{026CE761-6624-4A09-81C2-1EAC7AC91F7F}"
TDODBC_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TDODBC_64_Prod_Codes.ProductCode(1) = "{48ABA7D9-A1FC-47DA-A0CC-F0E4CD9D4BC1}"
TDODBC_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TDODBC_64_Prod_Codes.ProductCode(2) = "{F1982EF1-D750-49E3-9F30-F49E03052329}"
TDODBC_64_Prod_Codes.ProductVersion(3) = "13.00.00.07"      'Version 13.0.0.7
TDODBC_64_Prod_Codes.ProductCode(3) = "{82357635-7A65-4174-8D85-31B46261E229}"
TDODBC_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TDODBC_64_Prod_Codes.ProductCode(4) = "{845E3574-E403-46BE-809F-999B52ED2C23}"
TDODBC_64_Prod_Codes.ProductVersion(5) = "13.10.00.03"      'Version 13.10.0.3
TDODBC_64_Prod_Codes.ProductCode(5) = "{916726D1-522D-4C06-927E-D1BD12C4B277}"
TDODBC_64_Prod_Codes.ProductVersion(6) = "14.00.00.00"      'Version 14.00
TDODBC_64_Prod_Codes.ProductCode(6) = "{68F1AD2A-94AF-4E5F-A4AA-C836C42F9B99}"
TDODBC_64_Prod_Codes.ProductVersion(7) = "14.10.00.00"      'Version 14.10
TDODBC_64_Prod_Codes.ProductCode(7) = "{429A0692-B70F-4A49-8CB1-F1C8BD1D1410}"
TDODBC_64_Prod_Codes.ProductVersion(8) = "15.00.00.00"      'Version 15.00
TDODBC_64_Prod_Codes.ProductCode(8) = "{429A0692-B70F-4A49-8CB1-F1C8BD1D1500}"

set PIOM_64_Prod_Codes = New Product_Ver_Code_Info
PIOM_Prod_Codes.Ver_Count = 4
PIOM_Prod_Codes.ProductVersion(0) = "13.10.00.00"      'Version 13.10
PIOM_Prod_Codes.ProductCode(0) = "{9082EFBA-050F-4154-816F-E2B628991181}"
PIOM_Prod_Codes.ProductVersion(1) = "14.00.00.00"      'Version 14.00
PIOM_Prod_Codes.ProductCode(1) = "{B90039D5-6EF4-4447-88BC-89ADB662C665}"
PIOM_Prod_Codes.ProductVersion(2) = "14.10.00.00"      'Version 14.10
PIOM_Prod_Codes.ProductCode(2) = "{9FD2911E-1559-4271-B62D-48A262831410}"
PIOM_Prod_Codes.ProductVersion(3) = "15.00.00.00"      'Version 15.00
PIOM_Prod_Codes.ProductCode(3) = "{9FD2911E-1559-4271-B62D-48A262831500}"

set SQLPP_64_Prod_Codes = New Product_Ver_Code_Info
SQLPP_64_Prod_Codes.Ver_Count = 9
SQLPP_64_Prod_Codes.ProductVersion(0) = "09.01.00.00"      'Version 8.0, 9.1
SQLPP_64_Prod_Codes.ProductCode(0) = "{7288F593-AF9E-4A78-BB7D-B39779925406}"
SQLPP_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 9.2, 12.0
SQLPP_64_Prod_Codes.ProductCode(1) = "{8D58CAC7-DEAF-4FA9-BB05-FC27E7B681BC}"
SQLPP_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
SQLPP_64_Prod_Codes.ProductCode(2) = "{7A892362-D0BA-4F4B-9054-5E6F2C8417E0}"
SQLPP_64_Prod_Codes.ProductVersion(3) = "13.00.00.07"      'Version 13.0.0.7
SQLPP_64_Prod_Codes.ProductCode(3) = "{A6D9454D-4275-4D5A-A19E-EFADBB826C69}"
SQLPP_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
SQLPP_64_Prod_Codes.ProductCode(4) = "{42746526-49D4-4121-9539-F176585C86E9}"
SQLPP_64_Prod_Codes.ProductVersion(5) = "13.10.00.05"      'Version 13.10.0.5
SQLPP_64_Prod_Codes.ProductCode(5) = "{B350F7B7-C2DD-4503-86BA-1A5D62827432}"
SQLPP_64_Prod_Codes.ProductVersion(6) = "14.00.00.00"      'Version 14.00
SQLPP_64_Prod_Codes.ProductCode(6) = "{07059C9B-0161-4027-854E-D690BFC91EC4}"
SQLPP_64_Prod_Codes.ProductVersion(7) = "14.10.00.00"      'Version 14.10
SQLPP_64_Prod_Codes.ProductCode(7) = "{07059C9B-0161-4027-854E-D690BFC91410}"
SQLPP_64_Prod_Codes.ProductVersion(8) = "15.00.00.00"      'Version 15.00
SQLPP_64_Prod_Codes.ProductCode(8) = "{07059C9B-0161-4027-854E-D690BFC91500}"

set NPAXSMOD_64_Prod_Codes = New Product_Ver_Code_Info
NPAXSMOD_64_Prod_Codes.Ver_Count = 4
NPAXSMOD_64_Prod_Codes.ProductVersion(0) = "13.10.00.02"      'Version 13.10.0.2
NPAXSMOD_64_Prod_Codes.ProductCode(0) = "{4D3D2370-EEA3-4A6E-AC60-2576BB1AEDDB}"
NPAXSMOD_64_Prod_Codes.ProductVersion(1) = "14.00.00.00"      'Version 14.00
NPAXSMOD_64_Prod_Codes.ProductCode(1) = "{0D1261C5-880E-4229-8189-92C6DADFF4AE}"
NPAXSMOD_64_Prod_Codes.ProductVersion(2) = "14.10.00.00"      'Version 14.10
NPAXSMOD_64_Prod_Codes.ProductCode(2) = "{36133A07-461D-44BC-BA27-E0490D491410}"
NPAXSMOD_64_Prod_Codes.ProductVersion(3) = "15.00.00.00"      'Version 15.00
NPAXSMOD_64_Prod_Codes.ProductCode(3) = "{36133A07-461D-44BC-BA27-E0490D491500}"

set JMSAXSMOD_64_Prod_Codes = New Product_Ver_Code_Info
JMSAXSMOD_64_Prod_Codes.Ver_Count = 3
JMSAXSMOD_64_Prod_Codes.ProductVersion(0) = "14.00.00.03"      'Version 14.00.00.03
JMSAXSMOD_64_Prod_Codes.ProductCode(0) = "{915645F8-8759-47A9-83B7-46FE6499175E}"
JMSAXSMOD_64_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
JMSAXSMOD_64_Prod_Codes.ProductCode(1) = "{9DDC06AC-7510-4ECF-9422-92AAFE831410}"
JMSAXSMOD_64_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
JMSAXSMOD_64_Prod_Codes.ProductCode(2) = "{9DDC06AC-7510-4ECF-9422-92AAFE831500}"

set TPTBASE_64_Prod_Codes = New Product_Ver_Code_Info
TPTBASE_64_Prod_Codes.Ver_Count = 3
TPTBASE_64_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.0
TPTBASE_64_Prod_Codes.ProductCode(0) = "{268E41A4-8E42-4B66-A02C-54DA0773E435}"
TPTBASE_64_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TPTBASE_64_Prod_Codes.ProductCode(1) = "{107B4989-709F-4458-9626-CB99D81A1410}"
TPTBASE_64_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TPTBASE_64_Prod_Codes.ProductCode(2) = "{107B4989-709F-4458-9626-CB99D81A1500}"

set TPTSTREAM_64_Prod_Codes = New Product_Ver_Code_Info
TPTSTREAM_64_Prod_Codes.Ver_Count = 3
TPTSTREAM_64_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.0
TPTSTREAM_64_Prod_Codes.ProductCode(0) = "{A05C3D95-0065-4632-8B3B-1C17816C9397}"
TPTSTREAM_64_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TPTSTREAM_64_Prod_Codes.ProductCode(1) = "{DC921E73-77B3-48D9-995A-D1270C0B1410}"
TPTSTREAM_64_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TPTSTREAM_64_Prod_Codes.ProductCode(2) = "{DC921E73-77B3-48D9-995A-D1270C0B1500}"

set TPTAPI_64_Prod_Codes = New Product_Ver_Code_Info
TPTAPI_64_Prod_Codes.Ver_Count = 6
TPTAPI_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTAPI_64_Prod_Codes.ProductCode(0) = "{F335A2CC-31DB-49A3-98FC-AB17A9AAB69F}"
TPTAPI_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTAPI_64_Prod_Codes.ProductCode(1) = "{51015F9A-B5DA-41B2-8F36-A3FC2C7E06B6}"
TPTAPI_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTAPI_64_Prod_Codes.ProductCode(2) = "{D1FA20A3-815A-4F5B-968C-47909031ABD2}"
TPTAPI_64_Prod_Codes.ProductVersion(3) = "13.00.00.09"      'Version 13.0.0.09
TPTAPI_64_Prod_Codes.ProductCode(3) = "{0B557D2D-B601-4BC1-9FB5-56344C60BAF2}"
TPTAPI_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTAPI_64_Prod_Codes.ProductCode(4) = "{849C2925-8FBD-452D-8DF9-271FBC0D4EE3}"
TPTAPI_64_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTAPI_64_Prod_Codes.ProductCode(5) = "{9D497C81-29BD-4B7F-A031-3BE901C1A2E5}"


set TPTLOADOP_64_Prod_Codes = New Product_Ver_Code_Info
TPTLOADOP_64_Prod_Codes.Ver_Count = 6
TPTLOADOP_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTLOADOP_64_Prod_Codes.ProductCode(0) = "{8526C815-DCE0-4CB4-AE7B-982C536CFECE}"
TPTLOADOP_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTLOADOP_64_Prod_Codes.ProductCode(1) = "{9DD4407A-DDFF-46A8-AF65-57F6F8002AA3}"
TPTLOADOP_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTLOADOP_64_Prod_Codes.ProductCode(2) = "{79E16D18-1787-45E5-8610-C0CF955B6CF6}"
TPTLOADOP_64_Prod_Codes.ProductVersion(3) = "13.00.00.09"      'Version 13.0.0.09
TPTLOADOP_64_Prod_Codes.ProductCode(3) = "{A8C4946B-1BED-4094-AB8E-80A8FC319022}"
TPTLOADOP_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTLOADOP_64_Prod_Codes.ProductCode(4) = "{1DB1D02B-72D3-4B7A-AC9F-BFF871197C06}"
TPTLOADOP_64_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTLOADOP_64_Prod_Codes.ProductCode(5) = "{7A388D1F-A87B-4873-8EA9-30BA94A0976E}"

set TPTEXPORTOP_64_Prod_Codes = New Product_Ver_Code_Info
TPTEXPORTOP_64_Prod_Codes.Ver_Count = 6
TPTEXPORTOP_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTEXPORTOP_64_Prod_Codes.ProductCode(0) = "{2477C778-D944-4AA9-96D6-5BD16CC6EB5E}"
TPTEXPORTOP_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTEXPORTOP_64_Prod_Codes.ProductCode(1) = "{6898101E-04DA-4FD8-AB96-FC10BAC722B1}"
TPTEXPORTOP_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTEXPORTOP_64_Prod_Codes.ProductCode(2) = "{8D72F7A5-EC85-4C73-BDF4-659639A02732}"
TPTEXPORTOP_64_Prod_Codes.ProductVersion(3) = "13.00.00.07"      'Version 13.0.0.7
TPTEXPORTOP_64_Prod_Codes.ProductCode(3) = "{CE429A60-75FC-4C5A-9FB3-3C043C765EB3}"
TPTEXPORTOP_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTEXPORTOP_64_Prod_Codes.ProductCode(4) = "{ECF6125D-2281-4F2A-9E94-7F0EE55EFCE5}"
TPTEXPORTOP_64_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTEXPORTOP_64_Prod_Codes.ProductCode(5) = "{6AED9BBE-5CF2-4000-8B12-21F05745EDE6}"

set TPTUPDATEOP_64_Prod_Codes = New Product_Ver_Code_Info
TPTUPDATEOP_64_Prod_Codes.Ver_Count = 6
TPTUPDATEOP_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTUPDATEOP_64_Prod_Codes.ProductCode(0) = "{427176D7-2E9D-408E-B864-694FAFE52F1F}"
TPTUPDATEOP_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTUPDATEOP_64_Prod_Codes.ProductCode(1) = "{2D4F1498-CF6E-448B-96E7-E8D7078D9F67}"
TPTUPDATEOP_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTUPDATEOP_64_Prod_Codes.ProductCode(2) = "{92F46A51-0678-49CB-AD2D-D1570A5A3A45}"
TPTUPDATEOP_64_Prod_Codes.ProductVersion(3) = "13.00.00.08"      'Version 13.0.0.8
TPTUPDATEOP_64_Prod_Codes.ProductCode(3) = "{056BA64E-B996-47D6-8AFB-D1F7FFEBDAFB}"
TPTUPDATEOP_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTUPDATEOP_64_Prod_Codes.ProductCode(4) = "{BDA7D835-F825-46C1-890E-9E112E179309}"
TPTUPDATEOP_64_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTUPDATEOP_64_Prod_Codes.ProductCode(5) = "{B0A48994-ACF8-48AF-9380-FCA0E58DEFA6}"


set TPTSTREAMOP_64_Prod_Codes = New Product_Ver_Code_Info
TPTSTREAMOP_64_Prod_Codes.Ver_Count = 6
TPTSTREAMOP_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTSTREAMOP_64_Prod_Codes.ProductCode(0) = "{FCA023ED-545F-467E-B173-3F99E950E21D}"
TPTSTREAMOP_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTSTREAMOP_64_Prod_Codes.ProductCode(1) = "{271B3298-AF57-4B34-928C-4E6FB0FB3BBF}"
TPTSTREAMOP_64_Prod_Codes.ProductVersion(2) = "13.00.00.00"      'Version 13.0
TPTSTREAMOP_64_Prod_Codes.ProductCode(2) = "{9CDCEECC-DF60-435A-80C7-785A97327915}"
TPTSTREAMOP_64_Prod_Codes.ProductVersion(3) = "13.00.00.11"      'Version 13.0.0.11
TPTSTREAMOP_64_Prod_Codes.ProductCode(3) = "{0BD62A8F-148F-4481-9C17-F433FF489B8F}"
TPTSTREAMOP_64_Prod_Codes.ProductVersion(4) = "13.10.00.00"      'Version 13.10
TPTSTREAMOP_64_Prod_Codes.ProductCode(4) = "{1870442D-DD3E-4C82-991C-3ABDF260B520}"
TPTSTREAMOP_64_Prod_Codes.ProductVersion(5) = "13.10.00.02"      'Version 13.10.0.2
TPTSTREAMOP_64_Prod_Codes.ProductCode(5) = "{FA6C15B1-80F9-4A0C-97B9-15FF5EBE427F}"

set TPTICU_64_Prod_Codes = New Product_Ver_Code_Info
TPTICU_64_Prod_Codes.Ver_Count = 1
TPTICU_64_Prod_Codes.ProductVersion(0) = "12.00.00.00"      'Version 12.0
TPTICU_64_Prod_Codes.ProductCode(0) = "{61577D86-C3AC-44EE-88E9-909A81E593AE}"

set TPTOSL_64_Prod_Codes = New Product_Ver_Code_Info
TPTOSL_64_Prod_Codes.Ver_Count = 2
TPTOSL_64_Prod_Codes.ProductVersion(0) = "08.02.00.00"      'Version 8.2
TPTOSL_64_Prod_Codes.ProductCode(0) = "{9FE65AD8-5DFF-4EED-8A8B-ED4D90A36258}"
TPTOSL_64_Prod_Codes.ProductVersion(1) = "12.00.00.00"      'Version 12.0
TPTOSL_64_Prod_Codes.ProductCode(1) = "{941FDB05-6303-42B2-80DD-931A3AFC980F}"

set ARC_64_Prod_Codes = New Product_Ver_Code_Info
ARC_64_Prod_Codes.Ver_Count = 4
ARC_64_Prod_Codes.ProductVersion(0) = "13.10.00.00"      'Version 13.10
ARC_64_Prod_Codes.ProductCode(0) = "{B1A168BB-54DD-41BF-97F2-FA128F863C64}"
ARC_64_Prod_Codes.ProductVersion(1) = "14.00.00.00"      'Version 14.00
ARC_64_Prod_Codes.ProductCode(1) = "{5A328579-5C52-4702-BE0F-714D6370F88F}"
ARC_64_Prod_Codes.ProductVersion(2) = "14.10.00.00"      'Version 14.10
ARC_64_Prod_Codes.ProductCode(2) = "{F5BC53E6-54BC-4BEB-9EB1-CB6787051410}"
ARC_64_Prod_Codes.ProductVersion(3) = "15.00.00.00"      'Version 15.00
ARC_64_Prod_Codes.ProductCode(3) = "{F5BC53E6-54BC-4BEB-9EB1-CB6787051500}"

'TDWALLET
set TDWALLET_64_Prod_Codes = New Product_Ver_Code_Info
TDWALLET_64_Prod_Codes.Ver_Count = 3
TDWALLET_64_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.00
TDWALLET_64_Prod_Codes.ProductCode(0) = "{F62EC9E2-66B2-47C0-8005-F80BB7E1EA21}"
TDWALLET_64_Prod_Codes.ProductVersion(1) = "14.10.00.00"      'Version 14.10
TDWALLET_64_Prod_Codes.ProductCode(1) = "{B664EC42-7ADF-4244-B698-DE6CB46F1410}"
TDWALLET_64_Prod_Codes.ProductVersion(2) = "15.00.00.00"      'Version 15.00
TDWALLET_64_Prod_Codes.ProductCode(2) = "{B664EC42-7ADF-4244-B698-DE6CB46F1500}"

'TDGEOSPATIAL
set TDGEOSPATIAL_64_Prod_Codes = New Product_Ver_Code_Info
TDGEOSPATIAL_64_Prod_Codes.Ver_Count = 1
TDGEOSPATIAL_64_Prod_Codes.ProductVersion(0) = "15.00.00.00"      'Version 15.00
TDGEOSPATIAL_64_Prod_Codes.ProductCode(0) = "{B54AFC04-9403-46FC-8143-0C443B711500}"


'The following class objects are created and populated with the product code and product version information for all suite packages.
'For new releases when the product code changes the product code with the version needs to be added under the appropriate 
'product_ver_code object initialization section. When adding new information increase the Ver_Count member by 1 and add 
'new product code & product version at the end of the existing information by incrementing the index by 1.

set Suite_TERAGSS_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TERAGSS_Prod_Codes.Ver_Count = 1
Suite_TERAGSS_Prod_Codes.ProductVersion(0) = "12.00.00.00"                            'UpgradeCode used instead of ProductCode
Suite_TERAGSS_Prod_Codes.ProductCode(0) = "{51F73750-FA01-4A8E-AA73-4480F1853CCE}"    'because UpgradeCode is same for all pre-13.0 versions

set Suite_TDICU_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDICU_Prod_Codes.Ver_Count = 2
Suite_TDICU_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDICU_Prod_Codes.ProductCode(0) = "{FBBB82E9-A7DF-40A2-B3EB-123AAC731410}"
Suite_TDICU_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDICU_Prod_Codes.ProductCode(1) = "{FBBB82E9-A7DF-40A2-B3EB-123AAC731500}"

set Suite_CLIv2_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_CLIv2_Prod_Codes.Ver_Count = 2
Suite_CLIv2_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_CLIv2_Prod_Codes.ProductCode(0) = "{76707046-0BAA-48FA-91A7-AB9876A31410}"
Suite_CLIv2_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_CLIv2_Prod_Codes.ProductCode(1) = "{76707046-0BAA-48FA-91A7-AB9876A31500}"

set Suite_TDODBC_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDODBC_Prod_Codes.Ver_Count = 2
Suite_TDODBC_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDODBC_Prod_Codes.ProductCode(0) = "{DF7D8033-5CE9-46DC-B5C4-DA16B77D1410}"
Suite_TDODBC_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDODBC_Prod_Codes.ProductCode(1) = "{DF7D8033-5CE9-46DC-B5C4-DA16B77D1500}"

set Suite_PIOM_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_PIOM_Prod_Codes.Ver_Count = 2
Suite_PIOM_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_PIOM_Prod_Codes.ProductCode(0) = "{99CFA68C-06AF-4889-9295-57DE39771410}"
Suite_PIOM_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_PIOM_Prod_Codes.ProductCode(1) = "{99CFA68C-06AF-4889-9295-57DE39771500}"

set Suite_BTEQ_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_BTEQ_Prod_Codes.Ver_Count = 2
Suite_BTEQ_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_BTEQ_Prod_Codes.ProductCode(0) = "{ADDB19E3-8283-45EC-BB8D-419DBABC1410}"
Suite_BTEQ_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 14.00
Suite_BTEQ_Prod_Codes.ProductCode(1) = "{ADDB19E3-8283-45EC-BB8D-419DBABC1500}"

set Suite_FASTLD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_FASTLD_Prod_Codes.Ver_Count = 2
Suite_FASTLD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_FASTLD_Prod_Codes.ProductCode(0) = "{6E80C54D-58FC-4BFC-B842-B2AF86041410}"
Suite_FASTLD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_FASTLD_Prod_Codes.ProductCode(1) = "{6E80C54D-58FC-4BFC-B842-B2AF86041500}"

set Suite_MLOAD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_MLOAD_Prod_Codes.Ver_Count = 2
Suite_MLOAD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_MLOAD_Prod_Codes.ProductCode(0) = "{6AF6694D-8432-46D8-A0C4-A45213681410}"
Suite_MLOAD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_MLOAD_Prod_Codes.ProductCode(1) = "{6AF6694D-8432-46D8-A0C4-A45213681500}"

set Suite_FASTEXP_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_FASTEXP_Prod_Codes.Ver_Count = 2
Suite_FASTEXP_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_FASTEXP_Prod_Codes.ProductCode(0) = "{6F3498D2-AC81-41DE-A850-60A6A4FB1410}"
Suite_FASTEXP_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_FASTEXP_Prod_Codes.ProductCode(1) = "{6F3498D2-AC81-41DE-A850-60A6A4FB1500}"

set Suite_TPUMP_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TPUMP_Prod_Codes.Ver_Count = 2
Suite_TPUMP_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version  14.10
Suite_TPUMP_Prod_Codes.ProductCode(0) = "{E2149622-860A-4E49-8238-5FE60F321410}"
Suite_TPUMP_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version  15.00
Suite_TPUMP_Prod_Codes.ProductCode(1) = "{E2149622-860A-4E49-8238-5FE60F321500}"

set Suite_SQLPP_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_SQLPP_Prod_Codes.Ver_Count = 2
Suite_SQLPP_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_SQLPP_Prod_Codes.ProductCode(0) = "{D2D162F9-8D39-42A6-956C-2BED21811410}"
Suite_SQLPP_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_SQLPP_Prod_Codes.ProductCode(1) = "{D2D162F9-8D39-42A6-956C-2BED21811500}"

set Suite_NPAXSMOD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_NPAXSMOD_Prod_Codes.Ver_Count = 2
Suite_NPAXSMOD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_NPAXSMOD_Prod_Codes.ProductCode(0) = "{1BABD132-9AE4-4964-851D-906278C81410}"
Suite_NPAXSMOD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_NPAXSMOD_Prod_Codes.ProductCode(1) = "{1BABD132-9AE4-4964-851D-906278C81500}"

set Suite_MQAXSMOD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_MQAXSMOD_Prod_Codes.Ver_Count = 2
Suite_MQAXSMOD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_MQAXSMOD_Prod_Codes.ProductCode(0) = "{9760FAAE-F5B7-4460-B01C-2CDF04A91410}"
Suite_MQAXSMOD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_MQAXSMOD_Prod_Codes.ProductCode(1) = "{9760FAAE-F5B7-4460-B01C-2CDF04A91500}"

set Suite_OLEDBAXSMOD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_OLEDBAXSMOD_Prod_Codes.Ver_Count = 2
Suite_OLEDBAXSMOD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_OLEDBAXSMOD_Prod_Codes.ProductCode(0) = "{32F51C03-07D1-434C-9C40-9765169E1410}"
Suite_OLEDBAXSMOD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_OLEDBAXSMOD_Prod_Codes.ProductCode(1) = "{32F51C03-07D1-434C-9C40-9765169E1500}"

set Suite_JMSAXSMOD_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_JMSAXSMOD_Prod_Codes.Ver_Count = 2
Suite_JMSAXSMOD_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_JMSAXSMOD_Prod_Codes.ProductCode(0) = "{DC8E925F-F660-4820-8FD5-3895BA0D1410}"
Suite_JMSAXSMOD_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_JMSAXSMOD_Prod_Codes.ProductCode(1) = "{DC8E925F-F660-4820-8FD5-3895BA0D1500}"

set Suite_SQLA_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_SQLA_Prod_Codes.Ver_Count = 2
Suite_SQLA_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_SQLA_Prod_Codes.ProductCode(0) = "{F51CC502-7C9D-4F99-9E4F-D70D520B1410}"
Suite_SQLA_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_SQLA_Prod_Codes.ProductCode(1) = "{F51CC502-7C9D-4F99-9E4F-D70D520B1500}"

set Suite_TSET_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TSET_Prod_Codes.Ver_Count = 2
Suite_TSET_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TSET_Prod_Codes.ProductCode(0) = "{0FCC3DD4-B0F7-4AE1-B777-705D7A621410}"
Suite_TSET_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TSET_Prod_Codes.ProductCode(1) = "{0FCC3DD4-B0F7-4AE1-B777-705D7A621500}"

set Suite_VECOMP_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_VECOMP_Prod_Codes.Ver_Count = 2
Suite_VECOMP_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_VECOMP_Prod_Codes.ProductCode(0) = "{007D0AF6-0E6D-4695-B90F-EE0A27B41410}"
Suite_VECOMP_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_VECOMP_Prod_Codes.ProductCode(1) = "{007D0AF6-0E6D-4695-B90F-EE0A27B41500}"

set Suite_TIWIZ_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TIWIZ_Prod_Codes.Ver_Count = 2
Suite_TIWIZ_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TIWIZ_Prod_Codes.ProductCode(0) = "{D1BD2BD7-6115-4318-9CFB-1E0CD22A1410}"
Suite_TIWIZ_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TIWIZ_Prod_Codes.ProductCode(1) = "{D1BD2BD7-6115-4318-9CFB-1E0CD22A1500}"

set Suite_TSWIZ_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TSWIZ_Prod_Codes.Ver_Count = 1
Suite_TSWIZ_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TSWIZ_Prod_Codes.ProductCode(0) = "{E2BFCFC0-D224-4171-AE28-F5E001241410}"

set Suite_PMON_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_PMON_Prod_Codes.Ver_Count = 2
Suite_PMON_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_PMON_Prod_Codes.ProductCode(0) = "{9AF82AC8-0FC3-4C6F-ADBF-4771C9D71410}"
Suite_PMON_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_PMON_Prod_Codes.ProductCode(1) = "{95F2ACF6-6AC8-46F3-BC40-E237DB751500}"

set Suite_TQSADMIN_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TQSADMIN_Prod_Codes.Ver_Count = 2
Suite_TQSADMIN_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TQSADMIN_Prod_Codes.ProductCode(0) = "{BC39EEC1-7447-45E2-8F6F-92907D731410}"
Suite_TQSADMIN_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TQSADMIN_Prod_Codes.ProductCode(1) = "{BC39EEC1-7447-45E2-8F6F-92907D731500}"

set Suite_TQSSERVER_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TQSSERVER_Prod_Codes.Ver_Count = 2
Suite_TQSSERVER_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TQSSERVER_Prod_Codes.ProductCode(0) = "{29B253C0-4774-4916-A294-7BBFA36D1410}"
Suite_TQSSERVER_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TQSSERVER_Prod_Codes.ProductCode(1) = "{29B253C0-4774-4916-A294-7BBFA36D1500}"

set Suite_TQSCLIENT_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TQSCLIENT_Prod_Codes.Ver_Count = 2
Suite_TQSCLIENT_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TQSCLIENT_Prod_Codes.ProductCode(0) = "{E00558EE-EE85-4993-BC85-5A885A161410}"
Suite_TQSCLIENT_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TQSCLIENT_Prod_Codes.ProductCode(1) = "{E00558EE-EE85-4993-BC85-5A885A161500}"

set Suite_TWA_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TWA_Prod_Codes.Ver_Count = 2
Suite_TWA_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TWA_Prod_Codes.ProductCode(0) = "{95CC5FC2-D4B4-43BA-A39A-CCADC36D1410}"
Suite_TWA_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TWA_Prod_Codes.ProductCode(1) = "{95CC5FC2-D4B4-43BA-A39A-CCADC36D1500}"

set Suite_TDADMIN_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDADMIN_Prod_Codes.Ver_Count = 2
Suite_TDADMIN_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDADMIN_Prod_Codes.ProductCode(0) = "{908CD71C-F004-472C-9638-D47927F11410}"
Suite_TDADMIN_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDADMIN_Prod_Codes.ProductCode(1) = "{908CD71C-F004-472C-9638-D47927F11500}"

set Suite_TPTBASE_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TPTBASE_Prod_Codes.Ver_Count = 2
Suite_TPTBASE_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TPTBASE_Prod_Codes.ProductCode(0) = "{EAE2826E-F71E-4AB1-9D55-71ACAAD01410}"
Suite_TPTBASE_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TPTBASE_Prod_Codes.ProductCode(1) = "{709BD56F-9451-4AC4-B14F-304D9D8C1500}"

set Suite_TPTSTREAM_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TPTSTREAM_Prod_Codes.Ver_Count = 2
Suite_TPTSTREAM_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TPTSTREAM_Prod_Codes.ProductCode(0) = "{FD2A2864-57E1-4DF8-B756-4C124DBB1410}"
Suite_TPTSTREAM_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TPTSTREAM_Prod_Codes.ProductCode(1) = "{843D7BBA-C4FD-490C-913B-03C7AFD81500}"

set Suite_ARC_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_ARC_Prod_Codes.Ver_Count = 2
Suite_ARC_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_ARC_Prod_Codes.ProductCode(0) = "{03383B7B-9C53-42C2-BAD5-56FDA9661410}"
Suite_ARC_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_ARC_Prod_Codes.ProductCode(1) = "{03383B7B-9C53-42C2-BAD5-56FDA9661500}"

'TDWALLET
set Suite_TDWALLET_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDWALLET_Prod_Codes.Ver_Count = 2
Suite_TDWALLET_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDWALLET_Prod_Codes.ProductCode(0) = "{3CF8F483-AB79-48A3-AD8E-3EF5DC671410}"
Suite_TDWALLET_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDWALLET_Prod_Codes.ProductCode(1) = "{3CF8F483-AB79-48A3-AD8E-3EF5DC671500}"

'For TDNETDP the upgrade codes are used because the product code is changed for each package created. 
'The upgrade code is same for all packages in a release.
set Suite_TDNETDP_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDNETDP_Prod_Codes.Ver_Count = 2
Suite_TDNETDP_Prod_Codes.ProductVersion(0) = "14.00.00.00"      'Version 14.00-14.10
Suite_TDNETDP_Prod_Codes.ProductCode(0) = "{55542F49-5AD1-4A6F-817A-740C99721D95}"
Suite_TDNETDP_Prod_Codes.ProductVersion(1) = "14.11.00.00"      'Version 14.11
Suite_TDNETDP_Prod_Codes.ProductCode(1) = "{CE5A6FDC-21F0-4A9A-A965-E01C6E7CFE75}"

'TDGEOSPATIAL
set Suite_TDGEOSPATIAL_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDGEOSPATIAL_Prod_Codes.Ver_Count = 1
Suite_TDGEOSPATIAL_Prod_Codes.ProductVersion(0) = "15.00.00.00"      'Version 15.00
Suite_TDGEOSPATIAL_Prod_Codes.ProductCode(0) = "{AAB73B17-53F5-41A0-90C8-E85A5BB61500}"

'------------------------------
'Product code information for the 64-bit products.

set Suite_TERAGSS_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TERAGSS_64_Prod_Codes.Ver_Count = 1
Suite_TERAGSS_64_Prod_Codes.ProductVersion(0) = "12.00.00.00"                            'UpgradeCode used instead of ProductCode
Suite_TERAGSS_64_Prod_Codes.ProductCode(0) = "{51F73750-FA01-4A8E-AA73-4480F1853CCE}"    'because UpgradeCode is same for all pre-13.0 versions

set Suite_TDICU_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDICU_64_Prod_Codes.Ver_Count = 2
Suite_TDICU_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDICU_64_Prod_Codes.ProductCode(0) = "{7FF1884F-2FFA-4FAC-B19B-9F2871B81410}"
Suite_TDICU_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDICU_64_Prod_Codes.ProductCode(1) = "{7FF1884F-2FFA-4FAC-B19B-9F2871B81500}"

set Suite_CLIv2_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_CLIv2_64_Prod_Codes.Ver_Count = 2
Suite_CLIv2_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_CLIv2_64_Prod_Codes.ProductCode(0) = "{DD02328E-58D5-4753-91B5-99BA7BEC1410}"
Suite_CLIv2_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_CLIv2_64_Prod_Codes.ProductCode(1) = "{DD02328E-58D5-4753-91B5-99BA7BEC1500}"

set Suite_TDODBC_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDODBC_64_Prod_Codes.Ver_Count = 2
Suite_TDODBC_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDODBC_64_Prod_Codes.ProductCode(0) = "{429A0692-B70F-4A49-8CB1-F1C8BD1D1410}"
Suite_TDODBC_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDODBC_64_Prod_Codes.ProductCode(1) = "{429A0692-B70F-4A49-8CB1-F1C8BD1D1500}"

set Suite_PIOM_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_PIOM_Prod_Codes.Ver_Count = 2
Suite_PIOM_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_PIOM_Prod_Codes.ProductCode(0) = "{9FD2911E-1559-4271-B62D-48A262831410}"
Suite_PIOM_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_PIOM_Prod_Codes.ProductCode(1) = "{9FD2911E-1559-4271-B62D-48A262831500}"

set Suite_SQLPP_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_SQLPP_64_Prod_Codes.Ver_Count = 2
Suite_SQLPP_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_SQLPP_64_Prod_Codes.ProductCode(0) = "{07059C9B-0161-4027-854E-D690BFC91410}"
Suite_SQLPP_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_SQLPP_64_Prod_Codes.ProductCode(1) = "{07059C9B-0161-4027-854E-D690BFC91500}"

set Suite_NPAXSMOD_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_NPAXSMOD_64_Prod_Codes.Ver_Count = 2
Suite_NPAXSMOD_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_NPAXSMOD_64_Prod_Codes.ProductCode(0) = "{36133A07-461D-44BC-BA27-E0490D491410}"
Suite_NPAXSMOD_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_NPAXSMOD_64_Prod_Codes.ProductCode(1) = "{36133A07-461D-44BC-BA27-E0490D491500}"

set Suite_JMSAXSMOD_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_JMSAXSMOD_64_Prod_Codes.Ver_Count = 2
Suite_JMSAXSMOD_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_JMSAXSMOD_64_Prod_Codes.ProductCode(0) = "{9DDC06AC-7510-4ECF-9422-92AAFE831410}"
Suite_JMSAXSMOD_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_JMSAXSMOD_64_Prod_Codes.ProductCode(1) = "{9DDC06AC-7510-4ECF-9422-92AAFE831500}"

set Suite_TPTBASE_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TPTBASE_64_Prod_Codes.Ver_Count = 2
Suite_TPTBASE_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TPTBASE_64_Prod_Codes.ProductCode(0) = "{107B4989-709F-4458-9626-CB99D81A1410}"
Suite_TPTBASE_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TPTBASE_64_Prod_Codes.ProductCode(1) = "{107B4989-709F-4458-9626-CB99D81A1500}"

set Suite_TPTSTREAM_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TPTSTREAM_64_Prod_Codes.Ver_Count = 2
Suite_TPTSTREAM_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TPTSTREAM_64_Prod_Codes.ProductCode(0) = "{DC921E73-77B3-48D9-995A-D1270C0B1410}"
Suite_TPTSTREAM_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TPTSTREAM_64_Prod_Codes.ProductCode(1) = "{DC921E73-77B3-48D9-995A-D1270C0B1500}"

set Suite_ARC_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_ARC_64_Prod_Codes.Ver_Count = 2
Suite_ARC_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_ARC_64_Prod_Codes.ProductCode(0) = "{F5BC53E6-54BC-4BEB-9EB1-CB6787051410}"
Suite_ARC_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_ARC_64_Prod_Codes.ProductCode(1) = "{F5BC53E6-54BC-4BEB-9EB1-CB6787051500}"

'TDWALLET
set Suite_TDWALLET_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDWALLET_64_Prod_Codes.Ver_Count = 2
Suite_TDWALLET_64_Prod_Codes.ProductVersion(0) = "14.10.00.00"      'Version 14.10
Suite_TDWALLET_64_Prod_Codes.ProductCode(0) = "{B664EC42-7ADF-4244-B698-DE6CB46F1410}"
Suite_TDWALLET_64_Prod_Codes.ProductVersion(1) = "15.00.00.00"      'Version 15.00
Suite_TDWALLET_64_Prod_Codes.ProductCode(1) = "{B664EC42-7ADF-4244-B698-DE6CB46F1500}"

'TDGEOSPATIAL
set Suite_TDGEOSPATIAL_64_Prod_Codes = New Suite_Product_Ver_Code_Info
Suite_TDGEOSPATIAL_64_Prod_Codes.Ver_Count = 1
Suite_TDGEOSPATIAL_64_Prod_Codes.ProductVersion(0) = "15.00.00.00"      'Version 15.00
Suite_TDGEOSPATIAL_64_Prod_Codes.ProductCode(0) = "{B54AFC04-9403-46FC-8143-0C443B711500}"

'------------------------------
Basic_MSI_ver_13_0(0) = "13.00.00.00"   'TERAGSS
Basic_MSI_ver_13_0(1) = "13.00.00.00"   'TDICU
Basic_MSI_ver_13_0(2) = "13.00.00.00"   'CLIv2
Basic_MSI_ver_13_0(3) = "13.00.00.00"   'TDODBC
Basic_MSI_ver_13_0(4) = "13.00.00.08"   'PIOM
Basic_MSI_ver_13_0(5) = "13.00.00.10"   'BTEQ
Basic_MSI_ver_13_0(6) = "13.00.00.10"   'FASTLD
Basic_MSI_ver_13_0(7) = "13.00.00.08"   'MLOAD
Basic_MSI_ver_13_0(8) = "13.00.00.13"   'FASTEXP
Basic_MSI_ver_13_0(9) = "13.00.00.08"   'TPUMP
Basic_MSI_ver_13_0(10) = "13.00.00.02"   'TDOLEDB
Basic_MSI_ver_13_0(11) = "13.00.00.07"   'SQLPP
Basic_MSI_ver_13_0(12) = "13.00.00.05"   'NPAXSMOD
Basic_MSI_ver_13_0(13) = "13.00.00.06"   'MQAXSMOD
Basic_MSI_ver_13_0(14) = "13.00.00.10"   'OLEDBAXSMOD
Basic_MSI_ver_13_0(15) = "13.00.00.01"   'JMSAXSMOD
Basic_MSI_ver_13_0(16) = "13.00.00.00"   'SQLA
Basic_MSI_ver_13_0(17) = "13.00.00.06"   'TSET
Basic_MSI_ver_13_0(18) = "13.00.00.07"   'VECOMP
Basic_MSI_ver_13_0(19) = "13.00.00.04"   'TIWIZ
Basic_MSI_ver_13_0(20) = "13.00.00.05"   'TSWIZ
Basic_MSI_ver_13_0(21) = "13.00.00.03"   'PMON
Basic_MSI_ver_13_0(22) = "13.00.00.04"   'TQSADMIN
Basic_MSI_ver_13_0(23) = "13.00.00.04"   'TQSSERVER
Basic_MSI_ver_13_0(24) = "13.00.00.04"   'TQSCLIENT
Basic_MSI_ver_13_0(25) = "13.00.00.04"   'TWA
Basic_MSI_ver_13_0(26) = "13.00.00.10"   'TMGR
Basic_MSI_ver_13_0(27) = "13.00.00.00"   'TDADMIN
Basic_MSI_ver_13_0(28) = "13.00.00.07"   'TDWM
Basic_MSI_ver_13_0(29) = "13.00.00.00"   'TSAW
Basic_MSI_ver_13_0(30) = "14.00.00.00"   'TPTBASE
Basic_MSI_ver_13_0(31) = "14.00.00.00"   'TPTSTREAM
Basic_MSI_ver_13_0(32) = "13.00.00.12"   'TPTINFRA
Basic_MSI_ver_13_0(33) = "13.00.00.09"   'TPTAPI
Basic_MSI_ver_13_0(34) = "13.00.00.09"   'TPTLOADOP
Basic_MSI_ver_13_0(35) = "13.00.00.07"   'TPTEXPORTOP
Basic_MSI_ver_13_0(36) = "13.00.00.08"   'TPTUPDATEOP
Basic_MSI_ver_13_0(37) = "13.00.00.11"   'TPTSTREAMOP
Basic_MSI_ver_13_0(38) = "13.01.00.02"   'TDNETDP
Basic_MSI_ver_13_0(39) = Empty

'------------------------------

Basic_MSI_ver_13_10(0) = "13.10.00.00"   'TERAGSS
Basic_MSI_ver_13_10(1) = "13.10.00.00"   'TDICU
Basic_MSI_ver_13_10(2) = "13.10.00.00"   'CLIv2
Basic_MSI_ver_13_10(3) = "13.10.00.00"   'TDODBC
Basic_MSI_ver_13_10(4) = "13.10.00.00"   'PIOM
Basic_MSI_ver_13_10(5) = "13.10.00.00"   'BTEQ
Basic_MSI_ver_13_10(6) = "13.10.00.00"   'FASTLD
Basic_MSI_ver_13_10(7) = "13.10.00.00"   'MLOAD
Basic_MSI_ver_13_10(8) = "13.10.00.00"   'FASTEXP
Basic_MSI_ver_13_10(9) = "13.10.00.00"   'TPUMP
Basic_MSI_ver_13_10(10) = "13.10.00.00"   'TDOLEDB
Basic_MSI_ver_13_10(11) = "13.10.00.00"   'SQLPP
Basic_MSI_ver_13_10(12) = "13.10.00.00"   'NPAXSMOD
Basic_MSI_ver_13_10(13) = "13.10.00.00"   'MQAXSMOD
Basic_MSI_ver_13_10(14) = "13.10.00.00"   'OLEDBAXSMOD
Basic_MSI_ver_13_10(15) = "13.10.00.00"   'JMSAXSMOD
Basic_MSI_ver_13_10(16) = "13.10.00.00"   'SQLA
Basic_MSI_ver_13_10(17) = "13.10.00.00"   'TSET
Basic_MSI_ver_13_10(18) = "13.10.00.00"   'VECOMP
Basic_MSI_ver_13_10(19) = "13.10.00.00"   'TIWIZ
Basic_MSI_ver_13_10(20) = "13.10.00.00"   'TSWIZ
Basic_MSI_ver_13_10(21) = "13.10.00.00"   'PMON
Basic_MSI_ver_13_10(22) = "13.10.00.00"   'TQSADMIN
Basic_MSI_ver_13_10(23) = "13.10.00.00"   'TQSSERVER
Basic_MSI_ver_13_10(24) = "13.10.00.00"   'TQSCLIENT
Basic_MSI_ver_13_10(25) = "13.10.00.00"   'TWA
Basic_MSI_ver_13_10(26) = "13.00.00.00"   'TMGR
Basic_MSI_ver_13_10(27) = "13.10.00.00"   'TDADMIN
Basic_MSI_ver_13_10(28) = "13.00.00.00"   'TDWM
Basic_MSI_ver_13_10(29) = "13.00.00.00"   'TSAW
Basic_MSI_ver_13_10(30) = "14.00.00.00"   'TPTBASE
Basic_MSI_ver_13_10(31) = "14.00.00.00"   'TPTSTREAM
Basic_MSI_ver_13_10(32) = "13.10.00.02"   'TPTINFRA
Basic_MSI_ver_13_10(33) = "13.10.00.02"   'TPTAPI
Basic_MSI_ver_13_10(34) = "13.10.00.02"   'TPTLOADOP
Basic_MSI_ver_13_10(35) = "13.10.00.02"   'TPTEXPORTOP
Basic_MSI_ver_13_10(36) = "13.10.00.02"   'TPTUPDATEOP
Basic_MSI_ver_13_10(37) = "13.10.00.02"   'TPTSTREAMOP
Basic_MSI_ver_13_10(38) = "13.10.00.00"   'MONITOROBJ
Basic_MSI_ver_13_10(39) = "13.10.00.00"   'TDNETDP
Basic_MSI_ver_13_10(40) = Empty

'------------------------------

'Check if required arguments are provided
set args = WScript.Arguments.Unnamed
set nargs = WScript.Arguments.named

'Default current version is set to the current release version
def_cur_ver = "15.00.00.00"

WScript.Echo "Uninstall TTU script - version " & Get_Short_Version(def_cur_ver)

if (args.count < 1) then
	if ( (nargs.item("SUITE") = "") or (nargs.item("SUITE") <> "ALL") ) then
		DisplayUsage()
	end if
else
	for i = 1 to args.count 	
		'Get the Product_name from based on the arguments.
		Select case args(i-1)
		case "ALL"
		case TTUProds(0)
		case TTUProds(1)
		case TTUProds(2)
		case TTUProds(3)
		case TTUProds(4)
		case TTUProds(5)
		case TTUProds(6)
		case TTUProds(7)
		case TTUProds(8)
		case TTUProds(9)
		case TTUProds(10)
		case TTUProds(11)
		case TTUProds(12)
		case TTUProds(13)
		case TTUProds(14)
		case TTUProds(15)
		case TTUProds(16)
		case TTUProds(17)
		case TTUProds(18)
		case TTUProds(19)
		case TTUProds(20)
		case TTUProds(21)
		case TTUProds(22)
		case TTUProds(23)
		case TTUProds(24)
		case TTUProds(25)
		case TTUProds(26)
		case TTUProds(27)
		case TTUProds(28)
		case TTUProds(29)
		case TTUProds(30)
		case TTUProds(31)
		case TTUProds(32)
		case TTUProds(33)
		case TTUProds(34)
		case TTUProds(35)
		case TTUProds(36)
		case TTUProds(37)
		case TTUProds(38)
		case TTUProds(39)
		case TTUProds(40)
		case TTUProds(41)
		case TTUProds(42)
		case TTUProds(43)
		case TTUProds(44)
		case TTUProds(45)
		case TTUProds(46)
		case TTUProds(47)
		case TTUProds(48)
		case TTUProds(49)
		case TTUProds(50)
		case else
			WSCript.Echo "Invalid Product specified : " & args(i-1)
            DisplayUsage()
    	end select
	next
end if

'Reading the /PRIORTOVERSION option
if (nargs.item("PRIORTOVERSION") = "") then
    'If the PRIORTOVERSION is not supplied then the default is the current release version.
    priorto_version = def_cur_ver
else
    IsValid = ValidateVersion(nargs.item("PRIORTOVERSION"))
    if (IsValid = TRUE) then
        priorto_version = nargs.item("PRIORTOVERSION")
    else
        WScript.Echo "Prior to Version should be in xx.xx.xx.xx format. eg:13.10.00.00"
        WScript.Quit()
    end if
end if

'Reading the /FORCE option
if (nargs.item("FORCE") = "TRUE") then
    force_option = True
    WScript.Echo " /FORCE option is set to <" & force_option & ">"
else
    force_option = False
end if

'Reading the /SUITE option
suite_ptr=False
if ( nargs.item("SUITE") = "ALL" ) then
	suite_option = nargs.item("SUITE")
	suite_ptr=True
	WScript.Echo " /SUITE option is set to <" & suite_option & ">"
else
	suite_ptr=False
end if

WScript.Echo ""
WScript.Echo " Please wait while the script executes..."
WScript.Echo " The script execution might take several minutes..."
WScript.Echo " Please DO NOT abort the script execution..."
WScript.Echo ""

TIMESTAMP = Year(Now) &  Month(Now) &  Day(Now) &  Hour(Now) &  Minute(Now) &  Second(Now)

set objWshShell = CreateObject("WScript.Shell")
Set objFile = CreateObject("Scripting.FileSystemObject")

'Get Windows systemroot on the machine
winroot = objWshShell.ExpandEnvironmentStrings("%SYSTEMROOT%")

'Obtain User Name of the current user
CurrentUserName = objWshShell.ExpandEnvironmentStrings("%USERNAME%")

'Obtain Domain Name of the current user
UserDomain = objWshShell.ExpandEnvironmentStrings("%USERDOMAIN%")

'Obtain Computer Name of the current user
ComputerName = objWshShell.ExpandEnvironmentStrings("%COMPUTERNAME%")

'Get Windows All Users folder on the machine
allusers_dir = objWshShell.ExpandEnvironmentStrings("%ALLUSERSPROFILE%")

'Get Windows Users folder on the machine
users_dir = objWshShell.ExpandEnvironmentStrings("%USERPROFILE%")

Set objCtx = CreateObject("WbemScripting.SWbemNamedValueSet")
objCtx.Add "__ProviderArchitecture", 64
objCtx.Add "__RequiredArchitecture", TRUE
Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
Set objStdRegProv = objServices.Get("StdRegProv") 


'Retrieve the processor architecture from the registry.
Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
Inparams.Hdefkey = HKLM
Inparams.Ssubkeyname = "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"
Inparams.Svaluename = "PROCESSOR_ARCHITECTURE"
set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx) 
Proc_Arch = Outparams.SValue


''Get Windows Program Files folder on the machine
Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
Inparams.Hdefkey = HKLM
Inparams.Ssubkeyname = "SOFTWARE\Microsoft\Windows\CurrentVersion"
Inparams.Svaluename = "ProgramFilesDir"
set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx) 
program_files_dir = Outparams.SValue


if (Proc_Arch = "AMD64") then
'    'Get Windows Program Files(x86) folder on the machine
    Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
    Inparams.Hdefkey = HKLM
    Inparams.Ssubkeyname = "SOFTWARE\Microsoft\Windows\CurrentVersion"
    Inparams.Svaluename = "ProgramFilesDir (x86)"
    set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx) 
    program_files_x86_dir = Outparams.SValue
else
    program_files_x86_dir = ""
end if


'Get Windows version to determine the user's temp folder location.
Set Inparams = objStdRegProv.Methods_("GetStringValue").Inparameters
Inparams.Hdefkey = HKLM
Inparams.Ssubkeyname = "Software\Microsoft\Windows NT\CurrentVersion"
Inparams.Svaluename = "CurrentVersion"
set Outparams = objStdRegProv.ExecMethod_("GetStringValue", Inparams,,objCtx) 
windows_version = Outparams.SValue

'If a decimal symbol is used in the windows version string then extract only the part of the version
'before the decimal symbol, because we need to compare the Major version number only. If a locale specific
'symbol is used like ' between the Major and minor version then the conversion to numeric while comparison 
'will handle that scenario.
pos=0
pos = instr(windows_version,".")
if (pos > 0) then
    windows_version = left(windows_version,pos-1)
    pos=0
end if 

'If the script is executed as SYSTEM the USERNAME environment variable is not populated.
'So we cannot use the CurrentUserName to get the log folder location, instead default user is 
'chosen as the current user and the log folder will be under the default user.
if (CurrentUserName = "%USERNAME%") then
    if (users_dir = "%USERPROFILE%") then
        fldr_name = objWshShell.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\DOCUME~1\DEFAUL~1"
    else
        users_dir = replace(users_dir,"Documents and Settings","DOCUME~1")
        fldr_name = users_dir
    end if
    'Get default user's TEMP folder on the machine
    if (CInt(windows_version) < 6) then   'Set the TEMP folder for Windows 2000, Windows XP & Windows 2003
        logfldr = fldr_name & "\LOCALS~1\Temp"
    else    'Set the TEMP folder for Windows Vista, Windows 7 & Windows 2008
        logfldr = fldr_name & "\AppData\Local\Temp"
    end if
else
    if (users_dir = "%USERPROFILE%") then
        fldr_name = objWshShell.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\DOCUME~1\" & CurrentUserName
    else
        users_dir = replace(users_dir,"Documents and Settings","DOCUME~1")
        fldr_name = users_dir
    end if
    'Get user's TEMP folder on the machine
    if (CInt(windows_version) < 6) then   'Set the TEMP folder for Windows 2000, Windows XP & Windows 2003
        logfldr = fldr_name & "\LOCALS~1\Temp"
    else    'Set the TEMP folder for Windows Vista, Windows 7 & Windows 2008
        logfldr = fldr_name &  "\AppData\Local\Temp"
    end if
end if


'Define the temporary files and the log file.
outputfile = logfldr & "\output.txt"
outputfile1 = logfldr & "\output1.txt"
outputfile2 = logfldr & "\output2.txt"
ScriptLog = logfldr & "\uninstall_script_" & TIMESTAMP & ".log"

WScript.Echo "Log files created at : " & logfldr

Set lf = objFile.CreateTextFile(ScriptLog, True, True)
lf.WriteLine "====================Uninstall_TTU script being execution========================"
lf.WriteLine "Processor Architecture : " & Proc_Arch
lf.WriteLine "Programfiles folder : " & program_files_dir
lf.WriteLine "Programfiles (x86) folder : " & program_files_x86_dir

Reqd_WSHVersion = "5.6"
Reqd_MSIVersion = "3.0"

'Get the Windows Installer version on the machine.
set objInstaller = CreateObject("WindowsInstaller.Installer")
MSIVersion=objInstaller.Version

'Get the Windows Script Host version on the machine.
WSHVersion = ScriptEngineMajorVersion & "." & ScriptEngineMinorVersion

if strcomp(WSHVersion, Reqd_WSHVersion) >= 0 Then
    lf.WriteLine "Windows Script Host version on the machine<" & WSHVersion & "> is greater than or equal to the required Windows Script Host version<" & Reqd_WSHVersion & ">..."
else
    lf.WriteLine "Windows Script Host version on the machine<" & WSHVersion & "> is less than the required Windows Script Host version<" & Reqd_WSHVersion & "> ... Aborting the installation.."
    MsgBox "Windows Script Host version on the machine is less than the required Windows Script Host version<" & Reqd_WSHVersion & ">. Aborting the installation...",16,"Uninstall_TTU.vbs script"
    WScript.Quit()
end if

if (strcomp(MSIVersion,Reqd_MSIVersion) >= 0 ) then 
    lf.WriteLine "Windows Installer version<" & MSIVersion & "> on the machine is greater than or equal to required Windows Installer version<" & Reqd_MSIVersion & ">..."
else
    lf.WriteLine "Windows Installer version<" & MSIVersion & "> on the machine is less than the required Windows Installer version<" & Reqd_MSIVersion & ">... Aborting the installation.."
    MsgBox "Windows Installer version on the machine is less than the required Windows Installer version<" & Reqd_MSIVersion & ">. Aborting the installation...",16,"Uninstall_TTU.vbs script"
    WScript.Quit()
end if

'If the script is executed as SYSTEM the USERNAME environment variable is not populated.
'So we cannot perform any checks using the CurrentUserName. This check is skipped.
if (CurrentUserName <> "%USERNAME%") then
    'Check if the ComputerName and UserDomain are same then the user is 
    'not logged onto a domain.
    if (LCase(ComputerName) = LCase(UserDomain)) then
	    CompleteUserName = CurrentUserName
    elseif (LCase(CurrentUserName) = "administrator") then
	    CompleteUserName = CurrentUserName
    else
	    CompleteUserName = UserDomain & "\" & CurrentUserName
    end if

    'Retrieve the administrators on the machine
    rc = objWshShell.Run("cmd /C net localgroup administrators > " & outputfile,0,true)
    set txtfile = objFile.OpenTextFile(outputfile, ForReading, False)

    content=""
    Do While txtfile.AtEndOfStream <> True
	    content = content & txtfile.ReadLine
    loop
    txtfile.close

    'Search for the current user in the list of administrators on the machine.
    if instr(content, CompleteUserName) <> 0 then	
  	    lf.WriteLine CompleteUserName & " is an administrator."
    else
	    lf.WriteLine CompleteUserName & " is not an administrator."
    end if
end if

'Removing ALL Suites
if ( suite_ptr = True ) then
	'Checking TTUSuiteSilent.exe existed or not on the machine
	if objFile.FileExists(".\TTU\TTUSuiteSilent.exe") then
		lf.WriteLine "TTUSuiteSilent.exe is in .\TTU Directory."
		UninstallAllSuites
	else
		lf.WriteLine "TTUSuiteSilent.exe was not found in .\TTU directory."
		WScript.echo "TTUSuiteSilent.exe was not found in .\TTU directory."
		lf.WriteLine "This script needs TTUSuiteSilent.exe to remove suite packages."
		WScript.echo "This script needs TTUSuiteSilent.exe to remove suite packages."
		lf.WriteLine "Aborting uninstallation...."
		WScript.echo "Aborting uninstallation...."
		WScript.Quit()
	end if
end if

'Get the product name from the ProductName property in the .ism file
'Iterate the uninstallation process for all the arguments.
for iter=1 to args.Count 
    if (args(iter-1) = "ALL") then
		'If user specified ALL option, then the script removes all suite packages first and then it removes remaining packages.
		suite_option="ALL"
		UninstallAllSuites
        prod_iter = 50
        lf.WriteLine "============================ALL PRODUCTS ITERATION BEGIN======================================"
    else
        prod_iter = 0
    end if
    
    for counter=prod_iter to 0 Step -1 
        if (args(iter-1) <> "ALL") then
            arg_value = args(iter-1)
        else
            arg_value = TTUProds(counter)
        end if
	    'Assign the actual Product Name by searching through the TTUProducts array.
	    Select case arg_value
	    case TTUProds(0) 'TERAGSS
		    product_name = TTUProducts(0)
	    case TTUProds(1) 'TDICU
		    product_name = TTUProducts(1)	
	    case TTUProds(2) 'CLIv2
		    product_name = TTUProducts(2)	
	    case TTUProds(3) 'TDODBC
		    product_name = TTUProducts(3)	
	    case TTUProds(4) 'PIOM
		    product_name = TTUProducts(4)	
	    case TTUProds(5) 'BTEQ
		    product_name = TTUProducts(5)	
	    case TTUProds(6) 'FASTLD
		    product_name = TTUProducts(6)	
	    case TTUProds(7) 'MLOAD
		    product_name = TTUProducts(7)	
	    case TTUProds(8) 'FASTEXP
		    product_name = TTUProducts(8)	
	    case TTUProds(9) 'TPUMP
		    product_name = TTUProducts(9)	
	    case TTUProds(10) 'TDOLEDB
		    product_name = TTUProducts(10)	
	    case TTUProds(11) 'SQLPP
		    product_name = TTUProducts(11)	
	    case TTUProds(12) 'NPAXSMOD
		    product_name = TTUProducts(12)	
	    case TTUProds(13) 'MQAXSMOD
		    product_name = TTUProducts(13)	
	    case TTUProds(14) 'OLEDBAXSMOD
		    product_name = TTUProducts(14)	
	    case TTUProds(15) 'JMSAXSMOD
		    product_name = TTUProducts(15)	
	    case TTUProds(16) 'SQLA
		    product_name = TTUProducts(16)	
	    case TTUProds(17) 'TSET
		    product_name = TTUProducts(17)	
	    case TTUProds(18) 'VECOMP
		    product_name = TTUProducts(18)	
	    case TTUProds(19) 'TIWIZ
		    product_name = TTUProducts(19)	
	    case TTUProds(20) 'TSWIZ
		    product_name = TTUProducts(20)	
	    case TTUProds(21) 'PMON
		    product_name = TTUProducts(21)	
	    case TTUProds(22) 'TQSADMIN
		    product_name = TTUProducts(22)	
	    case TTUProds(23) 'TQSSERVER
		    product_name = TTUProducts(23)
	    case TTUProds(24) 'TQSCLIENT
		    product_name = TTUProducts(24)
	    case TTUProds(25) 'TWA
		    product_name = TTUProducts(25)
	    case TTUProds(26) 'TMGR
		    product_name = TTUProducts(26)
	    case TTUProds(27) 'TDADMIN
		    product_name = TTUProducts(27)
	    case TTUProds(28) 'TDWM
		    product_name = TTUProducts(28)
	    case TTUProds(29) 'TSAW
		    product_name = TTUProducts(29)
	    case TTUProds(30) 'TPTBASE
		    product_name = TTUProducts(30)
	    case TTUProds(31) 'TPTSTREAM
		    product_name = TTUProducts(31)
	    case TTUProds(32) 'TPTINFRA
		    product_name = TTUProducts(32)
	    case TTUProds(33) 'TPTAPI
		    product_name = TTUProducts(33)
	    case TTUProds(34) 'TPTLOADOP
		    product_name = TTUProducts(34)
	    case TTUProds(35) 'TPTEXPORTOP
		    product_name = TTUProducts(35)
	    case TTUProds(36) 'TPTUPDATEOP
		    product_name = TTUProducts(36)
	    case TTUProds(37) 'TPTSTREAMOP
		    product_name = TTUProducts(37)
	    case TTUProds(38) 'TPTICU
		    product_name = TTUProducts(38)
	    case TTUProds(39) 'TPTOSL
		    product_name = TTUProducts(39)
	    case TTUProds(40) 'TPTDATACONOP
		    product_name = TTUProducts(40)
	    case TTUProds(41) 'TPTDDLOP
		    product_name = TTUProducts(41)
	    case TTUProds(42) 'TPTINSERTOP
		    product_name = TTUProducts(42)
	    case TTUProds(43) 'TPTODBCOP
		    product_name = TTUProducts(43)
	    case TTUProds(44) 'TPTOSCMDOP
		    product_name = TTUProducts(44)
	    case TTUProds(45) 'TPTSELECT
		    product_name = TTUProducts(45)
	    case TTUProds(46) 'ARC
		    product_name = TTUProducts(46)
	    case TTUProds(47) 'MONITOROBJ
		    product_name = TTUProducts(47)
	    case TTUProds(48) 'TDWALLET
		    product_name = TTUProducts(48)
	    case TTUProds(49) 'TDNETDP
		    product_name = TTUProducts(49)
	    case TTUProds(50) 'TDGEOSPATIAL
		    product_name = TTUProducts(50)
	    end select
        
        
	    lf.WriteLine "==============================" & product_name & "======================================"
        
	    Set objCtx = CreateObject("WbemScripting.SWbemNamedValueSet")

	    if (Proc_Arch = "x86") then	    '32-bit machines
	        objCtx.Add "__ProviderArchitecture", 32
	        objCtx.Add "__RequiredArchitecture", TRUE
	        Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
	        Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
	        Set objStdRegProv = objServices.Get("StdRegProv") 
	        Wow6432Node=False

	        GetInstalledProducts()
	        lf.WriteLine "Completed searching the registry for " & product_name

            lf.WriteLine "-----------------------------------------------------------------------------------------"
        
        end if 
        
	    'Search the Wow6432Node registry section only on a 64-bit machine for 32-bit packages installed on the machine.
	    if (Proc_Arch = "AMD64") then	    '64-bit machine 
            'Searching for the 64-bit packages
            'Need to enter this section of code for TERAGSS, TDICU, CLIv2, TDODBC, PIOM, SQLPP, NPAXSMOD, JMSAXSMOD, TPTBASE, 
            'TPTSTREAM, TPTAPI, TPTLOADOP, TPTEXPORTOP, TPTUPDATEOP, TPTSTREAMOP, TPTICU, TPTOSL, ARC
	        Select case arg_value
            case TTUProds(0),   _
                 TTUProds(1),   _
                 TTUProds(2),   _
                 TTUProds(3),   _
                 TTUProds(4),   _
                 TTUProds(11),  _    
	             TTUProds(12),  _
	             TTUProds(15),  _
	             TTUProds(30),  _
	             TTUProds(31),  _
	             TTUProds(33),  _
	             TTUProds(34),  _
	             TTUProds(35),  _
	             TTUProds(36),  _
	             TTUProds(37),  _
	             TTUProds(38),  _
	             TTUProds(39),  _
	             TTUProds(46),  _
	             TTUProds(48),  _
	             TTUProds(50)
                objCtx.Add "__ProviderArchitecture", 64
	            objCtx.Add "__RequiredArchitecture", TRUE
	            Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
	            Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
	            Set objStdRegProv = objServices.Get("StdRegProv") 
	            Wow6432Node=False

	            GetInstalledProducts()
	            lf.WriteLine "Completed searching the registry for " & product_name

	            lf.WriteLine "-----------------------------------------------------------------------------------------"
	        End Select

            'Searching for the 32-bit packages
		    objCtx.Add "__ProviderArchitecture", 32
		    objCtx.Add "__RequiredArchitecture", TRUE
		    Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		    Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		    Set objStdRegProv = objServices.Get("StdRegProv") 

		    Wow6432Node=True
		    GetInstalledProducts()
		    lf.WriteLine "Completed searching the Wow6432Node registry for " & product_name

	        lf.WriteLine "-----------------------------------------------------------------------------------------"

	    end if
    	
	    'Force option is set to TRUE
        if (force_option = true) then   'Only if force_option is provided go through the extensive registry search & cleanup.
        
	        if (Proc_Arch = "AMD64") then	    'On 64-bit machines
                WScript.Echo "Searching and cleaning up any left over remnants of 32-bit packages from the 64-bit machine..." 
                lf.WriteLine "Searching and cleaning up any left over remnants of 32-bit packages from the 64-bit machine..." 

                'Searching for the 32-bit packages
		        objCtx.Add "__ProviderArchitecture", 32
		        objCtx.Add "__RequiredArchitecture", TRUE
		        Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		        Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		        Set objStdRegProv = objServices.Get("StdRegProv") 

		        Wow6432Node=True
		        Package_64bit=false

	            'Call the additional Registry Search to detect corrupted installs for the corresponding products.
	            Select case arg_value
	            case TTUProds(0) 'TERAGSS
                    Search_and_Cleanup TERAGSS_Prod_Codes, TTUProducts(0)
	            case TTUProds(1) 'TDICU
                    Search_and_Cleanup TDICU_Prod_Codes, TTUProducts(1)
	            case TTUProds(2) 'CLIv2
                    Search_and_Cleanup CLIv2_Prod_Codes, TTUProducts(2)
	            case TTUProds(3) 'TDODBC
                    Search_and_Cleanup TDODBC_Prod_Codes, TTUProducts(3)
	            case TTUProds(4) 'PIOM
                    Search_and_Cleanup PIOM_Prod_Codes, TTUProducts(4)
	            case TTUProds(5) 'BTEQ
                    Search_and_Cleanup BTEQ_Prod_Codes, TTUProducts(5)
	            case TTUProds(6) 'FASTLD
                    Search_and_Cleanup FASTLD_Prod_Codes, TTUProducts(6)
	            case TTUProds(7) 'MLOAD
                    Search_and_Cleanup MLOAD_Prod_Codes, TTUProducts(7)
	            case TTUProds(8) 'FASTEXP
                    Search_and_Cleanup FASTEXP_Prod_Codes, TTUProducts(8)
	            case TTUProds(9) 'TPUMP
                    Search_and_Cleanup TPUMP_Prod_Codes, TTUProducts(9)
	            case TTUProds(10) 'TDOLEDB
                    Search_and_Cleanup TDOLEDB_Prod_Codes, TTUProducts(10)
	            case TTUProds(11) 'SQLPP
                    Search_and_Cleanup SQLPP_Prod_Codes, TTUProducts(11)
	            case TTUProds(12) 'NPAXSMOD
                    Search_and_Cleanup NPAXSMOD_Prod_Codes, TTUProducts(12)
	            case TTUProds(13) 'MQAXSMOD
                    Search_and_Cleanup MQAXSMOD_Prod_Codes, TTUProducts(13)
	            case TTUProds(14) 'OLEDBAXSMOD
                    Search_and_Cleanup OLEDBAXSMOD_Prod_Codes, TTUProducts(14)
	            case TTUProds(15) 'JMSAXSMOD
                    Search_and_Cleanup JMSAXSMOD_Prod_Codes, TTUProducts(15)
	            case TTUProds(16) 'SQLA
                    Search_and_Cleanup SQLA_Prod_Codes, TTUProducts(16)
	            case TTUProds(17) 'TSET
                    Search_and_Cleanup TSET_Prod_Codes, TTUProducts(17)
	            case TTUProds(18) 'VECOMP
                    Search_and_Cleanup VECOMP_Prod_Codes, TTUProducts(18)
	            case TTUProds(19) 'TIWIZ
                    Search_and_Cleanup TIWIZ_Prod_Codes, TTUProducts(19)
	            case TTUProds(20) 'TSWIZ
                    Search_and_Cleanup TSWIZ_Prod_Codes, TTUProducts(20)
	            case TTUProds(21) 'PMON
                    Search_and_Cleanup PMON_Prod_Codes, TTUProducts(21)
	            case TTUProds(22) 'TQSADMIN
                    Search_and_Cleanup TQSADMIN_Prod_Codes, TTUProducts(22)
	            case TTUProds(23) 'TQSSERVER
                    Search_and_Cleanup TQSSERVER_Prod_Codes, TTUProducts(23)
	            case TTUProds(24) 'TQSCLIENT
                    Search_and_Cleanup TQSCLIENT_Prod_Codes, TTUProducts(24)
	            case TTUProds(25) 'TWA
                    Search_and_Cleanup TWA_Prod_Codes, TTUProducts(25)
	            case TTUProds(26) 'TMGR
                    Search_and_Cleanup TMGR_Prod_Codes, TTUProducts(26)
	            case TTUProds(27) 'TDADMIN
                    Search_and_Cleanup TDADMIN_Prod_Codes, TTUProducts(27)
	            case TTUProds(28) 'TDWM
                    Search_and_Cleanup TDWM_Prod_Codes, TTUProducts(28)
	            case TTUProds(29) 'TSAW
                    Search_and_Cleanup TSAW_Prod_Codes, TTUProducts(29)
	            case TTUProds(30) 'TPTBASE
                    Search_and_Cleanup TPTBASE_Prod_Codes, TTUProducts(30)
	            case TTUProds(31) 'TPTSTREAM
                    Search_and_Cleanup TPTSTREAM_Prod_Codes, TTUProducts(31)
	            case TTUProds(32) 'TPTINFRA
                    Search_and_Cleanup TPTINFRA_Prod_Codes, TTUProducts(32)
	            case TTUProds(33) 'TPTAPI
                    Search_and_Cleanup TPTAPI_Prod_Codes, TTUProducts(33)
	            case TTUProds(34) 'TPTLOADOP
                    Search_and_Cleanup TPTLOADOP_Prod_Codes, TTUProducts(34)
	            case TTUProds(35) 'TPTEXPORTOP
                    Search_and_Cleanup TPTEXPORTOP_Prod_Codes, TTUProducts(35)
	            case TTUProds(36) 'TPTUPDATEOP
                    Search_and_Cleanup TPTUPDATEOP_Prod_Codes, TTUProducts(36)
	            case TTUProds(37) 'TPTSTREAMOP
                    Search_and_Cleanup TPTSTREAMOP_Prod_Codes, TTUProducts(37)
	            case TTUProds(46) 'ARC
                    Search_and_Cleanup ARC_Prod_Codes, TTUProducts(46)
	            case TTUProds(47) 'MONITOROBJ
                    Search_and_Cleanup MONITOROBJ_Prod_Codes, TTUProducts(47)
	            case TTUProds(48) 'TDWALLET
                    Search_and_Cleanup TDWALLET_Prod_Codes, TTUProducts(48)
	            case TTUProds(49) 'TDNETDP
                    Search_and_Cleanup TDNETDP_Prod_Codes, TTUProducts(49)
	            case TTUProds(50) 'TDGEOSPATIAL
                    Search_and_Cleanup TDGEOSPATIAL_Prod_Codes, TTUProducts(50)
	            end select
        
    	        lf.WriteLine "-----------------------------------------------------------------------------------------"
    	        
                WScript.Echo "Searching and cleaning up any left over remnants of 64-bit packages from the 64-bit machine..." 
                lf.WriteLine "Searching and cleaning up any left over remnants of 64-bit packages from the 64-bit machine..." 

                objCtx.Add "__ProviderArchitecture", 64
	            objCtx.Add "__RequiredArchitecture", TRUE
	            Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
	            Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
	            Set objStdRegProv = objServices.Get("StdRegProv") 
    	        
	            Wow6432Node=False
                Package_64bit=true
                
	            'Call the additional Registry Search to detect corrupted installs for the corresponding products.
                Select case arg_value
                case TTUProds(0) 'TERAGSS
                    Search_and_Cleanup TERAGSS_64_Prod_Codes, TTUProducts(0)
                case TTUProds(1) 'TDICU
                    Search_and_Cleanup TDICU_64_Prod_Codes, TTUProducts(1)
                case TTUProds(2) 'CLIv2
                    Search_and_Cleanup CLIv2_64_Prod_Codes, TTUProducts(2)
                case TTUProds(3) 'TDODBC
                    Search_and_Cleanup TDODBC_64_Prod_Codes, TTUProducts(3)
                case TTUProds(4) 'PIOM
                    Search_and_Cleanup PIOM_64_Prod_Codes, TTUProducts(4)
                case TTUProds(11) 'SQLPP
                    Search_and_Cleanup SQLPP_64_Prod_Codes, TTUProducts(11)
                case TTUProds(12) 'NPAXSMOD
                    Search_and_Cleanup NPAXSMOD_64_Prod_Codes, TTUProducts(12)
                case TTUProds(15) 'JMSAXSMOD
                    Search_and_Cleanup JMSAXSMOD_64_Prod_Codes, TTUProducts(15)
	            case TTUProds(30) 'TPTBASE
                    Search_and_Cleanup TPTBASE_64_Prod_Codes, TTUProducts(30)
	            case TTUProds(31) 'TPTSTREAM
                    Search_and_Cleanup TPTSTREAM_64_Prod_Codes, TTUProducts(31)
	            case TTUProds(33) 'TPTAPI
                    Search_and_Cleanup TPTAPI_64_Prod_Codes, TTUProducts(33)
	            case TTUProds(34) 'TPTLOADOP
                    Search_and_Cleanup TPTLOADOP_64_Prod_Codes, TTUProducts(34)
	            case TTUProds(35) 'TPTEXPORTOP
                    Search_and_Cleanup TPTEXPORTOP_64_Prod_Codes, TTUProducts(35)
	            case TTUProds(36) 'TPTUPDATEOP
                    Search_and_Cleanup TPTUPDATEOP_64_Prod_Codes, TTUProducts(36)
	            case TTUProds(37) 'TPTSTREAMOP
                    Search_and_Cleanup TPTSTREAMOP_64_Prod_Codes, TTUProducts(37)
	            case TTUProds(46) 'ARC
                    Search_and_Cleanup ARC_64_Prod_Codes, TTUProducts(46)
	            case TTUProds(48) 'TDWALLET
                    Search_and_Cleanup TDWALLET_64_Prod_Codes, TTUProducts(48)
	            case TTUProds(50) 'TDGEOSPATIAL
                    Search_and_Cleanup TDGEOSPATIAL_64_Prod_Codes, TTUProducts(50)
                end select
    	        lf.WriteLine "-----------------------------------------------------------------------------------------"
	        else     'If(Proc_Arch = x86)
                WScript.Echo "Searching and cleaning up any left over remnants from the 32-bit machine..." 
                lf.WriteLine "Searching and cleaning up any left over remnants from the 32-bit machine..." 

	            objCtx.Add "__ProviderArchitecture", 32
	            objCtx.Add "__RequiredArchitecture", TRUE
	            Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
	            Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
	            Set objStdRegProv = objServices.Get("StdRegProv") 
    	        
	            Wow6432Node=False
                Package_64bit=false
                       
   	            'Testing the enhancements......
	            'Call the additional Registry Search to detect corrupted installs for the corresponding products.
	            Select case arg_value
	            case TTUProds(0) 'TERAGSS
                    Search_and_Cleanup TERAGSS_Prod_Codes, TTUProducts(0)
	            case TTUProds(1) 'TDICU
                    Search_and_Cleanup TDICU_Prod_Codes, TTUProducts(1)
	            case TTUProds(2) 'CLIv2
                    Search_and_Cleanup CLIv2_Prod_Codes, TTUProducts(2)
	            case TTUProds(3) 'TDODBC
                    Search_and_Cleanup TDODBC_Prod_Codes, TTUProducts(3)
	            case TTUProds(4) 'PIOM
                    Search_and_Cleanup PIOM_Prod_Codes, TTUProducts(4)
	            case TTUProds(5) 'BTEQ
                    Search_and_Cleanup BTEQ_Prod_Codes, TTUProducts(5)
	            case TTUProds(6) 'FASTLD
                    Search_and_Cleanup FASTLD_Prod_Codes, TTUProducts(6)
	            case TTUProds(7) 'MLOAD
                    Search_and_Cleanup MLOAD_Prod_Codes, TTUProducts(7)
	            case TTUProds(8) 'FASTEXP
                    Search_and_Cleanup FASTEXP_Prod_Codes, TTUProducts(8)
	            case TTUProds(9) 'TPUMP
                    Search_and_Cleanup TPUMP_Prod_Codes, TTUProducts(9)
	            case TTUProds(10) 'TDOLEDB
                    Search_and_Cleanup TDOLEDB_Prod_Codes, TTUProducts(10)
	            case TTUProds(11) 'SQLPP
                    Search_and_Cleanup SQLPP_Prod_Codes, TTUProducts(11)
	            case TTUProds(12) 'NPAXSMOD
                    Search_and_Cleanup NPAXSMOD_Prod_Codes, TTUProducts(12)
	            case TTUProds(13) 'MQAXSMOD
                    Search_and_Cleanup MQAXSMOD_Prod_Codes, TTUProducts(13)
	            case TTUProds(14) 'OLEDBAXSMOD
                    Search_and_Cleanup OLEDBAXSMOD_Prod_Codes, TTUProducts(14)
	            case TTUProds(15) 'JMSAXSMOD
                    Search_and_Cleanup JMSAXSMOD_Prod_Codes, TTUProducts(15)
	            case TTUProds(16) 'SQLA
                    Search_and_Cleanup SQLA_Prod_Codes, TTUProducts(16)
	            case TTUProds(17) 'TSET
                    Search_and_Cleanup TSET_Prod_Codes, TTUProducts(17)
	            case TTUProds(18) 'VECOMP
                    Search_and_Cleanup VECOMP_Prod_Codes, TTUProducts(18)
	            case TTUProds(19) 'TIWIZ
                    Search_and_Cleanup TIWIZ_Prod_Codes, TTUProducts(19)
	            case TTUProds(20) 'TSWIZ
                    Search_and_Cleanup TSWIZ_Prod_Codes, TTUProducts(20)
	            case TTUProds(21) 'PMON
                    Search_and_Cleanup PMON_Prod_Codes, TTUProducts(21)
	            case TTUProds(22) 'TQSADMIN
                    Search_and_Cleanup TQSADMIN_Prod_Codes, TTUProducts(22)
	            case TTUProds(23) 'TQSSERVER
                    Search_and_Cleanup TQSSERVER_Prod_Codes, TTUProducts(23)
	            case TTUProds(24) 'TQSCLIENT
                    Search_and_Cleanup TQSCLIENT_Prod_Codes, TTUProducts(24)
	            case TTUProds(25) 'TWA
                    Search_and_Cleanup TWA_Prod_Codes, TTUProducts(25)
	            case TTUProds(26) 'TMGR
                    Search_and_Cleanup TMGR_Prod_Codes, TTUProducts(26)
	            case TTUProds(27) 'TDADMIN
                    Search_and_Cleanup TDADMIN_Prod_Codes, TTUProducts(27)
	            case TTUProds(28) 'TDWM
                    Search_and_Cleanup TDWM_Prod_Codes, TTUProducts(28)
	            case TTUProds(29) 'TSAW
                    Search_and_Cleanup TSAW_Prod_Codes, TTUProducts(29)
	            case TTUProds(30) 'TPTBASE
                    Search_and_Cleanup TPTBASE_Prod_Codes, TTUProducts(30)
	            case TTUProds(31) 'TPTSTREAM
                    Search_and_Cleanup TPTSTREAM_Prod_Codes, TTUProducts(31)
	            case TTUProds(32) 'TPTINFRA
                    Search_and_Cleanup TPTINFRA_Prod_Codes, TTUProducts(32)
	            case TTUProds(33) 'TPTAPI
                    Search_and_Cleanup TPTAPI_Prod_Codes, TTUProducts(33)
	            case TTUProds(34) 'TPTLOADOP
                    Search_and_Cleanup TPTLOADOP_Prod_Codes, TTUProducts(34)
	            case TTUProds(35) 'TPTEXPORTOP
                    Search_and_Cleanup TPTEXPORTOP_Prod_Codes, TTUProducts(35)
	            case TTUProds(36) 'TPTUPDATEOP
                    Search_and_Cleanup TPTUPDATEOP_Prod_Codes, TTUProducts(36)
	            case TTUProds(37) 'TPTSTREAMOP
                    Search_and_Cleanup TPTSTREAMOP_Prod_Codes, TTUProducts(37)
	            case TTUProds(46) 'ARC
                    Search_and_Cleanup ARC_Prod_Codes, TTUProducts(46)
	            case TTUProds(47) 'MONITOROBJ
                    Search_and_Cleanup MONITOROBJ_Prod_Codes, TTUProducts(47)
	            case TTUProds(48) 'TDWALLET
                    Search_and_Cleanup TDWALLET_Prod_Codes, TTUProducts(48)
	            case TTUProds(49) 'TDNETDP
                    Search_and_Cleanup TDNETDP_Prod_Codes, TTUProducts(49)
				case TTUProds(50) 'TDGEOSPATIAL
                    Search_and_Cleanup TDGEOSPATIAL_Prod_Codes, TTUProducts(50)
	            end select
       	        lf.WriteLine "-----------------------------------------------------------------------------------------"
            end if  'End if for if(Proc_Arch = "AMD64")       	
        end if  'Endif for if(force_option = true)
	    lf.WriteLine "================================================================================="
    Next    'For for all products when ALL is passed as argument.  	

	    if (prod_iter > 1) then
	        lf.WriteLine "==============================ALL PRODUCTS ITERATION END===================================="
	    end if
Next    'For for the number of arguments

lf.WriteLine "===================Uninstall_TTU script end execution==========================="
lf.close

'=====================================================================================================================================================
'Search for the product based on product code and/or GUID and remove the left over entries. This function is invoked when /FORCE:TRUE is specified.
Function Search_and_Cleanup(ByRef Prod_Codes_Arr, ByVal prod_name)
Dim cntr
Dim prod_ver
Dim vcompare
    cntr=0
    prod_ver=""
    vcompare=0

    'TERAGSS & TDNETDP use upgradecodes for searching the registry.
    if ((prod_name = TTUProducts(0)) OR (prod_name = TTUProducts(49))) then   
        Do while (cntr < Prod_Codes_Arr.Ver_Count)
            Upgrade_GUID = ProductCode_to_GUID(Prod_Codes_Arr.ProductCode(cntr))
            Get_ProductGUID_FromRegistry_and_Search Upgrade_GUID, prod_name
            cntr= cntr+1
        Loop
    else    'All other products use productcodes for searching the registry. 
        Do while (cntr < Prod_Codes_Arr.Ver_Count)
            prod_ver = ExtractProductVersion("Software\Microsoft\Windows\CurrentVersion\Uninstall\" & Prod_Codes_Arr.ProductCode(cntr), prod_name)
            if (prod_ver <> "") then    'If product version found compare it with the Priorto version.
                'prod_ver is read from the uninstall key. 
            else
                prod_ver = Prod_Codes_Arr.ProductVersion(cntr)
            end if
            vcompare = VersionCompare(prod_ver, priorto_version, prod_name)
            if (vcompare = -1) then
	            lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " < " & "prior to version passed(" & priorto_version & ")"
	            lf.WriteLine "Proceeding with cleanup..."
	            WScript.Echo "Searching & Cleaning up " & prod_name & " : " & prod_ver 
                Verify_Uninstallation prod_name, Prod_Codes_Arr.ProductCode(cntr), prod_ver
                Product_GUID = ProductCode_to_GUID(Prod_Codes_Arr.ProductCode(cntr))
                SearchRegistryForGUIDEntries(Product_GUID)
            elseif (vcompare = 1) then
	            lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " > " & "prior to version passed(" & priorto_version & ")"
	            lf.WriteLine "Cleanup not required..."
            else
	            lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " = " & "prior to version passed(" & priorto_version & ")"
	            lf.WriteLine "Cleanup not required..."
            end if
            cntr= cntr+1
            WScript.Echo "..."
        Loop
    end if
End Function

'=====================================================================================================================================================

'Check the DisplayName key in the uninstall registry entry to match the product name of the TTU product 
Function GetInstalledProducts()
	' Use ExecMethod to call the GetStringValue method
	Set Inparams = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams.Hdefkey = HKLM
	Inparams.Ssubkeyname = "Software\Microsoft\Windows\CurrentVersion\Uninstall\" 
	Set Outparams = objStdRegProv.ExecMethod_("EnumKey", Inparams,,objCtx) 
	For Each strSubKey In Outparams.snames 
		if (instr(1,strSubKey,"{") <> 0 ) then
			pos = instr(1,strSubKey,"{")
			if (pos = 1) then
				product_code = strSubKey
				call FindTTUProduct("SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\" & strSubKey,product_name) 
			end if
		else
		    'Old TPT packages only created an uninstall entry using the product name. So searching these entries to remove them.
		     'TPTINFRA,TPTAPI, TPTLOADOP, TPTEXPORTOP, TPTUPDATEOP, TPTSTREAMOP, TPTICU, TPTOSL, TPTDATACONOP, TPTDDLOP, TPTINSERTOP,
		     'TPTODBCOP, TPTOSCMDOP, TPTSELECTOP 
		    Select case product_name
            case TTUProducts(32),   _
                 TTUProducts(33),   _
                 TTUProducts(34),   _
                 TTUProducts(35),   _
                 TTUProducts(36),   _
                 TTUProducts(37),   _
                 TTUProducts(38),   _         
                 TTUProducts(39),   _
                 TTUProducts(40),   _
                 TTUProducts(41),   _
                 TTUProducts(42),   _
                 TTUProducts(43),   _
                 TTUProducts(44),   _                                    
                 TTUProducts(45)
		            if ( instr(1,strSubKey,product_name) <> 0 ) then
				        product_code = strSubKey
		                Call FindOldTPTProducts("SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\" & strSubKey, product_name)
		            end if
		    End Select
		end if
	Next 

    
    
	'Uninstall the active TeraGSS version at the end.
	if (saved_product_ver <> "") then
	    ExtractProductVersion_using_ProductCode(saved_product_code)
		Call Initiate_Product_Uninstall(product_name, saved_product_code,saved_product_ver)
		saved_product_ver = ""
	end if
End Function
'=====================================================================================================================================================
'Check the DisplayName key in the uninstall registry entry to match the product name of the TTU product 
Function FindTTUProduct(ByVal uninst_key, Byval ProductName)
	Dim shellobj
	Dim outputobj
	Dim content
	Dim ExePath
	Dim vcompare
	Dim Inparams1
	Dim Outparams1

	set shellobj = CreateObject("WScript.Shell")

	'Get the DisplayName of the product from the uninstall key to filter out the matched products.
	Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = uninst_key
	Inparams1.Svaluename = "DisplayName"
	set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 

	'If the DisplayName matches the ProductName we further extract the productcode, product version to verify that the product
	'entry matches the criteria for uninstallation.
	if instr(1,Outparams1.SValue, ProductName) <> 0 then
		if instr(1,Outparams1.SValue, "x8664") <> 0 then
			Package_64bit=true
		else
			Package_64bit=false
		end if
		
		product_version = ExtractProductVersion(uninst_key,ProductName)
		ExtractUnInstallInfo uninst_key, ProductName
		
		if (Package_64bit = false) then
		    lf.WriteLine "Product installation Found. Product Name = " & ProductName & "    |    Product Version = " & product_version
		else
		    lf.WriteLine "Product installation Found. Product Name = " & ProductName & " x8664    |    Product Version = " & product_version
		end if 

		'TeraGSS does not allow the uninstallation of the TeraGSS version that is active if there are other versions
		'of TeraGSS already installed on the machine. The active TeraGSS version has to be the last version that 
		'should be uninstalled. Hence identifying the currently active TeraGSS version by running tdgssversion and
		'saving the product version and product code, so that they can be used to uninstall the active version later.
		if (ProductName = TTUProducts(0)) then	'TERAGSS
			if (saved_product_ver = "") then
				'Get the InstallPath of the product. 
				GetInstallPath ProductName,product_version
				if (Package_64bit = true) then	' Looking for 64-bit TeraGSS
					ExePath="nt-x8664\LCLIENT\bin\tdgssversion.exe"
				else
					ExePath="nt-i386\LCLIENT\bin\tdgssversion.exe"
				end if
				
				rc = shellobj.Run("cmd /C " & chr(34) & InstallPath & ExePath & chr(34) & " >" & outputfile1,0,true)
				set txtfile1 = objFile.OpenTextFile(outputfile1, ForReading, False)

				content = ""
				Do While txtfile1.AtEndOfStream <> True
					content = rtrim(txtfile1.ReadLine)
					strlen = len(content)
					if (InStr(1,content,"*")) then
						pos = InStr(1,content,"*")
						if ( pos = strlen) then
							lf.WriteLine "* Found  : " & content
							pos = InStr(1,content,".")
							pos = Instr(pos+1,content,".")
							pos = Instr(pos+1,content,".")
							saved_product_ver=Left(content,pos+2)
							if (alpha_product_ver <> "") then
								if (Instr(1,saved_product_ver,alpha_product_ver) <> 0) then
									saved_product_ver = product_version
									saved_product_code = product_code
								else
									saved_product_ver=""
								end if
							else
								if (Instr(1,saved_product_ver,product_version) <> 0) then
									saved_product_ver = product_version
									saved_product_code = product_code
								else
									saved_product_ver=""
								end if
							end if						
							lf.WriteLine "Saved Product Version : " & saved_product_ver & "    |    " & "Saved Product Code : " & saved_product_code
						end if
					end if
				loop
				txtfile1.close
			end if 
		
			'If this version is not the currently active version then initiate uninstallation	
			if (saved_product_ver <> product_version) then
				Call Initiate_Product_Uninstall(ProductName, product_code,product_version)
			end if
		else	'For all other products
			'Initiate uninstallation
			if (product_version <> "") then
			    Call Initiate_Product_Uninstall(ProductName, product_code,product_version)
			else
			    lf.WriteLine " Product_version is empty, hence cannot proceed with uninstallation.."
			end if
		end if	
	end if
End Function

'=====================================================================================================================================================
'Check the DisplayName key in the uninstall registry entry to match the product name of the TTU product 
Function FindOldTPTProducts(ByVal uninst_key, Byval ProductName)
	Dim Inparams1
	Dim Outparams1


	'Get the DisplayName of the product from the uninstall key to filter out the matched products.
	Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = uninst_key
	Inparams1.Svaluename = "DisplayName"
	set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 

	'If the DisplayName matches the ProductName we further extract the productcode, product version to verify that the product
	'entry matches the criteria for uninstallation.
	if instr(1,Outparams1.SValue, ProductName) <> 0 then
		if instr(1,Outparams1.SValue, "x8664") <> 0 then
			Package_64bit=true
		else
			Package_64bit=false
		end if
		
		product_version = ExtractProductVersion(uninst_key,ProductName)
		
		if (Package_64bit = false) then
		    lf.WriteLine "Product installation Found. Product Name = " & ProductName & "    |    Product Version = " & product_version
		else
		    lf.WriteLine "Product installation Found. Product Name = " & ProductName & " x8664    |    Product Version = " & product_version
		end if 

	    Inparams1.Svaluename = "UninstallString"
	    set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx)
	    uninstall_cmd="" 
        if (len(Outparams1.Svalue) <> 0) then
            uninstall_cmd = Outparams1.Svalue
        end if   
		'Initiate uninstallation
		Call Initiate_Product_Uninstall(ProductName, product_code,product_version)
	end if
End Function

'=====================================================================================================================================================
Function Initiate_Product_Uninstall(ByVal ProductName, ByVal ProductCode, ByVal ProductVersion)
	Dim shellobj
	Dim vcompare
	Dim ExePath
	Dim ExeArgs

	set shellobj = CreateObject("WScript.Shell")
		
	lf.WriteLine "Initating Product uninstallation..."

	'Compare the product version with the currently installed product version
	vcompare = VersionCompare(ProductVersion, priorto_version, ProductName)
    
	'Uninstall currently installed version only if it is less than the product version being installed.			
	if (vcompare = -1) then
		lf.WriteLine "Currently installed product version(" & ProductVersion & ")" & " < " & "prior to version passed(" & priorto_version & ")"
		lf.WriteLine "Proceed with uninstallation..."
		Call UninstallTTUProduct(ProductName, ProductCode, ProductVersion)
		if (instr(1,ProductCode,"{") <> 0) then
            Product_GUID = ProductCode_to_GUID(ProductCode)
            SearchRegistryForGUIDEntries(Product_GUID)
        end if
	elseif (vcompare = 1) then
		lf.WriteLine "Currently installed product version(" & ProductVersion & ")" & " > " & "prior to version passed(" & priorto_version & ")"
		lf.WriteLine "Uninstallation not required..."
	else
		lf.WriteLine "Currently installed product version(" & ProductVersion & ")" & " = " & "prior to version passed(" & priorto_version & ")"
		lf.WriteLine "Uninstallation not required..."
	end if

	'If uninstallation is not required for this version of the product and if it is not the current active TeraGSS version
	'then switch to this version so that uninstallation of other TeraGSS versions goes on smoothly.
	if (vcompare >= 0) and (tdgssver_switched = false) then
	    if (ProductName = TTUProducts(0)) and (saved_product_ver <> "") then 'TERAGSS		
	        'Compare the saved_product_ver with the priortoversion
	        vcompare = VersionCompare(saved_product_ver, priorto_version, ProductName)
            
	        'Switch the TeraGSS version only if its less than the supplied prior to version.			
	        if (vcompare = -1) then
		        lf.WriteLine "TeraGSS Saved product version(" & saved_product_ver & ")" & " < " & "prior to version passed(" & priorto_version & ")"
		        lf.WriteLine "Proceed with version switching..."
		        if (ProductVersion <> saved_product_ver) then
			        if (alpha_product_ver <> "") then	'If the version contains alpha character
				        if (Package_64bit = true) then	' Looking for 64-bit TeraGSS
					        ExePath="nt-x8664\" & alpha_product_ver & "\bin\tdgssversion.exe" 
				        else
					        ExePath="nt-i386\" & alpha_product_ver & "\bin\tdgssversion.exe"
				        end if
				        ExeArgs=" -switch " & alpha_product_ver
			        else
				        if (Package_64bit = true) then	' Looking for 64-bit TeraGSS
					        ExePath="nt-x8664\" & ProductVersion & "\bin\tdgssversion.exe"
				        else
					        ExePath="nt-i386\" & ProductVersion & "\bin\tdgssversion.exe"
				        end if
				        ExeArgs=" -switch " & ProductVersion
			        end if
			        lf.WriteLine "cmd /C " & chr(34) & InstallPath & ExePath & chr(34) & ExeArgs
			        rc = shellobj.Run("cmd /C " & chr(34) & InstallPath & ExePath & chr(34) & ExeArgs & " >" & outputfile1,0,true)
			        set txtfile1 = objFile.OpenTextFile(outputfile1, ForReading, False)
			        content=""
			        do while txtfile1.AtEndOfStream <> True
				        content = txtfile1.ReadLine
				        if (Instr(1,content,"switch") <> 0) then
					        lf.WriteLine content
				        end if
			        loop
			        txtfile1.close
			        tdgssver_switched = true
    			end if
	        else
		        lf.WriteLine "TeraGSS Saved product version(" & saved_product_ver & ")" & " >= " & "prior to version passed(" & priorto_version & ")"
		        lf.WriteLine "Version switching not required..."
	        end if
		    
		end if
	end if
End Function

'=====================================================================================================================================================
'Extract the Product Code from the uninstall registry key 
Function ExtractProductCode ( ByVal uninst_keyname )
	Dim pos
	Dim strlen

	strlen = len(uninst_keyname)
	pos = InStr(1,uninst_keyname,"{")
	ExtractProductCode = Right(uninst_keyname,(strlen-pos)+1)
	Exit Function
End Function

'=====================================================================================================================================================
'Extract the Product Version from the uninstall registry key 
Function ExtractProductVersion ( ByVal uninst_keyname, ByVal ProductName )
	Dim outputobj
	Dim content
	Dim pos
	Dim pos1
	Dim strlen
	Dim part
	Dim lpart
	Dim rpart
	Dim strComments
	Dim Inparams1
	Dim Outparams1
	Dim tmp_productname
	
	product_version=""
	Select case ProductName
	'For TeraGSS the DisplayVersion is not populated. Instead the Comments Registry value contains the actual product version.
	'So the comments registry value in the uninstall registry key is read for TeraGSS to get the product version.	
	case TTUProducts(0) 'TERAGSS
		Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
		Inparams1.Hdefkey = HKLM
		Inparams1.Ssubkeyname = uninst_keyname
		Inparams1.Svaluename = "Comments"
		set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
		
		strComments = Outparams1.SValue
		strlen = len(strComments)
		pos = InStr(1,strComments,"Version")
		if (pos > 1 ) then	'Extract the version only if "Version" is found, otherwise set the product_version blank.
			product_version = Right(strComments,(strlen-(pos+7)))
		else
			product_version="01.00"
		end if
	'TPTINFRA, TPTAPI, TPTLOADOP, TPTEXPORTOP, TPTUPDATEOP, TPTSTREAMOP, TPTICU, TPTOSL, TPTDATACONOP, TPTDDLOP, TPTINSERTOP,
	'TPTODBCOP, TPTOSCMDOP, TPTSELECTOP don't have the DisplayVersion registry value 
	'populated with the actual version number, instead the DisplayName has the actual version appended. Need to extract the
	'actual version from the DisplayName registry value.	
    case TTUProducts(32),   _
         TTUProducts(33),   _
         TTUProducts(34),   _
         TTUProducts(35),   _
         TTUProducts(36),   _
         TTUProducts(37),   _
         TTUProducts(38),   _         
         TTUProducts(39),   _
         TTUProducts(40),   _
         TTUProducts(41),   _
         TTUProducts(42),   _
         TTUProducts(43),   _
         TTUProducts(44),   _                                    
         TTUProducts(45)
		    Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = uninst_keyname
		    Inparams1.Svaluename = "DisplayName"
		    set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 

    		dispname = Outparams1.SValue
   		    if (Package_64bit = true) then
   		        tmp_productname = ProductName & " x8664"
    		else
    		    tmp_productname = ProductName
    		end if 
   		    if (len(dispname) <> len(tmp_productname)) then
   		        product_version = Right(dispname,(len(dispname) - len(tmp_productname) -1))
    		else
		        Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
		        Inparams1.Hdefkey = HKLM
		        Inparams1.Ssubkeyname = uninst_keyname
		        Inparams1.Svaluename = "DisplayVersion"
		        set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
        		
		        product_version = Outparams1.SValue
            end if
	case else	'For other products
		Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
		Inparams1.Hdefkey = HKLM
		Inparams1.Ssubkeyname = uninst_keyname
		Inparams1.Svaluename = "DisplayVersion"
		set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
		
		product_version = Outparams1.SValue
	End Select
  
    if (product_version <> "") then
	    'Format the product_version as xx.xx or xx.xx.xx or xx.xx.xx.xx
        strlen = len(product_version)
        pos = InStr(1,product_version,".")
        lpart=Left(product_version,pos-1)
        rpart=Right(product_version,len(product_version)-pos)
        if (len(lpart) = 1) then
	        lpart="0" & lpart
        end if
        do while (pos > 1)
	        pos = InStr(1,rpart,".")
	        if (pos > 1) then
		        part=left(rpart,pos-1)
		        rpart=Right(rpart,len(rpart)-pos)
		        if (len(part) = 1) then
			        part="0" & part
		        end if
		        lpart = lpart & "." & part
	        else
		        if (len(rpart) = 1) then
			        rpart="0" & rpart
		        end if
		        exit do
	        end if
        loop 
        product_version = lpart & "." & rpart
    	
        do while (len(product_version) < 11)
	        product_version = product_version & ".00"
        loop

	    'If the product_version contains an alpha character, removing it.
	    pos = InStr(1,product_version,".")
        lpart = Left(product_version,pos-1)
        rpart = Right(product_version,len(product_version)-pos)
        alpha_char=Mid(lpart,len(lpart),1)
    	
    	
        if (IsNumeric(alpha_char)) then
	        alpha_product_ver=""
	        alpha_char=""
	        do while (pos > 1)
	            pos = InStr(1,rpart,".")
	            if (pos > 1) then
                    tmpstr = Left(rpart,pos-1)
                    lpart = lpart & "." & tmpstr
                    rpart = Right(rpart,len(rpart)-pos)
                    alpha_char=Mid(lpart,len(lpart),1)

	                if (IsNumeric(alpha_char)) then
		                alpha_product_ver=""
		                alpha_char=""
	                else
		                alpha_product_ver=product_version
		                lpart = Left(lpart,len(lpart)-1)
		                product_version = lpart & "." & rpart
		                exit do
	                end if
	            end if
	        loop
        else
	        alpha_product_ver=product_version
	        lpart = Left(product_version,pos-2)
	        rpart = Right(product_version,len(product_version)-pos)
	        product_version = lpart & "." & rpart
        end if        
        
	    lf.WriteLine "Product Version : " & product_version & "    |     Alpha Product Version : " & alpha_product_ver

        short_version = Get_Short_Version(product_version)
    end if
	ExtractProductVersion = product_version
	Exit Function
End Function

'=====================================================================================================================================================
'Extract the Product Version from the uninstall registry key 
Function ExtractProductVersion_using_ProductCode (ByVal ProductCode )
	Dim outputobj
	Dim content
	Dim pos
	Dim pos1
	Dim strlen
	Dim part
	Dim lpart
	Dim rpart
	Dim strComments
	Dim Inparams1
	Dim Outparams1
	
	'For TeraGSS the DisplayVersion is not populated. Instead the Comments Registry value contains the actual product version.
	'So the comments registry value in the uninstall registry key is read for TeraGSS to get the product version.	
	Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Microsoft\Windows\CurrentVersion\Uninstall\" & ProductCode
	Inparams1.Svaluename = "Comments"
	set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
	
	strComments = Outparams1.SValue
	strlen = len(strComments)
	pos = InStr(1,strComments,"Version")
	if (pos > 1 ) then	'Extract the version only if "Version" is found, otherwise set the product_version blank.
		product_version = Right(strComments,(strlen-(pos+7)))
	else
		product_version="01.00"
	end if

	'Format the product_version as xx.xx or xx.xx.xx or xx.xx.xx.xx
	strlen = len(product_version)
	pos = InStr(1,product_version,".")
	lpart=Left(product_version,pos-1)
	rpart=Right(product_version,len(product_version)-pos)
	if (len(lpart) = 1) then
		lpart="0" & lpart
	end if
	do while (pos > 1)
		pos = InStr(1,rpart,".")
		if (pos > 1) then
			part=left(rpart,pos-1)
			rpart=Right(rpart,len(rpart)-pos)
			if (len(part) = 1) then
				part="0" & part
			end if
			lpart = lpart & "." & part
		else
			if (len(rpart) = 1) then
				rpart="0" & rpart
			end if
			exit do
		end if
	loop 
	product_version = lpart & "." & rpart
	
	do while (len(product_version) < 11)
		product_version = product_version & ".00"
	loop

	'If the product_version contains an alpha character, removing it.
	pos = InStr(1,product_version,".")
    lpart = Left(product_version,pos-1)
    rpart = Right(product_version,len(product_version)-pos)
    alpha_char=Mid(lpart,len(lpart),1)
	
	
    if (IsNumeric(alpha_char)) then
	    alpha_product_ver=""
	    alpha_char=""
	    do while (pos > 1)
	        pos = InStr(1,rpart,".")
	        if (pos > 1) then
                tmpstr = Left(rpart,pos-1)
                lpart = lpart & "." & tmpstr
                rpart = Right(rpart,len(rpart)-pos)
                alpha_char=Mid(lpart,len(lpart),1)

	            if (IsNumeric(alpha_char)) then
		            alpha_product_ver=""
		            alpha_char=""
	            else
		            alpha_product_ver=product_version
		            lpart = Left(lpart,len(lpart)-1)
		            product_version = lpart & "." & rpart
		            exit do
	            end if
	        end if
	    loop
    else
	    alpha_product_ver=product_version
	    lpart = Left(product_version,pos-2)
	    rpart = Right(product_version,len(product_version)-pos)
	    product_version = lpart & "." & rpart
    end if        
    
	lf.WriteLine "Product Version : " & product_version & "    |     Alpha Product Version : " & alpha_product_ver

    if (product_version <> "") then
        short_version = Get_Short_Version(product_version)
    end if

End Function

'=====================================================================================================================================================
'Some useful information like the DisplayName and Hex_Version from the uninstall registry key is stored so that it can be used to identify the 
Function Get_Short_Version(ByVal product_version)
    Dim short_ver, temp_ver
    Dim pos, pos1
    
    pos = InStr(product_version,".")
    short_ver = Left(product_version,pos-1)
    pos1 = InStr(pos+1,product_version,".")
    if (pos1 = 0 ) then
        pos1 = len(product_version) + 1
    end if 
    temp_ver = Mid(product_version,pos+1,pos1-pos-1)
    
    if ((CInt(short_ver) < 14) and (temp_ver = "00")) then
        temp_ver = "0"
    end if
    
    short_ver = short_ver & "." & temp_ver
    
    Get_Short_Version = short_ver
End Function
'=====================================================================================================================================================
'Some useful information like the DisplayName and Hex_Version from the uninstall registry key is stored so that it can be used to identify the 
'product's registry entries in HKLM\Software\Classes\Installer\Products registry entries.
Function ExtractUninstallInfo(ByVal uninst_keyname, ByVal ProductName)
	Dim shellobj
	Dim outputobj
	Dim content
	Dim pos
	Dim temp_ver
	Dim temp_name
	Dim strlen
	Dim strComments
	Dim Inparams1
	Dim Outparams1
	Dim search_keyname


	'Get DisplayName for the product. This will be used while deleting the HKLM\Software\Classes\Installer\Products registry entry.
	Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = uninst_keyname
	Inparams1.Svaluename = "DisplayName"
	set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
	temp_name = Outparams1.SValue

	'Get comments for the product. This will be used while deleting the HKLM\Software\Classes\Installer\Products registry entry.
	Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = uninst_keyname
	Inparams1.Svaluename = "Comments"
	set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 
	
	strComments = Outparams1.SValue
	strlen = len(strComments)
	pos = InStr(1,strComments,"Version")
	if (pos > 1 ) then	'Extract the version only if "Version" is found, otherwise set the product_version blank.
		temp_ver = Right(strComments,(strlen-(pos+7)))
	else
		temp_ver=""
	end if

	'Store DisplayName. It will be used to search the product in HKLM\Software\Classes\Installer\Products.
	Disp_Name = temp_name
		
	'Get HexVersion for the product. This will be used while deleting the HKLM\Software\Classes\Installer\Products registry entry.
	Set Inparams1 = objStdRegProv.Methods_("GetDWORDValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.sSubkeyname = uninst_keyname
	Inparams1.sValuename = "Version"
	set Outparams1 = objStdRegProv.ExecMethod_("GetDWORDValue", Inparams1,,objCtx) 
	Hex_Version = Outparams1.uValue

    'Extract uninstall command to be used during uninstall.
    pos = instr(uninst_keyname,"{")
    search_keyname = Left(uninst_keyname,pos-1)
    search_keyname = search_keyname & "Installshield_" & Right(uninst_keyname,len(uninst_keyname)-pos+1)

	Set Inparams1 = objStdRegProv.Methods_("GetDWORDValue").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.sSubkeyname = search_keyname
    Inparams1.Svaluename = "UninstallString"
    set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx)
    uninstall_cmd="" 
    if (len(Outparams1.Svalue) <> 0) then
        uninstall_cmd = Outparams1.Svalue
    end if   
	lf.WriteLine "UninstallInfo :  DisplayName =  " & Disp_Name & "\t Hex_Version = " & Hex_Version

End Function

'=====================================================================================================================================================

'Validate if the value passed is a valid version or not.
Function ValidateVersion(Byval product_version)
Dim strlen
Dim pos1, pos2, pos3
Dim first_ver_part
Dim second_ver_part
Dim third_ver_part
Dim fourth_ver_part
Dim result

strlen = len(product_version)
'Check if the length of the version string(xx.xx.xx.xx) is 11
if (strlen = 11) then
    pos1 = instr(1,product_version,".")
    pos2 = instr(pos1+1,product_version,".")
    pos3 = instr(pos2+1,product_version,".")
    'Check if the '.' are in the appropriate positions in the version string.
    if (pos1 = 3) and (pos2 = 6) and (pos3 = 9) then
        first_ver_part = Mid(product_version,1,2)
        second_ver_part = Mid(product_version,pos1+1, 2)
        third_ver_part = Mid(product_version,pos2+1,2)
        fourth_ver_part = Mid(product_version,pos3+1,2)
            if ((IsNumeric(first_ver_part) = true) and _
               (IsNumeric(second_ver_part) = true) and _
               (IsNumeric(third_ver_part) = true)  and _
               (IsNumeric(fourth_ver_part) = true)) then
                'WScript.Echo "The version entered is of correct format.." & product_version
                ValidateVersion = True
            else
                WScript.Echo "The version contains non-numeric characters..." & product_version
                ValidateVersion = False
            end if 
    else
        WScript.Echo "Version format not correct..."
        ValidateVersion = False
    end if
else
    WScript.Echo " Version length not correct.." & strlen
    ValidateVersion = False
end if 

End Function

'=====================================================================================================================================================

'Compare the version of the installed product with
'the version of the product being installed
Function VersionCompare(Byval product_ver, Byval product_version, ByVal product_name)
Dim strlen
Dim pos, pos1, pos2
Dim first_ver_1, first_ver_2, first_ver_3, first_ver_4
Dim second_ver_1, second_ver_2, second_ver_3, second_ver_4
Dim result
Dim index
Dim priorto_ver_last_part

'Get xx from the version string xx.yy.zz.kk
strlen = len(product_ver)
pos = instr(1,product_ver, ".")
first_ver_1=Mid(product_ver,1,pos-1)
'Get yy from the version string xx.yy.zz.kk
pos1 = instr(pos+1, product_ver, ".")
if (pos1 = 0) then
	pos1=strlen+1
end if
first_ver_2=Mid(product_ver,pos+1,pos1-pos-1)
'Get zz from the version string xx.yy.zz.kk
pos2 = instr(pos1+1, product_ver, ".")
if (pos2 = 0) then
	pos2=strlen+1
end if
first_ver_3=Mid(product_ver,pos1+1,pos2-pos1-1)
'Get kk from the version string xx.yy.zz.kk
first_ver_4=Mid(product_ver,pos2+1,strlen-pos2)

'Get xx from the version string xx.yy.zz.kk
strlen = len(product_version)
pos = instr(1,product_version, ".")
second_ver_1=Mid(product_version,1,pos-1)
'Get yy from the version string
pos1 = instr(pos+1, product_version, ".")
if (pos1 = 0) then
	pos1=strlen+1
end if 
second_ver_2=Mid(product_version,pos+1,pos1-pos-1)
'Get zz from the version string xx.yy.zz.kk
pos2 = instr(pos1+1, product_version, ".")
if (pos2 = 0) then
	pos2=strlen+1
end if
second_ver_3=Mid(product_version,pos1+1,pos2-pos1-1)
'Get kk from the version string xx.yy.zz.kk
second_ver_4=Mid(product_version,pos2+1,strlen-pos2)


'Compare the first two parts of the version string.
if CInt(first_ver_1) < CInt(second_ver_1) then
	result=-1
elseif CInt(first_ver_1) > CInt(second_ver_1) then
	result=1
else 
	if CInt(first_ver_2) < CInt(second_ver_2) then
		result=-1
	elseif CInt(first_ver_2) > CInt(second_ver_2) then
		result=1
	else
	    if CInt(first_ver_3) < CInt(second_ver_3) then
		    result=-1
	    elseif CInt(first_ver_3) > CInt(second_ver_3) then
		    result=1
	    else
	        if CInt(first_ver_4) < CInt(second_ver_4) then
		        result=-1
	        elseif CInt(first_ver_4) > CInt(second_ver_4) then
		        result=1
	        else
		        result=0
		    end if
		end if
    End if
End if

'Set the package type by checking against the pre-stored Basic MSI versions.
if (CInt(first_ver_1) > 12) then
    'Specifically check for 13.0 packages because Basic MSI changes were done to 13.0 as part of efixes.
    if ((CInt(first_ver_1) = 13) and (CInt(first_ver_2) = 0) and (CInt(first_ver_3) = 0) ) then
        'check for pre-stored basic MSI versions.
        Select case product_name
        case TTUProducts(0) 'TERAGSS
            index=0
	    case TTUProducts(1) 'TDICU
	        index=1
	    case TTUProducts(2) 'CLIv2
	        index=2
	    case TTUProducts(3) 'TDODBC
	        index=3
	    case TTUProducts(4) 'PIOM
	        index=4
	    case TTUProducts(5) 'BTEQ
	        index=5
	    case TTUProducts(6) 'FASTLD
	        index=6
	    case TTUProducts(7) 'MLOAD
	        index=7
	    case TTUProducts(8) 'FASTEXP
	        index=8
	    case TTUProducts(9) 'TPUMP
	        index=9
	    case TTUProducts(10) 'TDOLEDB
	        index=10
	    case TTUProducts(11) 'SQLPP
	        index=11
	    case TTUProducts(12) 'NPAXSMOD
	        index=12
	    case TTUProducts(13) 'MQAXSMOD
	        index=13
	    case TTUProducts(14) 'OLEDBAXSMOD
	        index=14
	    case TTUProducts(15) 'JMSAXSMOD
	        index=15
	    case TTUProducts(16) 'SQLA
	        index=16
	    case TTUProducts(17) 'TSET
	        index=17
	    case TTUProducts(18) 'VECOMP
	        index=18
	    case TTUProducts(19) 'TIWIZ
	        index=19
	    case TTUProducts(20) 'TSWIZ
	        index=20
	    case TTUProducts(21) 'PMON
	        index=21
	    case TTUProducts(22) 'TQSADMIN
	        index=22
	    case TTUProducts(23) 'TQSSERVER
	        index=23
	    case TTUProducts(24) 'TQSCLIENT
	        index=24
	    case TTUProducts(25) 'TWA
	        index=25
	    case TTUProducts(26) 'TMGR
	        index=26
	    case TTUProducts(27) 'TDADMIN
	        index=27
	    case TTUProducts(28) 'TDWM
	        index=28
	    case TTUProducts(29) 'TSAW
	        index=29
	    case TTUProducts(30) 'TPTBASE
	        index=30
	    case TTUProducts(31) 'TPTSTREAM
	        index=31
	    case TTUProducts(32) 'TPTINFRA
	        index=32
	    case TTUProducts(33) 'TPTAPI
	        index=33
	    case TTUProducts(34) 'TPTLOADOP
	        index=34
	    case TTUProducts(35) 'TPTEXPORTOP
	        index=35
	    case TTUProducts(36) 'TPTUPDATEOP
	        index=36
	    case TTUProducts(37) 'TPTSTREAMOP
	        index=37
	    case else
	        index = -1
        End select
        
        if (index <> -1) then
            'Extract the last part of the version provided as parameter
            priorto_ver_last_part = Right(Basic_MSI_ver_13_0(index),2)

            'Compare the last parts. If Found version is less than the stored 
            'version then the package type is Installscript MSI otherwise its Basic MSI
            if (CInt(first_ver_4) < CInt(priorto_ver_last_part)) then
                install_pkg_type = "INSTALLSCRIPT_MSI"
            else
                install_pkg_type = "BASIC_MSI"
            end if
        else
            install_pkg_type = "INSTALLSCRIPT_MSI"
        end if 
    'Specifically check for 13.01 packages because Basic MSI changes were done to TDNETDP as part of 13.01.00.02.
    elseif ((CInt(first_ver_1) = 13) and (CInt(first_ver_2) = 1) and (CInt(first_ver_3) = 0) ) then
        'check for pre-stored basic MSI versions.
        Select case product_name
        case TTUProducts(49) 'TDNETDP
            index=38
        case else
            index=-1
        End select
        if (index <> -1) then
            'Extract the last part of the version provided as parameter
            priorto_ver_last_part = Right(Basic_MSI_ver_13_0(index),2)

            'Compare the last parts. If Found version is less than the stored 
            'version then the package type is Installscript MSI otherwise its Basic MSI
            if (CInt(first_ver_4) < CInt(priorto_ver_last_part)) then
                install_pkg_type = "INSTALLSCRIPT_MSI"
            else
                install_pkg_type = "BASIC_MSI"
            end if
        else
            install_pkg_type = "INSTALLSCRIPT_MSI"
        end if 
    'Specifically check for 13.10 packages because Basic MSI changes were done to 13.10 as part of efixes.
    elseif ((CInt(first_ver_1) = 13) and (CInt(first_ver_2) = 10) and (CInt(first_ver_3) = 0) ) then
        'check for pre-stored basic MSI versions.
        Select case product_name
        case TTUProducts(0) 'TERAGSS
            index=0
	    case TTUProducts(1) 'TDICU
	        index=1
	    case TTUProducts(2) 'CLIv2
	        index=2
	    case TTUProducts(3) 'TDODBC
	        index=3
	    case TTUProducts(4) 'PIOM
	        index=4
	    case TTUProducts(5) 'BTEQ
	        index=5
	    case TTUProducts(6) 'FASTLD
	        index=6
	    case TTUProducts(7) 'MLOAD
	        index=7
	    case TTUProducts(8) 'FASTEXP
	        index=8
	    case TTUProducts(9) 'TPUMP
	        index=9
	    case TTUProducts(10) 'TDOLEDB
	        index=10
	    case TTUProducts(11) 'SQLPP
	        index=11
	    case TTUProducts(12) 'NPAXSMOD
	        index=12
	    case TTUProducts(13) 'MQAXSMOD
	        index=13
	    case TTUProducts(14) 'OLEDBAXSMOD
	        index=14
	    case TTUProducts(15) 'JMSAXSMOD
	        index=15
	    case TTUProducts(16) 'SQLA
	        index=16
	    case TTUProducts(17) 'TSET
	        index=17
	    case TTUProducts(18) 'VECOMP
	        index=18
	    case TTUProducts(19) 'TIWIZ
	        index=19
	    case TTUProducts(20) 'TSWIZ
	        index=20
	    case TTUProducts(21) 'PMON
	        index=21
	    case TTUProducts(22) 'TQSADMIN
	        index=22
	    case TTUProducts(23) 'TQSSERVER
	        index=23
	    case TTUProducts(24) 'TQSCLIENT
	        index=24
	    case TTUProducts(25) 'TWA
	        index=25
	    case TTUProducts(26) 'TMGR
	        index=26
	    case TTUProducts(27) 'TDADMIN
	        index=27
	    case TTUProducts(28) 'TDWM
	        index=28
	    case TTUProducts(29) 'TSAW
	        index=29
	    case TTUProducts(30) 'TPTBASE
	        index=30
	    case TTUProducts(31) 'TPTSTREAM
	        index=31
	    case TTUProducts(32) 'TPTINFRA
	        index=32
	    case TTUProducts(33) 'TPTAPI
	        index=33
	    case TTUProducts(34) 'TPTLOADOP
	        index=34
	    case TTUProducts(35) 'TPTEXPORTOP
	        index=35
	    case TTUProducts(36) 'TPTUPDATEOP
	        index=36
	    case TTUProducts(37) 'TPTSTREAMOP
	        index=37
	    case TTUProducts(47) 'MONITOROBJ
	        index=38
	    case TTUProducts(49) 'TDNETDP
	        index=39
	    case else
	        index = -1
        End select
        
        if (index <> -1) then
            'Extract the last part of the version provided as parameter
            priorto_ver_last_part = Right(Basic_MSI_ver_13_10(index),2)
            
            'Compare the last parts. If Found version is less than the stored 
            'version then the package type is Installscript MSI otherwise its Basic MSI
            if (CInt(first_ver_4) < CInt(priorto_ver_last_part)) then
                install_pkg_type = "INSTALLSCRIPT_MSI"
            else
                install_pkg_type = "BASIC_MSI"
            end if    
        else
                install_pkg_type = "INSTALLSCRIPT_MSI"
        end if 
    else
        'All post-13.10 packages will be Basic MSI packages, except ARC 14.00.
        if ((product_name = TTUProducts(46)) and (CInt(first_ver_1) <= 14) and (CInt(first_ver_2) = 0)) then
            install_pkg_type = "INSTALLSCRIPT_MSI"
        else
            install_pkg_type = "BASIC_MSI"
        end if
    end if
else ' Any pre-13.0 packages
    Select case product_name
    'TERAGSS, SQLA, TMGR, TDADMIN, TSAW,MONITOROBJ will be Basic MSI packages
    case TTUProducts(0),    _
         TTUProducts(16),   _
         TTUProducts(26),   _
         TTUProducts(27),   _
         TTUProducts(29),   _
         TTUProducts(47)
         install_pkg_type = "BASIC_MSI"
    'All versions of TPTINFRA, TPTDATACONOP, TPTDDLOP, TPTINSERTOP, TPTODBCOP, TPTOSCMDOP, TPTSELECTOP
    'below 13.0 are installscript type packages.        
    case TTUProducts(32),   _
         TTUProducts(40),   _
         TTUProducts(41),   _
         TTUProducts(42),   _
         TTUProducts(43),   _
         TTUProducts(44),   _
         TTUProducts(45)                            
        install_pkg_type = "INSTALLSCRIPT"
    'TPTAPI,TPTICU all versions below 13.0 are installscript MSI type packages.        
    case TTUProducts(33),   _
         TTUProducts(38)
        install_pkg_type = "INSTALLSCRIPT_MSI"
    'Version 8.1 and below for TPTLOADOP, TPTEXPORTOP, TPTUPDATEOP, TPTSTREAMOP,TPTOSL packages are installscript type.
    case TTUProducts(34),   _    
         TTUProducts(35),   _
         TTUProducts(36),   _
         TTUProducts(37),   _
         TTUProducts(39)
         if ((CInt(first_ver_1) = 8) and (CInt(first_ver_2) < 2)) then
            install_pkg_type = "INSTALLSCRIPT"
         else
            install_pkg_type = "INSTALLSCRIPT_MSI"
         end if
         if (CInt(first_ver_1) > 8) then
            install_pkg_type = "INSTALLSCRIPT_MSI"
         end if
         if (CInt(first_ver_1) < 8) then
            install_pkg_type = "INSTALLSCRIPT"
         end if
    case else    ' Rest of the pre-13.0 packages will be Installscript MSI packages.
        install_pkg_type = "INSTALLSCRIPT_MSI"
    End Select
end if

VersionCompare=result
End Function

'=====================================================================================================================================================
'Generates the uninstall ISS file for InstallScript MSI products using the productcode supplied.
Function GenerateLogFile ( ByVal ProductName, ByVal ProductVersion )
	Dim TempFolder
	Dim LogFile
	Dim pkg_64
	
	if (Package_64bit = True) then
		pkg_64 = "x8664_"
	else
		pkg_64 = ""
	end if
	
	TempFolder = logfldr

	Select case ProductName
	case TTUProducts(0) 'TERAGSS
		LogFile 	= "uninstall_teragss_" & pkg_64 &  ProductVersion & ".log"
	case TTUProducts(1) 'TDICU
		LogFile 	= "uninstall_tdicu_" & pkg_64 &  ProductVersion & ".log"
	case TTUProducts(2) 'CLIv2
		LogFile 	= "uninstall_cliv2_" & pkg_64 &  ProductVersion & ".log"
	case TTUProducts(3) 'TDODBC
		LogFile 	= "uninstall_tdodbc_" & pkg_64 &  ProductVersion & ".log"
	case TTUProducts(4) 'PIOM
		LogFile  	= "uninstall_piom_" & ProductVersion & ".log"
	case TTUProducts(5) 'BTEQ
		LogFile	    = "uninstall_bteq_" & ProductVersion & ".log"
	case TTUProducts(6) 'FASTLD
		LogFile	    = "uninstall_fastld_" & ProductVersion & ".log"
	case TTUProducts(7) 'MLOAD
		LogFile	    = "uninstall_mload_" & ProductVersion & ".log"
	case TTUProducts(8) 'FASTEXP
		LogFile	    = "uninstall_fastexp_" & ProductVersion & ".log"
	case TTUProducts(9) 'TPUMP
		LogFile	    = "uninstall_tpump_" & ProductVersion & ".log"
	case TTUProducts(10) 'TDOLEDB
		LogFile	    = "uninstall_tdoledb_" & ProductVersion & ".log"
	case TTUProducts(11) 'SQLPP
		LogFile	    = "uninstall_sqlpp_" & pkg_64 &  ProductVersion & ".log"
	case TTUProducts(12) 'NPAXSMOD
		LogFile	    = "uninstall_npaxsmod_" & ProductVersion & ".log"
	case TTUProducts(13) 'MQAXSMOD
		LogFile	    = "uninstall_mqaxsmod_" & ProductVersion & ".log"
	case TTUProducts(14) 'OLEDBAXSMOD
		LogFile	    = "uninstall_oledbaxsmod_" & ProductVersion & ".log"
	case TTUProducts(15) 'JMSAXSMOD
		LogFile	    = "uninstall_jmsaxsmod_" & ProductVersion & ".log"
	case TTUProducts(16) 'SQLA
		LogFile	    = "uninstall_sqla_" & ProductVersion & ".log"
	case TTUProducts(17) 'TSET
		LogFile	    = "uninstall_tset_" & ProductVersion & ".log"
	case TTUProducts(18) 'VECOMP
		LogFile	    = "uninstall_vecomp_" & ProductVersion & ".log"
	case TTUProducts(19) 'TIWIZ
		LogFile	    = "uninstall_tiwiz_" & ProductVersion & ".log"
	case TTUProducts(20) 'TSWIZ
		LogFile	    = "uninstall_tswiz_" & ProductVersion & ".log"
	case TTUProducts(21) 'PMON
		LogFile	    = "uninstall_pmon_" & ProductVersion & ".log"
	case TTUProducts(22) 'TQSADMIN
		LogFile	    = "uninstall_tqsadmin_" & ProductVersion & ".log"
	case TTUProducts(23) 'TQSSERVER
		LogFile	    = "uninstall_tqsserver_" & ProductVersion & ".log"
	case TTUProducts(24) 'TQSCLIENT
		LogFile	    = "uninstall_tqsclient_" & ProductVersion & ".log"
	case TTUProducts(25) 'TWA
		LogFile	    = "uninstall_twa_" & ProductVersion & ".log"
	case TTUProducts(26) 'TMGR
		LogFile	    = "uninstall_tmgr_" & ProductVersion & ".log"
	case TTUProducts(27) 'TDADMIN
		LogFile	    = "uninstall_tdadmin_" & ProductVersion & ".log"
	case TTUProducts(28) 'TDWM
		LogFile	    = "uninstall_tdwm_" & ProductVersion & ".log"
	case TTUProducts(29) 'TSAW
		LogFile	    = "uninstall_tsaw_" & ProductVersion & ".log"
	case TTUProducts(30) 'TPTBASE
		LogFile	    = "uninstall_tptbase_" & ProductVersion & ".log"
	case TTUProducts(31) 'TPTSTREAM
		LogFile	    = "uninstall_tptstream_" & ProductVersion & ".log"
	case TTUProducts(32) 'TPTINFRA
		LogFile	    = "uninstall_tptinfra_" & ProductVersion & ".log"
	case TTUProducts(33) 'TPTAPI
		LogFile	    = "uninstall_tptapi_" & ProductVersion & ".log"
	case TTUProducts(34) 'TPTLOADOP
		LogFile	    = "uninstall_tptloadop_" & ProductVersion & ".log"
	case TTUProducts(35) 'TPTEXPORTOP
		LogFile	    = "uninstall_tptexportop_" & ProductVersion & ".log"
	case TTUProducts(36) 'TPTUPDATEOP
		LogFile	    = "uninstall_tptupdateop_" & ProductVersion & ".log"
	case TTUProducts(37) 'TPTSTREAMOP
		LogFile	    = "uninstall_tptstreamop_" & ProductVersion & ".log"
	case TTUProducts(38) 'TPTICU
		LogFile	    = "uninstall_tpticu_" & ProductVersion & ".log"
	case TTUProducts(39) 'TPTOSL
		LogFile	    = "uninstall_tptosl_" & ProductVersion & ".log"
	case TTUProducts(46) 'ARC
		LogFile	    = "uninstall_arc_" & ProductVersion & ".log"
	case TTUProducts(47) 'MONITOROBJ
		LogFile	    = "uninstall_monitorobj_" & ProductVersion & ".log"
	case TTUProducts(48) 'TDWALLET
		LogFile	    = "uninstall_tdwallet_" & ProductVersion & ".log"
	case TTUProducts(49) 'TDNETDP
		LogFile	    = "uninstall_tdnetdp_" & ProductVersion & ".log"
	case TTUProducts(50) 'TDGEOSPATIAL
		LogFile	    = "uninstall_tdgeospatial_" & ProductVersion & ".log"
	end select   
	LogFileName=TempFolder & "\" & LogFile

	lf.WriteLine "Log File generated for the product. LogFileName = " & LogFileName
End Function

'=====================================================================================================================================================
'Generates the uninstall ISS file for InstallScript MSI products using the productcode supplied.
Function GenerateISSFile ( ByVal ProductName, ByVal ProductCode, ByVal ProductVersion )
	Dim shellobj
	Dim outputobj
	Dim content
	Dim pos1
	Dim pos2
	Dim f_product_code
	Dim TempFolder
	Dim ISSFile
	Dim tf
	Dim pkg_64
	
	if (Package_64bit = True) then
		pkg_64 = "x8664_"
	else
		pkg_64 = ""
	end if
	
	TempFolder = logfldr
    ISSFile = ""
	Select case ProductName
	case TTUProducts(1) 'TDICU
		ISSFile 	= "uninstall_tdicu_" & pkg_64 & ProductVersion & ".iss"
	case TTUProducts(2) 'CLIv2
		ISSFile 	= "uninstall_cliv2_" & pkg_64 &  ProductVersion & ".iss"
	case TTUProducts(3) 'TDODBC
		ISSFile 	= "uninstall_tdodbc_" & pkg_64 &  ProductVersion & ".iss"
	case TTUProducts(4) 'PIOM
		ISSFile 	= "uninstall_piom_" & ProductVersion & ".iss"
	case TTUProducts(5) 'BTEQ
		ISSFile 	= "uninstall_bteq_" & ProductVersion & ".iss"
	case TTUProducts(6) 'FASTLD
		ISSFile 	= "uninstall_fastld_" & ProductVersion & ".iss"
	case TTUProducts(7) 'MLOAD
		ISSFile 	= "uninstall_mload_" & ProductVersion & ".iss"
	case TTUProducts(8) 'FASTEXP
		ISSFile 	= "uninstall_fastexp_" & ProductVersion & ".iss"
	case TTUProducts(9) 'TPUMP
		ISSFile 	= "uninstall_tpump_" & ProductVersion & ".iss"
	case TTUProducts(10) 'TDOLEDB
		ISSFile 	= "uninstall_tdoledb_" & ProductVersion & ".iss"
	case TTUProducts(11) 'SQLPP
		ISSFile 	= "uninstall_sqlpp_" & pkg_64 &  ProductVersion & ".iss"
	case TTUProducts(12) 'NPAXSMOD
		ISSFile 	= "uninstall_npaxsmod_" & ProductVersion & ".iss"
	case TTUProducts(13) 'MQAXSMOD
		ISSFile 	= "uninstall_mqaxsmod_" & ProductVersion & ".iss"
	case TTUProducts(14) 'OLEDBAXSMOD
		ISSFile 	= "uninstall_oledbaxsmod_" & ProductVersion & ".iss"
	case TTUProducts(15) 'JMSAXSMOD
		ISSFile 	= "uninstall_jmsaxsmod_" & ProductVersion & ".iss"
	case TTUProducts(17) 'TSET
		ISSFile 	= "uninstall_tset_" & ProductVersion & ".iss"
	case TTUProducts(18) 'VECOMP
		ISSFile 	= "uninstall_vecomp_" & ProductVersion & ".iss"
	case TTUProducts(19) 'TIWIZ
		ISSFile 	= "uninstall_tiwiz_" & ProductVersion & ".iss"
	case TTUProducts(20) 'TSWIZ
		ISSFile 	= "uninstall_tswiz_" & ProductVersion & ".iss"
	case TTUProducts(21) 'PMON
		ISSFile 	= "uninstall_pmon_" & ProductVersion & ".iss"
	case TTUProducts(22) 'TQSADMIN
		ISSFile 	= "uninstall_tqsadmin_" & ProductVersion & ".iss"
	case TTUProducts(23) 'TQSSERVER
		ISSFile 	= "uninstall_tqsserver_" & ProductVersion & ".iss"
	case TTUProducts(24) 'TQSCLIENT
		ISSFile 	= "uninstall_tqsclient_" & ProductVersion & ".iss"
	case TTUProducts(25) 'TWA
		ISSFile 	= "uninstall_twa_" & ProductVersion & ".iss"
	case TTUProducts(28) 'TDWM
		ISSFile 	= "uninstall_tdwm_" & ProductVersion & ".iss"
	case TTUProducts(32) 'TPTINFRA
		ISSFile 	= "uninstall_tptinfra_" & ProductVersion & ".iss"
	case TTUProducts(33) 'TPTAPI
		ISSFile 	= "uninstall_tptapi_" & ProductVersion & ".iss"
	case TTUProducts(34) 'TPTLOADOP
		ISSFile 	= "uninstall_tptloadop_" & ProductVersion & ".iss"
	case TTUProducts(35) 'TPTEXPORTOP
		ISSFile 	= "uninstall_tptexportop_" & ProductVersion & ".iss"
	case TTUProducts(36) 'TPTUPDATEOP
		ISSFile 	= "uninstall_tptupdateop_" & ProductVersion & ".iss"
	case TTUProducts(37) 'TPTSTREAMOP
		ISSFile 	= "uninstall_tptstreamop_" & ProductVersion & ".iss"
	case TTUProducts(38) 'TPTICU
		ISSFile 	= "uninstall_tpticu_" & ProductVersion & ".iss"
	case TTUProducts(39) 'TPTOSL
		ISSFile 	= "uninstall_tptosl_" & ProductVersion & ".iss"
	case TTUProducts(46) 'ARC
		ISSFile 	= "uninstall_arc_" & ProductVersion & ".iss"
	case TTUProducts(49) 'TDNETDP
		ISSFile 	= "uninstall_tdnetdp_" & ProductVersion & ".iss"
	end select   
	ISSFileName=TempFolder & "\" & ISSFile

	'Generate the .iss file. Some products have special handling.
	Select case ProductName
	'TDICU. An extra dialog is observed during uninstallation for these products and needs to be handled in the .iss file. 
	case TTUProducts(1)
    	Set tf = objFile.CreateTextFile(ISSFileName, True)
		tf.WriteLine ("[" & ProductCode & "-DlgOrder]")     
		tf.WriteLine ("Dlg0=" & ProductCode & "-AskYesNo-0")
		tf.WriteLine ("Count=3")
		tf.WriteLine ("Dlg1=" & ProductCode & "-SprintfBox-0")
		tf.WriteLine ("Dlg2=" & ProductCode & "-SdFinish-0")
		tf.WriteLine ("[" & ProductCode & "-AskYesNo-0]")
		tf.WriteLine ("Result=1")
		tf.WriteLine ("[" & ProductCode & "-SprintfBox-0]")
		tf.WriteLine ("Result=1")
		tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
		tf.WriteLine ("Result=1")
		tf.close
    	lf.WriteLine "ISS File generated for the product. ISSFileName = " & ISSFileName
	'CLiv2, TDODBC, PIOM, BTEQ, FASTLD, MLOAD, FASTEXP, TPUMP, SQLPP, 
	'NPAXSMOD, MQAXSMOD, OLEDBAXSMOD, JMSAXSMOD.
	case TTUProducts(2),	_
		 TTUProducts(3),	_
		 TTUProducts(4),	_
		 TTUProducts(5),	_
		 TTUProducts(6),	_
		 TTUProducts(7),	_
		 TTUProducts(8),	_
		 TTUProducts(9),	_
		 TTUProducts(11),	_
		 TTUProducts(12),	_
		 TTUProducts(13),	_
		 TTUProducts(14),	_
		 TTUProducts(15)
    	Set tf = objFile.CreateTextFile(ISSFileName, True)
		tf.WriteLine ("[" & ProductCode & "-DlgOrder]")     
		tf.WriteLine ("Dlg0=" & ProductCode & "-SprintfBox-0")
		tf.WriteLine ("Count=2")
		tf.WriteLine ("Dlg1=" & ProductCode & "-SdFinish-0")
		tf.WriteLine ("[" & ProductCode & "-SprintfBox-0]")
		tf.WriteLine ("Result=1")
		tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
		tf.WriteLine ("Result=1")
		tf.close
    	lf.WriteLine "ISS File generated for the product. ISSFileName = " & ISSFileName
	'Need to handle the maintenance dialog during uninstallation.
	'TDOLEDB, TSET, VECOMP, TIWIZ, TSWIZ, PMON, TQSADMIN, TQSSERVER,
	'TQSCLIENT, TWA, TDWM, TPTINFRA, TPTAPI, TPTLOADOP, TPTEXPORTOP,
	'TPTUPDATEOP, TPTSTREAMOP, TPTICU, TPTOSL
	case TTUProducts(10),   _
	     TTUProducts(17),   _
	     TTUProducts(18),   _
	     TTUProducts(19),   _
	     TTUProducts(20),   _
	     TTUProducts(21),   _
	     TTUProducts(22),   _
	     TTUProducts(23),   _
	     TTUProducts(24),   _
	     TTUProducts(25),   _
	     TTUProducts(28),   _
	     TTUProducts(32),   _
	     TTUProducts(33),   _
	     TTUProducts(34),   _
	     TTUProducts(35),   _
	     TTUProducts(36),   _
	     TTUProducts(37),   _
	     TTUProducts(38),   _
	     TTUProducts(39)
    	Set tf = objFile.CreateTextFile(ISSFileName, True)
		tf.WriteLine ("[" & ProductCode & "-DlgOrder]")     
		tf.WriteLine ("Dlg0=" & ProductCode & "-SdWelcomeMaint-0")
		tf.WriteLine ("Count=3")
		tf.WriteLine ("Dlg1=" & ProductCode & "-SprintfBox-0")
		tf.WriteLine ("Dlg2=" & ProductCode & "-SdFinish-0")
		tf.WriteLine ("[" & ProductCode & "-SdWelcomeMaint-0]")
		tf.WriteLine ("Result=303")
		tf.WriteLine ("[" & ProductCode & "-SprintfBox-0]")
		tf.WriteLine ("Result=1")
		tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
		tf.WriteLine ("Result=1")
		tf.close
    	lf.WriteLine "ISS File generated for the product. ISSFileName = " & ISSFileName
    'ARC has a different set of dialog sequence during uninstallation.	
    case TTUProducts(46)
    	Set tf = objFile.CreateTextFile(ISSFileName, True)
        tf.WriteLine ("[" & ProductCode & "-DlgOrder]")
        tf.WriteLine ("Dlg0=" & ProductCode & "-MessageBox-0")
        tf.WriteLine ("Count=2")
		tf.WriteLine ("Dlg1=" & ProductCode & "-SdFinish-0")
		tf.WriteLine ("[" & ProductCode & "-MessageBox-0]")
		tf.WriteLine ("Result=6")
		tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
		tf.WriteLine ("Result=1")
		tf.WriteLine ("bOpt1=0")
		tf.WriteLine ("bOpt2=0")
    case TTUProducts(49)    'TDNETDP
        Set tf = objFile.CreateTextFile(ISSFileName, True)
        tf.WriteLine ("[" & ProductCode & "-DlgOrder]")
        tf.WriteLine ("Dlg0=" & ProductCode & "-MessageBox-0")
        tf.WriteLine ("Count=2")
        tf.WriteLine ("Dlg1=" & ProductCode & "-SdFinish-0")
        tf.WriteLine ("[" & ProductCode & "-MessageBox-0]")
        tf.WriteLine ("Result=6")
        tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
        tf.WriteLine ("Result=1")
        tf.WriteLine ("bOpt1=0")
        tf.WriteLine ("bOpt2=0")
        tf.WriteLine ("[" & ProductCode & "-DlgOrder]")
        tf.WriteLine ("Dlg0=" & ProductCode & "-SdWelcomeMaint-0")
        tf.WriteLine ("Count=3")
        tf.WriteLine ("Dlg1=" & ProductCode & "-SprintfBox-0")
        tf.WriteLine ("Dlg2=" & ProductCode & "-SdFinish-0")
        tf.WriteLine ("[" & ProductCode & "-SdWelcomeMaint-0]")
        tf.WriteLine ("Result=303")
        tf.WriteLine ("[" & ProductCode & "-SprintfBox-0]")
        tf.WriteLine ("Result=1")
        tf.WriteLine ("[" & ProductCode & "-SdFinish-0]")
        tf.WriteLine ("Result=1")
        tf.WriteLine ("bOpt1=0")
        tf.WriteLine ("bOpt2=0")
	case else
	    'ISS file is not needed for Basic MSI packages.
	end select
	
End Function

'=====================================================================================================================================================
'Uninstall the product using one of the uninstallation methods based on the product.
'Using IDriver.exe to uninstall the product if the package is installscript MSI.
'Using MSIExec.exe to uninstall the product if the package is Basic MSI.
Function UninstallTTUProduct(ByVal ProductName, ByVal ProductCode, ByVal ProductVersion)
	Dim shellobj
	Dim outputobj
	Dim content
	Dim rc
	Dim IDriver9Path, IDriver7Path
	
	set shellobj = CreateObject("WScript.Shell")
	Set objFilesys = CreateObject("Scripting.FilesystemObject")

	'Set the IDriver.exe path based on the processor architecture. Since IDriver.exe is a 32-bit program 
	'it resides in Program Files (x86) folder on 64-bit machines.
	if (Proc_Arch = "AMD64") then
        IDriver7Path = Mid(program_files_x86_dir,1,3) & chr(34) & Mid(program_files_x86_dir,4,len(program_files_x86_dir)-3)& chr(34) & "\""Common Files""\InstallShield\Driver\7\""Intel 32""\IDriver.exe"
        IDriver9Path = Mid(program_files_x86_dir,1,3) & chr(34) & Mid(program_files_x86_dir,4,len(program_files_x86_dir)-3)& chr(34) & "\""Common Files""\InstallShield\Driver\9\""Intel 32""\IDriver.exe"
        ' The IDriver.exe location is picked based on ProgramFilesDir (x86) set on a machine. If Idriver.exe does not exist using the 
        ' ProgramFilesDir (x86) then picking up IDriver.exe from system drive's Program Files (x86).        
	    if not objFilesys.FileExists(IDriver9Path) then
	        IDriver7Path = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\""Program Files (x86)""\""Common Files""\InstallShield\Driver\7\""Intel 32""\IDriver.exe"
   	        IDriver9Path = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\""Program Files (x86)""\""Common Files""\InstallShield\Driver\9\""Intel 32""\IDriver.exe"
	    end if        
	else
        IDriver7Path = Mid(program_files_dir,1,3) & chr(34) & Mid(program_files_dir,4,len(program_files_dir)-3)& chr(34) & "\""Common Files""\InstallShield\Driver\7\""Intel 32""\IDriver.exe"
        IDriver9Path = Mid(program_files_dir,1,3) & chr(34) & Mid(program_files_dir,4,len(program_files_dir)-3)& chr(34) & "\""Common Files""\InstallShield\Driver\9\""Intel 32""\IDriver.exe"
        ' The IDriver.exe location is picked based on ProgramFilesDir set on a machine. If Idriver.exe does not exist using the 
        ' ProgramFilesDir then picking up IDriver.exe from system drive's Program Files.        
	    if not objFilesys.FileExists(IDriver9Path) then
	        IDriver7Path = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\""Program Files""\""Common Files""\InstallShield\Driver\7\""Intel 32""\IDriver.exe"
   	        IDriver9Path = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\""Program Files""\""Common Files""\InstallShield\Driver\9\""Intel 32""\IDriver.exe"
	    end if        
	end if
	
    if (Package_64bit = false) then
	    lf.WriteLine "Uninstalling " & ProductName & " : " & ProductVersion & " : " & ProductCode
	    WScript.Echo "Installation Found --> " & ProductName & " : " & ProductVersion & " --> Proceeding to uninstall..."
    else
	    lf.WriteLine "Uninstalling " & ProductName & " x8664 : " & ProductVersion & " : " & ProductCode
	    WScript.Echo "Installation Found --> " & ProductName & " x8664 : " & ProductVersion & " --> Proceeding to uninstall..."
    end if    

	'Generate the Log file(.log) for uninstallation
	GenerateLogFile ProductName,ProductVersion

    Select case install_pkg_type
    case "BASIC_MSI"
	    'Get the InstallPath of the product. This is used for cleanup of left over remnants of the installation.
	    GetInstallPath ProductName,ProductVersion

	    if (ProductName = TTUProducts(0)) then			'TeraGSS
		    'Copy the TdgssUserConfigFile.xml from older location to a temporary location so that it can be copied to the Teradata location
		    rc = shellobj.Run("cmd /C copy " & chr(34) & InstallPath & "Site\TdgssUserConfigFile.xml" & chr(34) & " " & logfldr,0,true)
        End if

	    'TMGR : Special case for TMGR uninstallation. Even though it is installscript MSI package 
	    'silent uninstallation is only possible through msiexec.exe. uninstallation using idriver.exe fails.
        
	    'Run the command to uninstall the product.
	    lf.WriteLine "The install package type is Basic MSI."
	    lf.WriteLine "cmd /C MsiExec.exe /qn /X" & ProductCode & " /log " & chr(34) & LogFileName & chr(34)
	    rc = shellobj.Run("cmd /C MsiExec.exe /qn /X" & ProductCode & " /log " & chr(34) & LogFileName & chr(34), 0, true)
    case "INSTALLSCRIPT_MSI"
	    'Get the InstallPath of the product. This is used for cleanup of left over remnants of the installation.
	    GetInstallPath ProductName,ProductVersion

	    'Generate the response file(.iss) for uninstallation
	    GenerateISSFile ProductName,ProductCode,ProductVersion

	    lf.WriteLine "The install package type is Installscript MSI."
	    'Run the command to uninstall the product.
	    'For earlier versions of TDODBC, SQLPP IDriver.exe from Installshield version 7.0 is required.
	    if ((ProductName = TTUProducts(3)) OR (ProductName = TTUProducts(11))) then
		    lf.WriteLine "cmd /C " & IDriver7Path & " /M" & ProductCode &  _
								    " /verbose" & chr(34) & LogFileName & chr(34) & _
								    " /s /f1" & chr(34) & ISSFileName & chr(34)
		    rc = shellobj.Run("cmd /C " & IDriver7Path & " /M" & ProductCode &  _
								    " /verbose" & chr(34) & LogFileName & chr(34) & _
								    " /s /f1" & chr(34) & ISSFileName & chr(34), 0, true)
	    end if
		
		'ARC & TDNETDP needs special handling during uninstallation.
		if ((ProductName = TTUProducts(46)) OR (ProductName = TTUProducts(49))) then
		    if (instr(1,uninstall_cmd,"IDriver.exe") <> 0) then  'The uninstall string uses IDriver.exe for uninstallation.
		        lf.WriteLine "Uninstall String uses IDriver.exe to uninstall that package.."
		    else    'If IDriver.exe is not found in the uninstall string then generate the uninstall string.
		        if (Proc_Arch = "AMD64") then
           		    uninstall_cmd = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\PROGRA~2\INSTAL~1\" & ProductCode & "\setup.exe -runfromtemp -l0x0409 -removeonly"
		        else
           		    uninstall_cmd = shellobj.ExpandEnvironmentStrings("%SYSTEMDRIVE%") & "\PROGRA~1\INSTAL~1\" & ProductCode & "\setup.exe -runfromtemp -l0x0409 -removeonly"
		        end if
		    end if
	        lf.WriteLine "cmd /C " & uninstall_cmd & " /s /f1" & chr(34) & ISSFileName & chr(34) & " /verbose" & chr(34) & LogFileName & chr(34)
					        
	        rc = shellobj.Run("cmd /C " & uninstall_cmd & " /s /f1" & chr(34) & ISSFileName & chr(34) & " /verbose" & chr(34) & LogFileName & chr(34), 0, true)
	        WScript.Sleep 10000
		else
	        'For all other products including newer versions of TDODBC & SQLPP IDriver.exe from 
	        'Installshield version 9.0 is required.
	        lf.WriteLine "cmd /C " & IDriver9Path & " /M" & ProductCode &  _
								        " /verbose" & chr(34) & LogFileName & chr(34) & _
								        " /s /f1" & chr(34) & ISSFileName & chr(34)
    									
	        rc = shellobj.Run("cmd /C " & IDriver9Path & " /M" & ProductCode &  _
								        " /verbose" & chr(34) & LogFileName & chr(34) & _
								        " /s /f1" & chr(34) & ISSFileName & chr(34), 0, true)
        end if
    case "INSTALLSCRIPT"
        if (len(uninstall_cmd) <> 0) then
            lf.WriteLine "cmd /C " & uninstall_cmd & " -a"
            rc = shellobj.Run("cmd /C " & uninstall_cmd & " -a", 0, true) 
        else
            lf.WriteLine "uninstall_cmd is empty.."
        end if
    end select
    
	if (rc = 0) then
		'Upon successful uninstallation verify that no remnants of the product are left over.
		lf.WriteLine ProductName & " uninstallation successful...."
		Verify_Uninstallation ProductName,ProductCode,ProductVersion
	else
		'Incase of an uninstallation failure also verify that no remnants of the product are left over.
		lf.WriteLine ProductName & " uninstallation failed. rc = " & rc
		Verify_Uninstallation ProductName,ProductCode,ProductVersion
	end if

End Function

'=====================================================================================================================================================
'Uninstall all suites on the machine using TTUSuiteSilent.exe which comes with media.
Function UninstallAllSuites
	Dim rc
	Dim shellobj
	Dim objFilesys
	Dim strlen
	Dim pos, pos1
	Dim first_ver_1, first_ver_2

	strlen = len(priorto_version)
	pos = instr(1,priorto_version, ".")
	first_ver_1=Mid(priorto_version,1,pos-1)
	'Get yy from the version string xx.yy.zz.kk
	pos1 = instr(pos+1, priorto_version, ".")
	if (pos1 = 0) then
		pos1=strlen+1
	end if
	first_ver_2=Mid(priorto_version,pos+1,pos1-pos-1)

	if ( (CInt(first_ver_1) >= 15) AND (CInt(first_ver_2) >= 0) )then

		set shellobj = CreateObject("WScript.Shell")
		Set objFilesys = CreateObject("Scripting.FilesystemObject")
		'Removing all suites from the machine	
		lf.WriteLine "Removing all suites exist on the machine having version less than " & priorto_version
		WScript.echo "Removing all suites exist on the machine having version less than " & priorto_version
		rc=shellobj.Run("cmd /c .\TTU\TTUSuiteSilent.exe ALL_SUITES " & priorto_version, 0, True)

		if ( rc = 0 ) then
			lf.WriteLine suite_option & " SUITES removed successfully"
			lf.WriteLine "See TTUSuiteSilent_Uninstall.log for more information"
			WScript.echo suite_option & " SUITES removed successfully"
		else
			lf.WriteLine "Uninstallation of " & suite_option & " SUITES was unsuccessful"
			lf.WriteLine "Error code : " & rc
			WScript.echo "Uninstallation of " & suite_option & " SUITES was unsuccessful"
		end if


		if (force_option = true) then   'Only if force_option is provided go through the extensive registry search & cleanup.
			
			if (Proc_Arch = "AMD64") then	    'On 64-bit machines
				WScript.Echo "Searching and cleaning up any left over remnants of 32-bit packages from the 64-bit machine..." 
				lf.WriteLine "Searching and cleaning up any left over remnants of 32-bit packages from the 64-bit machine..." 

				'Searching for the 32-bit packages
				objCtx.Add "__ProviderArchitecture", 32
				objCtx.Add "__RequiredArchitecture", TRUE
				Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
				Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
				Set objStdRegProv = objServices.Get("StdRegProv") 

				Wow6432Node=True
				Package_64bit=false

				'Call the additional Registry Search to detect corrupted installs for the corresponding products.
				Search_and_Cleanup Suite_TERAGSS_Prod_Codes, TTUProducts(0)
				Search_and_Cleanup Suite_TDICU_Prod_Codes, TTUProducts(1)
				Search_and_Cleanup Suite_CLIv2_Prod_Codes, TTUProducts(2)
				Search_and_Cleanup Suite_TDODBC_Prod_Codes, TTUProducts(3)
				Search_and_Cleanup Suite_PIOM_Prod_Codes, TTUProducts(4)
				Search_and_Cleanup Suite_BTEQ_Prod_Codes, TTUProducts(5)
				Search_and_Cleanup Suite_FASTLD_Prod_Codes, TTUProducts(6)
				Search_and_Cleanup Suite_MLOAD_Prod_Codes, TTUProducts(7)
				Search_and_Cleanup Suite_FASTEXP_Prod_Codes, TTUProducts(8)
				Search_and_Cleanup Suite_TPUMP_Prod_Codes, TTUProducts(9)
				Search_and_Cleanup Suite_SQLPP_Prod_Codes, TTUProducts(11)
				Search_and_Cleanup Suite_NPAXSMOD_Prod_Codes, TTUProducts(12)
				Search_and_Cleanup Suite_MQAXSMOD_Prod_Codes, TTUProducts(13)
				Search_and_Cleanup Suite_OLEDBAXSMOD_Prod_Codes, TTUProducts(14)
				Search_and_Cleanup Suite_JMSAXSMOD_Prod_Codes, TTUProducts(15)
				Search_and_Cleanup Suite_SQLA_Prod_Codes, TTUProducts(16)
				Search_and_Cleanup Suite_TSET_Prod_Codes, TTUProducts(17)
				Search_and_Cleanup Suite_VECOMP_Prod_Codes, TTUProducts(18)
				Search_and_Cleanup Suite_TIWIZ_Prod_Codes, TTUProducts(19)
				Search_and_Cleanup Suite_TSWIZ_Prod_Codes, TTUProducts(20)
				Search_and_Cleanup Suite_PMON_Prod_Codes, TTUProducts(21)
				Search_and_Cleanup Suite_TQSADMIN_Prod_Codes, TTUProducts(22)
				Search_and_Cleanup Suite_TQSSERVER_Prod_Codes, TTUProducts(23)
				Search_and_Cleanup Suite_TQSCLIENT_Prod_Codes, TTUProducts(24)
				Search_and_Cleanup Suite_TWA_Prod_Codes, TTUProducts(25)
				Search_and_Cleanup Suite_TDADMIN_Prod_Codes, TTUProducts(27)
				Search_and_Cleanup Suite_TPTBASE_Prod_Codes, TTUProducts(30)
				Search_and_Cleanup Suite_TPTSTREAM_Prod_Codes, TTUProducts(31)
				Search_and_Cleanup Suite_ARC_Prod_Codes, TTUProducts(46)
				Search_and_Cleanup Suite_TDWALLET_Prod_Codes, TTUProducts(48)
				Search_and_Cleanup Suite_TDNETDP_Prod_Codes, TTUProducts(49)
				Search_and_Cleanup Suite_TDGEOSPATIAL_Prod_Codes, TTUProducts(50)
		
				lf.WriteLine "-----------------------------------------------------------------------------------------"
				
				WScript.Echo "Searching and cleaning up any left over remnants of 64-bit packages from the 64-bit machine..." 
				lf.WriteLine "Searching and cleaning up any left over remnants of 64-bit packages from the 64-bit machine..." 

				objCtx.Add "__ProviderArchitecture", 64
				objCtx.Add "__RequiredArchitecture", TRUE
				Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
				Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
				Set objStdRegProv = objServices.Get("StdRegProv") 
				
				Wow6432Node=False
				Package_64bit=true
				
				'Call the additional Registry Search to detect corrupted installs for the corresponding products.
				Search_and_Cleanup Suite_TERAGSS_64_Prod_Codes, TTUProducts(0)
				Search_and_Cleanup Suite_TDICU_64_Prod_Codes, TTUProducts(1)
				Search_and_Cleanup Suite_CLIv2_64_Prod_Codes, TTUProducts(2)
				Search_and_Cleanup Suite_TDODBC_64_Prod_Codes, TTUProducts(3)
				Search_and_Cleanup Suite_PIOM_64_Prod_Codes, TTUProducts(4)
				Search_and_Cleanup Suite_SQLPP_64_Prod_Codes, TTUProducts(11)
				Search_and_Cleanup Suite_NPAXSMOD_64_Prod_Codes, TTUProducts(12)
				Search_and_Cleanup Suite_JMSAXSMOD_64_Prod_Codes, TTUProducts(15)
				Search_and_Cleanup Suite_TPTBASE_64_Prod_Codes, TTUProducts(30)
				Search_and_Cleanup Suite_TPTSTREAM_64_Prod_Codes, TTUProducts(31)
				Search_and_Cleanup Suite_ARC_64_Prod_Codes, TTUProducts(46)
				Search_and_Cleanup Suite_TDWALLET_64_Prod_Codes, TTUProducts(48)
				Search_and_Cleanup Suite_TDGEOSPATIAL_64_Prod_Codes, TTUProducts(50)
				
				lf.WriteLine "-----------------------------------------------------------------------------------------"
			else     'If(Proc_Arch = x86)
				WScript.Echo "Searching and cleaning up any left over remnants from the 32-bit machine..." 
				lf.WriteLine "Searching and cleaning up any left over remnants from the 32-bit machine..." 

				objCtx.Add "__ProviderArchitecture", 32
				objCtx.Add "__RequiredArchitecture", TRUE
				Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
				Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
				Set objStdRegProv = objServices.Get("StdRegProv") 
				
				Wow6432Node=False
				Package_64bit=false
					   
				'Testing the enhancements......
				'Call the additional Registry Search to detect corrupted installs for the corresponding products.
				Search_and_Cleanup Suite_TERAGSS_Prod_Codes, TTUProducts(0)
				Search_and_Cleanup Suite_TDICU_Prod_Codes, TTUProducts(1)
				Search_and_Cleanup Suite_CLIv2_Prod_Codes, TTUProducts(2)
				Search_and_Cleanup Suite_TDODBC_Prod_Codes, TTUProducts(3)
				Search_and_Cleanup Suite_PIOM_Prod_Codes, TTUProducts(4)
				Search_and_Cleanup Suite_BTEQ_Prod_Codes, TTUProducts(5)
				Search_and_Cleanup Suite_FASTLD_Prod_Codes, TTUProducts(6)
				Search_and_Cleanup Suite_MLOAD_Prod_Codes, TTUProducts(7)
				Search_and_Cleanup Suite_FASTEXP_Prod_Codes, TTUProducts(8)
				Search_and_Cleanup Suite_TPUMP_Prod_Codes, TTUProducts(9)
				Search_and_Cleanup Suite_SQLPP_Prod_Codes, TTUProducts(11)
				Search_and_Cleanup Suite_NPAXSMOD_Prod_Codes, TTUProducts(12)
				Search_and_Cleanup Suite_MQAXSMOD_Prod_Codes, TTUProducts(13)
				Search_and_Cleanup Suite_OLEDBAXSMOD_Prod_Codes, TTUProducts(14)
				Search_and_Cleanup Suite_JMSAXSMOD_Prod_Codes, TTUProducts(15)
				Search_and_Cleanup Suite_SQLA_Prod_Codes, TTUProducts(16)
				Search_and_Cleanup Suite_TSET_Prod_Codes, TTUProducts(17)
				Search_and_Cleanup Suite_VECOMP_Prod_Codes, TTUProducts(18)
				Search_and_Cleanup Suite_TIWIZ_Prod_Codes, TTUProducts(19)
				Search_and_Cleanup Suite_TSWIZ_Prod_Codes, TTUProducts(20)
				Search_and_Cleanup Suite_PMON_Prod_Codes, TTUProducts(21)
				Search_and_Cleanup Suite_TQSADMIN_Prod_Codes, TTUProducts(22)
				Search_and_Cleanup Suite_TQSSERVER_Prod_Codes, TTUProducts(23)
				Search_and_Cleanup Suite_TQSCLIENT_Prod_Codes, TTUProducts(24)
				Search_and_Cleanup Suite_TWA_Prod_Codes, TTUProducts(25)
				Search_and_Cleanup Suite_TDADMIN_Prod_Codes, TTUProducts(27)
				Search_and_Cleanup Suite_TPTBASE_Prod_Codes, TTUProducts(30)
				Search_and_Cleanup Suite_TPTSTREAM_Prod_Codes, TTUProducts(31)
				Search_and_Cleanup Suite_ARC_Prod_Codes, TTUProducts(46)
				Search_and_Cleanup Suite_TDWALLET_Prod_Codes, TTUProducts(48)
				Search_and_Cleanup Suite_TDNETDP_Prod_Codes, TTUProducts(49)
				Search_and_Cleanup Suite_TDGEOSPATIAL_Prod_Codes, TTUProducts(50)
				lf.WriteLine "-----------------------------------------------------------------------------------------"
			end if  'End if for if(Proc_Arch = "AMD64")       	
		end if  'Endif for if(force_option = true)
	end if
End Function

'=====================================================================================================================================================
'Get the install path for the product from the registry.
Function GetInstallPath(ByVal ProductName, ByVal ProductVersion)
Dim content
Dim strlen
Dim pos
Dim RegPath
Dim RegValue
Dim tmp_InstallPath
Dim Inparams1
Dim Outparams1
Dim Inst_loc
Dim Inst_axsmod_loc

'if (short_version = "") then
    short_version = Get_Short_Version(ProductVersion)
'end if

if (Package_64bit = True) then
	pkg_64 = " x8664"
else
	pkg_64 = ""
end if

pos=Instr(short_version,".")
short_ver_first_part = Left(short_version,pos-1)
if (CInt(short_ver_first_part) < 13) then
    CompanyName="NCR"
    if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName
	    Inst_loc = program_files_dir & "\" & CompanyName
	    Inst_axsmod_loc = program_files_dir & "\Common Files\" & CompanyName
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName
	    Inst_loc = program_files_x86_dir & "\" & CompanyName
	    Inst_axsmod_loc = program_files_x86_dir & "\Common Files\" & CompanyName
    end if
else
    CompanyName="Teradata"
    if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName & "\client\" & short_version
	    Inst_loc = program_files_dir & "\" & CompanyName & "\client\" & short_version
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName & "\client\" & short_version
	    Inst_loc = program_files_x86_dir & "\" & CompanyName & "\client\" & short_version
    end if
end if

lf.WriteLine "Get InstallPath for " & ProductName & " : " & ProductVersion

'Set the default InstallPath and set RegValue that needs to be searched to get the actual install path.
Select case ProductName
Case TTUProducts(0) 'TeraGSS
	if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName & "\" & ProductName
        InstallPath = program_files_dir & "\" & CompanyName & "\Teradata GSS\"
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName & "\" & ProductName
        InstallPath = program_files_x86_dir & "\" & CompanyName & "\Teradata GSS\"
    end if
    RegValue="InstallDir"
Case TTUProducts(1) 'TDICU
	InstallPath = Inst_loc & "\Common Files\Shared ICU Libraries for Teradata\lib"
	RegPath = RegPath & "\" & ProductName
	RegValue="InstallDLLPath"
Case TTUProducts(2) 'CLIv2
    if (CInt(short_ver_first_part) < 13) then
	    RegPath = RegPath &  "\" & ProductName & "\" & ProductVersion
	    InstallPath = Inst_loc & "\Teradata Client\cliv2\"
	else
	    RegPath = RegPath & "\" & ProductName
	    InstallPath = Inst_loc & "\cliv2\"
	end if
	RegValue="InstallDLLsPath"
Case TTUProducts(3) 'TDODBC
	InstallPath = Inst_loc & "\ODBC Driver for Teradata\"
	RegPath = RegPath & "\" & ProductName
	RegValue="InstallPath"
Case TTUProducts(4) 'PIOM
    if (CInt(short_ver_first_part) < 13) then
    	InstallPath = Inst_loc & "\Teradata Client\bin\"
	else
    	InstallPath = Inst_loc & "\bin\"
	end if
    RegPath = RegPath & "\" & ProductName & pkg_64
	RegValue="InstallDLLPath"
Case TTUProducts(5) 'BTEQ
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_loc & "\Teradata Client\"
	else
		InstallPath = Inst_loc & "\bin\"
	end if
    RegPath = RegPath & "\" & ProductName
	RegValue="InstallPath"
Case TTUProducts(6) 'FASTLD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_loc & "\Teradata Client\"
	else
		InstallPath = Inst_loc
	end if
	RegPath =  RegPath & "\" & ProductName
	RegValue="InstallPath"
Case TTUProducts(7) 'MLOAD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_loc & "\Teradata Client\"
	else
		InstallPath = Inst_loc
	end if
	RegPath =  RegPath & "\" & ProductName
	RegValue="InstallBasePath"
Case TTUProducts(8) 'FASTEXP
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_loc & "\Teradata Client\"
	else
		InstallPath = Inst_loc
	end if
	RegPath =  RegPath & "\" & ProductName
	RegValue="InstallBasePath"
Case TTUProducts(9) 'TPUMP
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_loc & "\Teradata Client\"
	else
		InstallPath = Inst_loc
	end if
	RegPath =  RegPath & "\" & ProductName
	RegValue="InstallBasePath"
Case TTUProducts(10) 'TDOLEDB
    if (CInt(short_ver_first_part) < 13) then
		RegPath = RegPath & "\" & ProductName & "\" & ProductVersion
		InstallPath = Inst_loc & "\Teradata Client\OLE DB Provider for Teradata\"
	else
		RegPath = RegPath & "\" & ProductNamw
		InstallPath = Inst_loc & "\OLE DB Provider for Teradata\"
	end if
	RegValue="InstallDir"
Case TTUProducts(11) 'SQLPP
    if (CInt(short_ver_first_part) < 13) then
		RegPath = RegPath & "\" & ProductName & "\" & ProductVersion
		InstallPath = Inst_loc & "\Teradata Client\pp2"
	else
		RegPath = RegPath & "\" & ProductName
		InstallPath = Inst_loc & "\pp2"
	end if
	RegValue="InstallPP2RuntimePath"
Case TTUProducts(12) 'NPAXSMOD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_axsmod_loc & "\AXSMOD\"
	else
		InstallPath = Inst_loc & "\AXSMOD\"
	end if
    RegPath = RegPath & "\" & ProductName & pkg_64
	RegValue="InstallPath"
Case TTUProducts(13) 'MQAXSMOD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_axsmod_loc & "\AXSMOD\"
	else
		InstallPath = Inst_loc & "\AXSMOD\"
	end if
    RegPath = RegPath & "\" & ProductName & pkg_64
	RegValue="InstallPath"
Case TTUProducts(14) 'OLEDBAXSMOD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_axsmod_loc & "\AXSMOD\"
	else
		InstallPath = Inst_loc & "\AXSMOD\"
	end if
    RegPath = RegPath & "\" & ProductName  & pkg_64
	RegValue="InstallPath"
Case TTUProducts(15) 'JMSAXSMOD
    if (CInt(short_ver_first_part) < 13) then
		InstallPath = Inst_axsmod_loc & "\AXSMOD\"
	else
		InstallPath = Inst_loc & "\JMSAXSMOD\"
	end if
    RegPath = RegPath & "\" & ProductName  & pkg_64
	RegValue="InstallDir"
'TPTBASE, TPTSTREAM
Case TTUProducts(30), _
     TTUProducts(31)
	InstallPath = Inst_loc & "\Teradata Parallel Transporter\"
	RegPath =  RegPath & "\" & ProductName
    RegValue="INSTALLBASE"
'TPTINFRA, TPTAPI, TPTLOADOP, TPTEXPORTOP, TPTUPDATEOP, TPTSTREAMOP
Case TTUProducts(32),   _
     TTUProducts(33),   _
     TTUProducts(34),   _
     TTUProducts(35),   _
     TTUProducts(36),   _
     TTUProducts(37),   _
     TTUProducts(38),   _
     TTUProducts(39),   _
     TTUProducts(40),   _
     TTUProducts(41),   _
     TTUProducts(42),   _
     TTUProducts(43),   _
     TTUProducts(44),   _
     TTUProducts(45)
    if (CInt(short_ver_first_part) < 13) then
    	InstallPath = Inst_loc & "\Teradata Parallel Transporter\" & short_version 
    	RegPath =  RegPath & "\" & ProductName & " " & short_version
    else
        InstallPath = Inst_loc & "\Teradata Parallel Transporter\"
    	RegPath =  RegPath & "\" & ProductName
    end if
	RegValue="INSTALLBASE"
'ARC
Case TTUProducts(46)
	InstallPath = Inst_loc & "\bin\"
	RegPath =  RegPath & "\" & ProductName
    RegValue="InstallExecPath"
Case TTUProducts(48) 'TDWALLET
	if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName & "\" & ProductName
        InstallPath = program_files_dir & "\" & CompanyName & "\client\"
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName & "\" & ProductName
        InstallPath = program_files_x86_dir & "\" & CompanyName & "\client\"
    end if
    RegValue="InstallDir"
Case TTUProducts(49) 'TDNETDP
	if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName & "\" & ProductName & "\" & ProductVersion
        InstallPath = program_files_dir & "\" & CompanyName & "\" & Replace(ProductName,".","") & "\" & Left(ProductVersion,len(ProductVersion)-3)
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName & "\" & ProductName & "\" & ProductVersion
        InstallPath = program_files_x86_dir & "\" & CompanyName & "\" & Replace(ProductName,".","") & "\" & Left(ProductVersion,len(ProductVersion)-3)
    end if
    RegValue="InstallPath"
Case TTUProducts(50) 'TDGEOSPATIAL
	short_version = Get_Short_Version(ProductVersion)
	if (Wow6432Node = False) then
        RegPath = "SOFTWARE\" & CompanyName & "\Client\" & short_version & "\" & ProductName
        InstallPath = program_files_dir & "\" & CompanyName & "\Client\" & short_version & "\tdgeospatial\"
    else
        RegPath = "SOFTWARE\Wow6432Node\" & CompanyName & "\Client\" & short_version & "\" & ProductName
        InstallPath = program_files_x86_dir & "\" & CompanyName & "\Client\" & short_version & "\tdgeospatial\"
    end if
    RegValue="InstallDir"
end select

tmp_InstallPath=""

'Check for registry entries in HKLM\Software\" & CompanyName & "
Set Inparams1 = objStdRegProv.Methods_("GetStringValue").Inparameters
Inparams1.Hdefkey = HKLM
Inparams1.Ssubkeyname = RegPath
Inparams1.Svaluename = RegValue
set Outparams1 = objStdRegProv.ExecMethod_("GetStringValue", Inparams1,,objCtx) 

tmp_InstallPath = Outparams1.SValue

lf.Writeline "Product Install Path from registry : " & tmp_InstallPath

if (len(tmp_InstallPath)> 0) then
    InstallPath=tmp_InstallPath
else
	lf.WriteLine "No output for reg query " & chr(34) & RegPath & chr(34) & " /v " & RegValue
    'The shortversion is appended in Install Path for the following packages 
    'TSET, VECOMP, TIWIZ, TSWIZ, PMON, TWA, TMGR, TDADMIN, TDWM
    Select case ProductName
    Case TTUProducts(17),   _
        TTUProducts(18),    _
        TTUProducts(19),    _
        TTUProducts(20),    _
        TTUProducts(21),    _
        TTUProducts(25),    _
        TTUProducts(26),    _
        TTUProducts(27),    _
        TTUProducts(28)
        if (short_version = "") then
            short_version = Get_Short_Version(ProductVersion)
        end if
        if (Wow6432Node = False) then
		    InstallPath = program_files_dir & "\" & CompanyName & "\" & ProductName & " " & short_version
	    else
		    InstallPath = program_files_x86_dir & "\" & CompanyName & "\" & ProductName & " " & short_version
	    end if
    case  TTUProducts(22)   'TQSADMIN
        if (short_version = "") then
            short_version = Get_Short_Version(ProductVersion)
        end if
        if (Wow6432Node = False) then
		    InstallPath = program_files_dir & "\" & CompanyName & "\Teradata Query Scheduler Admin" & " " & short_version
	    else
		    InstallPath = program_files_x86_dir & "\" & CompanyName & "\Teradata Query Scheduler Admin" & " " & short_version
	    end if
	'Both TQSSERVER, TQSCLIENT install to same folder.
    case TTUProducts(23),  _
        TTUProducts(24)
        if (short_version = "") then
            short_version = Get_Short_Version(ProductVersion)
        end if
        if (Wow6432Node = False) then
		    InstallPath = program_files_dir & "\" & CompanyName & "\Teradata Query Scheduler" & " " & short_version
	    else
		    InstallPath = program_files_x86_dir & "\" & CompanyName & "\Teradata Query Scheduler" & " " & short_version
	    end if
    end select	
end if 

lf.WriteLine "Product Install Path : " & InstallPath
End Function
'=====================================================================================================================================================
'Verifies whether the product uninstallation was successful and if any remnants(Files, registry entries, PATH entries) of the product are left over on the machine.
Function Verify_Uninstallation(ByVal ProductName, ByVal ProductCode, ByVal ProductVersion)
Dim TempInstallPath
lf.WriteLine "Verifying uninstallation of " & ProductName & " : " & ProductVersion & " : " & ProductCode

'Get the InstallPath of the product. This is used for cleanup of left over remnants of the installation.
GetInstallPath ProductName,ProductVersion

VerifyProductFiles ProductName,ProductVersion, InstallPath
VerifyRegistryEntries ProductName, ProductCode, ProductVersion


'Since the InstallPath only points to the top installation folder. The exact entry for the product in the PATH variable
'is passed to PATHCleanup, so that the entry can be removed from PATH if not already done.
select case ProductName
case TTUProducts(5)	'BTEQ
	PATHCleanup InstallPath & "Bin"
case TTUProducts(6)	'FASTLD
	PATHCleanup InstallPath & "Bin"
case TTUProducts(7)	'MLOAD
	PATHCleanup InstallPath & "Bin"
case TTUProducts(8)	'FASTEXP
	PATHCleanup InstallPath & "Bin"
case TTUProducts(9)	'TPUMP
	PATHCleanup InstallPath & "Bin"
case TTUProducts(11)	'SQLPP
	TempInstallPath=replace(InstallPath,"\pp2","\\pp2")
	InstallPath=TempInstallPath
	TempInstallPath=replace(InstallPath,"pp2","Bin")
	PATHCleanup TempInstallPath
	PATHCleanup InstallPath
'For TDICU, CLIv2, TDODBC, ARC	
case TTUProducts(1),    _
     TTUProducts(2),    _
     TTUProducts(3),    _
     TTUProducts(46)
    	PATHCleanup InstallPath
'For TPTBASE, TPTSTREAM	
case TTUProducts(30),    _
     TTUProducts(31)
    	PATHCleanup InstallPath & "Bin"
    	PATHCleanup InstallPath & "msg"
end select

lf.WriteLine "Verification successful... "
End Function

'=====================================================================================================================================================
'Verifies that the files installed by the products are removed during the uninstallation. 
'Removes the left over files forcibly.
Function VerifyProductFiles(ByVal ProductName, ByVal ProductVersion, ByVal InstallPath)
Dim objFilesys
Dim shellobj
Dim TempInstallPath
Dim tmppath
Dim rc
Dim Continue_TeraGSS_Flag

set shellobj = CreateObject("WScript.Shell")
Set objFilesys = CreateObject("Scripting.FilesystemObject")

select case ProductName
case TTUProducts(0) 'TERAGSS
	if (alpha_product_ver <> "") then 
		temp_product_ver = alpha_product_ver
	else
		temp_product_ver = ProductVersion
	end if

	If (Package_64bit = true) then
		folderpath=InstallPath & "nt-x8664\" & temp_product_ver
		If (temp_product_ver = "01.00.00.00") Then
			folderpath=InstallPath & "nt-x8664\"
			Continue_TeraGSS_Flag = False
			TeraGSSCleanup folderpath
		End If
	else
		folderpath=InstallPath & "nt-i386\" & temp_product_ver
		If (temp_product_ver = "01.00.00.00") Then
			folderpath=InstallPath & "nt-i386\"
			Continue_TeraGSS_Flag = False
			TeraGSSCleanup folderpath
		End If
	End If
	If (Continue_TeraGSS_Flag = True) Then
		if objFilesys.FolderExists(folderpath) then
			lf.WriteLine "Folder found : " & folderpath
			rc = objFilesys.DeleteFolder(folderpath,true)
		else
			lf.WriteLine "Folder not found : " & folderpath
		end If
	End If
case TTUProducts(1) 'TDICU
	'Check if ICU3.4 files exist on the machine
	if objFilesys.FileExists(InstallPath & "\icudttd34l.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icudttd34l.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icudttd34l.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icudttd34l.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuintd34.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuintd34.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuintd34.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuintd34.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuiotd34.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuiotd34.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuiotd34.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuiotd34.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\iculetd34.dll") then
		lf.WriteLine "File found : " & InstallPath & "\iculetd34.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\iculetd34.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\iculetd34.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\iculxtd34.dll") then
		lf.WriteLine "File found : " & InstallPath & "\iculxtd34.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\iculxtd34.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\iculxtd34.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuuctd34.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuuctd34.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuuctd34.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuuctd34.dll"
	end if

	'Check if ICU 2.8 files exist on the machine.
	if objFilesys.FileExists(InstallPath & "\icudttd28l.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icudttd28l.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icudttd28l.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icudttd28l.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuintd28.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuintd28.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuintd28.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuintd28.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuiotd28.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuiotd28.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuiotd28.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuiotd28.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\iculetd28.dll") then
		lf.WriteLine "File found : " & InstallPath & "\iculetd28.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\iculetd28.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\iculetd28.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\iculxtd28.dll") then
		lf.WriteLine "File found : " & InstallPath & "\iculxtd28.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\iculxtd28.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\iculxtd28.dll"
	end if

	if objFilesys.FileExists(InstallPath & "\icuuctd28.dll") then
		lf.WriteLine "File found : " & InstallPath & "\icuuctd28.dll"
		rc = objFilesys.DeleteFile(InstallPath & "\icuuctd28.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\icuuctd28.dll"
	end if
	
	if objFilesys.FileExists(InstallPath & "\MSVCP71.DLL") then
		lf.WriteLine "File found : " & InstallPath & "\MSVCP71.DLL"
		rc = objFilesys.DeleteFile(InstallPath & "\MSVCP71.DLL",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\MSVCP71.DLL"
	end if

	if objFilesys.FileExists(InstallPath & "\MSVCR71.DLL") then
		lf.WriteLine "File found : " & InstallPath & "\MSVCR71.DLL"
		rc = objFilesys.DeleteFile(InstallPath & "\MSVCR71.DLL",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\MSVCR71.DLL"
	end if

    if (Right(InstallPath,1) = "\") then
        InstallPath = Left(InstallPath,len(InstallPath)-1)
    end if
    'Remove left over folders
	if objFilesys.FolderExists(InstallPath) then
		lf.WriteLine "Folder found : " & InstallPath
		rc = objFilesys.DeleteFolder(InstallPath,true)
	else
		lf.WriteLine "Folder not found : " & InstallPath
	end if
    
    pos = InstrRev(InstallPath, "\")
    tmppath = Left(InstallPath,pos-1)
    lf.WriteLine "checking if Folder exists : " & tmppath
	if objFilesys.FolderExists(tmppath) then
		lf.WriteLine "Folder found : " & tmppath
		rc = objFilesys.DeleteFolder(tmppath,true)
	else
		lf.WriteLine "Folder not found : " & tmppath
	end if

    pos = InstrRev(tmppath, "\")
    tmppath = Left(tmppath,pos-1)

	if objFilesys.FolderExists(tmppath) then
		lf.WriteLine "Folder found : " & tmppath
		rc = objFilesys.DeleteFolder(tmppath,true)
	else
		lf.WriteLine "Folder not found : " & tmppath
	end if
	
case TTUProducts(2)	'CLIv2
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "wincli32.dll") then
		lf.WriteLine "File found : " & InstallPath & "wincli32.dll"
		rc = objFilesys.DeleteFile(InstallPath & "wincli32.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "wincli32.dll"
	end if

	'terasso.dll is not shipped with CLIv2
	if objFilesys.FileExists(InstallPath & "terasso.dll") then
		lf.WriteLine "File found : " & InstallPath & "terasso.dll"
		rc = objFilesys.DeleteFile(InstallPath & "terasso.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "terasso.dll"
	end if

	if objFilesys.FileExists(InstallPath & "tdusr32.dll") then
		lf.WriteLine "File found : " & InstallPath & "tdusr32.dll"
		rc = objFilesys.DeleteFile(InstallPath & "tdusr32.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdusr32.dll"
	end if

	if objFilesys.FileExists(InstallPath & "localisation.dll") then
		lf.WriteLine "File found : " & InstallPath & "localisation.dll"
		rc = objFilesys.DeleteFile(InstallPath & "localisation.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "localisation.dll"
	end if

	if objFilesys.FileExists(InstallPath & "clispb.dat") then
		lf.WriteLine "File found : " & InstallPath & "clispb.dat"
		rc = objFilesys.DeleteFile(InstallPath & "clispb.dat",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "clispb.dat"
	end if

	if objFilesys.FileExists(InstallPath & "\lib\tdusr32.lib") then
		lf.WriteLine "File found : " & InstallPath & "\lib\tdusr32.lib"
		rc = objFilesys.DeleteFile(InstallPath & "\lib\tdusr32.lib",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\lib\tdusr32.lib"
	end if

	if objFilesys.FileExists(InstallPath & "\lib\wincli32.lib") then
		lf.WriteLine "File found : " & InstallPath & "\lib\wincli32.lib"
		rc = objFilesys.DeleteFile(InstallPath & "\lib\wincli32.lib",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\lib\wincli32.lib"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\cliv2if.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\cliv2if.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\cliv2if.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\cliv2if.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\coperr.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\coperr.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\coperr.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\coperr.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\coptypes.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\coptypes.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\coptypes.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\coptypes.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\dbcacnx.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\dbcacnx.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\dbcacnx.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\dbcacnx.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\dbcarea.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\dbcarea.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\dbcarea.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\dbcarea.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\dbcerr.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\dbcerr.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\dbcerr.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\dbcerr.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\dbchqep.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\dbchqep.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\dbchqep.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\dbchqep.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\mosiif.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\mosiif.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\mosiif.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\mosiif.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\nojunk.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\nojunk.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\nojunk.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\nojunk.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\parcel.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\parcel.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\parcel.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\parcel.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\resource.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\resource.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\resource.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\resource.h"
	end if

	if objFilesys.FileExists(InstallPath & "\inc\wincliv2.h") then
		lf.WriteLine "File found : " & InstallPath & "\inc\wincliv2.h"
		rc = objFilesys.DeleteFile(InstallPath & "\inc\wincliv2.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\inc\wincliv2.h"
	end if

	if objFilesys.FileExists(InstallPath & "\clisamp\clisamp.c") then
		lf.WriteLine "File found : " & InstallPath & "\clisamp\clisamp.c"
		rc = objFilesys.DeleteFile(InstallPath & "\clisamp\clisamp.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\clisamp\clisamp.c"
	end if

	if objFilesys.FileExists(InstallPath & "\clisamp\makesamp.win") then
		lf.WriteLine "File found : " & InstallPath & "\clisamp\makesamp.win"
		rc = objFilesys.DeleteFile(InstallPath & "\clisamp\makesamp.win",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\clisamp\makesamp.win"
	end if

	if objFilesys.FileExists(InstallPath & "\UserExit\CliLgnEx.c") then
		lf.WriteLine "File found : " & InstallPath & "\UserExit\CliLgnEx.c"
		rc = objFilesys.DeleteFile(InstallPath & "\UserExit\CliLgnEx.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\UserExit\CliLgnEx.c"
	end if

	if objFilesys.FileExists(InstallPath & "\UserExit\CliPPS.c") then
		lf.WriteLine "File found : " & InstallPath & "\UserExit\CliPPS.c"
		rc = objFilesys.DeleteFile(InstallPath & "\UserExit\CliPPS.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\UserExit\CliPPS.c"
	end if

	if objFilesys.FileExists(InstallPath & "\UserExit\tdusr.def") then
		lf.WriteLine "File found : " & InstallPath & "\UserExit\tdusr.def"
		rc = objFilesys.DeleteFile(InstallPath & "\UserExit\tdusr.def",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\UserExit\tdusr.def"
	end if

	if objFilesys.FileExists(InstallPath & "\UserExit\tdusr.rc") then
		lf.WriteLine "File found : " & InstallPath & "\UserExit\tdusr.rc"
		rc = objFilesys.DeleteFile(InstallPath & "\UserExit\tdusr.rc",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\UserExit\tdusr.rc"
	end if

	if objFilesys.FileExists(InstallPath & "\UserExit\userexit.mak") then
		lf.WriteLine "File found : " & InstallPath & "\UserExit\userexit.mak"
		rc = objFilesys.DeleteFile(InstallPath & "\UserExit\userexit.mak",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\UserExit\userexit.mak"
	end if

	'Removing CLIv2 libraries from system32
	if objFilesys.FileExists(winroot & "\system32\wincli32.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\wincli32.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\wincli32.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\wincli32.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\tdusr32.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\tdusr32.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\tdusr32.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\tdusr32.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\terasso.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\terasso.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\terasso.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\terasso.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\localisation.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\localisation.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\localisation.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\localisation.dll"
	end if

case TTUProducts(3)	'TDODBC
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "_unodbc.dll") then
		lf.WriteLine "File found : " & InstallPath & "_unodbc.dll"
		rc = objFilesys.DeleteFile(InstallPath & "_unodbc.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "_unodbc.dll"
	end if

	if objFilesys.FileExists(InstallPath & "Pbodb0x0.txt") then
		lf.WriteLine "File found : " & InstallPath & "Pbodb0x0.txt"
		rc = objFilesys.DeleteFile(InstallPath & "Pbodb0x0.txt",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "Pbodb0x0.txt"
	end if

	if objFilesys.FileExists(InstallPath & "Readme.txt") then
		lf.WriteLine "File found : " & InstallPath & "Readme.txt"
		rc = objFilesys.DeleteFile(InstallPath & "Readme.txt",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "Readme.txt"
	end if

	if objFilesys.FileExists(InstallPath & "tdata32.dll") then
		lf.WriteLine "File found : " & InstallPath & "tdata32.dll"
		rc = objFilesys.DeleteFile(InstallPath & "tdata32.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdata32.dll"
	end if

	if objFilesys.FileExists(InstallPath & "tdatas32.dll") then
		lf.WriteLine "File found : " & InstallPath & "tdatas32.dll"
		rc = objFilesys.DeleteFile(InstallPath & "tdatas32.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdatas32.dll"
	end if

	if objFilesys.FileExists(InstallPath & "tdprsr32.dll") then
		lf.WriteLine "File found : " & InstallPath & "tdprsr32.dll"
		rc = objFilesys.DeleteFile(InstallPath & "tdprsr32.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdprsr32.dll"
	end if

	if objFilesys.FileExists(InstallPath & "terasso.dll") then
		lf.WriteLine "File found : " & InstallPath & "terasso.dll"
		rc = objFilesys.DeleteFile(InstallPath & "terasso.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "terasso.dll"
	end if

	'Deleting the ODBC Libraries from system32
	if objFilesys.FileExists(winroot & "\system32\tdata32.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\tdata32.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\tdata32.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\tdata32.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\tdatas32.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\tdatas32.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\tdatas32.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\tdatas32.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\tdprsr32.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\tdprsr32.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\tdprsr32.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\tdprsr32.dll"
	end if

	if objFilesys.FileExists(winroot & "\system32\terasso.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\terasso.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\terasso.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\terasso.dll"
	end if

    'Remove left over Start Menu entries
	if objFilesys.FolderExists(allusers_dir & "\Start Menu\Programs\ODBC Driver for Teradata") then
		lf.WriteLine "Folder found : " & allusers_dir & "\Start Menu\Programs\ODBC Driver for Teradata"
		rc = objFilesys.DeleteFolder(allusers_dir & "\Start Menu\Programs\ODBC Driver for Teradata",true)
	else
		lf.WriteLine "Folder not found : " & allusers_dir & "\Start Menu\Programs\ODBC Driver for Teradata"
	end if
case TTUProducts(4) 'PIOM
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "libpm.dll") then
		lf.WriteLine "File found : " & InstallPath & "libpm.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libpm.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libpm.dll"
	end if

	if objFilesys.FileExists(InstallPath & "pmddamt.h") then
		lf.WriteLine "File found : " & InstallPath & "pmddamt.h"
		rc = objFilesys.DeleteFile(InstallPath & "pmddamt.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "pmddamt.h"
	end if

	if objFilesys.FileExists(InstallPath & "pmdcomt.h") then
		lf.WriteLine "File found : " & InstallPath & "pmdcomt.h"
		rc = objFilesys.DeleteFile(InstallPath & "pmdcomt.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "pmdcomt.h"
	end if
case TTUProducts(5) 'BTEQ
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "bin\bteq.exe") then
		lf.WriteLine "File found : " & InstallPath & "bin\bteq.exe"
		rc = objFilesys.DeleteFile(InstallPath & "bin\bteq.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\bteq.exe"
	end if

	if objFilesys.FileExists(InstallPath & "bin\bteqwin.exe") then
		lf.WriteLine "File found : " & InstallPath & "bin\bteqwin.exe"
		rc = objFilesys.DeleteFile(InstallPath & "bin\bteqwin.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\bteqwin.exe"
	end if

	if objFilesys.FileExists(InstallPath & "bin\mgrcli.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\mgrcli.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\mgrcli.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\mgrcli.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\ncrtmgr.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\ncrtmgr.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\ncrtmgr.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\ncrtmgr.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\printman.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\printman.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\printman.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\printman.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\tdis.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\tdis.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\tdis.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\tdis.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\tm_dialogs.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\tm_dialogs.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\tm_dialogs.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\tm_dialogs.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\tm_stat.dll") then
		lf.WriteLine "File found : " & InstallPath & "bin\tm_stat.dll"
		rc = objFilesys.DeleteFile(InstallPath & "bin\tm_stat.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\tm_stat.dll"
	end if

	if objFilesys.FileExists(InstallPath & "bin\bteqwin_enu.cnt") then
		lf.WriteLine "File found : " & InstallPath & "bin\bteqwin_enu.cnt"
		rc = objFilesys.DeleteFile(InstallPath & "bin\bteqwin_enu.cnt",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\bteqwin_enu.cnt"
	end if

	if objFilesys.FileExists(InstallPath & "bin\BTEQWIN_ENU.HLP") then
		lf.WriteLine "File found : " & InstallPath & "bin\BTEQWIN_ENU.HLP"
		rc = objFilesys.DeleteFile(InstallPath & "bin\BTEQWIN_ENU.HLP",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\BTEQWIN_ENU.HLP"
	end if

	if objFilesys.FileExists(InstallPath & "bin\teqtalk.ico") then
		lf.WriteLine "File found : " & InstallPath & "bin\teqtalk.ico"
		rc = objFilesys.DeleteFile(InstallPath & "bin\teqtalk.ico",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\teqtalk.ico"
	end if

	if objFilesys.FileExists(InstallPath & "btnfy\btnfyext.c") then
		lf.WriteLine "File found : " & InstallPath & "btnfy\btnfyext.c"
		rc = objFilesys.DeleteFile(InstallPath & "btnfy\btnfyext.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "btnfy\btnfyext.c"
	end if

	if objFilesys.FileExists(InstallPath & "btnfy\btnfyext.def") then
		lf.WriteLine "File found : " & InstallPath & "btnfy\btnfyext.def"
		rc = objFilesys.DeleteFile(InstallPath & "btnfy\btnfyext.def",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "btnfy\btnfyext.def"
	end if

	if objFilesys.FileExists(InstallPath & "btnfy\btnfyext.h") then
		lf.WriteLine "File found : " & InstallPath & "btnfy\btnfyext.h"
		rc = objFilesys.DeleteFile(InstallPath & "btnfy\btnfyext.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "btnfy\btnfyext.h"
	end if

	if objFilesys.FileExists(InstallPath & "btnfy\btnfyext.mak") then
		lf.WriteLine "File found : " & InstallPath & "btnfy\btnfyext.mak"
		rc = objFilesys.DeleteFile(InstallPath & "btnfy\btnfyext.mak",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "btnfy\btnfyext.mak"
	end if

	if objFilesys.FileExists(winroot & "\system32\caputl.dll") then
		lf.WriteLine "File found : " & winroot & "\system32\caputl.dll"
		rc = objFilesys.DeleteFile(winroot & "\system32\caputl.dll",true)
	else
		lf.WriteLine "File not found : " & winroot & "\system32\caputl.dll"
	end if

    'Remove the folder
	if objFilesys.FolderExists(InstallPath & "btnfy") then
		lf.WriteLine "Folder found : " & InstallPath & "btnfy"
		rc = objFilesys.DeleteFolder(InstallPath & "btnfy",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "fexp"
	end if

    'Remove left over Start Menu entries
    tmppath = allusers_dir & "\Start Menu\Programs\Teradata Client\BTEQ.lnk"
	if objFilesys.FileExists(chr(34) & tmppath & chr(34)) then
		lf.WriteLine "File found : " & tmppath
		rc = objFilesys.DeleteFile(chr(34) & tmppath & chr(34),true)
	else
		lf.WriteLine "File not found : " & tmppath
	end if

    tmppath = allusers_dir & "\Start Menu\Programs\Teradata Client\BTEQWin.lnk"
	if objFilesys.FileExists(tmppath) then
		lf.WriteLine "File found : " & tmppath
		rc = objFilesys.DeleteFile(tmppath,true)
	else
		lf.WriteLine "File not found : " & tmppath
	end if
	
case TTUProducts(6) 'FASTLD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "\bin\fastload.exe") then
		lf.WriteLine "File found : " & InstallPath & "\bin\fastload.exe"
		rc = objFilesys.DeleteFile(InstallPath & "\bin\fastload.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\bin\fastload.exe"
	end if

	if objFilesys.FileExists(InstallPath & "\fastload\blkexit.c") then
		lf.WriteLine "File found : " & InstallPath & "\fastload\blkexit.c"
		rc = objFilesys.DeleteFile(InstallPath & "\fastload\blkexit.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\fastload\blkexit.c"
	end if

	if objFilesys.FileExists(InstallPath & "\fastload\blkexit.mak") then
		lf.WriteLine "File found : " & InstallPath & "\fastload\blkexit.mak"
		rc = objFilesys.DeleteFile(InstallPath & "\fastload\blkexit.mak",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\fastload\blkexit.mak"
	end if
	
	if objFilesys.FileExists(InstallPath & "\fastload\blkexitr.c") then
		lf.WriteLine "File found : " & InstallPath & "\fastload\blkexitr.c"
		rc = objFilesys.DeleteFile(InstallPath & "\fastload\blkexitr.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\fastload\blkexitr.c"
	end if

	if objFilesys.FileExists(InstallPath & "\fastload\flnfyext.c") then
		lf.WriteLine "File found : " & InstallPath & "\fastload\flnfyext.c"
		rc = objFilesys.DeleteFile(InstallPath & "\fastload\flnfyext.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\fastload\flnfyext.c"
	end if
case TTUProducts(7) 'MLOAD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "bin\mload.exe") then
		lf.WriteLine "File found : " & InstallPath & "bin\mload.exe"
		rc = objFilesys.DeleteFile(InstallPath & "bin\mload.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\mload.exe"
	end if

	if objFilesys.FileExists(InstallPath & "mload\mlimod.c") then
		lf.WriteLine "File found : " & InstallPath & "mload\mlimod.c"
		rc = objFilesys.DeleteFile(InstallPath & "mload\mlimod.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "mload\mlimod.c"
	end if

	if objFilesys.FileExists(InstallPath & "mload\mlnotf.c") then
		lf.WriteLine "File found : " & InstallPath & "mload\mlnotf.c"
		rc = objFilesys.DeleteFile(InstallPath & "mload\mlnotf.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "mload\mlnotf.c"
	end if
case TTUProducts(8) 'FASTEXP
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "bin\fexp.exe") then
		lf.WriteLine "File found : " & InstallPath & "bin\fexp.exe"
		rc = objFilesys.DeleteFile(InstallPath & "bin\fexp.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\fexp.exe"
	end if

	if objFilesys.FileExists(InstallPath & "fexp\feimod.c") then
		lf.WriteLine "File found : " & InstallPath & "fexp\feimod.c"
		rc = objFilesys.DeleteFile(InstallPath & "fexp\feimod.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "fexp\feimod.c"
	end if

	if objFilesys.FileExists(InstallPath & "fexp\fenotf.c") then
		lf.WriteLine "File found : " & InstallPath & "fexp\fenotf.c"
		rc = objFilesys.DeleteFile(InstallPath & "fexp\fenotf.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "fexp\fenotf.c"
	end if

	if objFilesys.FileExists(InstallPath & "fexp\feomod.c") then
		lf.WriteLine "File found : " & InstallPath & "fexp\feomod.c"
		rc = objFilesys.DeleteFile(InstallPath & "fexp\feomod.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "fexp\feomod.c"
	end if

    'Remove the folder
	if objFilesys.FolderExists(InstallPath & "fexp") then
		lf.WriteLine "Folder found : " & InstallPath & "fexp"
		rc = objFilesys.DeleteFolder(InstallPath & "fexp",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "fexp"
	end if

    'Remove left over Start Menu entries
	if objFilesys.FileExists(chr(34) & allusers_dir & "\Start Menu\Programs\Teradata Client\Teradata FastExport.lnk" & chr(34)) then
		lf.WriteLine "File found : " & chr(34) & allusers_dir & "\Start Menu\Programs\Teradata Client\Teradata FastExport.lnk" & chr(34)
		rc = objFilesys.DeleteFile(allusers_dir & "\Start Menu\Programs\Teradata Client\Teradata FastExport.lnk",true)
	else
		lf.WriteLine "File not found : " & allusers_dir & "\Start Menu\Programs\Teradata Client\Teradata FastExport.lnk"
	end if
	
case TTUProducts(9) 'TPUMP
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "bin\tpump.exe") then
		lf.WriteLine "File found : " & InstallPath & "bin\tpump.exe"
		rc = objFilesys.DeleteFile(InstallPath & "bin\tpump.exe",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "bin\tpump.exe"
	end if

	if objFilesys.FileExists(InstallPath & "tpump\tdatpump.cfg") then
		lf.WriteLine "File found : " & InstallPath & "tpump\tdatpump.cfg"
		rc = objFilesys.DeleteFile(InstallPath & "tpump\tdatpump.cfg",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tpump\tdatpump.cfg"
	end if

	if objFilesys.FileExists(InstallPath & "tpump\tldnfyxt.c") then
		lf.WriteLine "File found : " & InstallPath & "tpump\tldnfyxt.c"
		rc = objFilesys.DeleteFile(InstallPath & "tpump\tldnfyxt.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tpump\tldnfyxt.c"
	end if

	if objFilesys.FileExists(InstallPath & "tpump\tpumpar.csql") then
		lf.WriteLine "File found : " & InstallPath & "tpump\tpumpar.csql"
		rc = objFilesys.DeleteFile(InstallPath & "tpump\tpumpar.csql",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tpump\tpumpar.csql"
	end if

	if objFilesys.FileExists(InstallPath & "tpump\tpumpimd.c") then
		lf.WriteLine "File found : " & InstallPath & "tpump\tpumpimd.c"
		rc = objFilesys.DeleteFile(InstallPath & "tpump\tpumpimd.c",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tpump\tpumpimd.c"
	end if
case TTUProducts(10) 'TDOLEDB
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "msvcp71.dll") then
		lf.WriteLine "File found : " & InstallPath & "msvcp71.dll"
		rc = objFilesys.DeleteFile(InstallPath & "msvcp71.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "msvcp71.dll"
	end if

	if objFilesys.FileExists(InstallPath & "msvcr71.dll") then
		lf.WriteLine "File found : " & InstallPath & "msvcr71.dll"
		rc = objFilesys.DeleteFile(InstallPath & "msvcr71.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "msvcr71.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TD_OC.dll") then
		lf.WriteLine "File found : " & InstallPath & "TD_OC.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TD_OC.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TD_OC.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TD_OCPR.dll") then
		lf.WriteLine "File found : " & InstallPath & "TD_OCPR.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TD_OCPR.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TD_OCPR.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TD_OCPR.dll") then
		lf.WriteLine "File found : " & InstallPath & "TD_OCPR.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TD_OCPR.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TD_OCPR.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TD_RT.dll") then
		lf.WriteLine "File found : " & InstallPath & "TD_RT.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TD_RT.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TD_RT.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TD_TL.dll") then
		lf.WriteLine "File found : " & InstallPath & "TD_TL.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TD_TL.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TD_TL.dll"
	end if

	if objFilesys.FileExists(InstallPath & "TDOLEDB.dll") then
		lf.WriteLine "File found : " & InstallPath & "TDOLEDB.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TDOLEDB.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TDOLEDB.dll"
	end if

	if objFilesys.FileExists(InstallPath & "tdoledb.h") then
		lf.WriteLine "File found : " & InstallPath & "tdoledb.h"
		rc = objFilesys.DeleteFile(InstallPath & "tdoledb.h",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdoledb.h"
	end if

	if objFilesys.FileExists(InstallPath & "TDOLEDB_TEST.udl") then
		lf.WriteLine "File found : " & InstallPath & "TDOLEDB_TEST.udl"
		rc = objFilesys.DeleteFile(InstallPath & "TDOLEDB_TEST.udl",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TDOLEDB_TEST.udl"
	end if

	if objFilesys.FileExists(InstallPath & "TDOLEDBR.dll") then
		lf.WriteLine "File found : " & InstallPath & "TDOLEDBR.dll"
		rc = objFilesys.DeleteFile(InstallPath & "TDOLEDBR.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "TDOLEDBR.dll"
	end if
case TTUProducts(11) 'SQLPP
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "LABSBTEQ") then
		lf.WriteLine "File found : " & InstallPath & "LABSBTEQ"
		rc = objFilesys.DeleteFile(InstallPath & "LABSBTEQ",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "LABSBTEQ"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB1") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB1"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB1",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB1"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB2") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB2"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB2",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB2"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB3") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB3"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB3",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB3"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB4") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB4"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB4",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB4"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB5") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB5"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB5",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB5"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB6") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB6"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB6",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB6"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB7") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB7"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB7",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB7"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB8") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB8"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB8",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB8"
	end if

	if objFilesys.FileExists(InstallPath & "PPCLB9") then
		lf.WriteLine "File found : " & InstallPath & "PPCLB9"
		rc = objFilesys.DeleteFile(InstallPath & "PPCLB9",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "PPCLB9"
	end if

	if objFilesys.FileExists(InstallPath & "ppruntim.dll") then
		lf.WriteLine "File found : " & InstallPath & "ppruntim.dll"
		rc = objFilesys.DeleteFile(InstallPath & "ppruntim.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "ppruntim.dll"
	end if

	if objFilesys.FileExists(InstallPath & "ppruntim.lib") then
		lf.WriteLine "File found : " & InstallPath & "ppruntim.lib"
		rc = objFilesys.DeleteFile(InstallPath & "ppruntim.lib",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "ppruntim.lib"
	end if

	TempInstallPath=replace(InstallPath,"pp2","bin")
	if objFilesys.FileExists(TempInstallPath & "ppcmain.exe") then
		lf.WriteLine "File found : " & TempInstallPath & "ppcmain.exe"
		rc = objFilesys.DeleteFile(TempInstallPath & "ppcmain.exe",true)
	else
		lf.WriteLine "File not found : " & TempInstallPath & "ppcmain.exe"
	end if
case TTUProducts(12) 'NPAXSMOD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "np_AXSMOD.dll") then
		lf.WriteLine "File found : " & InstallPath & "np_AXSMOD.dll"
		rc = objFilesys.DeleteFile(InstallPath & "np_AXSMOD.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "np_AXSMOD.dll"
	end if

	if objFilesys.FileExists(InstallPath & "np_AXSMODenu.dll") then
		lf.WriteLine "File found : " & InstallPath & "np_AXSMODenu.dll"
		rc = objFilesys.DeleteFile(InstallPath & "np_AXSMODenu.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "np_AXSMODenu.dll"
	end if

	if objFilesys.FileExists(InstallPath & "np_AXSMODenuTWB.dll") then
		lf.WriteLine "File found : " & InstallPath & "np_AXSMODenuTWB.dll"
		rc = objFilesys.DeleteFile(InstallPath & "np_AXSMODenuTWB.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "np_AXSMODenuTWB.dll"
	end if

	if objFilesys.FileExists(InstallPath & "np_AXSMODTWB.dll") then
		lf.WriteLine "File found : " & InstallPath & "np_AXSMODTWB.dll"
		rc = objFilesys.DeleteFile(InstallPath & "np_AXSMODTWB.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "np_AXSMODTWB.dll"
	end if
case TTUProducts(13) 'MQAXSMOD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "libmqs.dll") then
		lf.WriteLine "File found : " & InstallPath & "libmqs.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libmqs.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libmqs.dll"
	end if

	if objFilesys.FileExists(InstallPath & "libmqsc.dll") then
		lf.WriteLine "File found : " & InstallPath & "libmqsc.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libmqsc.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libmqsc.dll"
	end if

	if objFilesys.FileExists(InstallPath & "libmqscTWB.dll") then
		lf.WriteLine "File found : " & InstallPath & "libmqscTWB.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libmqscTWB.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libmqscTWB.dll"
	end if

	if objFilesys.FileExists(InstallPath & "libmqsTWB.dll") then
		lf.WriteLine "File found : " & InstallPath & "libmqsTWB.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libmqsTWB.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libmqsTWB.dll"
	end if
case TTUProducts(14) 'OLEDBAXSMOD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "msvcr71.dll") then
		lf.WriteLine "File found : " & InstallPath & "msvcr71.dll"
		rc = objFilesys.DeleteFile(InstallPath & "msvcr71.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "msvcr71.dll"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMOD.dll") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMOD.dll"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMOD.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMOD.dll"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODenu.cnt") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODenu.cnt"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODenu.cnt",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODenu.cnt"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODenu.dll") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODenu.dll"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODenu.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODenu.dll"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODENU.HLP") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODENU.HLP"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODENU.HLP",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODENU.HLP"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODjpn.cnt") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODjpn.cnt"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODjpn.cnt",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODjpn.cnt"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODjpn.dll") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODjpn.dll"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODjpn.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODjpn.dll"
	end if

	if objFilesys.FileExists(InstallPath & "OLEDB_AXSMODJPN.HLP") then
		lf.WriteLine "File found : " & InstallPath & "OLEDB_AXSMODJPN.HLP"
		rc = objFilesys.DeleteFile(InstallPath & "OLEDB_AXSMODJPN.HLP",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "OLEDB_AXSMODJPN.HLP"
	end if

	if objFilesys.FileExists(InstallPath & "program.ico") then
		lf.WriteLine "File found : " & InstallPath & "program.ico"
		rc = objFilesys.DeleteFile(InstallPath & "program.ico",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "program.ico"
	end if

	if objFilesys.FileExists(InstallPath & "Uninst.dll") then
		lf.WriteLine "File found : " & InstallPath & "Uninst.dll"
		rc = objFilesys.DeleteFile(InstallPath & "Uninst.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "Uninst.dll"
	end if

	if objFilesys.FolderExists(InstallPath & "Teradata OLE DB Access Module Help") then
		lf.WriteLine "Folder found : " & InstallPath & "Teradata OLE DB Access Module Help"
		rc = objFilesys.DeleteFolder(InstallPath & "Teradata OLE DB Access Module Help",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "Teradata OLE DB Access Module Help"
	end if

	TempInstallPath="C:\Program Files\" & CompanyName & "\Teradata Client\Bin"
	if objFilesys.FileExists(TempInstallPath & "OleLoad.exe") then
		lf.WriteLine "File found : " & TempInstallPath & "OleLoad.exe"
		rc = objFilesys.DeleteFile(TempInstallPath & "OleLoad.exe",true)
	else
		lf.WriteLine "File not found : " & TempInstallPath & "OleLoad.exe"
	end if

	if objFilesys.FileExists(TempInstallPath & "OleLoadKeyFile.txt") then
		lf.WriteLine "File found : " & TempInstallPath & "OleLoadKeyFile.txt"
		rc = objFilesys.DeleteFile(TempInstallPath & "OleLoadKeyFile.txt",true)
	else
		lf.WriteLine "File not found : " & TempInstallPath & "OleLoadKeyFile.txt"
	end if
case TTUProducts(15) 'JMSAXSMOD
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "libjmsam.dll") then
		lf.WriteLine "File found : " & InstallPath & "libjmsam.dll"
		rc = objFilesys.DeleteFile(InstallPath & "libjmsam.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "libjmsam.dll"
	end if

	if objFilesys.FileExists(InstallPath & "readme") then
		lf.WriteLine "File found : " & InstallPath & "readme"
		rc = objFilesys.DeleteFile(InstallPath & "readme",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "readme"
	end if

	if objFilesys.FileExists(InstallPath & "Receiver.class") then
		lf.WriteLine "File found : " & InstallPath & "Receiver.class"
		rc = objFilesys.DeleteFile(InstallPath & "Receiver.class",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "Receiver.class"
	end if
'TSET, VECOMP, TIWIZ, TSWIZ, TWA, TDADMIN, TDWM
case TTUProducts(17),   _
    TTUProducts(18),    _
    TTUProducts(19),    _
    TTUProducts(20),    _
    TTUProducts(25),    _
    TTUProducts(27),    _
    TTUProducts(28)
    'Remove left over folder & files 
	if objFilesys.FolderExists(InstallPath) then
		lf.WriteLine "Folder found & deleted : " & InstallPath
		rc = objFilesys.DeleteFolder(InstallPath,true)
	else
		lf.WriteLine "Folder not found : " & InstallPath
	end if

    'Remove left over Start Menu entries
	if objFilesys.FileExists(allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version & ".lnk") then
		lf.WriteLine "File found : " & allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version & ".lnk"
		rc = objFilesys.DeleteFile(allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version & ".lnk",true)
	else
		lf.WriteLine "File not found : " & allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version & ".lnk"
	end if
'PMON, TMGR
case TTUProducts(21),   _
    TTUProducts(26)
    'Remove left over folder & files 
	if objFilesys.FolderExists(InstallPath) then
		lf.WriteLine "Folder found & deleted : " & InstallPath
		rc = objFilesys.DeleteFolder(InstallPath,true)
	else
		lf.WriteLine "Folder not found : " & InstallPath
	end if

    'Remove left over Start Menu entries
	if objFilesys.FolderExists(allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version) then
		lf.WriteLine "Folder found : " & allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version
		rc = objFilesys.DeleteFolder(allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version,true)
	else
		lf.WriteLine "Folder not found : " & allusers_dir & "\Start Menu\Programs\" & ProductName & " " & short_version
	end if
case TTUProducts(22)    'TQSADMIN
    'Remove left over folder & files 
	if objFilesys.FolderExists(InstallPath) then
		lf.WriteLine "Folder found & deleted : " & InstallPath
		rc = objFilesys.DeleteFolder(InstallPath,true)
	else
		lf.WriteLine "Folder not found : " & InstallPath
	end if

    'Remove left over Start Menu entries
	if objFilesys.FolderExists(allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler Admin" & " " & short_version) then
		lf.WriteLine "Folder found : " & allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler Admin" & " " & short_version
		rc = objFilesys.DeleteFolder(allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler Admin" & " " & short_version,true)
	else
		lf.WriteLine "Folder not found : " & allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler Admin" & " " & short_version
	end if
case TTUProducts(23)    'TQSSERVER
    'Remove left over folder & files 
	if objFilesys.FolderExists(InstallPath & "\server") then
		lf.WriteLine "Folder found & deleted : " & InstallPath & "\server"
		rc = objFilesys.DeleteFolder(InstallPath & "\server",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "\server"
	end if
case TTUProducts(24)    'TQSCLIENT
    'Remove left over folder & files 
	if objFilesys.FolderExists(InstallPath & "\client") then
		lf.WriteLine "Folder found & deleted : " & InstallPath & "\client"
		rc = objFilesys.DeleteFolder(InstallPath & "\client",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "\client"
	end if

	if objFilesys.FolderExists(InstallPath & "\Help") then
		lf.WriteLine "Folder found & deleted : " & InstallPath & "\Help"
		rc = objFilesys.DeleteFolder(InstallPath & "\Help",true)
	else
		lf.WriteLine "Folder not found : " & InstallPath & "\Help"
	end if

	if objFilesys.FileExists(InstallPath & "\README.TXT") then
		lf.WriteLine "File found & deleted : " & InstallPath & "\README.TXT"
		rc = objFilesys.DeleteFile(InstallPath & "\README.TXT",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "\README.TXT"
	end if

    'Remove left over Start Menu entries
	if objFilesys.FolderExists(allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler" & " " & short_version) then
		lf.WriteLine "Folder found : " & allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler" & " " & short_version
		rc = objFilesys.DeleteFolder(allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler" & " " & short_version,true)
	else
		lf.WriteLine "Folder not found : " & allusers_dir & "\Start Menu\Programs\Teradata Query Scheduler" & " " & short_version
	end if
case TTUProducts(48)    'TDWALLET
    'Remove left over folder & files 
    if (Proc_Arch = "AMD64") then   '64-bit System
	    folderpath=InstallPath & short_version & "\tdwallet"
   	    if (Package_64bit = true) then  '64-bit TDWALLET package
	        if objFilesys.FolderExists(folderpath & "\nt-x8664") then
                folderpath1=replace(folderpath,"Program Files", "Program Files (x86)")

          	    tdlink_path = replace(folderpath,"Program Files","PROGRA~1") & "\nt-x8664\tdlink.exe"
          	    junction_path = replace(folderpath1,"Program Files (x86)","PROGRA~2") & "\nt-x8664"
                lf.WriteLine "Deleting the link using the command : " & "cmd /C " & tdlink_path & " -d " & junction_path
                rc = shellobj.Run("cmd /C " & tdlink_path & " -d " & junction_path,0,true)    
                lf.WriteLine "Deleting the link using the command  rc : " & rc

    	        WScript.Sleep 5000
		        lf.WriteLine "Folder found & deleted : " & folderpath & "\nt-x8664"
    	        rc = objFilesys.DeleteFolder(folderpath & "\nt-x8664",true)

                if objFilesys.FolderExists(folderpath1 & "\nt-i386") then
                    lf.WriteLine "32-bit TDWALLET package exists on the machine hence not deleting config.xml.."
                else
   	                if objFilesys.FileExists(folderpath & "\config.xml") then
		                lf.WriteLine "File found & deleted : " & folderpath & "\config.xml"
		                rc = objFilesys.DeleteFile(folderpath & "\config.xml",true)
	                else
		                lf.WriteLine "File not found : " & folderpath & "\config.xml"
	                end if

   	                if objFilesys.FileExists(folderpath1 & "\config.xml") then
		                lf.WriteLine "File found & deleted : " & folderpath1 & "\config.xml"
		                rc = objFilesys.DeleteFile(folderpath1 & "\config.xml",true)
	                else
		                lf.WriteLine "File not found : " & folderpath1 & "\config.xml"
	                end if

		            lf.WriteLine "Folder found & deleted : " & folderpath
    	            rc = objFilesys.DeleteFolder(folderpath,true)

		            lf.WriteLine "Folder found & deleted : " & folderpath1
    	            rc = objFilesys.DeleteFolder(folderpath1,true)
	            end if
	        else
    	        lf.WriteLine "Folder not found : " & folderpath & "\nt-x8664"
            end if
	    else    '32-bit TDWALLET package
	        if objFilesys.FolderExists(folderpath & "\nt-i386") then
                folderpath1=replace(folderpath,"Program Files (x86)", "Program Files")

          	    tdlink_path = replace(folderpath,"Program Files (x86)","PROGRA~2") & "\nt-i386\tdlink.exe"
          	    junction_path = replace(folderpath1,"Program Files","PROGRA~1") & "\nt-i386"
                lf.WriteLine "Deleting the link using the command : " & "cmd /C " & tdlink_path & " -d " & junction_path
                rc = shellobj.Run("cmd /C " & tdlink_path & " -d " & junction_path,0,true)    
                lf.WriteLine "Deleting the link using the command  rc : " & rc

    	        WScript.Sleep 5000
		        lf.WriteLine "Folder found & deleted : " & folderpath & "\nt-i386"
    	        rc = objFilesys.DeleteFolder(folderpath & "\nt-i386",true)

                if objFilesys.FolderExists(folderpath1 & "\nt-x8664") then
                    lf.WriteLine "64-bit TDWALLET package exists on the machine hence not deleting config.xml.."
                else
   	                if objFilesys.FileExists(folderpath & "\config.xml") then
		                lf.WriteLine "File found & deleted : " & folderpath & "\config.xml"
		                rc = objFilesys.DeleteFile(folderpath & "\config.xml",true)
	                else
		                lf.WriteLine "File not found : " & folderpath & "\config.xml"
	                end if

   	                if objFilesys.FileExists(folderpath1 & "\config.xml") then
		                lf.WriteLine "File found & deleted : " & folderpath1 & "\config.xml"
		                rc = objFilesys.DeleteFile(folderpath1 & "\config.xml",true)
	                else
		                lf.WriteLine "File not found : " & folderpath1 & "\config.xml"
	                end if

		            lf.WriteLine "Folder found & deleted : " & folderpath
    	            rc = objFilesys.DeleteFolder(folderpath,true)

		            lf.WriteLine "Folder found & deleted : " & folderpath1
    	            rc = objFilesys.DeleteFolder(folderpath1,true)
	            end if
	        else
    	        lf.WriteLine "Folder not found : " & folderpath & "\nt-i386"
            end if
	    end if
    else    '32-bit System
	    folderpath=InstallPath & short_version & "\tdwallet" 

	    if objFilesys.FolderExists(folderpath) then
		    lf.WriteLine "Folder found & deleted : " & folderpath
    	    rc = objFilesys.DeleteFolder(folderpath,true)
	    else
    	    lf.WriteLine "Folder not found : " & folderpath
        end if
    end if
case TTUProducts(50) 'TDGEOSPATIAL
	'Check if files exist on the machine
	if objFilesys.FileExists(InstallPath & "geojni.dll") then
		lf.WriteLine "File found : " & InstallPath & "geojni.dll"
		rc = objFilesys.DeleteFile(InstallPath & "geojni.dll",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "geojni.dll"
	end if

	if objFilesys.FileExists(InstallPath & "readme") then
		lf.WriteLine "File found : " & InstallPath & "readme"
		rc = objFilesys.DeleteFile(InstallPath & "readme",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "readme"
	end if

	if objFilesys.FileExists(InstallPath & "tdgeospatial.jar") then
		lf.WriteLine "File found : " & InstallPath & "tdgeospatial.jar"
		rc = objFilesys.DeleteFile(InstallPath & "tdgeospatial.jar",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdgeospatial.jar"
	end if
	
	if objFilesys.FileExists(InstallPath & "tdgeospatial_charsets.properties") then
		lf.WriteLine "File found : " & InstallPath & "tdgeospatial_charsets.properties"
		rc = objFilesys.DeleteFile(InstallPath & "tdgeospatial_charsets.properties",true)
	else
		lf.WriteLine "File not found : " & InstallPath & "tdgeospatial_charsets.properties"
	end if
end select

End Function

'=====================================================================================================================================================
'Verifies that all the registry entries for a product are deleted. If any registry entry is found, it is deleted forcibly.
Function VerifyRegistryEntries(ByVal ProductName, ByVal ProductCode, ByVal ProductVersion)
Dim Inparams1
Dim Outparam1
Dim regtxt
Dim tdgssarch_txt
Dim version_key

    if (Wow6432Node = False) then
        regtxt = "\"
        If (Package_64bit = True) Then
        	tdgssarch_txt= "nt-x8664\"
        Else
        	tdgssarch_txt= "nt-i386\"
        End If
    else
        regtxt = "\Wow6432Node\"
        tdgssarch_txt= "nt-i386\"
    end if    
    
	'Check for registry entries in HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductCode
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
	if (Outparams1.ReturnValue = 0) then
		rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductCode & chr(34) & " /f",0,true)
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductCode & " entry found and deleted..."
	else
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductCode & " entry not found..."
	end if

	'Check for registry entries in HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\InstallShield_{Product_Code}
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\Installshield_" & ProductCode
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
	if (Outparams1.ReturnValue = 0) then
		rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\Installshield_" & ProductCode & chr(34) & " /f",0,true)
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\Installsheild_" & ProductCode & " entry found and deleted..."
	else
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\Installsheild_" & ProductCode & " entry not found..."
	end if

	'Check for registry entries in HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\InstallShield Uninstall Information 
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\InstallShield Uninstall Information\" & ProductCode
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
	if (Outparams1.ReturnValue = 0) then
		rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\InstallShield Uninstall Information\" & ProductCode & chr(34) & " /f",0,true)
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\InstallShield Uninstall Information\" & ProductCode & " entry found and deleted..."
	else
		lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\InstallShield Uninstall Information\" & ProductCode & " entry not found..."
	end if

    if (ProductVersion <> "") then
        Select case ProductName
        'For the following products the registry entry contains the short version number.
        'TSET, VECOMP, TIWIZ, TSWIZ, TWA
        case TTUProducts(17),   _
            TTUProducts(18),    _
            TTUProducts(19),    _
            TTUProducts(20),    _
            TTUProducts(25)
	        'Check for registry entries in HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall
	        Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	        Inparams1.Hdefkey = HKLM
	        Inparams1.Ssubkeyname = "Software" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " " & short_version
	        Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
	        if (Outparams1.ReturnValue = 0) then
		        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " " & short_version & chr(34) & " /f",0,true)
		        lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " " & short_version & " entry found and deleted..."
	        else
		        lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " " & short_version & " entry not found..."
	        end if
        case else   'For all other products
	        'Check for registry entries in HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall
	        Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	        Inparams1.Hdefkey = HKLM
	        Inparams1.Ssubkeyname = "Software" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName
	        Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
	        if (Outparams1.ReturnValue = 0) then
		        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & chr(34) & " /f",0,true)
		        lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " entry found and deleted..."
	        else
		        lf.WriteLine "HKLM\SOFTWARE" & regtxt & "Microsoft\Windows\CurrentVersion\Uninstall\" & ProductName & " entry not found..."
	        end if
        end select

        Select case ProductName
	    case TTUProducts(1) 'TDICU 
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    if (CInt(short_ver_first_part) < 13) then   'NCR
                Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
            else    'Teradata
                Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & short_version & "\" & ProductName
            end if
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    if (CInt(short_ver_first_part) < 13) then   'NCR
    		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName & "64"
            else    'Teradata
                Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & short_version & "\" & ProductName & "64"
            end if
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
		    'Check for registry entries in HKLM\Software\CompanyName\TDICU. Earlier versions of TDICU created this entry.
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & "TDICU"
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "TDICU" & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & "TDICU" & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & "TDICU" & " entry not found..."
		    end if
		    'Check for registry entries in HKLM\Software\CompanyName\TDICU64. Earlier versions of TDICU created this entry.
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & "TDICU64"
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & "TDICU64" & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & "TDICU64" & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & "TDICU64" & " entry not found..."
		    end if
        case TTUProducts(2) 'CLIv2
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    if (CInt(short_ver_first_part) < 13) then   'NCR
    		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
            else    'Teradata
       		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & short_version & "\" & ProductName
            end if
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
		    'Check for registry entries in HKLM\Software\CompanyName\Teradata CLI2. Earlier versions of CLIv2 created two entries.
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Teradata CLI2"
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\Teradata CLI2" & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\Teradata CLI2" & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\Teradata CLI2" & " entry not found..."
		    end if
	    case TTUProducts(16)    'SQLA
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " entry not found..."
		    end if
		    'Check for registry entries in HKLM\Software\CompanyName\SQLAssistant. Older versions have this entry.
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\SQLAssistant" 
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\SQLAssistant" & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\SQLAssistant" & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\SQLAssistant" & " entry not found..."
		    end if
        case TTUProducts(26) 'TMGR
		    'Check for registry entries in HKLM\Software\CompanyName\TeradataManager
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\TeradataManager"
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\TeradataManager" & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\TeradataManager" & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\TeradataManager" & " entry not found..."
		    end if
	    'For all other DBM products : TSET, VECOMP, TIWIZ, TSWIZ, TWA, TQS, TSAW, TDWM 
	    case TTUProducts(17),   _
            TTUProducts(18),    _
            TTUProducts(19),    _
            TTUProducts(20),    _
            TTUProducts(21),    _
            TTUProducts(22),    _
            TTUProducts(23),    _
            TTUProducts(24),    _
            TTUProducts(25),    _
            TTUProducts(28),    _
            TTUProducts(29)	     
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " entry not found..."
		    end if
	    'TDADMIN
	    case TTUProducts(27)
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " " & short_version & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " " & short_version  & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\SOFTWARE" & regtxt & CompanyName & "\" & ProductName & " " & short_version  & " entry not found..."
		    end if
	    case TTUProducts(48)	'TDWALLET
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
   		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & ProductName
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
	    case TTUProducts(49)	'TDNETDP
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
   		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName & "\" & ProductVersion
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
		 case TTUProducts(0)	'TeraGSS
		 
		 	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
   		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName & "\" & tdgssarch_txt & ProductVersion
			Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx)
			if (Outparams1.ReturnValue = 0) Then
				rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & Chr(34) & " /f",0,true)
				lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
			Else
				lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
			End If
	    case TTUProducts(50)	'TDGEOSPATIAL
		    'Check for registry entries in HKLM\Software\CompanyName
			short_version = Get_Short_Version(ProductVersion)
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
   		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & short_version & "\" & ProductName
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
	    case else   'For all other products
		    'Check for registry entries in HKLM\Software\CompanyName
		    Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
		    Inparams1.Hdefkey = HKLM
		    if (CInt(short_ver_first_part) < 13) then   'NCR
    		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & ProductName
            else    'Teradata
    		    Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Client\" & short_version & "\" & ProductName
            end if
		    Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end if
	    End Select
    End if
End Function
'=====================================================================================================================================================

Function TeraGSSCleanup(ByVal folderpath)
Dim objFilesys
Dim rc
Dim version_key
Dim tdgssarch_txt

'Version Pattern check 
 Set versionstr_match = New RegExp
  With versionstr_match
      .Pattern    = "^(\d\d)(\w?)\.(\d\d)(\w?)\.(\d\d)(\w?)\.(\d\d)(\d?)$"
      .IgnoreCase = True
      .Global     = False
  End With


'################################### Registry Cleanup
    if (Wow6432Node = False) then
        regtxt = "\"
        If (Package_64bit = True) Then
        	tdgssarch_txt= "nt-x8664\"
        Else
        	tdgssarch_txt= "nt-i386\"
        End If
    else
        regtxt = "\Wow6432Node\"
        tdgssarch_txt= "nt-i386\"
    end if    
	
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").InParameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Teradata GSS\" & tdgssarch_txt 
   	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx)
	
	lf.WriteLine "Searching for remnants at HKLM\" & Inparams1.Ssubkeyname & " PRIORTOVERSION: " & priorto_version
	If Not (IsNull(Outparams1.snames)) then
		For Each version_key In Outparams1.snames
		 If versionstr_match.Test(version_key) Then
 	 		vcompare = VersionCompare(version_key, priorto_version, "TeraGSS") 
			If (vcompare = -1) Then
		    	rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & version_key & Chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & version_key & " entry found and version is less than priortoversion flag, so deleted..."
			Else
			
		    	lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & version_key & " entry retained as version in higher than priortoversion flag..."
			End If
	   	  End If
		Next
		
		'Removing nt-x8664 & nt-i386 entry under HKLM\Software\...\Teradata\Teradata GSS if no TeraGSS version exists	
		Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx)
		If (IsNull(Outparams1.snames)) Then
			Inparams1.Ssubkeyname=Left(Inparams1.Ssubkeyname,Len(Inparams1.Ssubkeyname)-1)
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry removed as there are no versions left..."	
		End If 
		
		'Removing HKLM\Software\...\Teradata\Teradata GSS entry
		Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\Teradata GSS"
		Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx)
		If (IsNull(Outparams1.snames)) Then
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry removed..."	
		End If 
		 
	End If
	lf.WriteLine "Search completed...."
	
	'Check for Temp registry key under TeraGSS
			Inparams1.Ssubkeyname = "Software" & regtxt & CompanyName & "\" & "Temp"
			Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 
		    if (Outparams1.ReturnValue = 0) then
			    rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\" & Inparams1.Ssubkeyname & chr(34) & " /f",0,true)
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry found and deleted..."
		    else
			    lf.WriteLine "HKLM\" & Inparams1.Ssubkeyname & " entry not found..."
		    end If
	
'################################### Files Cleanup
Set objFilesys = CreateObject("Scripting.FilesystemObject")
lf.WriteLine "Searching for remnants at " & folderpath & " PRIORTOVERSION: " & priorto_version
If (objFilesys.FolderExists(folderpath)) Then
	Set TargetRootFolder = objFilesys.GetFolder(folderpath)
	Set Folderlist = TargetRootFolder.SubFolders
	For Each TargetFolder In Folderlist
		If TargetFolder.Name <> "LCLIENT" Then
		 If versionstr_match.Test(TargetFolder.Name) Then
			vcompare = VersionCompare(TargetFolder.Name, priorto_version, "TeraGSS") 
			If (vcompare = -1) Then
				lf.WriteLine "Folder Found: " & folderpath & TargetFolder.Name & ", deleted..."
				rc=objFilesys.DeleteFolder(folderpath & TargetFolder.Name,True)
			End If
		 End If
		End If
	Next
End If		
lf.WriteLine "Search completed...."
End Function


'=====================================================================================================================================================

'Compare the Major release of the installed product with
'the Major release of the product being installed
Function PATHCleanup(Byval InstallPath)
Dim strlen
Dim TotalStr
Dim FirstPart, LastPart
Dim pos, pos1, pos2
Dim objEnv
Dim fldr
Dim fls
Dim Path_modified

lf.WriteLine "Inside PATHCleanup : Searching for " & InstallPath

Path_Modified=false

Set objEnv = objWshShell.Environment("SYSTEM")

TotalStr=objEnv("PATH")

pos=1
pos1=1
pos2=1

pos = instr(1,TotalStr,InstallPath)
if (pos > 0) then
	strlen = len(TotalStr)
	do while (strlen > 0 ) 
		pos2=instr(pos1,TotalStr,";")
		if (pos2 > 0) then
			if (InstallPath = Left(TotalStr,pos2-1)) then	'Path Matches PATH entry
				lf.WriteLine "PATH Entry Found..."
				if (objFile.FolderExists(InstallPath) = True) then	' Check if the folder exists
					set fldr = objFile.GetFolder(InstallPath)
					set fls = fldr.Files
					if (fls.count = 0)	then 'If the folder is empty remove the PATH entry
						lf.WriteLine "Removing " & InstallPath & " entry from PATH."
						Path_Modified=True
					else
						lf.WriteLine "Not removing " & InstallPath & " entry from PATH, because the folder is not empty."
						FirstPart = FirstPart & Left(TotalStr,pos2)
					end if
				else
					lf.WriteLine "Folder doesn't exist : Removing " & InstallPath & " entry from PATH.."
					Path_Modified=True
				end if
			else
				FirstPart = FirstPart & Left(TotalStr,pos2)
			end if
			TotalStr=Right(TotalStr,(strlen-pos2))
			strlen = len (TotalStr)
		else	'When no semicolon in the string, usually the last entry in PATH
			if (InstallPath = TotalStr) then
					lf.WriteLine "PATH Entry Found..."
					if (objFile.FolderExists(InstallPath) = True) then	' Check if the folder exists
						set fldr = objFile.GetFolder(InstallPath)
						set fls = fldr.Files
						if (fls.count = 0)	then 'If the folder is empty remove the PATH entry
							lf.WriteLine "Removing " & InstallPath & " entry from PATH."
							Path_Modified=True
						else
							lf.WriteLine "Not removing " & InstallPath & " entry from PATH, because the folder is not empty."
							FirstPart = FirstPart & Left(TotalStr,pos2)
						end if
					else
						lf.WriteLine "Folder doesn't exist : Removing " & InstallPath & " entry from PATH.."
						Path_Modified=True
					end if
			else
				FirstPart = FirstPart & TotalStr
			end if
			strlen=0
		end if
	loop
else
	lf.WriteLine "PATH entry not found..."
end if

if (Path_Modified = True) then
	objEnv("PATH")=FirstPart
	lf.WriteLine "PATH modified..."
else
	lf.WriteLine "PATH not modified..."
end if

End Function

'=====================================================================================================================================================
'Takes the product code as input and generates the GUID that is used in the registry entries for a package.
Function ProductCode_to_GUID(ByVal ProductCode)
Dim pos
Dim pos1
Dim pos2
Dim tempstr
Dim tempstr1
Dim tempstr2
Dim tempstr3
Dim tempstr4
Dim tempstr5
Dim tempstr6

Set objWshShell = CreateObject("WScript.Shell")

'First Part
pos1 = instr(ProductCode, "{")
pos2 = instr(ProductCode, "-")
tempstr1 = Mid(ProductCode,pos1+1,pos2-pos1-1)
tempstr1 = StrReverse(tempstr1)

'Second Part
pos1=pos2
pos2 = instr(pos1+1,ProductCode,"-")
tempstr2 = Mid(ProductCode, pos1+1, pos2-pos1-1)
tempstr2 = StrReverse(tempstr2)

'Third Part
pos1=pos2
pos2 = instr(pos1+1,ProductCode,"-")
tempstr3 = Mid(ProductCode, pos1+1, pos2-pos1-1)
tempstr3 = StrReverse(tempstr3)

'Fourth Part
pos1=pos2
pos2 = pos1 + 1
tempstr4 = Mid(ProductCode, pos2+1, 1)
tempstr4 = tempstr4 + Mid(ProductCode, pos1+1, 1)

pos1=pos2 + 1
pos2=pos1 + 1 
tempstr4 = tempstr4 + Mid(ProductCode, pos2+1, 1)
tempstr4 = tempstr4 + Mid(ProductCode, pos1+1, 1)

'Fifth Part
pos2 = pos2 + 1
tempstr5=""
while (pos2  < (len(ProductCode)-2))
    pos1=pos2 + 1
    pos2=pos1 + 1 
    tempstr5 = tempstr5 + Mid(ProductCode, pos2+1, 1)
    tempstr5 = tempstr5 + Mid(ProductCode, pos1+1, 1)
Wend

ProductCode_to_GUID = tempstr1 & tempstr2 & tempstr3 & tempstr4 & tempstr5
End Function

'=====================================================================================================================================================
'Takes a guid as input and generates the ProductCode that is used in the registry entries for a package.
Function GUID_to_ProductCode(ByVal guid)
Dim pos
Dim pos1
Dim pos2
Dim tempstr1
Dim tempstr2
Dim tempstr3
Dim tempstr4
Dim tempstr5
Dim tempstr6

Set objWshShell = CreateObject("WScript.Shell")

'First Part
tempstr1 = left(guid, 8)
tempstr1 = StrReverse(tempstr1)

'Second Part
pos1=8
tempstr2 = Mid(guid, pos1+1, 4)
tempstr2 = StrReverse(tempstr2)

'Third Part
pos1=12
tempstr3 = Mid(guid, pos1+1, 4)
tempstr3 = StrReverse(tempstr3)

'Fourth Part
pos1=16
pos2=pos1 + 1 
tempstr4 = Mid(guid, pos2+1,1)
tempstr4 = tempstr4 + Mid(guid, pos1+1,1)

pos1=pos2 + 1 
pos2=pos1 + 1
tempstr4 = tempstr4 + Mid(guid, pos2+1, 1)
tempstr4 = tempstr4 + Mid(guid, pos1+1, 1)

'Fifth Part
tempstr5=""
while (pos2 <= len(guid))
    pos1=pos2 + 1 
    pos2=pos1 + 1
    tempstr5 = tempstr5 + Mid(guid, pos2+1, 1)
    tempstr5 = tempstr5 + Mid(guid, pos1+1, 1)
Wend

GUID_to_ProductCode = "{" & tempstr1 & "-" & tempstr2 & "-" & tempstr3 & "-" & tempstr4 & "-" & tempstr5 & "}"

End Function

'=====================================================================================================================================================
'Search for the registry entries with the generated UpgradeGUID for a TeraGSS product.
'Get the productcode for each entry ProductGUID found. Search and obtain the productversion for the productcode. 
'check if the productversion is less than the priorto_version and only delete the entries forcibly if less than priorto_version.
Function Get_ProductGUID_FromRegistry_and_Search(ByVal Upgrade_GUID, ByVal prod_name)
Dim Inparams1, Inparams2
Dim Outparams1, Outparams2
Dim prod_code, prod_guid, prod_ver
Dim suite_vcompare

lf.WriteLine " Searching the registry for the Upgrade_GUID : " & Upgrade_GUID & " to get the productGUID..."

' Search for the GUID under HKLM\SOFTWARE\Classes\Installer registry key.
' Searching the HKLM\Software\Classes\Installer Keys is only possible in 64-bit mode, so switching the context to 64-bit mode temporarily.
	if (Wow6432Node = True) then
		objCtx.Add "__ProviderArchitecture", 64
		objCtx.Add "__RequiredArchitecture", TRUE
		Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		Set objStdRegProv = objServices.Get("StdRegProv") 
    end if

' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Installer\UpgradeCodes    KeyValue
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Classes\Installer\UpgradeCodes" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

    If not (IsNull(Outparams1.snames)) then
	    For Each strSubKey In Outparams1.snames 
	        'If the Upgrade_GUID matches with the Key then exit for loop. 
    	    if (strSubKey = Upgrade_GUID)   then
		    	    lf.WriteLine "Upgrade_GUID match found : HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey
		            Set Inparams2 = objStdRegProv.Methods_("EnumValues").Inparameters
		            Inparams2.Hdefkey = HKLM
		            Inparams2.Ssubkeyname = "Software\Classes\Installer\UpgradeCodes\" & strSubKey
		            set Outparams2 = objStdRegProv.ExecMethod_("EnumValues", Inparams2,,objCtx)

                    If not (IsNull(Outparams2.snames)) then
                        For Each strValue in Outparams2.snames
                            prod_guid = strValue
                            prod_code = GUID_to_ProductCode(prod_guid)
                                if (Proc_Arch = "AMD64") then
									prod_ver = ExtractProductVersion("Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\" & prod_code, prod_name)
									If (prod_ver = "01.00.00.00") Then
										prod_ver = ExtractProductVersion("Software\Microsoft\Windows\CurrentVersion\Uninstall\" & prod_code, prod_name)
									End If
								else
									prod_ver = ExtractProductVersion("Software\Microsoft\Windows\CurrentVersion\Uninstall\" & prod_code, prod_name)
								End if
                            if ( suite_ptr = True ) then
								if (prod_ver <> "") then    'If product version found compare it with the Priorto version.
									'prod_ver is found and read from the uninstall key. 
									suite_vcompare = VersionCompare("14.10.00.00", prod_ver, prod_name)
									vcompare = VersionCompare(prod_ver, priorto_version, prod_name)
									if ( ( (suite_vcompare = -1) or (suite_vcompare = 0) ) and (vcompare = -1) )then
										lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " < " & "prior to version passed(" & priorto_version & ")"
										lf.WriteLine "Proceeding with cleanup..."
										SearchRegistryForGUIDEntries(prod_guid)
										'Added to populate company name
										GetInstallPath prod_name,prod_ver
										VerifyRegistryEntries prod_name, prod_code, prod_ver
									else
										'lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " = " & "prior to version passed(" & priorto_version & ")"
										lf.WriteLine "Cleanup not required..."
									end if
								end if
							else 
								if (prod_ver <> "" And prod_ver <> "01.00.00.00") then    'If product version found compare it with the Priorto version.
									'prod_ver is found and read from the uninstall key. 
									vcompare = VersionCompare(prod_ver, priorto_version, prod_name)
									if (vcompare = -1) then
										lf.WriteLine prod_ver & "Currently installed product version(" & prod_ver & ")" & " < " & "prior to version passed(" & priorto_version & ")"
										lf.WriteLine "Proceeding with cleanup..."
										SearchRegistryForGUIDEntries(prod_guid)
										'Added to populate company name
										GetInstallPath prod_name,prod_ver
										VerifyProductFiles prod_name,prod_ver, InstallPath
										VerifyRegistryEntries prod_name, prod_code, prod_ver										
									elseif (vcompare = 1) then
										lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " > " & "prior to version passed(" & priorto_version & ")"
										lf.WriteLine "Cleanup not required..."
									else
										lf.WriteLine "Currently installed product version(" & prod_ver & ")" & " = " & "prior to version passed(" & priorto_version & ")"
										lf.WriteLine "Cleanup not required..."
									end if
								Else
									SearchRegistryForGUIDEntries(prod_guid)
									'Added to populate company name
									GetInstallPath prod_name, priorto_version
									VerifyRegistryEntries prod_name, prod_code, "01.00.00.00"
								end If
							End if
                        Next
                    End if 
            end if
        Next    
    end if
	
'Searching for remnants of files, registry without considering version
if (prod_name = "Teradata GSS") then
	'Added to populate company name
	GetInstallPath prod_name, priorto_version
	VerifyProductFiles prod_name,"01.00.00.00", InstallPath
End If

	
' Searching the HKLM\Software\Classes\Installer Keys is only possible in 64-bit mode, so switching back the context to 32-bit mode.
	if (Wow6432Node = True) then
		objCtx.Add "__ProviderArchitecture", 32
		objCtx.Add "__RequiredArchitecture", TRUE
		Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		Set objStdRegProv = objServices.Get("StdRegProv") 
    end if


End Function
'=====================================================================================================================================================
'Search for the registry entries with the generated GUID for a product are delete the entries forcibly if found.
Function SearchRegistryForGUIDEntries(ByVal GUID)
Dim Inparams1, Inparams2
Dim Outparams1, Outparams2

lf.WriteLine " Searching the registry for the GUID : " & GUID
' Search for the GUID under HKLM\SOFTWARE\Classes\Installer registry key.
' Searching the HKLM\Software\Classes\Installer Keys is only possible in 64-bit mode, so switching the context to 64-bit mode temporarily.
	if (Wow6432Node = True) then
		objCtx.Add "__ProviderArchitecture", 64
		objCtx.Add "__RequiredArchitecture", TRUE
		Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		Set objStdRegProv = objServices.Get("StdRegProv") 
	end if

' Searching HKEY_CLASSES_ROOT\Installer\Features
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKCR
	Inparams1.Ssubkeyname = "Installer\Features" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
	    'If the GUID matches with the Key then delete the key. 
		if (strSubKey = GUID)   then
			lf.WriteLine "GUID match found & deleting the entry : HKCR\Installer\Features\" & strSubKey
			'WScript.Echo " Found match strSubKey : " & strSubKey & "    HKCR\Installer\Features\" & strSubKey 
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKCR\Installer\Features\" & strSubKey & chr(34) & " /f",0,true)
	    end if
	Next

' Searching HKEY_CLASSES_ROOT\Installer\Products
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKCR
	Inparams1.Ssubkeyname = "Installer\Products" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
	    'If the GUID matches with the Key then delete the key. 
		if (strSubKey = GUID)   then
			lf.WriteLine "GUID match found & deleting the entry : HKCR\Installer\Products\" & strSubKey
		    'WScript.Echo " Found match strSubKey : " & strSubKey & "    HKCR\Installer\Products\" & strSubKey 
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKCR\Installer\Products\" & strSubKey & chr(34) & " /f",0,true)
	    end if
	Next


' Searching HKEY_CLASSES_ROOT\Installer\UpgradeCodes    KeyValue
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKCR
	Inparams1.Ssubkeyname = "Installer\UpgradeCodes" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
		Set Inparams2 = objStdRegProv.Methods_("EnumValues").Inparameters
		Inparams2.Hdefkey = HKCR
		Inparams2.Ssubkeyname = "Installer\UpgradeCodes\" & strSubKey
		set Outparams2 = objStdRegProv.ExecMethod_("EnumValues", Inparams2,,objCtx) 
		
		For Each strSubKeyValue In Outparams2.snames
    	    'If the GUID matches with the Key then delete the key. 
	    	if (strSubKeyValue = GUID)   then
			    'WScript.Echo " Found match strSubKeyValue : " & strSubKeyValue & "    HKCR\Installer\UpgradeCodes\" & strSubKey 
			    if (UBound(Outparams2.snames) = 0 ) then    'Delete the subKey if the subKeyValue is the only entry in the subkey
    		    	lf.WriteLine "GUID match found & deleting the entry : HKCR\Installer\UpgradeCodes\" & strSubKey
			        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKCR\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /f",0,true)
			    else    'Otherwise only delete the subkeyvalue from the subkey.
			    	lf.WriteLine "GUID match found & deleting the entry : HKCR\Installer\UpgradeCodes\" & strSubKey & " /v " & strSubKeyValue
    		        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKCR\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /v " & strSubKeyValue & " /f",0,true)
			    end if 
	        end if
		Next
    Next    

' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Installer\Features
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Classes\Installer\Features" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
	    'If the GUID matches with the Key then delete the key. 
		if (strSubKey = GUID)   then
			lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Classes\Installer\Features\" & strSubKey
			'WScript.Echo " Found match strSubKey : " & strSubKey & "    HKLM\Software\Classes\Installer\Features\" & strSubKey 
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Classes\Installer\Features\" & strSubKey & chr(34) & " /f",0,true)
	    end if
	Next

' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Installer\Products
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Classes\Installer\Products" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
	    'If the GUID matches with the Key then delete the key. 
		if (strSubKey = GUID)   then
			lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Classes\Installer\Products\" & strSubKey
		    'WScript.Echo " Found match strSubKey : " & strSubKey & "    HKLM\Software\Classes\Installer\Products\" & strSubKey 
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Classes\Installer\Products\" & strSubKey & chr(34) & " /f",0,true)
	    end if
	Next


' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Installer\UpgradeCodes    KeyValue
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Classes\Installer\UpgradeCodes" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
		Set Inparams2 = objStdRegProv.Methods_("EnumValues").Inparameters
		Inparams2.Hdefkey = HKLM
		Inparams2.Ssubkeyname = "Software\Classes\Installer\UpgradeCodes\" & strSubKey
		set Outparams2 = objStdRegProv.ExecMethod_("EnumValues", Inparams2,,objCtx) 
		
		For Each strSubKeyValue In Outparams2.snames
    	    'If the GUID matches with the Key then delete the key. 
	    	if (strSubKeyValue = GUID)   then
			    'WScript.Echo " Found match strSubKeyValue : " & strSubKeyValue & "    HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey 
			    if (UBound(Outparams2.snames) = 0 ) then    'Delete the subKey if the subKeyValue is the only entry in the subkey
    		    	lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey
			        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /f",0,true)
			    else    'Otherwise only delete the subkeyvalue from the subkey.
			    	lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey & " /v " & strSubKeyValue
    		        rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Classes\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /v " & strSubKeyValue & " /f",0,true)
			    end if 
	        end if
		Next
    Next    

' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes  KeyValue
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
		Set Inparams2 = objStdRegProv.Methods_("EnumValues").Inparameters
		Inparams2.Hdefkey = HKLM
		Inparams2.Ssubkeyname = "Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey
		set Outparams2 = objStdRegProv.ExecMethod_("EnumValues", Inparams2,,objCtx) 
		
        If not (IsNull(Outparams2.snames)) then
		    For Each strSubKeyValue In Outparams2.snames
    	        'If the GUID matches with the Key then delete the key. 
	    	    if (strSubKeyValue = GUID)   then
			        'WScript.Echo " Found match strSubKeyValue : " & strSubKeyValue & "    HKLM\Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey 
			        if (UBound(Outparams2.snames) = 0 ) then    'Delete the subKey if the subKeyValue is the only entry in the subkey
    		    	    lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey
			            rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /f",0,true)
			        else    'Otherwise only delete the subkeyvalue from the subkey.
			    	    lf.WriteLine "GUID match found & deleting the entry : HKLM\Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey & " /v " & strSubKeyValue
		                rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\Software\Microsoft\Windows\CurrentVersion\Installer\UpgradeCodes\" & strSubKey & chr(34) & " /v " & strSubKeyValue & " /f",0,true)
			        end if 
	            end if
		    Next
		End if
    Next    
    
' HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\0A7FA7AE846C6D1108A0000B0DCA3AF7 KeyValue
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
		Set Inparams2 = objStdRegProv.Methods_("EnumValues").Inparameters
		Inparams2.Hdefkey = HKLM
		Inparams2.Ssubkeyname = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey
		set Outparams2 = objStdRegProv.ExecMethod_("EnumValues", Inparams2,,objCtx) 

        If not (IsNull(Outparams2.snames)) then
		    For Each strSubKeyValue In Outparams2.snames
    	        'If the GUID matches with the Key then delete the key. 
	    	    if (strSubKeyValue = GUID)   then
			        'WScript.Echo " Found match strSubKeyValue : " & strSubKeyValue & "    HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey 
			        'WScript.Echo "UBound(Outparams2.snames) : " & UBound(Outparams2.snames)
			        if (UBound(Outparams2.snames) = 0 ) then    'Delete the subKey if the subKeyValue is the only entry in the subkey
    		    	    lf.WriteLine "GUID match found & deleting the entry : HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey 
			            rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey & chr(34) & " /f",0,true)
			        else    'Otherwise only delete the subkeyvalue from the subkey.
    		    	    lf.WriteLine "GUID match found & deleting the entry : HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey & " /v " & strSubKeyValue
  			            rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Components\" & strSubKey & chr(34) & " /v " & strSubKeyValue & " /f",0,true)
  			        end if    
	            end if
		    Next
		End if
    Next    

' Searching HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products
	Set Inparams1 = objStdRegProv.Methods_("EnumKey").Inparameters
	Inparams1.Hdefkey = HKLM
	Inparams1.Ssubkeyname = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products" 
	Set Outparams1 = objStdRegProv.ExecMethod_("EnumKey", Inparams1,,objCtx) 

	For Each strSubKey In Outparams1.snames 
	    'If the GUID matches with the Key then delete the key. 
		if (strSubKey = GUID)   then
			lf.WriteLine "GUID match found & deleting the entry : HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\" & strSubKey
			'WScript.Echo " Found match  HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\" & strSubKey 
			rc = objWshShell.Run("cmd /C reg delete " & chr(34) & "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\" & strSubKey & chr(34) & " /f",0,true)
	    end if
	Next

' Search for the GUID under HKLM\SOFTWARE\Classes\Installer registry key.
' Searching the HKLM\Software\Classes\Installer Keys is only possible in 64-bit mode, so switching back the context to 32-bit mode.
	if (Wow6432Node = True) then
		objCtx.Add "__ProviderArchitecture", 32
		objCtx.Add "__RequiredArchitecture", TRUE
		Set objLocator = CreateObject("Wbemscripting.SWbemLocator")
		Set objServices = objLocator.ConnectServer("","root\default","","",,,,objCtx)
		Set objStdRegProv = objServices.Get("StdRegProv") 
    end if


End Function

'=====================================================================================================================================================

Function DisplayUsage()
    WSCript.Echo "Copyright 2007-2013 Teradata. All rights reserved."
    WSCript.Echo "TERADATA CONFIDENTIAL AND TRADE SECRET"
    WSCript.Echo "Usage: "
    WScript.Echo "cscript uninstall_TTU.vbs [ALL TERAGSS TDICU CLIv2 TDODBC PIOM BTEQ FASTLD    " 
    WScript.Echo "                          MLOAD FASTEXP TPUMP TDOLEDB SQLPP NPAXSMOD MQAXSMOD "
    WScript.Echo "                          OLEDBAXSMOD JMSAXSMOD SQLA TSET VECOMP TIWIZ TSWIZ  "
    WScript.Echo "                          PMON TQSADMIN TQSSERVER TQSCLIENT TWA TMGR TDADMIN  "
    WScript.Echo "                          TDWM TSAW TPTSTREAM TPTBASE TPTINFRA TPTAPI TPTLOADOP"
    WScript.Echo "                          TPTEXPORTOP TPTUPDATEOP TPTSTREAMOP TPTICU TPTOSL   "
    WScript.Echo "                          TPTDATACONOP TPTDDLOP TPTINSERTOP TPTODBCOP         "
    WScript.Echo "                          TPTOSCMDOP TPTSELECTOP ARC MONITOROBJ TDWALLET      "
    WScript.Echo "                          TDNETDP TDGEOSPATIAL] [/PRIORTOVERSION:xx.xx.xx.xx] "
    WScript.Echo "                          [/FORCE:TRUE] [/SUITE:ALL]"
    WSCript.Echo "1)Any or all of the products specified above can be passed as arguments"
    WScript.Echo "to the script."
	WScript.Echo "2)The /SUITE option should be used to remove all suites having version less "
	WScript.Echo "than the PRIORTOVERSION.PRIORTOVERSION value should to be equal to or greater than"
	WScript.Echo "15.00.00.00 and the script should be run from media to remove suite packages."
    WScript.Echo "3)The /FORCE option should be used to remove all traces of the product by "
    WScript.Echo "force. Specify /FORCE:TRUE if needed, otherwise the default is /FORCE:FALSE."
    WScript.Echo "4)The /PRIORTOVERSION option should be used to remove all versions of the "
    WScript.Echo "product less than the specified version. Specify /PRIORTOVERSION:xx.xx.xx.xx "
    WScript.Echo "if needed, otherwise the default is /PRIORTOVERSION:" & def_cur_ver & "."
    WScript.Echo "5)When both /PRIORTOVERSION and /FORCE options are specified then all versions "
    WScript.Echo "of the specified products less than the PRIORTOVERSION are removed. "
    WScript.Echo "6)When the product name is specified as 'ALL' all the Suites and products supported"
    WScript.Echo " by the script are uninstalled. When /PRIORTOVERSION and /FORCE options are not "
    WScript.Echo "specified with 'ALL', the default values for these options are used. "
    WScript.Echo "Examples:"
    WScript.Echo "cscript uninstall_TTU.vbs TDODBC"
    WScript.Echo "cscript uninstall_TTU.vbs TDODBC CLIv2 /PRIORTOVERSION:" & def_cur_ver
    WScript.Echo "cscript uninstall_TTU.vbs TDODBC CLIv2 TDICU TERAGSS /FORCE:TRUE"
    WScript.Echo "cscript uninstall_TTU.vbs CLIv2 TDICU /FORCE:TRUE /PRIORTOVERSION:" & def_cur_ver
    WScript.Echo "cscript uninstall_TTU.vbs ALL"
    WScript.Echo "cscript uninstall_TTU.vbs ALL /PRIORTOVERSION:" & def_cur_ver & " /FORCE:TRUE"
	WScript.Echo "cscript uninstall_TTU.vbs /SUITE:ALL /PRIORTOVERSION:15.00.00.00"
    WScript.Echo "cscript uninstall_TTU.vbs TDODBC /SUITE:ALL /PRIORTOVERSION:" & def_cur_ver
    WScript.Echo "cscript uninstall_TTU.vbs /SUITE:ALL /PRIORTOVERSION:15.00.00.00 /FORCE:TRUE" 
	WScript.Quit()
End Function
'=====================================================================================================================================================