/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.jgssp2tdnego.TdnegoMechanism;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdnegoName
implements GSSName {
    private final TdgssLogger logger;
    private byte[] name;
    private Oid namespace;
    private HashMap mechNameMap = new HashMap();

    private static int hashCode(byte[] byArray) {
        int n = 31;
        if (byArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = n * n2 + byArray[i];
        }
        return n2;
    }

    public TdnegoName(byte[] byArray, Oid oid, Vector vector, TdgssLogger tdgssLogger) throws GSSException {
        GSSMechanism gSSMechanism = null;
        Oid oid2 = null;
        GSSName gSSName = null;
        this.logger = tdgssLogger;
        this.name = byArray;
        this.namespace = oid;
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            gSSMechanism = (GSSMechanism)enumeration.nextElement();
            oid2 = gSSMechanism.getMech();
            try {
                gSSName = gSSMechanism.createName(this.name, this.namespace);
                this.mechNameMap.put(oid2, gSSName);
            }
            catch (GSSException gSSException) {
                this.mechNameMap.put(oid2, gSSException);
                if (!tdgssLogger.isInfoEnabled()) continue;
                tdgssLogger.info(gSSException.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TdnegoName)) {
            return false;
        }
        TdnegoName tdnegoName = (TdnegoName)object;
        if (this.mechNameMap == null ? tdnegoName.mechNameMap != null : !this.mechNameMap.equals(tdnegoName.mechNameMap)) {
            return false;
        }
        if (!Arrays.equals(this.name, tdnegoName.name)) {
            return false;
        }
        return !(this.namespace == null ? tdnegoName.namespace != null : !this.namespace.equals(tdnegoName.namespace));
    }

    @Override
    public boolean equals(GSSName gSSName) throws GSSException {
        if (gSSName == null) {
            return false;
        }
        if (!(gSSName instanceof TdnegoName)) {
            return false;
        }
        TdnegoName tdnegoName = (TdnegoName)gSSName;
        if (this.getStringNameType() != tdnegoName.getStringNameType()) {
            return false;
        }
        return this.toString().equals(tdnegoName.toString());
    }

    @Override
    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(TdnegoMechanism.MECH_OID)) {
            throw new TdgssException(3, TdnegoMinorStatus.TDNEGO_ERR_INVALID_INPUT);
        }
        return this;
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        return this.namespace;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isMN() {
        return true;
    }

    @Override
    public String toString() {
        try {
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                return new String(this.name, "UTF-16");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                return new String(this.name, "UTF-8");
            }
            return new String(this.name, "US-ASCII");
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
            return null;
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mechNameMap == null ? 0 : this.mechNameMap.hashCode());
        n = 31 * n + TdnegoName.hashCode(this.name);
        n = 31 * n + (this.namespace == null ? 0 : this.namespace.hashCode());
        return n;
    }

    public Object getNameForMech(Oid oid) {
        if (oid != null) {
            return this.mechNameMap.get(oid);
        }
        return null;
    }

    @Override
    public byte[] export() throws GSSException {
        throw new TdgssException(16, TdnegoMinorStatus.TDNEGO_ERR_API_NOT_SUPPORTED);
    }
}

