/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMechanism;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssp2tdnego.TdnegoName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdnegoCredential
implements GSSCredential {
    private final TdgssLogger logger;
    private TdnegoName name;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private char[] password;
    private HashMap mechCredMap = new HashMap();
    private ListArray nameList = new ListArray(GSSName.class);

    private static int hashCode(char[] cArray) {
        int n = 31;
        if (cArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = n * n2 + cArray[i];
        }
        return n2;
    }

    public TdnegoCredential(TdnegoName tdnegoName, int n, int n2, Vector vector, TdgssLogger tdgssLogger) throws GSSException {
        GSSMechanism gSSMechanism = null;
        GSSCredential gSSCredential = null;
        this.logger = tdgssLogger;
        if (tdnegoName == null) {
            this.name = new TdnegoName(null, null, vector, tdgssLogger);
        } else {
            this.name = tdnegoName;
            this.nameList.add(tdnegoName);
        }
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
        if (n2 != 2) {
            this.password = "dummypassword".toCharArray();
        }
        if (vector == null) {
            throw new TdgssException(11, TdnegoMinorStatus.TDNEGO_ERR_NEGMECHLIST_EMPTY);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object = null;
            gSSMechanism = (GSSMechanism)enumeration.nextElement();
            Oid oid = gSSMechanism.getMech();
            object = this.name.getNameForMech(oid);
            if (object instanceof GSSName) {
                try {
                    gSSCredential = gSSMechanism.createCredential((GSSName)object, n, n2);
                    this.mechCredMap.put(oid, gSSCredential);
                }
                catch (GSSException gSSException) {
                    this.mechCredMap.put(oid, gSSException);
                    if (!tdgssLogger.isInfoEnabled()) continue;
                    tdgssLogger.info(gSSException.getMessage());
                }
                continue;
            }
            this.mechCredMap.put(oid, object);
        }
    }

    @Override
    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        Set set = this.mechCredMap.entrySet();
        Iterator iterator = set.iterator();
        if (gSSName != null) {
            this.nameList.add(gSSName);
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            Oid oid2 = (Oid)entry.getKey();
            if (!(v instanceof GSSCredential)) continue;
            try {
                ((GSSCredential)v).add(gSSName, n, n2, oid2, n3);
            }
            catch (GSSException gSSException) {
                this.mechCredMap.put(oid2, gSSException);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(gSSException.getMessage());
            }
        }
    }

    @Override
    public void dispose() throws GSSException {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        this.password = null;
    }

    @Override
    public GSSName getName() throws GSSException {
        return this.name;
    }

    @Override
    public GSSName getName(Oid oid) throws GSSException {
        if (oid != TdnegoMechanism.MECH_OID) {
            throw new TdgssException(2, TdnegoMinorStatus.TDNEGO_ERR_INVALID_INPUT);
        }
        return this.name;
    }

    @Override
    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(TdnegoMechanism.MECH_OID);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(TdnegoMechanism.MECH_OID);
        }
        int n2 = this.getRemainingAcceptLifetime(TdnegoMechanism.MECH_OID);
        return n2 < (n = this.getRemainingInitLifetime(TdnegoMechanism.MECH_OID)) ? n2 : n;
    }

    @Override
    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != TdnegoMechanism.MECH_OID) {
            throw new TdgssException(2, TdnegoMinorStatus.TDNEGO_ERR_INVALID_INPUT);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(this.initEnd - System.currentTimeMillis());
        return n < 0 ? 0 : n;
    }

    @Override
    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != TdnegoMechanism.MECH_OID) {
            throw new TdgssException(2, TdnegoMinorStatus.TDNEGO_ERR_INVALID_INPUT);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(this.acceptEnd - System.currentTimeMillis());
        return n < 0 ? 0 : n;
    }

    @Override
    public int getUsage() throws GSSException {
        return this.usage;
    }

    @Override
    public int getUsage(Oid oid) throws GSSException {
        if (oid != TdnegoMechanism.MECH_OID) {
            throw new TdgssException(2, TdnegoMinorStatus.TDNEGO_ERR_INVALID_INPUT);
        }
        return this.usage;
    }

    @Override
    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{TdnegoMechanism.MECH_OID};
        return oidArray;
    }

    protected char[] getPassword() {
        return this.password;
    }

    @Override
    public int hashCode() {
        int n = 1;
        if (this.usage != 1) {
            n = 31 * n + (this.acceptOnly ? 1231 : 1237);
            n = 31 * n + (this.indefiniteAccept ? 1231 : 1237);
        }
        if (this.usage != 2) {
            n = 31 * n + (this.indefiniteInit ? 1231 : 1237);
            n = 31 * n + (this.initOnly ? 1231 : 1237);
        }
        n = 31 * n + (this.mechCredMap == null ? 0 : this.mechCredMap.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.password == null ? 0 : TdnegoCredential.hashCode(this.password));
        n = 31 * n + this.usage;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (!gSSCredential.getName().equals(this.name)) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public Object getCredForMech(Oid oid) {
        if (oid != null) {
            return this.mechCredMap.get(oid);
        }
        return null;
    }

    ListArray returnNames() {
        return this.nameList;
    }
}

