/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.jgssp2jwt.JwtContext;
import com.teradata.tdgss.jgssp2jwt.JwtCredential;
import com.teradata.tdgss.jgssp2jwt.JwtMinorStatus;
import com.teradata.tdgss.jgssp2jwt.JwtName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class JwtMechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    protected static final Oid mechOid;
    protected static final int servicesAvailable = -2147483550;
    protected static int servicesNeeded;

    public JwtMechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        servicesNeeded = -2147483550;
    }

    @Override
    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof JwtCredential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForAccept ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, JwtMinorStatus.JWT_ERR_INVALID_TOKEN);
        }
        return new JwtContext((JwtCredential)gSSCredential, objectArray, this.logger);
    }

    @Override
    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2, List<Oid> list) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForInit ");
        }
        if (list != null && list.contains(_mechOid)) {
            n2 |= Integer.MIN_VALUE;
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, n2 &= 0x80000062)) {
            throw new TdgssException(10, JwtMinorStatus.JWT_ERR_INVALID_TOKEN);
        }
        return new JwtContext((JwtCredential)gSSCredential, (JwtName)gSSName, n, objectArray, n2, this.logger);
    }

    @Override
    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2) {
        if (gSSCredential != null && !(gSSCredential instanceof JwtCredential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            }
            return false;
        }
        if (gSSName != null && !(gSSName instanceof JwtName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("must be a name created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        JwtName jwtName;
        if (gSSName == null) {
            jwtName = null;
        } else if (gSSName instanceof JwtName) {
            jwtName = (JwtName)gSSName;
        } else {
            throw new TdgssException(3, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        return new JwtCredential(jwtName, n, n2, this.logger);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        String string = null;
        byte[] byArray2 = null;
        if (oid != null) {
            if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                try {
                    string = new String(byArray, "UTF-16");
                    byArray2 = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.logger.error(unsupportedEncodingException.getMessage());
                    throw new TdgssException(3, JwtMinorStatus.JWT_ERR_INVALID_INPUT, unsupportedEncodingException);
                }
                return new JwtName(byArray2, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger);
            }
            if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32)) {
                try {
                    string = new String(byArray, "UTF-32");
                    byArray2 = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.logger.error(unsupportedEncodingException.getMessage());
                    throw new TdgssException(3, JwtMinorStatus.JWT_ERR_INVALID_INPUT, unsupportedEncodingException);
                }
                return new JwtName(byArray2, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger);
            }
        }
        return new JwtName(byArray, oid, this.logger);
    }

    @Override
    public Oid getMech() {
        return mechOid;
    }

    @Override
    public int getServices() {
        return -2147483550;
    }

    @Override
    public Oid[] getNames() {
        return new Oid[]{TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8};
    }

    static {
        try {
            _mechOid = new Oid("1.3.6.1.4.1.28698.4.302.1.4");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        servicesNeeded = 0;
    }
}

