/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.util.InitializedMap;
import java.util.HashMap;
import java.util.Map;

public class JDBC4Constants {
    public static final int DEFAULT_BUFFER_SIZE = 65104;
    public static final int MAX_TOTAL_MSG_SIZE_64KB = 65156;
    public static final int MAX_CIPHERTEXT_EXPANSION_FACTOR = 2;
    public static final int MAX_LOB_DATA_SIZE = 64000;
    public static final int MAX_APH_LOB_DATA_SIZE = 1024000;
    public static final byte TD_DEFAULT_CHARSET_CODE = -1;
    public static final String TD_DEFAULT_CHARSET = "ASCII";
    public static final int PRECISION_BYTEINT = 3;
    public static final int PRECISION_SMALLINT = 5;
    public static final int PRECISION_INTEGER = 10;
    public static final Integer CTG_CHAR = new Integer(1);
    public static final Integer CTG_TIME_TS = new Integer(2);
    public static final Integer CTG_INTERVAL = new Integer(3);
    public static final Integer CTG_DEFLOBCHAR = new Integer(4);
    public static final Integer CTG_DEFLOBBIN = new Integer(5);
    public static final Integer CTG_BINARY = new Integer(6);
    private static final HashMap tdToJavaSQLTypes = new HashMap();
    private static final HashMap nullable = new HashMap();
    private static final HashMap tdTypesToTypeNames = new HashMap();
    private static final HashMap tdTypesToDispSize = new HashMap();
    private static final HashMap JavaSQLTypesToSQLTypeName = new HashMap();
    private static final HashMap JavaSQLTypesToJavaClassName = new HashMap();
    private static final HashMap tdTypesToJavaClassName = new HashMap();
    private static final HashMap tdTypesToParameterMode = new HashMap();
    private static final HashMap tdTypeToBasicTDType = new HashMap();
    private static final HashMap tdTypesToCategory = new HashMap();
    private static final HashMap structCompatTypeNameToCode = new HashMap();
    private static final HashMap intervalTypeToIntervalDigits = new HashMap();
    private static final HashMap intervalTypeToFractionDigits = new HashMap();
    private static final HashMap intervalTypeToDefaultLength = new HashMap();
    private static final int[] anIntervYr = new int[]{2, 0, 1};
    private static final int[] anIntervYrMo = new int[]{2, 0, 4};
    private static final int[] anIntervMo = new int[]{2, 0, 1};
    private static final int[] anIntervDay = new int[]{2, 0, 1};
    private static final int[] anIntervDayHr = new int[]{2, 0, 4};
    private static final int[] anIntervDayMin = new int[]{2, 0, 7};
    private static final int[] anIntervDaySec = new int[]{2, 6, 11};
    private static final int[] anIntervHr = new int[]{2, 0, 1};
    private static final int[] anIntervHrMin = new int[]{2, 0, 4};
    private static final int[] anIntervHrSec = new int[]{2, 6, 8};
    private static final int[] anIntervMin = new int[]{2, 0, 1};
    private static final int[] anIntervMinSec = new int[]{2, 6, 5};
    private static final int[] anIntervSec = new int[]{2, 6, 2};
    private static final Map tdTypesToServerDataTypes = new InitializedMap(new HashMap()).add(749, 833).add(761, 837).add(769, 841).add(765, 845).add(773, 849);
    private static final Integer RSMD_NO_NULLS = new Integer(0);
    private static final Integer RSMD_NULLABLE = new Integer(1);
    private static final Integer PARAMETER_UNKNOWN = new Integer(0);
    private static final Integer PARAMETER_IN = new Integer(1);
    private static final Integer PARAMETER_INOUT = new Integer(2);
    private static final Integer PARAMETER_OUT = new Integer(4);
    private static final Integer[] RSMD_NULLABILITES = new Integer[]{RSMD_NO_NULLS, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE};
    private static final Integer[] PARAMETER_MODES = new Integer[]{PARAMETER_UNKNOWN, PARAMETER_UNKNOWN, PARAMETER_IN, PARAMETER_INOUT, PARAMETER_OUT};

    private static void putMaps(int n, int n2, Integer n3, boolean bl, int[] nArray, String string, int n4, String string2, String string3) {
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n + 1), new Integer(n + 500), new Integer(n + 501), new Integer(n + 502)};
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n4);
        for (int i = 0; i < integerArray.length; ++i) {
            if (n != 0) {
                tdTypeToBasicTDType.put(integerArray[i], integerArray[0]);
                tdToJavaSQLTypes.put(integerArray[i], n6);
                nullable.put(integerArray[i], RSMD_NULLABILITES[i]);
                tdTypesToParameterMode.put(integerArray[i], PARAMETER_MODES[i]);
                tdTypesToDispSize.put(integerArray[i], n5);
                tdTypesToCategory.put(integerArray[i], n3);
                tdTypesToJavaClassName.put(integerArray[i], string3);
            }
            if (string == null) continue;
            tdTypesToTypeNames.put(integerArray[i], string);
        }
        JavaSQLTypesToSQLTypeName.put(n6, string2);
        if (n4 != 1111 && string3 != null) {
            JavaSQLTypesToJavaClassName.put(n6, string3);
        }
        if (bl) {
            structCompatTypeNameToCode.put(string, integerArray[1]);
        }
        if (nArray != null) {
            intervalTypeToIntervalDigits.put(integerArray[1], new Integer(nArray[0]));
            intervalTypeToFractionDigits.put(integerArray[1], new Integer(nArray[1]));
            intervalTypeToDefaultLength.put(integerArray[1], new Integer(nArray[0] + nArray[1] + nArray[2]));
        }
    }

    public static int getNullableTDTypeCodeForStructCompatibleBuiltInType(String string) {
        Integer n = string == null ? null : (Integer)structCompatTypeNameToCode.get(string.trim().toUpperCase());
        return n == null ? 0 : n;
    }

    public static int getJavaSQLTypeForStructCompatibleBuiltInType(String string) {
        return JDBC4Constants.getJavaSQLType(JDBC4Constants.getNullableTDTypeCodeForStructCompatibleBuiltInType(string));
    }

    public static short getNumberOfIntervalDigits(int n) {
        Integer n2 = (Integer)intervalTypeToIntervalDigits.get(new Integer(n));
        return n2 == null ? (short)0 : n2.shortValue();
    }

    public static short getNumberOfIntervalFracDigits(int n) {
        Integer n2 = (Integer)intervalTypeToFractionDigits.get(new Integer(n));
        return n2 == null ? (short)0 : n2.shortValue();
    }

    public static int getIntervalLength(int n) {
        Integer n2 = (Integer)intervalTypeToDefaultLength.get(new Integer(n));
        return n2 == null ? 0 : n2;
    }

    public static int getJavaSQLType(int n) {
        Integer n2 = (Integer)tdToJavaSQLTypes.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static String getJavaSQLTypeName(int n) {
        return (String)JavaSQLTypesToSQLTypeName.get(new Integer(n));
    }

    public static String getJavaClassNameForTdType(int n) {
        return (String)tdTypesToJavaClassName.get(new Integer(n));
    }

    public static String getJavaClassNameForSqlType(int n) {
        return (String)JavaSQLTypesToJavaClassName.get(new Integer(n));
    }

    public static int getNullable(int n) {
        Integer n2 = (Integer)nullable.get(new Integer(n));
        return n2 != null ? n2 : 2;
    }

    public static String getTDTypeName(int n) {
        return (String)tdTypesToTypeNames.get(new Integer(n));
    }

    public static int getDisplaySize(int n) {
        Integer n2 = (Integer)tdTypesToDispSize.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static int getTDTypeParameterMode(int n) {
        Object v = tdTypesToParameterMode.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public static short getTDBasicType(int n) {
        Integer n2 = (Integer)tdTypeToBasicTDType.get(new Integer(n));
        return n2 != null ? n2.shortValue() : (short)0;
    }

    public static boolean isBinaryType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_DEFLOBBIN || JDBC4Constants.getCategory(n) == CTG_BINARY;
    }

    public static boolean isCharType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_CHAR || JDBC4Constants.getCategory(n) == CTG_DEFLOBCHAR;
    }

    public static boolean isIntervalType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_INTERVAL;
    }

    public static boolean isDeferredLobType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_DEFLOBBIN || JDBC4Constants.getCategory(n) == CTG_DEFLOBCHAR;
    }

    public static boolean isDeferredClobType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_DEFLOBCHAR;
    }

    public static boolean isDeferredBlobType(int n) {
        return JDBC4Constants.getCategory(n) == CTG_DEFLOBBIN;
    }

    public static Integer getCategory(int n) {
        return (Integer)tdTypesToCategory.get(new Integer(n));
    }

    public static short getServerDataType(int n) {
        Integer n2 = (Integer)tdTypesToServerDataTypes.get(new Integer(n));
        return n2 != null ? n2.shortValue() : (short)0;
    }

    static {
        JDBC4Constants.putMaps(400, 0, CTG_BINARY, false, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(404, 0, CTG_DEFLOBBIN, false, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(408, 0, CTG_BINARY, false, null, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(416, 0, CTG_CHAR, false, null, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(420, 0, CTG_DEFLOBCHAR, false, null, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(424, 0, CTG_CHAR, false, null, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(440, 0, null, false, null, "", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(448, 0, CTG_CHAR, false, null, "VARCHAR", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(452, 0, CTG_CHAR, false, null, "CHAR", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(456, 0, CTG_CHAR, false, null, "LONGVARCHAR", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(464, 0, CTG_CHAR, false, null, "VARGRAPHIC", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(468, 0, CTG_CHAR, false, null, "GRAPHIC", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(472, 0, CTG_CHAR, false, null, "LONGVARGRAPHIC", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(480, 22, null, false, null, "FLOAT", 6, "FLOAT", "java.lang.Double");
        JDBC4Constants.putMaps(484, 20, null, false, null, "DECIMAL", 3, "DECIMAL", "java.math.BigDecimal");
        JDBC4Constants.putMaps(496, 11, null, false, null, "INTEGER", 4, "INTEGER", "java.lang.Integer");
        JDBC4Constants.putMaps(500, 6, null, false, null, "SMALLINT", 5, "SMALLINT", "java.lang.Integer");
        JDBC4Constants.putMaps(504, 0, null, false, null, "", 2003, "ARRAY", "java.sql.Array");
        JDBC4Constants.putMaps(508, 0, null, false, null, "", 2003, "ARRAY", "java.sql.Array");
        JDBC4Constants.putMaps(512, 0, CTG_DEFLOBBIN, true, null, "DATASET STORAGE FORMAT AVRO", 1111, "OTHER", "java.sql.Blob");
        JDBC4Constants.putMaps(516, 0, CTG_DEFLOBCHAR, true, null, "DATASET STORAGE FORMAT CSV", 1111, "OTHER", "java.sql.Clob");
        JDBC4Constants.putMaps(600, 20, null, false, null, "BIGINT", -5, "BIGINT", "java.lang.Long");
        JDBC4Constants.putMaps(604, 47, null, false, null, "NUMBER", 2, "NUMERIC", "java.math.BigDecimal");
        JDBC4Constants.putMaps(688, 0, CTG_BINARY, false, null, "VARBYTE", -3, "VARBINARY", "[B");
        JDBC4Constants.putMaps(692, 0, CTG_BINARY, false, null, "BYTE", -2, "BINARY", "[B");
        JDBC4Constants.putMaps(696, 0, CTG_BINARY, false, null, "LONGVARBYTE", -4, "LONGVARBINARY", "[B");
        JDBC4Constants.putMaps(748, 10, null, false, null, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(752, 10, null, false, null, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(756, 4, null, false, null, "BYTEINT", -6, "TINYINT", "java.lang.Integer");
        JDBC4Constants.putMaps(760, 8, CTG_TIME_TS, false, null, "TIME", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(764, 19, CTG_TIME_TS, false, null, "TIMESTAMP", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(768, 14, CTG_TIME_TS, true, null, "TIME WITH TIME ZONE", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(772, 25, CTG_TIME_TS, true, null, "TIMESTAMP WITH TIME ZONE", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(776, 1, CTG_INTERVAL, true, anIntervYr, "INTERVAL YEAR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(780, 4, CTG_INTERVAL, true, anIntervYrMo, "INTERVAL YEAR TO MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(784, 1, CTG_INTERVAL, true, anIntervMo, "INTERVAL MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(788, 1, CTG_INTERVAL, true, anIntervDay, "INTERVAL DAY", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(792, 4, CTG_INTERVAL, true, anIntervDayHr, "INTERVAL DAY TO HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(796, 7, CTG_INTERVAL, true, anIntervDayMin, "INTERVAL DAY TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(800, 10, CTG_INTERVAL, true, anIntervDaySec, "INTERVAL DAY TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(804, 1, CTG_INTERVAL, true, anIntervHr, "INTERVAL HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(808, 4, CTG_INTERVAL, true, anIntervHrMin, "INTERVAL HOUR TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(812, 7, CTG_INTERVAL, true, anIntervHrSec, "INTERVAL HOUR TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(816, 1, CTG_INTERVAL, true, anIntervMin, "INTERVAL MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(820, 4, CTG_INTERVAL, true, anIntervMinSec, "INTERVAL MINUTE TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(824, 1, CTG_INTERVAL, true, anIntervSec, "INTERVAL SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(832, 0, null, false, null, "PERIOD(DATE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(836, 0, null, false, null, "PERIOD(TIME)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(840, 0, null, false, null, "PERIOD(TIME WITH TIME ZONE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(844, 0, null, false, null, "PERIOD(TIMESTAMP)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(848, 0, null, false, null, "PERIOD(TIMESTAMP WITH TIME ZONE)", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(852, 0, CTG_CHAR, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(856, 0, CTG_DEFLOBCHAR, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(860, 0, CTG_CHAR, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(864, 0, CTG_BINARY, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(868, 0, CTG_DEFLOBBIN, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(872, 0, CTG_BINARY, false, null, "XML", 2009, "SQLXML", "java.sql.SQLXML");
        JDBC4Constants.putMaps(880, 0, CTG_CHAR, true, null, "JSON", 1111, "OTHER", "java.sql.Clob");
        JDBC4Constants.putMaps(884, 0, CTG_CHAR, true, null, "JSON", 1111, "OTHER", "java.sql.Clob");
        JDBC4Constants.putMaps(888, 0, CTG_DEFLOBCHAR, true, null, "JSON", 1111, "OTHER", "java.sql.Clob");
        JDBC4Constants.putMaps(0, 0, null, false, null, null, -7, "BIT", "java.lang.Boolean");
        JDBC4Constants.putMaps(0, 0, null, false, null, null, 16, "BOOLEAN", "java.lang.Boolean");
        JDBC4Constants.putMaps(0, 0, null, false, null, null, 8, "DOUBLE", "java.lang.Double");
        JDBC4Constants.putMaps(0, 0, null, false, null, null, 0, "NULL", null);
        JDBC4Constants.putMaps(0, 0, null, false, null, null, 7, "REAL", "java.lang.Double");
    }
}

