/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class AuthMechParcel
extends Parcel {
    private Oid m_oid;
    private int m_nRank = 0;
    private boolean m_bDefaultMechanism = false;
    private boolean m_bDefaultNegotiatingMechanism = false;
    private boolean m_bCIBypassSupported = false;
    private static final int DER_OBJECT_IDENTIFIER = 6;

    public AuthMechParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        int n = this.flavorPosition + this.length;
        if (tDPacketStream.getInt() != 1) {
            return;
        }
        int n2 = tDPacketStream.getInt();
        byte[] byArray = new byte[n2 + 2];
        tDPacketStream.get(byArray, 2, n2);
        byArray[0] = 6;
        byArray[1] = (byte)n2;
        try {
            this.m_oid = new Oid(byArray);
        }
        catch (GSSException gSSException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ342", gSSException.getMessage());
            sQLException.initCause(gSSException);
            throw sQLException;
        }
        while (tDPacketStream.position() + 4 < n) {
            int n3 = tDPacketStream.position();
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            int n4 = tDPacketStream.getInt();
            switch (s) {
                case 16: {
                    this.m_bDefaultMechanism = tDPacketStream.getInt() != 0;
                    break;
                }
                case 17: {
                    this.m_nRank = tDPacketStream.getInt();
                    break;
                }
                case 112: {
                    this.m_bDefaultNegotiatingMechanism = tDPacketStream.getInt() != 0;
                    break;
                }
                case 129: {
                    this.m_bCIBypassSupported = tDPacketStream.getInt() != 0;
                    break;
                }
                default: {
                    this.log.debug("AuthMech parcel: unknown property received: " + s);
                }
            }
            tDPacketStream.position(n3 + s2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("AuthMechParcel: m_oid=" + this.m_oid + " m_nRank=" + this.m_nRank + " DefaultMechanism=" + this.m_bDefaultMechanism + " DefaultNegotiatingMechanism=" + this.m_bDefaultNegotiatingMechanism + " CIBypassSupported=" + this.m_bCIBypassSupported);
        }
    }

    public Oid getMechOid() {
        return this.m_oid;
    }

    public boolean isDefaultMechanism() {
        return this.m_bDefaultMechanism;
    }

    public boolean isDefaultNegotiatingMechanism() {
        return this.m_bDefaultNegotiatingMechanism;
    }

    public boolean isCIBypassSupported() {
        return this.m_bCIBypassSupported;
    }
}

