/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertCastScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertExtraTextScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertIfNullScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertSplitScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertSubStringScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertSwitchArgsScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampAddScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampDiffScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeConverter;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeStringUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.ManageEscapeState;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class EscapeUtil {
    private static Map sm_mapEscFuncNameToClass = EscapeUtil.initClassTable();

    public static String nativeSQL(String string, LocalEscapeFunctions localEscapeFunctions) throws SQLException {
        return EscapeUtil.nativeSQL(string, true, localEscapeFunctions, null);
    }

    public static String nativeSQL(String string, boolean bl, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        if (map != null) {
            map.clear();
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", "null");
        }
        string = ComUtil.remLineFeeds(string);
        string = string.trim();
        if (bl) {
            string = EscapeUtil.processString(string, localEscapeFunctions, map);
        }
        return string;
    }

    private static String processScalarFunction(StringTokenizer stringTokenizer, String string, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        String string2 = null;
        ManageEscapeState manageEscapeState = new ManageEscapeState();
        CommentContext commentContext = new CommentContext();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (EscapeUtil.ignore(string3, manageEscapeState, commentContext)) continue;
            string2 = EscapeUtil.callEscapeInterface(string3, stringTokenizer, true, string, localEscapeFunctions, map);
            break;
        }
        if (string2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ383");
        }
        return EscapeUtil.restoreComments(string2, commentContext);
    }

    private static String convertToNativeSql(String string, String string2, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"'(), \t\n\r\f/*-", true);
        ManageEscapeState manageEscapeState = new ManageEscapeState();
        CommentContext commentContext = new CommentContext();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (EscapeUtil.ignore(string3, manageEscapeState, commentContext)) continue;
            if ("FN".equals(string3.toUpperCase())) {
                string = EscapeUtil.processScalarFunction(stringTokenizer, string2, localEscapeFunctions, map);
                break;
            }
            string = EscapeUtil.callEscapeInterface(string3, stringTokenizer, false, string2, localEscapeFunctions, map);
            break;
        }
        return EscapeUtil.restoreComments(string, commentContext);
    }

    private static String processString(String string, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        int n;
        String string2 = string;
        int n2 = ComUtil.lastIndexOf(string2, "{");
        if (n2 == -1 && (n = ComUtil.indexOf(string2, "}", n2)) != -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ384");
        }
        while (n2 != -1) {
            n = ComUtil.indexOf(string2, "}", n2);
            if (n == -1) {
                throw ErrorFactory.makeDriverJDBCException("TJ384");
            }
            String string3 = string2.substring(n2 + 1, n);
            string3 = EscapeUtil.convertToNativeSql(string3, string, localEscapeFunctions, map);
            boolean bl = n2 == 0 && n + "}".length() == string2.length();
            string2 = EscapeStringUtil.replace(n2, n, string2, string3);
            if (bl) break;
            n2 = ComUtil.lastIndexOf(string2, "{");
        }
        return string2;
    }

    private static String callEscapeInterface(String string, StringTokenizer stringTokenizer, boolean bl, String string2, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        string = string.toUpperCase();
        Class clazz = (Class)sm_mapEscFuncNameToClass.get(string);
        int n = localEscapeFunctions.getTeradataDatabaseVersionNumber();
        if (clazz != null && n >= 1510 && "RIGHT".equals(string)) {
            clazz = null;
        }
        ConfigRspParcel configRspParcel = localEscapeFunctions.getConfigResponse();
        if (clazz != null && configRspParcel != null && configRspParcel.getODBCScalarFunctionLevel() >= 2) {
            if ("CURDATE".equals(string) || "CURTIME".equals(string) || "NOW".equals(string)) {
                return ConvertNoArgScalarFunction.createNativeSQL(string, string + "()", stringTokenizer);
            }
            if ("CONCAT".equals(string) || "DAYOFMONTH".equals(string) || "HOUR".equals(string) || "LEFT".equals(string) || "LENGTH".equals(string) || "LOCATE".equals(string) || "LTRIM".equals(string) || "MINUTE".equals(string) || "MOD".equals(string) || "MONTH".equals(string) || "RTRIM".equals(string) || "SECOND".equals(string) || "SUBSTRING".equals(string) || "UCASE".equals(string) || "YEAR".equals(string)) {
                clazz = null;
            }
        }
        if (clazz != null) {
            Object var9_9 = null;
            try {
                var9_9 = clazz.newInstance();
            }
            catch (Exception exception) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ157", clazz.getName());
                sQLException.initCause(exception);
                throw sQLException;
            }
            EscapeConverter escapeConverter = var9_9;
            return escapeConverter.processTokens(string, stringTokenizer, localEscapeFunctions, map);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl || "ESCAPE".equals(string) || "CALL".equals(string)) {
            stringBuffer.append(string);
        } else if (!"OJ".equals(string)) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String string3 = stringBuffer.toString();
        if ("CALL".equals(string) && ComUtil.lastIndexOf(string3, ")") == -1) {
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = string3 + "()";
        }
        return string3;
    }

    private static Map initClassTable() {
        LinkedHashMap<String, Class<ConvertScalarFunction>> linkedHashMap = new LinkedHashMap<String, Class<ConvertScalarFunction>>();
        linkedHashMap.put("T", ConvertDateTimeLiterals.class);
        linkedHashMap.put("D", ConvertDateTimeLiterals.class);
        linkedHashMap.put("TS", ConvertDateTimeLiterals.class);
        linkedHashMap.put("SECOND", ConvertScalarFunction.class);
        linkedHashMap.put("PI", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("MOD", ConvertSplitScalarFunction.class);
        linkedHashMap.put("LENGTH", ConvertScalarFunction.class);
        linkedHashMap.put("LOCATE", ConvertSwitchArgsScalarFunction.class);
        linkedHashMap.put("ATAN2", ConvertSwitchArgsScalarFunction.class);
        linkedHashMap.put("LTRIM", ConvertScalarFunction.class);
        linkedHashMap.put("RTRIM", ConvertScalarFunction.class);
        linkedHashMap.put("LCASE", ConvertScalarFunction.class);
        linkedHashMap.put("UCASE", ConvertScalarFunction.class);
        linkedHashMap.put("SUBSTRING", ConvertSubStringScalarFunction.class);
        linkedHashMap.put("CONCAT", ConvertSplitScalarFunction.class);
        linkedHashMap.put("CURDATE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("CURTIME", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("NOW", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("MINUTE", ConvertScalarFunction.class);
        linkedHashMap.put("HOUR", ConvertScalarFunction.class);
        linkedHashMap.put("DAYOFMONTH", ConvertScalarFunction.class);
        linkedHashMap.put("MONTH", ConvertScalarFunction.class);
        linkedHashMap.put("YEAR", ConvertScalarFunction.class);
        linkedHashMap.put("TIMESTAMPADD", ConvertTimestampAddScalarFunction.class);
        linkedHashMap.put("TIMESTAMPDIFF", ConvertTimestampDiffScalarFunction.class);
        linkedHashMap.put("DATABASE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("USER", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("IFNULL", ConvertIfNullScalarFunction.class);
        linkedHashMap.put("CONVERT", ConvertCastScalarFunction.class);
        linkedHashMap.put("TERADATA_LOGON_SEQUENCE_NUMBER", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_AMP_COUNT", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_GETLOGLEVEL", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_PROVIDE", ConvertScalarFunction.class);
        linkedHashMap.put("TERADATA_USEANSIDATE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_USEINTEGERDATE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_SESSION_NUMBER", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_SOCKET_INFO", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_UNTRUSTED", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_NOPREPARE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_FAILFAST", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_CALL_PARAM_RS", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("TERADATA_AUTO_OUT_PARAM", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("LOG", ConvertScalarFunction.class);
        linkedHashMap.put("CHAR", ConvertScalarFunction.class);
        linkedHashMap.put("COT", ConvertScalarFunction.class);
        linkedHashMap.put("CURRENT_DATE", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("CURRENT_TIME", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("CURRENT_TIMESTAMP", ConvertNoArgScalarFunction.class);
        linkedHashMap.put("DIFFERENCE", ConvertExtraTextScalarFunction.class);
        linkedHashMap.put("INSERT", ConvertScalarFunction.class);
        linkedHashMap.put("LEFT", ConvertExtraTextScalarFunction.class);
        linkedHashMap.put("LOG10", ConvertScalarFunction.class);
        linkedHashMap.put("RAND", ConvertScalarFunction.class);
        linkedHashMap.put("REPEAT", ConvertScalarFunction.class);
        linkedHashMap.put("REPLACE", ConvertScalarFunction.class);
        linkedHashMap.put("RIGHT", ConvertScalarFunction.class);
        linkedHashMap.put("SPACE", ConvertScalarFunction.class);
        linkedHashMap.put("TRUNCATE", ConvertScalarFunction.class);
        return linkedHashMap;
    }

    private static boolean ignore(String string, ManageEscapeState manageEscapeState, CommentContext commentContext) throws SQLException {
        if (" \t\n\r\f".indexOf(string) != -1) {
            return true;
        }
        boolean bl = true;
        manageEscapeState.setManageEscapeState(string, bl);
        if (!manageEscapeState.inEscapeState() && "/-".indexOf(string) != -1) {
            commentContext.lastToken = string;
            commentContext.commentBuffer = new StringBuffer(string);
            return true;
        }
        if (!manageEscapeState.inEscapeState() && commentContext.lastToken != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", commentContext.lastToken);
        }
        commentContext.lastToken = null;
        if (manageEscapeState.inEscapeState()) {
            commentContext.commentBuffer.append(string);
        }
        return manageEscapeState.inEscapeState();
    }

    private static String restoreComments(String string, CommentContext commentContext) {
        if (commentContext.commentBuffer != null) {
            string = commentContext.commentBuffer + " " + string;
            commentContext.commentBuffer = null;
        }
        return string;
    }

    private static class CommentContext {
        public String lastToken = null;
        public StringBuffer commentBuffer = null;

        private CommentContext() {
        }
    }
}

