/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    private LocatorBlob blob;

    public BlobOutputStream(LocatorBlob locatorBlob) {
        this.blob = locatorBlob;
    }

    @Override
    public void close() {
        this.blob = null;
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.blob == null) {
            throw new IOException(ErrorMessage.messages.getString("TJ550"));
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            this.blob.writeStream(this.blob.length() + 1L, byteArrayInputStream, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }
}

