/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastload.FastLoadCSVConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerConnection;
import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.regex.Matcher;

public class FastLoadCSVPreparedStatement
implements PreparedStatement {
    private static final int DEFAULT_FASTLOAD_MAX_SESSION_COUNT = 8;
    private static final int DATE_STRING_LENGTH = 10;
    private static final int FLOAT_STRING_LENGTH = new Double(Double.MAX_VALUE).toString().length() + 2;
    private static final int RESP_PARCEL_LENGTH = 6;
    private static final int INITIAL_INDIC_DATA_PARCEL_LENGTH = 4;
    private static final int INITIAL_INDIC_DATA_PARCEL_ALT_HEADER_LENGTH = 8;
    private Connection m_conManager = null;
    private TDSession m_controlSession = null;
    private Connection[] m_aconFastLoad = null;
    private boolean m_bFastLoading = false;
    private String m_sMachineName = null;
    private String m_sUserName = null;
    private String m_sPassword = null;
    private String m_sTableName = null;
    private String m_sBeginLoading = null;
    private String m_sUsingInsert = null;
    private Statement m_stmtControl = null;
    private PreparedStatement[] m_apstmtFastLoad = null;
    private ResultSet[] m_arsFastLoad = null;
    private int[] m_anFastLoadRequestNumbers = null;
    private int m_iFastLoadPrepStmt = 0;
    private InputStream m_instream = null;
    private byte[][] m_aabyRequestMessage = null;
    private int m_iRequestMessage = 0;
    private ByteBuffer[] m_abbufRequestMessage = new ByteBuffer[2];
    private int m_iFirstIndicDataParcel = 0;
    private int m_nColumnCount = 0;
    private byte m_byFieldSeparator;
    private int m_nNullIndicatorByteCount = 0;
    private int m_nSerializedRowCount = 0;
    private boolean m_bIsClosed = false;
    private boolean m_bFastLoadSessionsConnected = false;
    private String m_sOriginalSQL = null;
    private SQLWarning m_sqlWarnings = null;

    public FastLoadCSVPreparedStatement(FastLoadCSVConnection fastLoadCSVConnection, String string, String string2, String string3, String string4) throws SQLException {
        this.m_conManager = fastLoadCSVConnection;
        this.m_sMachineName = string;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        this.m_sOriginalSQL = string4;
        this.initializeFastLoad();
    }

    protected void abortIfClosed() throws SQLException {
        if (this.m_conManager.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.m_bIsClosed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ700", n);
        }
    }

    private void initializeFastLoad() throws SQLException {
        try {
            this.connectFastLoad();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ691");
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.m_sqlWarnings == null) {
            this.m_sqlWarnings = sQLWarning;
        } else {
            this.m_sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    public String getLogonSequenceNumber() {
        return this.m_controlSession != null ? this.m_controlSession.getLogonSequenceNumber() : "";
    }

    private int getSessionsCount(int n) throws SQLException {
        int n2;
        int n3 = Integer.parseInt(this.m_controlSession.getAMPCount());
        if (n == 0) {
            n2 = Math.min(8, n3);
        } else {
            n2 = Math.min(n, n3);
            if (n2 < n) {
                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ616", String.valueOf(n), String.valueOf(n2), this.m_sUsingInsert);
                this.chainSQLWarnings(sQLWarning);
            }
        }
        return n2;
    }

    private void connectFastLoad() throws SQLException {
        if (!this.m_bFastLoadSessionsConnected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                int n6;
                URLParameters uRLParameters = ((FastLoadCSVConnection)this.m_conManager).getURLParameters();
                String string = uRLParameters.getFieldSeparator();
                n3 = uRLParameters.getSessions();
                URLParameters uRLParameters2 = new URLParameters(uRLParameters.getDelegatedParameters() + (uRLParameters.getDatabaseName() != null && uRLParameters.getDatabaseName().length() > 0 && !uRLParameters.getDatabaseName().equals("NO_DEF_DATABASE") ? ",DATABASE='" + uRLParameters.getDatabaseName() + "'" : "") + "," + "TMODE" + "=TERA" + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.m_controlSession = (TDSession)ConnectionFactory.createConnection(this.m_sMachineName, this.m_sUserName, this.m_sPassword, uRLParameters2);
                n = Integer.parseInt(this.m_controlSession.getAMPCount());
                this.prepareFastLoad();
                this.validateFieldSeparator(string);
                this.m_stmtControl = this.m_controlSession.createStatement();
                n2 = this.getSessionsCount(n3);
                URLParameters uRLParameters3 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "TYPE" + "=" + "RAW" + "," + "PARTITION" + "=" + "FASTLOAD" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.m_controlSession.getLogonSequenceNumber());
                this.m_aconFastLoad = new Connection[n2];
                for (n6 = 0; n6 < this.m_aconFastLoad.length; ++n6) {
                    this.m_aconFastLoad[n6] = ConnectionFactory.createConnection(this.m_sMachineName, this.m_sUserName, this.m_sPassword, uRLParameters3);
                    ++n4;
                }
                this.m_apstmtFastLoad = new PreparedStatement[this.m_aconFastLoad.length];
                for (n6 = 0; n6 < this.m_apstmtFastLoad.length; ++n6) {
                    this.m_apstmtFastLoad[n6] = this.m_aconFastLoad[n6].prepareStatement(null);
                    ++n5;
                }
                this.m_arsFastLoad = new ResultSet[this.m_apstmtFastLoad.length];
                this.m_anFastLoadRequestNumbers = new int[this.m_apstmtFastLoad.length];
                Arrays.fill(this.m_anFastLoadRequestNumbers, 1);
                if (this.m_aabyRequestMessage == null) {
                    n6 = this.m_controlSession.getMaxMessageSize(true, true);
                    this.m_aabyRequestMessage = new byte[2][n6];
                }
                for (n6 = 0; n6 < this.m_aabyRequestMessage.length; ++n6) {
                    this.m_aabyRequestMessage[n6][0] = 3;
                    this.m_aabyRequestMessage[n6][1] = 1;
                    this.m_aabyRequestMessage[n6][2] = 5;
                    this.m_aabyRequestMessage[n6][37] = this.m_controlSession.getTdSessionCharSetCode();
                    this.m_abbufRequestMessage[n6] = ByteBuffer.wrap(this.m_aabyRequestMessage[n6]);
                    this.m_abbufRequestMessage[n6].position(52);
                }
                this.m_iFirstIndicDataParcel = this.m_abbufRequestMessage[0].position();
                this.m_iFastLoadPrepStmt = 0;
                this.m_iRequestMessage = 0;
                this.m_controlSession.getLog().info("FastLoad found " + n + " AMP (s) in " + this.m_sMachineName + " and created " + n4 + " FastLoadConnection (s) and " + n5 + " FastLoadPreparedStatement (s) with SESSIONS=" + n3 + ".");
                this.m_bFastLoadSessionsConnected = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ690", String.valueOf(n), String.valueOf(n4), String.valueOf(n5), String.valueOf(n3));
                sQLException4.setNextException(sQLException);
                throw sQLException4;
            }
        }
    }

    private String getTeradataTypeCast(int n, FullContentMetadataItem fullContentMetadataItem, String string) throws SQLException {
        String string2 = null;
        String string3 = fullContentMetadataItem.getCustomerVisibleColumnTypeName();
        if (string3.equals("BIGINT") || string3.equals("BYTEINT") || string3.equals("INTEGER") || string3.equals("SMALLINT")) {
            string2 = "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 1) + ")";
        } else if (string3.equals("FLOAT")) {
            string2 = "VARCHAR (" + FLOAT_STRING_LENGTH + ")";
        } else if (string3.equals("DATE")) {
            string2 = "VARCHAR (10)";
        } else if (string3.endsWith("CHAR") || string3.startsWith("INTERVAL")) {
            if (string3.endsWith("CHAR") && this.m_controlSession.getURLParameters().getCharSet().equals("ASCII") && fullContentMetadataItem.getCharsetCode() != 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ708", String.valueOf(n));
            }
            long l = "UTF8".equals(string) ? Math.min(fullContentMetadataItem.getMaxDataLengthInBytes(), 32000L) : fullContentMetadataItem.getMaxDataLengthInBytes();
            string2 = "VARCHAR (" + l + ")";
        } else if (string3.equals("DECIMAL")) {
            string2 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 1) + ")" : "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 2) + ")";
        } else if (string3.equals("NUMBER")) {
            string2 = "VARCHAR (71)";
        } else if (string3.startsWith("TIME")) {
            if (string3.startsWith("TIMESTAMP")) {
                int n2 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = "VARCHAR (" + (25 + n2) + ")";
            } else {
                int n3 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = "VARCHAR (" + (14 + n3) + ")";
            }
        } else if (string3.startsWith("PERIOD")) {
            if (string3.startsWith("PERIOD(DATE")) {
                string2 = "VARCHAR(28)";
            } else if (string3.startsWith("PERIOD(TIMESTAMP")) {
                int n4 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = "VARCHAR(" + ((25 + n4) * 2 + 8) + ")";
            } else {
                int n5 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = "VARCHAR(" + ((14 + n5) * 2 + 8) + ")";
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ546", string3, String.valueOf(n));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFastLoad() throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("USING ");
        StringBuffer stringBuffer2 = new StringBuffer(" INSERT INTO ");
        StringBuffer stringBuffer3 = new StringBuffer(" VALUES ( ");
        try (PreparedStatement preparedStatement = this.m_controlSession.prepareStatement(this.m_sOriginalSQL);){
            object4 = this.m_controlSession.getURLParameters().getCharSet();
            if (!((String)object4).equals("ASCII") && !((String)object4).equals("UTF8")) {
                throw ErrorFactory.makeDriverJDBCException("TJ701", (String)object4);
            }
            object3 = (TDPreparedStatement)preparedStatement;
            object2 = ((TDStatement)object3).getMetaDataList();
            if (((MetaDataList)object2).size() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ628");
            }
            if (((MetaDataList)object2).size() > 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ541");
            }
            object = ((MetaDataList)object2).getFirstMetaData();
            if (!ActivityAnalyzer.isFastLoadCompatible(((TeraResultSetMetaData)object).getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ542");
            }
            if (((TDStatement)object3).hasGeneratedKeysRequest()) {
                throw ErrorFactory.makeDriverJDBCException("TJ543");
            }
            if (!this.m_controlSession.isStatementInfoSupported()) {
                throw ErrorFactory.makeDriverJDBCException("TJ696");
            }
            ArrayList arrayList = ((TDPreparedStatement)object3).getParameterMarkerMetaData();
            Matcher matcher = FastLoadManagerConnection.matchInsertValuesStatement(((TDPreparedStatement)object3).getOriginalSql());
            if (!matcher.matches()) {
                throw ErrorFactory.makeDriverJDBCException("TJ544");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)arrayList.get(i);
                String string3 = this.getTeradataTypeCast(i + 1, fullContentMetadataItem, (String)object4);
                if (i == 0) {
                    string = fullContentMetadataItem.getDatabaseName();
                    string2 = fullContentMetadataItem.getProcedureOrTableName();
                    stringBuffer2.append(Utility.quoteName(string) + "." + Utility.quoteName(string2) + " ( ");
                } else {
                    stringBuffer.append(", ");
                    stringBuffer2.append(", ");
                    stringBuffer3.append(", ");
                }
                String string4 = fullContentMetadataItem.getColumnOrParameterName();
                stringBuffer.append(Utility.quoteName("F_" + string4) + " (" + string3 + ")");
                stringBuffer2.append(Utility.quoteName(string4));
                stringBuffer3.append(":" + Utility.quoteName("F_" + string4));
            }
        }
        stringBuffer2.append(" )");
        stringBuffer3.append(" )");
        this.m_sTableName = Utility.quoteName(string) + "." + Utility.quoteName(string2);
        object4 = ((FastLoadCSVConnection)this.m_conManager).getURLParameters();
        object3 = ((URLParameters)object4).getErrorTableDatabase() != null ? ((URLParameters)object4).getErrorTableDatabase() : string;
        object2 = Utility.quoteName((String)object3) + "." + Utility.quoteName(string2 + ((URLParameters)object4).getErrorTable1Suffix());
        object = Utility.quoteName((String)object3) + "." + Utility.quoteName(string2 + ((URLParameters)object4).getErrorTable2Suffix());
        this.m_sBeginLoading = "BEGIN LOADING " + this.m_sTableName + " ERRORFILES " + (String)object2 + ", " + (String)object + " WITH INTERVAL";
        this.m_sUsingInsert = stringBuffer.toString() + stringBuffer2.toString() + stringBuffer3.toString();
        this.m_controlSession.getLog().info("FastLoad " + this.m_sUsingInsert);
    }

    private void validateFieldSeparator(String string) throws SQLException {
        byte[] byArray;
        String string2 = string;
        if (string2.equals("\\")) {
            throw ErrorFactory.makeDriverJDBCException("TJ703", string);
        }
        if (string.length() == 6 && string.startsWith("\\u")) {
            try {
                string2 = String.valueOf((char)Integer.parseInt(string.substring(2, string.length()), 16));
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ704", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
        if ((byArray = Encoder.encodeFieldSep(this.m_controlSession, string2)).length != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ706", string);
        }
        this.m_byFieldSeparator = byArray[0];
        if (this.m_byFieldSeparator == 13 || this.m_byFieldSeparator == 10 || this.m_byFieldSeparator == 34) {
            throw ErrorFactory.makeDriverJDBCException("TJ707", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastLoad() throws SQLException {
        SQLException sQLException = null;
        try {
            SQLException sQLException2;
            int n;
            if (this.m_arsFastLoad != null) {
                for (n = 0; n < this.m_arsFastLoad.length; ++n) {
                    if (this.m_arsFastLoad[n] == null) continue;
                    try {
                        this.m_arsFastLoad[n].close();
                        continue;
                    }
                    catch (SQLException sQLException3) {
                        sQLException2 = ErrorFactory.makeDriverJDBCException("TJ693", n, this.m_arsFastLoad.length);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
            }
            if (this.m_apstmtFastLoad != null) {
                for (n = 0; n < this.m_apstmtFastLoad.length; ++n) {
                    if (this.m_apstmtFastLoad[n] == null) continue;
                    try {
                        this.m_apstmtFastLoad[n].close();
                        continue;
                    }
                    catch (SQLException sQLException4) {
                        sQLException2 = ErrorFactory.makeDriverJDBCException("TJ694", n, this.m_apstmtFastLoad.length);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                    }
                }
            }
            if (this.m_stmtControl != null) {
                try {
                    this.m_stmtControl.close();
                }
                catch (SQLException sQLException5) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                }
            }
            if (this.m_aconFastLoad != null) {
                for (int i = 0; i < this.m_aconFastLoad.length; ++i) {
                    if (this.m_aconFastLoad[i] == null) continue;
                    try {
                        this.m_aconFastLoad[i].close();
                        continue;
                    }
                    catch (SQLException sQLException6) {
                        sQLException2 = ErrorFactory.makeDriverJDBCException("TJ695", i, this.m_aconFastLoad.length);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                    }
                }
            }
            if (this.m_controlSession != null) {
                try {
                    this.m_controlSession.close();
                }
                catch (SQLException sQLException7) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                }
            }
        }
        finally {
            this.m_bFastLoadSessionsConnected = false;
            this.m_arsFastLoad = null;
            this.m_apstmtFastLoad = null;
            this.m_stmtControl = null;
            this.m_aconFastLoad = null;
            this.m_controlSession = null;
        }
        if (sQLException != null) {
            SQLException sQLException8 = ErrorFactory.makeDriverJDBCException("TJ692");
            sQLException8.setNextException(sQLException);
            throw sQLException8;
        }
    }

    private void beginFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && !this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                this.abortFastLoad();
                try {
                    this.m_stmtControl.execute(this.m_sBeginLoading);
                    this.m_bFastLoading = true;
                    this.m_controlSession.setAutoCommit(false);
                    this.m_stmtControl.executeUpdate(this.m_sUsingInsert);
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    this.abortFastLoad();
                }
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            }
            if (sQLException != null) {
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ460", this.m_sTableName);
                sQLException4.setNextException(sQLException);
                throw sQLException4;
            }
        }
    }

    private void abortFastLoad() throws SQLException {
        if (!this.m_bFastLoadSessionsConnected) {
            return;
        }
        SQLException sQLException = null;
        boolean bl = false;
        try {
            if (this.m_bFastLoading) {
                try {
                    this.flushRequestMessage();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                this.closeFastLoad();
                this.connectFastLoad();
            } else {
                try {
                    this.m_stmtControl.executeQuery("SELECT 1 FROM " + this.m_sTableName + " WHERE 1=2");
                }
                catch (SQLException sQLException3) {
                    if (sQLException3.getErrorCode() == 2652) {
                        bl = true;
                    }
                    throw sQLException3;
                }
            }
            if (this.m_bFastLoading || bl) {
                this.m_controlSession.setAutoCommit(true);
                this.m_stmtControl.execute(this.m_sBeginLoading);
                this.m_controlSession.setAutoCommit(false);
                this.m_stmtControl.executeUpdate("END LOADING");
                this.m_controlSession.commit();
                this.m_controlSession.setAutoCommit(true);
                this.m_stmtControl.executeUpdate("DELETE " + this.m_sTableName + " ALL");
            }
        }
        catch (SQLException sQLException4) {
            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
        }
        if (sQLException != null) {
            SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ477", this.m_sTableName);
            sQLException5.setNextException(sQLException);
            throw sQLException5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                try {
                    this.flushRequestMessage();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                this.m_stmtControl.executeUpdate("CHECKPOINT LOADING END");
                this.m_controlSession.commit();
                int n = this.m_stmtControl.executeUpdate("END LOADING");
                if (n != this.m_nSerializedRowCount) {
                    SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ476", String.valueOf(this.m_nSerializedRowCount - n), this.m_sTableName, String.valueOf(this.m_nSerializedRowCount), String.valueOf(n));
                    ((FastLoadCSVConnection)this.m_conManager).chainSQLWarnings(sQLWarning);
                }
                this.m_controlSession.commit();
                this.m_controlSession.setAutoCommit(true);
                this.closeFastLoad();
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                try {
                    this.abortFastLoad();
                }
                catch (SQLException sQLException4) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                }
            }
            finally {
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)this.m_conManager).removeStatement(this);
                }
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ461", this.m_sTableName);
                sQLException5.setNextException(sQLException);
                throw sQLException5;
            }
        }
    }

    protected void rollbackFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                this.abortFastLoad();
                if (this.m_bIsClosed) {
                    this.closeFastLoad();
                }
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            finally {
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)this.m_conManager).removeStatement(this);
                }
            }
            if (sQLException != null) {
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ478", this.m_sTableName);
                sQLException3.setNextException(sQLException);
                throw sQLException3;
            }
        }
    }

    protected boolean isFastLoading() {
        return this.m_bFastLoading;
    }

    private int setParcelHeader(int n) {
        int n2 = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)n);
        if (n == -32700) {
            this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)0);
            this.m_abbufRequestMessage[this.m_iRequestMessage].putInt(8);
        } else {
            this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)4);
        }
        return n2;
    }

    private void setParcelLength(int n) {
        int n2 = this.m_abbufRequestMessage[this.m_iRequestMessage].position() - n;
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort(n + 2, (short)n2);
    }

    private void addRespParcel() {
        int n = this.setParcelHeader(4);
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)-432);
        this.setParcelLength(n);
    }

    private void sendRequestMessage() throws SQLException {
        this.addRespParcel();
        int n = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
        int n2 = n - 52;
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(n2);
        this.m_aabyRequestMessage[this.m_iRequestMessage][3] = byArray[0];
        this.m_aabyRequestMessage[this.m_iRequestMessage][4] = byArray[1];
        this.m_aabyRequestMessage[this.m_iRequestMessage][8] = byArray[2];
        this.m_aabyRequestMessage[this.m_iRequestMessage][9] = byArray[3];
        this.m_abbufRequestMessage[this.m_iRequestMessage].putInt(32, this.m_anFastLoadRequestNumbers[this.m_iFastLoadPrepStmt]);
        if (this.m_arsFastLoad[this.m_iFastLoadPrepStmt] != null) {
            this.receiveResponseMessage(this.m_aconFastLoad[this.m_iFastLoadPrepStmt], this.m_arsFastLoad[this.m_iFastLoadPrepStmt]);
        }
        this.m_apstmtFastLoad[this.m_iFastLoadPrepStmt].setObject(1, (Object)this.m_aabyRequestMessage[this.m_iRequestMessage], -2, n);
        this.m_arsFastLoad[this.m_iFastLoadPrepStmt] = this.m_apstmtFastLoad[this.m_iFastLoadPrepStmt].executeQuery();
        int n3 = this.m_iFastLoadPrepStmt;
        this.m_anFastLoadRequestNumbers[n3] = this.m_anFastLoadRequestNumbers[n3] + 1;
        this.m_iFastLoadPrepStmt = (this.m_iFastLoadPrepStmt + 1) % this.m_apstmtFastLoad.length;
    }

    private void receiveResponseMessage(Connection connection, ResultSet resultSet) throws SQLException {
        byte[] byArray;
        ByteBuffer byteBuffer;
        int n;
        if (resultSet.next() && (n = (byteBuffer = ByteBuffer.wrap(byArray = resultSet.getBytes(1))).getShort(52) & Short.MAX_VALUE) != 8) {
            TDPacket tDPacket = new TDPacket(0);
            tDPacket.getBuffer().setBuffer(byArray);
            tDPacket.initParcelFactory((RawConnection)connection);
            Parcel parcel = null;
            block6: while ((parcel = tDPacket.nextParcel()) != null) {
                ((RawConnection)connection).getLog().debug("Parcel flavor: " + parcel.getFlavor());
                switch (parcel.getFlavor()) {
                    case 8: {
                        SuccessParcel successParcel = (SuccessParcel)parcel;
                        continue block6;
                    }
                    case 9: {
                        FailureParcel failureParcel = (FailureParcel)parcel;
                        ((RawConnection)connection).getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        ((RawConnection)connection).getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    case 12: {
                        return;
                    }
                }
                ((RawConnection)connection).getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
            }
            ((RawConnection)connection).getLog().error("Did not receive an expected parcel from the database");
            throw ErrorFactory.makeIoJDBCException("TJ420", "FastLoadCSVPreparedStatement.receiveResponseMessage", ((RawConnection)connection).getIO(), null, ((RawConnection)connection).getLog());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        this.m_instream = null;
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int executeUpdate() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (n2 != -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ699", n2);
        }
        this.m_instream = inputStream;
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.m_sqlWarnings = null;
        if (this.m_bFastLoadSessionsConnected) {
            this.m_stmtControl.clearWarnings();
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        SQLException sQLException = null;
        try {
            if (!this.m_bFastLoading) {
                this.closeFastLoad();
            }
        }
        catch (SQLException sQLException2) {
            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        finally {
            this.m_bIsClosed = true;
            if (!this.m_bFastLoading) {
                ((FastLoadCSVConnection)this.m_conManager).removeStatement(this);
            }
        }
        if (sQLException != null) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ466", this.m_sTableName);
            sQLException3.setNextException(sQLException);
            throw sQLException3;
        }
    }

    private void flushRequestMessage() throws SQLException {
        SQLException sQLException = null;
        try {
            if (this.m_abbufRequestMessage[this.m_iRequestMessage].position() > this.m_iFirstIndicDataParcel) {
                try {
                    this.sendRequestMessage();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            if (this.m_arsFastLoad != null) {
                for (int i = 0; i < this.m_arsFastLoad.length; ++i) {
                    if (this.m_arsFastLoad[i] == null) continue;
                    try {
                        this.receiveResponseMessage(this.m_aconFastLoad[i], this.m_arsFastLoad[i]);
                        continue;
                    }
                    catch (SQLException sQLException3) {
                        SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ693", i, this.m_arsFastLoad.length);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
            }
        }
        catch (Exception exception) {
            SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ727");
            sQLException5.initCause(exception);
            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.m_conManager;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.m_bFastLoadSessionsConnected) {
            this.chainSQLWarnings(this.m_stmtControl.getWarnings());
            this.m_stmtControl.clearWarnings();
        }
        return this.m_sqlWarnings;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_bIsClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        this.m_instream = inputStream;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (l != -1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ699", String.valueOf(l));
        }
        this.m_instream = inputStream;
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

