/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.BearerFlow;
import com.teradata.jdbc.jdbc.BrowserAuth;
import com.teradata.jdbc.jdbc.ClientCredFlow;
import com.teradata.jdbc.jdbc.ClientSecretFlow;
import com.teradata.jdbc.jdbc.DeviceCodeFlow;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.PasswordFlow;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TokenCache {
    private static Map<String, CacheEntry> sm_cache = new LinkedHashMap<String, CacheEntry>();
    private static final String FINDER_SEP = "\u001f";

    private static CacheEntry newCacheEntry(String string, CacheContext cacheContext) {
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.sEndpointURL = string;
        cacheEntry.sRefreshToken = cacheContext.sRefreshToken;
        cacheEntry.sJWT = cacheContext.sJWT;
        cacheEntry.nExpireTimeSecs = cacheContext.nExpireTimeSecs;
        cacheEntry.sClaimValue = cacheContext.sClaimValue;
        cacheEntry.sUserDesc = cacheContext.sUserDesc;
        cacheEntry.nReuseCount = 0;
        cacheEntry.nAccessTimeMs = System.currentTimeMillis();
        cacheEntry.nCreateTimeSecs = cacheEntry.nAccessTimeMs / 1000L;
        return cacheEntry;
    }

    private static CacheEntry copyCacheEntry(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return null;
        }
        ++cacheEntry.nReuseCount;
        cacheEntry.nAccessTimeMs = System.currentTimeMillis();
        return cacheEntry.clone();
    }

    private static String composeCacheKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        string3 = Utility.coalesce(string3, "");
        string4 = Utility.coalesce(string4, "");
        string7 = Utility.coalesce(string7, "").toLowerCase();
        string8 = Utility.coalesce(string8, "");
        string9 = Utility.coalesce(string9, "");
        return Utility.safeForURL(string) + "&" + Utility.safeForURL(string2) + "&" + Utility.safeForURL(string3) + "&" + Utility.safeForURL(string4) + "&" + Utility.safeForURL(string5) + "&" + Utility.safeForURL(string6) + "&" + Utility.safeForURL(string7) + "&" + Utility.safeForURL(string8) + "&" + Utility.safeForURL(string9);
    }

    private static void parseIdPResponse(GenericTeradataConnection genericTeradataConnection, String string, String string2, CacheContext cacheContext) throws SQLException {
        String[] stringArray;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        String string3 = uRLParameters.getLogMech();
        String string4 = uRLParameters.getOIDCToken();
        String string5 = uRLParameters.getOIDCClaim();
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sLogMech=" + string3);
            log.debug("parseIdPResponse: sOIDCToken=" + string4);
            log.debug("parseIdPResponse: sOIDCClaim=" + string5);
            log.debug("parseIdPResponse: sEndpointURL=" + string);
            log.debug("parseIdPResponse: sIdPResponse=" + string2);
        }
        cacheContext.sRefreshToken = Utility.getStringFromJSON("refresh_token", string2, null, null);
        cacheContext.sJWT = Utility.getStringFromJSON(string4, string2, "TJ1552", string);
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sJWT=" + cacheContext.sJWT);
        }
        if ((stringArray = Utility.getJWTHeaderAndPayload(cacheContext.sJWT, log, "parseIdPResponse")) == null) {
            throw Utility.logEx(log, "parseIdPResponse", ErrorFactory.makeDriverJDBCException("TJ1552", string4, string));
        }
        String string6 = stringArray[1];
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sJWTPayload=" + string6);
        }
        cacheContext.nExpireTimeSecs = Utility.getLongFromJSON("exp", string6, null, null, 0L);
        cacheContext.sClaimValue = Utility.getStringFromJSON(string5, string6, null, null);
        cacheContext.sUserDesc = string4 + " " + string5 + " " + Utility.coalesce(cacheContext.sClaimValue, "unavailable");
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sCacheStatus=" + cacheContext.sCacheStatus);
            log.debug("parseIdPResponse: sRefreshToken=" + cacheContext.sRefreshToken);
            log.debug("parseIdPResponse: sJWT=" + cacheContext.sJWT);
            log.debug("parseIdPResponse: nExpireTimeSecs=" + cacheContext.nExpireTimeSecs);
            log.debug("parseIdPResponse: sClaimValue=" + cacheContext.sClaimValue);
            log.debug("parseIdPResponse: sUserDesc=" + cacheContext.sUserDesc);
            log.debug("parseIdPResponse: nReuseCount=" + cacheContext.nReuseCount);
        }
    }

    private static String makeFinder(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return Utility.coalesce(string, "") + FINDER_SEP + Utility.coalesce(string2, "") + FINDER_SEP + Utility.coalesce(string3, "") + FINDER_SEP + Utility.coalesce(string4, "") + FINDER_SEP + Utility.coalesce(string5, "") + FINDER_SEP + bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] findToken(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter findToken");
        }
        try {
            String[] stringArray = string.split(FINDER_SEP);
            String string2 = stringArray[0].equals("") ? null : stringArray[0];
            String string3 = stringArray[1].equals("") ? null : stringArray[1];
            String string4 = stringArray[2].equals("") ? null : stringArray[2];
            String string5 = stringArray[3].equals("") ? null : stringArray[3];
            String string6 = stringArray[4].equals("") ? null : stringArray[4];
            boolean bl = Boolean.parseBoolean(stringArray[5]);
            String[] stringArray2 = TokenCache.doSingleOIDCFlow(genericTeradataConnection, string2, string3, string4, string5, string6, bl);
            return stringArray2;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave findToken");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] doSingleOIDCFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doSingleOIDCFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            String[] stringArray;
            CacheContext cacheContext = TokenCache.getCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl);
            if (cacheContext.sJWT == null) {
                stringArray = genericTeradataConnection.getURLParameters().getLogMech();
                if ("BROWSER".equalsIgnoreCase((String)stringArray)) {
                    BrowserAuth.doBrowserAuth(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                } else if ("BEARER".equalsIgnoreCase((String)stringArray)) {
                    BearerFlow.doBearerFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                } else if ("CODE".equalsIgnoreCase((String)stringArray)) {
                    DeviceCodeFlow.doDeviceCodeFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                } else if ("CRED".equalsIgnoreCase((String)stringArray)) {
                    ClientCredFlow.doClientCredFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                } else if ("ROPC".equalsIgnoreCase((String)stringArray)) {
                    PasswordFlow.doPasswordFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                } else if ("SECRET".equalsIgnoreCase((String)stringArray)) {
                    ClientSecretFlow.doClientSecretFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
                }
            }
            if (cacheContext.sJWT != null) {
                stringArray = new String[]{string5, cacheContext.sJWT};
                return stringArray;
            }
            stringArray = null;
            return stringArray;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doSingleOIDCFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doAllNeededOIDCFlows(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doAllNeededOIDCFlows");
        }
        try {
            String string;
            String string2;
            Object object;
            String string3;
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            String string4 = uRLParameters.getLogMech();
            LogonInformation logonInformation = genericTeradataConnection.getLogonInformation();
            String string5 = logonInformation.getUserName();
            String string6 = logonInformation.getPassword();
            if ("BROWSER".equalsIgnoreCase(string4)) {
                BrowserAuth.validateBrowserAuth(genericTeradataConnection, string5, string6);
            } else if ("BEARER".equalsIgnoreCase(string4)) {
                BearerFlow.validateBearerFlow(genericTeradataConnection, string5, string6);
            } else if ("CODE".equalsIgnoreCase(string4)) {
                DeviceCodeFlow.validateDeviceCodeFlow(genericTeradataConnection, string5, string6);
            } else if ("CRED".equalsIgnoreCase(string4)) {
                ClientCredFlow.validateClientCredFlow(genericTeradataConnection, string5, string6);
            } else if ("ROPC".equalsIgnoreCase(string4)) {
                PasswordFlow.validatePasswordFlow(genericTeradataConnection, string5, string6);
            } else if ("SECRET".equalsIgnoreCase(string4)) {
                ClientSecretFlow.validateClientSecretFlow(genericTeradataConnection, string5, string6);
            } else {
                return;
            }
            GtwConfigParcel gtwConfigParcel = genericTeradataConnection.getGtwConfig();
            if (gtwConfigParcel == null || gtwConfigParcel.getIdentityProviderURL() == null || gtwConfigParcel.getIdentityProviderClientID() == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ1579", string4);
            }
            if ("CRED".equalsIgnoreCase(string4)) {
                string3 = uRLParameters.getLogData();
                if (log.isDebugEnabled()) {
                    log.debug("sFormData=" + string3);
                }
                object = Utility.parseFormData(string3);
                string2 = object.get("client_id");
                string = object.get("scope");
            } else {
                string2 = uRLParameters.getOIDCClientID();
                if (string2 == null) {
                    string2 = gtwConfigParcel.getIdentityProviderClientID();
                }
                if ((string = uRLParameters.getOIDCScope()) == null) {
                    string = gtwConfigParcel.getOIDCScope();
                }
                if (string == null) {
                    string = "openid";
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("sClientID=" + string2);
                log.debug("sOIDCScope=" + string);
            }
            string3 = Utility.coalesce(uRLParameters.getOIDCMetadata(), gtwConfigParcel.getIdentityProviderURL());
            if (log.isDebugEnabled()) {
                log.debug("sIdProURL=" + string3);
            }
            if ((string3 = string3.replaceFirst("/+$", "")).length() == 0 || string2.length() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
            }
            object = "/.well-known/openid-configuration";
            if (!string3.toLowerCase().endsWith((String)object)) {
                string3 = string3 + (String)object;
                if (log.isDebugEnabled()) {
                    log.debug("Modified sIdProURL=" + string3);
                }
            }
            String[] stringArray = Utility.joinStrings(string, "|", uRLParameters.getOAuthScopes()).split("\\|");
            for (int i = 0; i < stringArray.length; ++i) {
                TokenCache.doSingleOIDCFlow(genericTeradataConnection, string5, string6, string3, string2, stringArray[i], i > 0);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doAllNeededOIDCFlows");
            }
        }
    }

    private static void completeOIDCFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, CacheContext cacheContext) {
        boolean bl2;
        int n;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        ClientAttributesParcel.Extra extra = genericTeradataConnection.m_extraClientAttributes;
        Log log = genericTeradataConnection.getLog();
        String string6 = uRLParameters.getLogMech();
        String string7 = cacheContext.sCacheStatus != null ? "" + cacheContext.nReuseCount : null;
        String string8 = cacheContext.sRefreshToken != null ? "Y" : "N";
        String string9 = "" + cacheContext.tokenTTLSecs();
        if (bl && string5 != null) {
            extra.sOAuthReuseCounts = Utility.joinStrings(extra.sOAuthReuseCounts, ",", string7);
            extra.sOAuthRefreshAvail = Utility.joinStrings(extra.sOAuthRefreshAvail, "", string8);
            extra.sOAuthScopes = Utility.joinStrings(extra.sOAuthScopes, "|", string5);
        }
        boolean bl3 = ((n = uRLParameters.getOAuthLevel()) & 1) != 0;
        boolean bl4 = (n & 2) != 0;
        boolean bl5 = bl2 = bl && bl4 || !bl && bl3 || uRLParameters.getTokenMode();
        if (bl2 && string5 != null) {
            genericTeradataConnection.m_setTokenFinders.add(TokenCache.makeFinder(string, string2, string3, string4, string5, bl));
        }
        if (log.isDebugEnabled()) {
            log.debug("completeOIDCFlow: sLogMech=" + string6);
            log.debug("completeOIDCFlow: bOAuthFlow=" + bl);
            log.debug("completeOIDCFlow: sOAuthReuseCounts=" + extra.sOAuthReuseCounts);
            log.debug("completeOIDCFlow: sOAuthRefreshAvail=" + extra.sOAuthRefreshAvail);
            log.debug("completeOIDCFlow: sOAuthScopes=" + extra.sOAuthScopes);
            log.debug("completeOIDCFlow: nOAuthLevel=" + n);
            log.debug("completeOIDCFlow: bSendOIDCToken=" + bl3);
            log.debug("completeOIDCFlow: bSendOAuthToken=" + bl4);
            log.debug("completeOIDCFlow: getTokenMode=" + uRLParameters.getTokenMode());
            log.debug("completeOIDCFlow: bAddToken=" + bl2);
            log.debug("completeOIDCFlow: TokenFinders.size=" + genericTeradataConnection.m_setTokenFinders.size());
            log.debug("completeOIDCFlow: sIdProURL=" + string3);
            log.debug("completeOIDCFlow: sClientID=" + string4);
            log.debug("completeOIDCFlow: sOIDCScope=" + string5);
            log.debug("completeOIDCFlow: sUserName=" + string);
            log.debug("completeOIDCFlow: sPassword=" + string2);
            log.debug("completeOIDCFlow: sUserDesc=" + cacheContext.sUserDesc);
            log.debug("completeOIDCFlow: sCacheStatus=" + cacheContext.sCacheStatus);
            log.debug("completeOIDCFlow: sReuseCount=" + string7);
            log.debug("completeOIDCFlow: sRefreshTokenAvail=" + string8);
            log.debug("completeOIDCFlow: sTokenTTLSecs=" + string9);
            log.debug("completeOIDCFlow: sJWT=" + cacheContext.sJWT);
        }
        if (bl) {
            return;
        }
        extra.sOIDCMetadataURL = string3;
        extra.sOIDCClientID = string4;
        extra.sLogonOIDCScope = string5;
        extra.sOIDCLoginHint = string;
        extra.sOIDCTokenKind = cacheContext.sUserDesc;
        extra.sTokenCacheStatus = cacheContext.sCacheStatus;
        extra.sTokenReuseCount = string7;
        extra.sRefreshTokenAvail = string8;
        extra.sTokenTTLSecs = string9;
        genericTeradataConnection.m_sLogMechForTDGSS = "JWT";
        genericTeradataConnection.m_sLogDataForTDGSS = "token=" + cacheContext.sJWT;
        if (log.isDebugEnabled()) {
            log.debug("completeOIDCFlow: m_sLogMechForTDGSS=" + genericTeradataConnection.m_sLogMechForTDGSS);
            log.debug("completeOIDCFlow: m_sLogDataForTDGSS=" + genericTeradataConnection.m_sLogDataForTDGSS);
        }
        if (cacheContext.sCacheStatus != null) {
            genericTeradataConnection.setNoTransmitCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheContext getCacheEntry(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter getCacheEntry bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            Object object;
            String string6;
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            String string7 = uRLParameters.getLogMech();
            String string8 = uRLParameters.getLogData();
            int n = uRLParameters.getOIDCCacheSize();
            String string9 = uRLParameters.getOIDCToken();
            String string10 = uRLParameters.getOIDCClaim();
            if (log.isDebugEnabled()) {
                log.debug("getCacheEntry: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
                log.debug("getCacheEntry: sLogMech=" + string7);
                log.debug("getCacheEntry: sIdProURL=" + string3);
                log.debug("getCacheEntry: sClientID=" + string4);
                log.debug("getCacheEntry: sOIDCScope=" + string5);
                log.debug("getCacheEntry: bOAuthFlow=" + bl);
                log.debug("getCacheEntry: sOIDCToken=" + string9);
                log.debug("getCacheEntry: sOIDCClaim=" + string10);
                log.debug("getCacheEntry: sUserName=" + string);
                log.debug("getCacheEntry: sPassword=" + string2);
                log.debug("getCacheEntry: sLogData=" + string8);
            }
            CacheContext cacheContext = new CacheContext();
            if (n == 0) {
                cacheContext.sCacheStatus = "O";
                string6 = "turned off";
            } else {
                CacheEntry cacheEntry;
                object = TokenCache.composeCacheKey(string7, string3, string4, string5, string9, string10, string, string2, string8);
                if (log.isDebugEnabled()) {
                    log.debug("getCacheEntry: sKey=" + (String)object);
                }
                Map<String, CacheEntry> map = sm_cache;
                synchronized (map) {
                    cacheEntry = TokenCache.copyCacheEntry(sm_cache.get(object));
                }
                if (cacheEntry == null) {
                    cacheContext.sCacheStatus = "M";
                    string6 = "miss";
                } else {
                    boolean bl2;
                    long l = uRLParameters.getOIDCRefreshPercent();
                    boolean bl3 = uRLParameters.getOIDCRefresh();
                    long l2 = cacheEntry.nExpireTimeSecs > cacheEntry.nCreateTimeSecs ? cacheEntry.nExpireTimeSecs - cacheEntry.nCreateTimeSecs : 0L;
                    long l3 = l2 * l / 100L;
                    long l4 = cacheEntry.nExpireTimeSecs - l3;
                    long l5 = System.currentTimeMillis() / 1000L;
                    boolean bl4 = bl2 = l5 < l4;
                    if (log.isDebugEnabled()) {
                        log.debug("getCacheEntry: nEarlyPercent=" + l + " bRefreshEnabled=" + bl3 + " nExpireTimeSecs=" + cacheEntry.nExpireTimeSecs + " nLifespanSecs=" + l2 + " nEarlyAmountSecs=" + l3 + " nDeadlineSecs=" + l4 + " nCurrentTimeSecs=" + l5 + " bValid=" + bl2 + " sOIDCScope=" + string5);
                    }
                    String string11 = string9 + " reused " + (cacheEntry.nReuseCount == 1 ? "once" : cacheEntry.nReuseCount + " times");
                    if (bl2) {
                        cacheContext.sCacheStatus = "H";
                        string6 = "hit with valid " + string11;
                        cacheContext.sRefreshToken = cacheEntry.sRefreshToken;
                        cacheContext.sJWT = cacheEntry.sJWT;
                        cacheContext.nExpireTimeSecs = cacheEntry.nExpireTimeSecs;
                        cacheContext.sClaimValue = cacheEntry.sClaimValue;
                        cacheContext.sUserDesc = cacheEntry.sUserDesc;
                        cacheContext.nReuseCount = cacheEntry.nReuseCount;
                    } else if (cacheEntry.sRefreshToken == null) {
                        cacheContext.sCacheStatus = "X";
                        string6 = "hit with expired " + string11;
                    } else if (bl3) {
                        TokenCache.doRefreshFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheEntry.sRefreshToken, cacheContext);
                        if (cacheContext.sJWT != null) {
                            cacheContext.sCacheStatus = "R";
                            string6 = "hit with expired " + string11 + ", used refresh token to obtain new " + string9;
                        } else {
                            cacheContext.sCacheStatus = "F";
                            string6 = "hit with expired " + string11 + ", refresh failed";
                        }
                    } else {
                        cacheContext.sCacheStatus = "D";
                        string6 = "hit with expired " + string11 + " and refresh disabled";
                    }
                }
            }
            if (log.isInfoEnabled()) {
                log.info("OIDC token cache " + string6 + " for " + (string != null && string.length() > 0 ? "user " + string : "default user") + " scope " + string5);
            }
            if (cacheContext.sJWT != null) {
                TokenCache.completeOIDCFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
            }
            object = cacheContext;
            return object;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave getCacheEntry bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCacheEntry(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter putCacheEntry bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            String string8;
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            String string9 = uRLParameters.getLogMech();
            String string10 = uRLParameters.getLogData();
            int n = uRLParameters.getOIDCCacheSize();
            String string11 = uRLParameters.getOIDCToken();
            String string12 = uRLParameters.getOIDCClaim();
            if (log.isDebugEnabled()) {
                log.debug("putCacheEntry: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
                log.debug("putCacheEntry: sEndpointURL=" + string6);
                log.debug("putCacheEntry: sIdPResponse=" + string7);
                log.debug("putCacheEntry: sLogMech=" + string9);
                log.debug("putCacheEntry: sIdProURL=" + string3);
                log.debug("putCacheEntry: sClientID=" + string4);
                log.debug("putCacheEntry: sOIDCScope=" + string5);
                log.debug("putCacheEntry: bOAuthFlow=" + bl);
                log.debug("putCacheEntry: sOIDCToken=" + string11);
                log.debug("putCacheEntry: sOIDCClaim=" + string12);
                log.debug("putCacheEntry: sUserName=" + string);
                log.debug("putCacheEntry: sPassword=" + string2);
                log.debug("putCacheEntry: sLogData=" + string10);
            }
            TokenCache.parseIdPResponse(genericTeradataConnection, string6, string7, cacheContext);
            String string13 = string8 = string != null && string.length() > 0 ? cacheContext.sClaimValue : null;
            if (log.isDebugEnabled()) {
                log.debug("putCacheEntry: sKeyClaimValue=" + string8);
            }
            if (n > 0) {
                if (string != null && string.length() > 0 && string8 == null) {
                    throw Utility.logEx(log, "putCacheEntry", ErrorFactory.makeDriverJDBCException("TJ1552", string12, string6));
                }
                String string14 = TokenCache.composeCacheKey(string9, string3, string4, string5, string11, string12, string8, string2, string10);
                if (log.isDebugEnabled()) {
                    log.debug("putCacheEntry: sKey=" + string14);
                }
                CacheEntry cacheEntry = TokenCache.newCacheEntry(string6, cacheContext);
                ArrayList<String> arrayList = new ArrayList<String>();
                Map<String, CacheEntry> map = sm_cache;
                synchronized (map) {
                    sm_cache.put(string14, cacheEntry);
                    while (sm_cache.size() > n) {
                        Map.Entry[] entryArray = sm_cache.entrySet().toArray(new Map.Entry[0]);
                        int n2 = 0;
                        for (int i = 1; i < entryArray.length; ++i) {
                            if (((CacheEntry)entryArray[i].getValue()).nAccessTimeMs >= ((CacheEntry)entryArray[n2].getValue()).nAccessTimeMs) continue;
                            n2 = i;
                        }
                        String string15 = (String)entryArray[n2].getKey();
                        sm_cache.remove(string15);
                        arrayList.add(string15);
                    }
                }
                if (log.isDebugEnabled()) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        log.debug("putCacheEntry: removed key " + (i + 1) + " of " + arrayList.size() + ": " + (String)arrayList.get(i));
                    }
                    log.debug("putCacheEntry: after put: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
                }
            }
            TokenCache.completeOIDCFlow(genericTeradataConnection, string, string2, string3, string4, string5, bl, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave putCacheEntry bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRefreshFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, String string6, CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doRefreshFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            Utility.HttpResponse httpResponse = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
            String string7 = httpResponse.sBody;
            String string8 = Utility.getStringFromJSON("token_endpoint", string7, "TJ1544", string3);
            String string9 = "grant_type=refresh_token&refresh_token=" + Utility.safeForURL(string6) + "&scope=" + Utility.safeForURL(string5);
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string7);
                log.debug("sTokenURL=" + string8);
                log.debug("sFormData=" + string9);
            }
            byte[] byArray = Encoder.encodeStringUTF8(string9);
            httpResponse = Utility.doHttpRequest(uRLParameters, log, "POST", string8, new String[]{"Content-Type: application/x-www-form-urlencoded"}, byArray, true, new int[]{200, 400});
            if (log.isDebugEnabled()) {
                log.debug("Refresh result: resp.nCode=" + httpResponse.nCode + " resp.sBody=" + httpResponse.sBody);
            }
            if (httpResponse.nCode == 200) {
                TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string8, httpResponse.sBody, cacheContext);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doRefreshFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }

    public static class CacheContext {
        String sCacheStatus;
        String sRefreshToken;
        String sJWT;
        long nExpireTimeSecs;
        String sClaimValue;
        String sUserDesc;
        int nReuseCount;

        long tokenTTLSecs() {
            return this.nExpireTimeSecs - System.currentTimeMillis() / 1000L;
        }
    }

    private static class CacheEntry
    implements Cloneable {
        String sEndpointURL;
        String sRefreshToken;
        String sJWT;
        long nExpireTimeSecs;
        String sClaimValue;
        String sUserDesc;
        int nReuseCount;
        long nCreateTimeSecs;
        long nAccessTimeMs;

        private CacheEntry() {
        }

        public CacheEntry clone() {
            try {
                return (CacheEntry)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

