/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.sql.SQLException;

public class BearerFlow {
    public static void validateBearerFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        if (string != null && string.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1572", uRLParameters.getLogMech());
        }
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        if (uRLParameters.getOAuthScopes() != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "OAUTH_SCOPES", uRLParameters.getLogMech());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBearerFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, TokenCache.CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doBearerFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            String string6 = Utility.coalesce(uRLParameters.getJWSAlgorithm(), "RS256");
            if (!(string6.equals("RS256") || string6.equals("RS384") || string6.equals("RS512"))) {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "JWS_ALGORITHM", string6);
            }
            genericTeradataConnection.m_extraClientAttributes.sJWSAlgorithm = string6;
            String string7 = "RSA";
            String string8 = "SHA" + string6.substring(2) + "withRSA";
            if (log.isDebugEnabled()) {
                log.debug("sJWSAlgorithm=" + string6);
                log.debug("sKeyFactory=" + string7);
                log.debug("sSignatureAlgorithm=" + string8);
            }
            if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ1574", "LOGDATA", uRLParameters.getLogMech());
            }
            if (uRLParameters.getJWSPrivateKey() == null || uRLParameters.getJWSPrivateKey().length() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ1582", "JWS_PRIVATE_KEY", uRLParameters.getLogMech());
            }
            String[] stringArray = new String[1];
            PrivateKey privateKey = Utility.loadPrivateKeyFromFile(log, string7, uRLParameters.getJWSPrivateKey(), stringArray);
            String string9 = uRLParameters.getJWSCert() != null && uRLParameters.getJWSCert().length() > 0 ? BearerFlow.loadX509Thumbprint(log, privateKey, uRLParameters.getJWSPrivateKey(), uRLParameters.getJWSCert()) : null;
            Utility.HttpResponse httpResponse = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
            String string10 = httpResponse.sBody;
            String string11 = Utility.getStringFromJSON("token_endpoint", string10, "TJ1544", string3);
            String string12 = "{\"alg\": \"" + string6 + "\"" + (stringArray[0] != null ? ", \"kid\": \"" + stringArray[0] + "\"" : "") + ", \"typ\": \"JWT\"" + (string9 != null ? ", \"x5t\": \"" + string9 + "\"" : "") + "}";
            genericTeradataConnection.m_extraClientAttributes.sJWTHeaderParams = ((stringArray[0] != null ? " kid" : "") + (string9 != null ? " x5t" : "")).trim().replace(' ', ',');
            String string13 = string4;
            String string14 = string4;
            String string15 = string11;
            String string16 = Long.toString(System.currentTimeMillis() / 1000L + 60L);
            String string17 = Utility.base64Encode(true, Utility.getRandomBytes(16));
            String string18 = "{\"iss\": \"" + string13 + "\"" + ", \"sub\": \"" + string14 + "\"" + ", \"aud\": \"" + string15 + "\"" + ", \"exp\": " + string16 + ", \"jti\": \"" + string17 + "\"" + "}";
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string10);
                log.debug("sTokenURL=" + string11);
                log.debug("sIssuer=" + string13);
                log.debug("sSubject=" + string14);
                log.debug("sAudience=" + string15);
                log.debug("sExpiration=" + string16);
                log.debug("sUniqueID=" + string17);
                log.debug("sJWTHeader=" + string12);
                log.debug("sPayload=" + string18);
            }
            String string19 = Utility.makeJWT(log, string12, string18, string8, privateKey);
            String string20 = "grant_type=client_credentials&scope=" + Utility.safeForURL(string5) + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer" + "&client_assertion=" + string19;
            if (log.isDebugEnabled()) {
                log.debug("sSignedJWT=" + string19);
                log.debug("sFormData=" + string20);
            }
            byte[] byArray = Encoder.encodeStringUTF8(string20);
            string10 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string11, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
            TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string11, string10, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doBearerFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }

    private static void verifyMatchingKeys(Log log, PrivateKey privateKey, String string, X509Certificate x509Certificate, String string2) throws SQLException {
        boolean bl;
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (log.isDebugEnabled()) {
            log.debug("verifyMatchingKeys: privkey class=" + privateKey.getClass().getName() + " pubkey class=" + publicKey.getClass().getName());
        }
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1590", string, "JWS_PRIVATE_KEY", "RSAPrivateCrtKey");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1591", string2, "JWS_CERT", "RSAPublicKey");
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        boolean bl2 = bl = rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus()) && rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent());
        if (log.isDebugEnabled()) {
            log.debug("verifyMatchingKeys: bMatchingKeyPair=" + bl);
        }
        if (!bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ1592", string, "JWS_PRIVATE_KEY", string2, "JWS_CERT");
        }
    }

    private static String loadX509Thumbprint(Log log, PrivateKey privateKey, String string, String string2) throws SQLException {
        byte[] byArray;
        X509Certificate[] x509CertificateArray = Utility.loadCertificatesFromPEMFile(string2, log, "JWS_CERT", "TJ1589");
        X509Certificate x509Certificate = x509CertificateArray[0];
        BearerFlow.verifyMatchingKeys(log, privateKey, string, x509Certificate, string2);
        try {
            byArray = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw Utility.wrapEx(certificateEncodingException, ErrorFactory.makeDriverJDBCException("TJ1589", string2, "JWS_CERT"));
        }
        byte[] byArray2 = Utility.hashBytes(log, "SHA-1", byArray);
        String string3 = Utility.base64Encode(true, byArray2);
        if (log.isDebugEnabled()) {
            log.debug("loadX509Thumbprint: abyThumbprint=" + Utility.formatByteArrayAsHexDigits(byArray2));
            log.debug("loadX509Thumbprint: sThumbprintBase64=" + string3);
        }
        return string3;
    }
}

