/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class LdapName
implements GSSName {
    private final TdgssLogger logger;
    private byte[] name;
    private Oid namespace;

    public LdapName(byte[] byArray, Oid oid, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.namespace = oid == null ? GSSName.NT_USER_NAME : oid;
        if (byArray == null) {
            throw new TdgssException(3, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        this.name = byArray;
    }

    @Override
    public boolean equals(GSSName gSSName) throws GSSException {
        return this.getStringNameType().equals(gSSName.getStringNameType()) && this.toString().equals(gSSName.toString());
    }

    @Override
    public boolean equals(Object object) {
        try {
            GSSName gSSName = (GSSName)object;
            return this.equals(gSSName);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (GSSException gSSException) {
            return false;
        }
    }

    @Override
    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(LdapMechanism.mechOid)) {
            throw new TdgssException(2, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        return this;
    }

    @Override
    public byte[] export() throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public String toString() {
        try {
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                return new String(this.name, "UTF-16");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                return new String(this.name, "UTF-8");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32)) {
                return new String(this.name, "UTF-32");
            }
            return new String(this.name, "US-ASCII");
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
            return null;
        }
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        return this.namespace;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isMN() {
        return true;
    }
}

