/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class RequestParcel
extends Parcel {
    protected byte[] requestText;
    public static final int LENGTH = 4;

    public RequestParcel(GenericTeradataConnection genericTeradataConnection) {
        super(genericTeradataConnection);
        this.setFlavor((short)1);
    }

    public void setRequestText(String string) throws SQLException {
        this.requestText = Encoder.encodeRequestText(this.m_con, string);
        this.setLength(RequestParcel.calculateHeaderLength(this.altHeader) + this.requestText.length);
        this.createBuffer(this.getLength());
    }

    public void setRequestText(byte[] byArray) {
        this.requestText = byArray;
        this.setLength(RequestParcel.calculateHeaderLength(this.altHeader) + this.requestText.length);
        this.createBuffer(this.getLength());
    }

    public void setRequestText(byte[] byArray, int n, int n2) {
        this.requestText = new byte[n2];
        System.arraycopy(byArray, n, this.requestText, 0, n2);
        this.setLength(RequestParcel.calculateHeaderLength(this.altHeader) + this.requestText.length);
        this.createBuffer(this.getLength());
    }

    @Override
    public TDPacketStream toStream() throws SQLException {
        super.toStream();
        this.buffer.put(this.requestText);
        this.buffer.flip();
        return this.buffer;
    }
}

