echo off

REM If no command line options specified go immediately to ShowUsage
if "%~1" == "" goto ShowUsage

if "%~1" == "ALL_SUITES" (goto RemovePriorSuites) else (goto RemovePackages)

:RemovePriorSuites
if "%~2" == "" goto RemoveCurrentReleaseSuites
if "%~2" == "PRIORTO" (
	if "%~3" == "" goto ShowUsage
	pushd "%~dp0"
	TTUSuiteSilent.exe ALL_SUITES PRIORTO %3
	popd
) else (
	pushd "%~dp0"
	TTUSuiteSilent.exe ALL_SUITES %2
	popd
)
goto eof

:RemoveCurrentReleaseSuites
pushd "%~dp0"
TTUSuiteSilent.exe ALL_SUITES 20.00
popd
goto eof

:RemovePackages
pushd "%~dp0"
TTUSuiteSilent.exe {F075B63A-C629-41F8-BA56-33D9940F2000} 20.00 "%1" /x ODBC
popd
goto eof


:ShowUsage

  echo Usage: silent_uninstall.bat "<list of features>|<ALL>|<ALL_SUITES [VERSION]>|<ALL_SUITES PRIORTO  VERSION>]"
  echo.
  echo Where: "<list of features>" is a comma separated list of the features 
  echo        enclosed in quotes to be uninstalled silently. If the "ALL" flag is 
  echo        used then the suite will be uninstalled.
  echo.
  echo        ALL_SUITES                 : Removes all Suites of current release.
  echo        ALL_SUITES VERSION         : Removes all Suites with short version equal to VERSION 
  echo        ALL_SUITES PRIORTO VERSION : Removes all Suites with short version less than VERSION
  echo.

  echo Example: silent_uninstall.bat "TDWALLET,ODBC"
  echo          silent_uninstall.bat ALL
  echo          silent_uninstall.bat ALL_SUITES
  echo          silent_uninstall.bat ALL_SUITES 17.10
  echo          silent_uninstall.bat ALL_SUITES PRIORTO 17.20
  echo.
  
  goto eof

:eof



